/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.overflow.OverflowState;
import org.sosy_lab.cpachecker.cpa.predicate.BAMBlockFormulaStrategy;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="counterexample.export", deprecatedPrefix="cpa.predicate")
public class PathChecker {
    @Option(secure=true, name="formula", deprecatedName="dumpCounterexampleFormula", description="where to dump the counterexample formula in case a specification violation is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpCounterexampleFormula = PathTemplate.ofFormatString((String)"Counterexample.%d.smt2");
    @Option(secure=true, name="model", deprecatedName="dumpCounterexampleModel", description="where to dump the counterexample model in case a specification violation is found")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpCounterexampleModel = PathTemplate.ofFormatString((String)"Counterexample.%d.assignment.txt");
    @Option(secure=true, description="An imprecise counterexample of the Predicate CPA is usually a bug, but expected in some configurations. Should it be treated as a bug or accepted?")
    private boolean allowImpreciseCounterexamples = false;
    @Option(secure=true, description="Always use imprecise counterexamples of the predicate analysis. If this option is set to true, counterexamples generated by the predicate analysis will be exported as-is. This means that no information like variable assignments will be added and imprecise or potentially wrong program paths will be exported as counterexample.")
    private boolean alwaysUseImpreciseCounterexamples = false;
    private final LogManager logger;
    private final PathFormulaManager pmgr;
    private final Solver solver;
    private final AssignmentToPathAllocator assignmentToPathAllocator;

    public PathChecker(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel, PathFormulaManager pPmgr, Solver pSolver) throws InvalidConfigurationException {
        this(pConfig, pLogger, pPmgr, pSolver, new AssignmentToPathAllocator(pConfig, pShutdownNotifier, pLogger, pMachineModel));
    }

    public PathChecker(Configuration pConfig, LogManager pLogger, PathFormulaManager pPmgr, Solver pSolver, AssignmentToPathAllocator pAssignmentToPathAllocator) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.pmgr = pPmgr;
        this.solver = pSolver;
        this.assignmentToPathAllocator = pAssignmentToPathAllocator;
        pConfig.inject((Object)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public CounterexampleInfo handleFeasibleCounterexample(CounterexampleTraceInfo counterexample, ARGPath fallbackPath) throws InterruptedException {
        ARGPath precisePath;
        if (this.alwaysUseImpreciseCounterexamples) {
            return this.createImpreciseCounterexample(fallbackPath, counterexample);
        }
        Preconditions.checkArgument((!counterexample.isSpurious() ? 1 : 0) != 0);
        if (counterexample.getPrecisePath() != null) {
            precisePath = counterexample.getPrecisePath();
            return this.createCounterexample(precisePath, counterexample);
        }
        if (this.hasBranching(fallbackPath)) {
            precisePath = fallbackPath;
            return this.createCounterexample(precisePath, counterexample);
        }
        this.logger.log(Level.WARNING, new Object[]{"No information about ARG branches available!"});
        return this.createImpreciseCounterexample(fallbackPath, counterexample);
    }

    private boolean hasBranching(ARGPath path) {
        ImmutableSet<ARGState> elementsOnPath = ARGUtils.getAllStatesOnPathsTo(path.getLastState());
        if (elementsOnPath.size() >= path.size()) {
            return true;
        }
        for (ARGState state : elementsOnPath) {
            if (FluentIterable.from(state.getChildren()).filter(arg_0 -> elementsOnPath.contains(arg_0)).size() <= 1) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CounterexampleInfo createCounterexample(ARGPath precisePath, CounterexampleTraceInfo pInfo) throws InterruptedException {
        try (ProverEnvironment prover = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            Pair<PathFormula, List<SSAMap>> replayedPath = this.createPrecisePathFormula(precisePath);
            List<SSAMap> ssaMaps = replayedPath.getSecond();
            BooleanFormula pathFormula = replayedPath.getFirstNotNull().getFormula();
            prover.push(pathFormula);
            if (prover.isUnsat()) {
                this.logger.log(Level.WARNING, new Object[]{"Inconsistent replayed error path! No variable values will be available."});
                CounterexampleInfo counterexampleInfo2 = this.createImpreciseCounterexample(precisePath, pInfo);
                return counterexampleInfo2;
            }
            ImmutableList<Model.ValueAssignment> model = this.getModel(prover);
            CFAPathWithAssumptions pathWithAssignments = this.assignmentToPathAllocator.allocateAssignmentsToPath(precisePath, (Iterable<Model.ValueAssignment>)model, ssaMaps);
            CounterexampleInfo cex = CounterexampleInfo.feasiblePrecise(precisePath, pathWithAssignments);
            this.addCounterexampleFormula((List<BooleanFormula>)ImmutableList.of((Object)pathFormula), cex);
            this.addCounterexampleModel(model, cex);
            CounterexampleInfo counterexampleInfo = cex;
            return counterexampleInfo;
        }
        catch (CPATransferException | SolverException e) {
            this.logger.logUserException(Level.WARNING, e, "Could not replay error path! No variable values will be available.");
            return this.createImpreciseCounterexample(precisePath, pInfo);
        }
    }

    private CounterexampleInfo createImpreciseCounterexample(ARGPath imprecisePath, CounterexampleTraceInfo pInfo) {
        if (!this.allowImpreciseCounterexamples) {
            throw new AssertionError((Object)"Found imprecise counterexample in PredicateCPA. If this is expected for this configuration (e.g., because of UF-based heap encoding), set counterexample.export.allowImpreciseCounterexamples=true. Otherwise please report this as a bug.");
        }
        CounterexampleInfo cex = CounterexampleInfo.feasibleImprecise(imprecisePath);
        if (!this.alwaysUseImpreciseCounterexamples) {
            this.addCounterexampleFormula((List<BooleanFormula>)pInfo.getCounterExampleFormulas(), cex);
        }
        return cex;
    }

    private void addCounterexampleModel(final ImmutableList<Model.ValueAssignment> model, CounterexampleInfo counterexample) {
        counterexample.addFurtherInformation(new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                ImmutableList lines = ImmutableList.sortedCopyOf((Iterable)Lists.transform((List)model, Object::toString));
                Joiner.on((char)'\n').appendTo(out, (Iterable)lines);
            }
        }, this.dumpCounterexampleModel);
    }

    private void addCounterexampleFormula(List<BooleanFormula> cexFormulas, CounterexampleInfo counterexample) {
        BooleanFormula f;
        FormulaManagerView fmgr = this.solver.getFormulaManager();
        BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
        if (!bfmgr.isTrue(f = bfmgr.and(cexFormulas))) {
            counterexample.addFurtherInformation(fmgr.dumpFormula(f), this.dumpCounterexampleFormula);
        }
    }

    private Pair<PathFormula, List<SSAMap>> createPrecisePathFormula(ARGPath pPath) throws CPATransferException, InterruptedException {
        ArrayList<SSAMap> ssaMaps = new ArrayList<SSAMap>(pPath.size());
        PathFormula pathFormula = this.pmgr.makeEmptyPathFormula();
        PathIterator pathIt = pPath.fullPathIterator();
        ArrayDeque<PathFormula> callstack = new ArrayDeque<PathFormula>();
        while (pathIt.hasNext()) {
            if (pathIt.isPositionWithState()) {
                pathFormula = this.addAssumptions(pathFormula, pathIt.getAbstractState());
            }
            CFAEdge edge = pathIt.getOutgoingEdge();
            pathIt.advance();
            if (!pathIt.hasNext() && pathIt.isPositionWithState()) {
                pathFormula = this.addAssumptions(pathFormula, pathIt.getAbstractState());
            }
            if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                callstack.push(pathFormula);
            }
            if (!callstack.isEmpty() && edge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                pathFormula = BAMBlockFormulaStrategy.rebuildStateAfterFunctionCall(pathFormula, (PathFormula)callstack.pop(), ((FunctionReturnEdge)edge).getPredecessor());
            }
            pathFormula = this.pmgr.makeAnd(pathFormula, edge);
            ssaMaps.add(pathFormula.getSsa());
        }
        return Pair.of(pathFormula, ssaMaps);
    }

    private PathFormula addAssumptions(PathFormula pathFormula, ARGState nextState) throws CPATransferException, InterruptedException {
        if (nextState != null) {
            FluentIterable<AbstractStateWithAssumptions> assumptionStates = AbstractStates.projectToType(AbstractStates.asIterable(nextState), AbstractStateWithAssumptions.class);
            for (AbstractStateWithAssumptions assumptionState : assumptionStates) {
                if (assumptionState instanceof OverflowState && ((OverflowState)assumptionState).hasOverflow()) {
                    assumptionState = ((OverflowState)assumptionState).getParent();
                }
                for (AExpression expr : assumptionState.getAssumptions()) {
                    assert (expr instanceof CExpression) : "Expected a CExpression as assumption!";
                    pathFormula = this.pmgr.makeAnd(pathFormula, (CExpression)expr);
                }
            }
        }
        return pathFormula;
    }

    private ImmutableList<Model.ValueAssignment> getModel(ProverEnvironment thmProver) {
        try {
            return thmProver.getModelAssignments();
        }
        catch (SolverException e) {
            this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, variable assignment of error path can not be dumped."});
            this.logger.logDebugException((Throwable)e);
            return ImmutableList.of();
        }
    }
}

