/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

@Options(prefix="rcnf")
public class RCNFManager
implements StatisticsProvider {
    @Option(description="Limit on the size of the resulting number of lemmas from the explicit expansion", secure=true)
    private int expansionResultSizeLimit = 100;
    @Option(secure=true, description="Quantifier elimination strategy", toUppercase=true)
    private BOUND_VARS_HANDLING boundVarsHandling = BOUND_VARS_HANDLING.QE_LIGHT_THEN_DROP;
    @Option(secure=true, description="Expand equality atoms. E.g. 'x=a' gets expanded into 'x >= a AND x <= a'. Can lead to stronger weakenings.")
    private boolean expandEquality = false;
    private FormulaManagerView fmgr = null;
    private BooleanFormulaManager bfmgr = null;
    private final RCNFConversionStatistics statistics;
    private final Map<BooleanFormula, ImmutableSet<BooleanFormula>> conversionCache;
    private final DefaultFormulaVisitor<Optional<BooleanFormula>> quantifiedBodyExtractor = new DefaultFormulaVisitor<Optional<BooleanFormula>>(){

        protected Optional<BooleanFormula> visitDefault(Formula f) {
            return Optional.empty();
        }

        public Optional<BooleanFormula> visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
            return Optional.of(body);
        }
    };

    public RCNFManager(Configuration options) throws InvalidConfigurationException {
        options.inject((Object)this);
        this.statistics = new RCNFConversionStatistics();
        this.conversionCache = new HashMap<BooleanFormula, ImmutableSet<BooleanFormula>>();
    }

    public Set<BooleanFormula> toLemmasInstantiated(PathFormula pf, FormulaManagerView pFmgr) throws InterruptedException {
        BooleanFormula transition = pf.getFormula();
        SSAMap ssa = pf.getSsa();
        transition = pFmgr.filterLiterals(transition, (Predicate<BooleanFormula>)((Predicate)input -> !this.hasDeadUf((BooleanFormula)input, ssa, pFmgr)));
        BooleanFormula quantified = pFmgr.quantifyDeadVariables(transition, ssa);
        return this.toLemmas(quantified, pFmgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<BooleanFormula> toLemmas(BooleanFormula input, FormulaManagerView pFmgr) throws InterruptedException {
        BooleanFormula result;
        Preconditions.checkNotNull((Object)pFmgr);
        this.fmgr = pFmgr;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        ImmutableSet<BooleanFormula> out = this.conversionCache.get(input);
        if (out != null) {
            ++this.statistics.conversionCacheHits;
            return out;
        }
        switch (this.boundVarsHandling) {
            case QE_LIGHT_THEN_DROP: {
                try {
                    this.statistics.lightQuantifierElimination.start();
                    result = this.fmgr.applyTactic(input, Tactic.QE_LIGHT);
                    break;
                }
                finally {
                    this.statistics.lightQuantifierElimination.stop();
                }
            }
            case QE: {
                try {
                    this.statistics.quantifierElimination.start();
                    result = this.fmgr.getQuantifiedFormulaManager().eliminateQuantifiers(input);
                    break;
                }
                catch (SolverException pE) {
                    throw new UnsupportedOperationException("Unexpected solver error", pE);
                }
                finally {
                    this.statistics.quantifierElimination.stop();
                }
            }
            case DROP: {
                result = input;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled case statement: " + this.boundVarsHandling));
            }
        }
        BooleanFormula noBoundVars = this.dropBoundVariables(result);
        try {
            this.statistics.conversion.start();
            out = this.convert(noBoundVars);
        }
        finally {
            this.statistics.conversion.stop();
        }
        this.conversionCache.put(input, out);
        return out;
    }

    private BooleanFormula dropBoundVariables(BooleanFormula input) throws InterruptedException {
        Optional<BooleanFormula> body = this.fmgr.visit((Formula)input, this.quantifiedBodyExtractor);
        if (body.isPresent()) {
            return this.fmgr.filterLiterals(body.orElseThrow(), (Predicate<BooleanFormula>)((Predicate)input1 -> !this.hasBoundVariables((BooleanFormula)input1)));
        }
        return input;
    }

    private BooleanFormula factorize(BooleanFormula input) {
        return this.bfmgr.transformRecursively(input, (BooleanFormulaTransformationVisitor)new BooleanFormulaManagerView.BooleanFormulaTransformationVisitor(this.fmgr){

            public BooleanFormula visitAnd(List<BooleanFormula> processed) {
                return RCNFManager.this.bfmgr.and((Collection)RCNFManager.this.bfmgr.toConjunctionArgs(RCNFManager.this.bfmgr.and(processed), false));
            }

            public BooleanFormula visitOr(List<BooleanFormula> processed) {
                Set intersection = null;
                ArrayList<Set> argsAsConjunctions = new ArrayList<Set>();
                for (BooleanFormula op : processed) {
                    Set args2 = RCNFManager.this.bfmgr.toConjunctionArgs(op, false);
                    argsAsConjunctions.add(args2);
                    if (intersection == null) {
                        intersection = args2;
                        continue;
                    }
                    intersection = Sets.intersection((Set)intersection, (Set)args2);
                }
                assert (intersection != null) : "Should not be null for a non-zero number of operands.";
                Set commonTerms = intersection;
                BooleanFormula common = RCNFManager.this.bfmgr.and(commonTerms);
                BooleanFormula branches = (BooleanFormula)argsAsConjunctions.stream().map(args -> RCNFManager.this.bfmgr.and((Collection)Sets.difference((Set)args, (Set)commonTerms))).collect(RCNFManager.this.bfmgr.toDisjunction());
                return RCNFManager.this.bfmgr.and(common, branches);
            }
        });
    }

    private Iterable<BooleanFormula> expandClause(final BooleanFormula input) {
        return (Iterable)this.bfmgr.visit(input, (BooleanFormulaVisitor)new DefaultBooleanFormulaVisitor<Iterable<BooleanFormula>>(){

            protected Iterable<BooleanFormula> visitDefault() {
                return ImmutableList.of((Object)input);
            }

            public Iterable<BooleanFormula> visitOr(List<BooleanFormula> operands) {
                long sizeAfterExpansion = 1L;
                ArrayList<Set> asConjunctions = new ArrayList<Set>();
                for (BooleanFormula op : operands) {
                    Set out = RCNFManager.this.bfmgr.toConjunctionArgs(op, true);
                    try {
                        sizeAfterExpansion = Math.multiplyExact(sizeAfterExpansion, out.size());
                    }
                    catch (ArithmeticException ex) {
                        sizeAfterExpansion = (long)RCNFManager.this.expansionResultSizeLimit + 1L;
                        break;
                    }
                    asConjunctions.add(out);
                }
                if (sizeAfterExpansion <= (long)RCNFManager.this.expansionResultSizeLimit) {
                    Set product = Sets.cartesianProduct(asConjunctions);
                    return FluentIterable.from((Iterable)product).transform(arg_0 -> ((BooleanFormulaManager)RCNFManager.this.bfmgr).or(arg_0));
                }
                return ImmutableList.of((Object)RCNFManager.this.bfmgr.or(operands));
            }
        });
    }

    private ImmutableSet<BooleanFormula> convert(BooleanFormula input) {
        BooleanFormula factorized = this.factorize(input);
        Set factorizedLemmas = this.bfmgr.toConjunctionArgs(factorized, true);
        ImmutableSet.Builder out = ImmutableSet.builder();
        for (BooleanFormula lemma : factorizedLemmas) {
            Iterable<BooleanFormula> expandedLemmas = this.expandClause(lemma);
            for (BooleanFormula l : expandedLemmas) {
                if (this.expandEquality) {
                    out.addAll((Iterable)this.bfmgr.toConjunctionArgs(this.transformEquality(l), false));
                    continue;
                }
                out.add((Object)l);
            }
        }
        return out.build();
    }

    private BooleanFormula transformEquality(BooleanFormula input) {
        return (BooleanFormula)this.fmgr.visit((Formula)input, new DefaultFormulaVisitor<BooleanFormula>(){

            protected BooleanFormula visitDefault(Formula f) {
                return (BooleanFormula)f;
            }

            public BooleanFormula visitFunction(Formula f, List<Formula> newArgs, FunctionDeclaration<?> functionDeclaration) {
                if (functionDeclaration.getKind() == FunctionDeclarationKind.EQ && RCNFManager.this.fmgr.getFormulaType(newArgs.get(0)).isNumeralType()) {
                    Preconditions.checkState((newArgs.size() == 2 ? 1 : 0) != 0);
                    Formula a = newArgs.get(0);
                    Formula b = newArgs.get(1);
                    return RCNFManager.this.bfmgr.and(RCNFManager.this.fmgr.makeGreaterOrEqual(a, b, true), RCNFManager.this.fmgr.makeLessOrEqual(a, b, true));
                }
                return (BooleanFormula)f;
            }
        });
    }

    private boolean hasBoundVariables(BooleanFormula input) {
        final AtomicBoolean hasBound = new AtomicBoolean(false);
        this.fmgr.visitRecursively((Formula)input, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitBoundVariable(Formula f, int deBruijnIdx) {
                hasBound.set(true);
                return TraversalProcess.ABORT;
            }
        });
        return hasBound.get();
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.statistics);
    }

    private boolean hasDeadUf(BooleanFormula atom, final SSAMap pSSAMap, final FormulaManagerView pFmgr) {
        final AtomicBoolean out = new AtomicBoolean(false);
        pFmgr.visitRecursively((Formula)atom, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                if (functionDeclaration.getKind() == FunctionDeclarationKind.UF && pFmgr.isIntermediate(functionDeclaration.getName(), pSSAMap)) {
                    out.set(true);
                    return TraversalProcess.ABORT;
                }
                return TraversalProcess.CONTINUE;
            }
        });
        return out.get();
    }

    private static class RCNFConversionStatistics
    implements Statistics {
        Timer lightQuantifierElimination = new Timer();
        Timer quantifierElimination = new Timer();
        Timer conversion = new Timer();
        int conversionCacheHits = 0;

        private RCNFConversionStatistics() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            this.printTimer(out, this.conversion, "RCNF conversion");
            this.printTimer(out, this.lightQuantifierElimination, "light quantifier elimination");
            this.printTimer(out, this.quantifierElimination, "quantifier elimination");
        }

        @Override
        public String getName() {
            return "RCNF Conversion";
        }

        private void printTimer(PrintStream out, Timer t, String name) {
            out.printf("Time spent in %s: %s (Max: %s), (Avg: %s), (#calls = %s), (#cached = %d) %n", name, t.getSumTime().formatAs(TimeUnit.SECONDS), t.getMaxTime().formatAs(TimeUnit.SECONDS), t.getAvgTime().formatAs(TimeUnit.SECONDS), t.getNumberOfIntervals(), this.conversionCacheHits);
        }
    }

    public static enum BOUND_VARS_HANDLING {
        QE_LIGHT_THEN_DROP,
        QE,
        DROP;

    }
}

