/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.util.predicates.RCNFManager;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

@RunWith(value=Parameterized.class)
public class RCNFManagerTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverToUse;
    private RCNFManager rcnfManager;
    private BooleanFormulaManager bfmgr;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverToUse;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() {
        return super.createTestConfigBuilder().setOption("rcnf.boundVarsHandling", "drop");
    }

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.rcnfManager = new RCNFManager(this.config);
        this.bfmgr = this.bmgrv;
    }

    @Test
    public void testFactorization() throws Exception {
        BooleanFormula a = this.bfmgr.and(this.bfmgr.makeVariable("p"), this.bfmgr.makeVariable("a"));
        BooleanFormula b = this.bfmgr.and(this.bfmgr.makeVariable("p"), this.bfmgr.makeVariable("b"));
        BooleanFormula c = this.bfmgr.or(a, b);
        BooleanFormula converted = this.bfmgr.and(this.rcnfManager.toLemmas(c, this.mgrv));
        this.assertThatFormula(converted).isEquivalentTo(c);
        Truth.assertThat((Iterable)this.bfmgr.toConjunctionArgs(converted, false)).containsExactly(new Object[]{this.bfmgr.makeVariable("p"), this.bfmgr.or(this.bfmgr.makeVariable("a"), this.bfmgr.makeVariable("b"))});
    }

    @Test
    public void testNestedConjunctions() throws Exception {
        BooleanFormula input = this.bfmgr.and(this.bfmgr.makeVariable("a"), this.bfmgr.and(this.bfmgr.makeVariable("b"), this.bfmgr.and(this.bfmgr.makeVariable("c"), this.bfmgr.makeVariable("d"))));
        ImmutableSet<BooleanFormula> lemmas = this.rcnfManager.toLemmas(input, this.mgrv);
        this.assertThatFormula(this.bmgr.and(lemmas)).isEquivalentTo(input);
        Truth.assertThat(lemmas).containsExactly(new Object[]{this.v("a"), this.v("b"), this.v("c"), this.v("d")});
    }

    @Test
    public void testExplicitExpansion() throws Exception {
        BooleanFormula input = this.bfmgr.or(this.bfmgr.and(new BooleanFormula[]{this.v("a"), this.v("b"), this.v("c")}), this.bfmgr.and(new BooleanFormula[]{this.v("d"), this.v("e"), this.v("f")}));
        ImmutableSet<BooleanFormula> lemmas = this.rcnfManager.toLemmas(input, this.mgrv);
        this.assertThatFormula(this.bfmgr.and(lemmas)).isEquivalentTo(input);
        Truth.assertThat(lemmas).containsExactly(new Object[]{this.bfmgr.or(this.v("a"), this.v("d")), this.bfmgr.or(this.v("a"), this.v("e")), this.bfmgr.or(this.v("a"), this.v("f")), this.bfmgr.or(this.v("b"), this.v("d")), this.bfmgr.or(this.v("b"), this.v("e")), this.bfmgr.or(this.v("b"), this.v("f")), this.bfmgr.or(this.v("c"), this.v("d")), this.bfmgr.or(this.v("c"), this.v("e")), this.bfmgr.or(this.v("c"), this.v("f"))});
    }

    private BooleanFormula v(String name) {
        return this.bfmgr.makeVariable(name);
    }
}

