/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class UCBRefinementManager {
    private final LogManager logger;
    private final Solver solver;
    private final PathFormulaManager pfmgr;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;

    public UCBRefinementManager(LogManager pLogger, Solver pSolver, PathFormulaManager pPfmgr) {
        this.logger = pLogger;
        this.solver = pSolver;
        this.pfmgr = pPfmgr;
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
    }

    public CounterexampleTraceInfo buildCounterexampleTrace(ARGPath allStatesTrace, List<ARGState> abstractionStatesTrace, BlockFormulaStrategy.BlockFormulas pFormulas) throws CPAException, InterruptedException {
        ArrayList<ARGState> trace = new ArrayList<ARGState>(abstractionStatesTrace);
        trace.add(0, allStatesTrace.getFirstState());
        List<BooleanFormula> preds = this.computeWeakestPreconditions(trace);
        if (preds == null) {
            return CounterexampleTraceInfo.feasibleImprecise(pFormulas.getFormulas());
        }
        preds = this.computeUCB(trace, pFormulas, preds);
        preds.addAll(0, Collections.nCopies(abstractionStatesTrace.size() - preds.size() - 1, this.bfmgr.makeTrue()));
        return CounterexampleTraceInfo.infeasible(preds);
    }

    private List<BooleanFormula> computeWeakestPreconditions(List<ARGState> pTrace) throws CPAException, InterruptedException {
        BooleanFormula wpre = this.bfmgr.makeTrue();
        ArrayList<BooleanFormula> wpres = new ArrayList<BooleanFormula>();
        this.logger.log(Level.FINEST, new Object[]{"Calculate weakest precondition for the error trace."});
        for (int i = pTrace.size() - 2; i >= 0; --i) {
            try {
                wpre = this.computeWeakestPrecondition(pTrace.get(i), pTrace.get(i + 1), wpre);
                PredicateAbstractState abstractState = AbstractStates.extractStateByType(pTrace.get(i), PredicateAbstractState.class);
                BooleanFormula stateFormula = abstractState.getAbstractionFormula().asFormula();
                if (this.solver.isUnsat(this.bfmgr.and(stateFormula, wpre))) {
                    this.logger.log(Level.FINEST, new Object[]{"Abstract state is disjoint with the weakest precondition. Found spurious error trace suffix."});
                    return wpres;
                }
                wpres.add(wpre);
                continue;
            }
            catch (SolverException e) {
                throw new CPAException(e.getMessage());
            }
        }
        return null;
    }

    private BooleanFormula computeWeakestPrecondition(ARGState src, ARGState dst, BooleanFormula postCondition) throws CPAException, InterruptedException {
        CFAEdge singleEdge = src.getEdgeToChild(dst);
        if (singleEdge != null) {
            return this.pfmgr.buildWeakestPrecondition(singleEdge, postCondition);
        }
        CFANode srcNode = AbstractStates.extractLocation(src);
        CFANode dstNode = AbstractStates.extractLocation(dst);
        if (srcNode != null && dstNode != null) {
            return this.computeWeakestPrecondition(srcNode, dstNode, postCondition, (Set<CFANode>)ImmutableSet.of());
        }
        return this.bfmgr.makeFalse();
    }

    private BooleanFormula computeWeakestPrecondition(CFANode src, CFANode dst, BooleanFormula postCondition, Set<CFANode> visitedNodes) throws CPAException, InterruptedException {
        HashSet<CFANode> visited = new HashSet<CFANode>(visitedNodes);
        visited.add(src);
        BooleanFormula res = this.bfmgr.makeFalse();
        for (CFAEdge edge : CFAUtils.leavingEdges(src)) {
            CFANode next = edge.getSuccessor();
            BooleanFormula wp = this.bfmgr.makeFalse();
            BooleanFormula post = this.bfmgr.makeFalse();
            if (next.equals(dst)) {
                post = postCondition;
            } else if (!visited.contains(next)) {
                post = this.computeWeakestPrecondition(next, dst, postCondition, visited);
            }
            if (!this.bfmgr.isFalse(post)) {
                wp = this.pfmgr.buildWeakestPrecondition(edge, post);
            }
            if (this.bfmgr.isFalse(res)) {
                res = wp;
                continue;
            }
            if (this.bfmgr.isFalse(wp)) continue;
            res = this.bfmgr.or(res, wp);
        }
        return res;
    }

    private List<BooleanFormula> computeUCB(List<ARGState> pTrace, BlockFormulaStrategy.BlockFormulas pFormulas, List<BooleanFormula> wpres) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Calculate UCB predicates for the spurious trace suffix."});
        ArrayList<BooleanFormula> ucbs = new ArrayList<BooleanFormula>(wpres);
        Collections.reverse(ucbs);
        int startStateIdx = pTrace.size() - ucbs.size() - 2;
        BooleanFormula pred = null;
        for (int i = startStateIdx; i < pTrace.size() - 2; ++i) {
            PredicateAbstractState curState = AbstractStates.extractStateByType(pTrace.get(i), PredicateAbstractState.class);
            PredicateAbstractState nextState = AbstractStates.extractStateByType(pTrace.get(i + 1), PredicateAbstractState.class);
            if (pred == null) {
                pred = curState.getAbstractionFormula().asFormula();
            }
            pred = this.fmgr.instantiate(pred, curState.getPathFormula().getSsa());
            BooleanFormula pf = (BooleanFormula)pFormulas.getFormulas().get(i);
            BooleanFormula ucb = this.fmgr.instantiate((BooleanFormula)ucbs.get(i - startStateIdx), nextState.getPathFormula().getSsa());
            Set<BooleanFormula> ucbConj = this.bfmgr.toConjunctionArgs(ucb, true);
            HashSet<BooleanFormula> conjs = new HashSet<BooleanFormula>();
            conjs.add(pred);
            conjs.add(pf);
            conjs.addAll(ucbConj);
            try {
                BooleanFormula ucf = this.fmgr.uninstantiate(this.solver.unsatCore(conjs).stream().filter(uc -> ucbConj.contains(uc)).collect(this.bfmgr.toConjunction()));
                pred = this.bfmgr.isTrue(ucf) ? this.bfmgr.makeFalse() : (this.bfmgr.isFalse(ucf) ? this.bfmgr.makeTrue() : this.bfmgr.not(ucf));
                ucbs.set(i - startStateIdx, pred);
                continue;
            }
            catch (SolverException e) {
                throw new CPAException(e.getMessage());
            }
        }
        return ucbs;
    }
}

