/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;

@RunWith(value=Parameterized.class)
public class BDDExistsTest {
    private NamedRegionManager nrm;
    private Configuration config;
    private LogManager logger = LogManager.createTestLogManager();
    @Parameterized.Parameter(value=0)
    public String bddPackage;

    @Parameterized.Parameters(name="{0}")
    public static List<String> getAllPackages() {
        return ImmutableList.of((Object)"SYLVAN", (Object)"JAVA");
    }

    @Test
    public void existsTest() throws InvalidConfigurationException {
        Region r2;
        this.config = Configuration.builder().setOption("bdd.package", this.bddPackage).build();
        this.nrm = new NamedRegionManager(new BDDManagerFactory(this.config, this.logger).createRegionManager());
        Region r0 = this.nrm.createPredicate("r0");
        Region r1 = this.nrm.createPredicate("r1");
        Region complete = r2 = this.nrm.createPredicate("r2");
        complete = this.nrm.makeAnd(complete, r1);
        complete = this.nrm.makeAnd(complete, r0);
        Region reduced = this.nrm.makeExists(complete, r1, r2);
        Truth.assertWithMessage((String)this.nrm.dumpRegion(reduced).toString()).that((Object)reduced).isEqualTo((Object)r0);
    }
}

