/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.JavaBDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.PJBDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.SylvanBDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.CountingRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.SynchronizedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.TimedRegionManager;

@Options(prefix="bdd")
public class BDDManagerFactory {
    @Option(secure=true, name="package", description="Which BDD package should be used?\n- java:   JavaBDD (default, no dependencies, many features)\n- sylvan: Sylvan (only 64bit Linux, uses multiple threads)\n- cudd:   CUDD (native library required, reordering not supported)\n- micro:  MicroFactory (maximum number of BDD variables is 1024, slow, but less memory-comsumption)\n- buddy:  Buddy (native library required)\n- cal:    CAL (native library required)\n- jdd:    JDD\n- pjbdd:  A java native parallel bdd framework", values={"JAVA", "SYLVAN", "CUDD", "MICRO", "BUDDY", "CAL", "JDD", "PJBDD"}, toUppercase=true)
    private String bddPackage = "JAVA";
    @Option(secure=true, description="sequentialize all accesses to the BDD library.")
    private boolean synchronizeLibraryAccess = false;
    @Option(secure=true, description="Measure the time spent in the BDD library. The behaviour in case of concurrent accesses is undefined!")
    private boolean measureLibraryAccess = false;
    @Option(secure=true, description="Count accesses for the BDD library. Counting works for concurrent accesses.")
    private boolean countLibraryAccess = false;
    private final Configuration config;
    private final LogManager logger;

    public BDDManagerFactory(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
    }

    public RegionManager createRegionManager() throws InvalidConfigurationException {
        RegionManager rmgr = this.bddPackage.equals("SYLVAN") ? new SylvanBDDRegionManager(this.config, this.logger) : (this.bddPackage.equals("PJBDD") ? new PJBDDRegionManager(this.config) : new JavaBDDRegionManager(this.bddPackage, this.config, this.logger));
        if (this.measureLibraryAccess) {
            rmgr = new TimedRegionManager(rmgr);
        }
        if (this.countLibraryAccess) {
            rmgr = new CountingRegionManager(rmgr);
        }
        if (this.synchronizeLibraryAccess) {
            rmgr = new SynchronizedRegionManager(rmgr);
        }
        return rmgr;
    }
}

