/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.primitives.ImmutableIntArray;
import java.io.PrintStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;
import net.sf.javabdd.JFactory;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.bdd.JavaBDDRegion;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;

@Options(prefix="bdd.javabdd")
class JavaBDDRegionManager
implements RegionManager {
    private static final Level LOG_LEVEL = Level.FINE;
    private final StatInt cleanupQueueSize = new StatInt(StatKind.AVG, "Size of BDD node cleanup queue");
    private final StatTimer cleanupTimer = new StatTimer("Time for BDD node cleanup");
    private final LogManager logger;
    private final BDDFactory factory;
    private final Region trueFormula;
    private final Region falseFormula;
    private final ReferenceQueue<JavaBDDRegion> referenceQueue = new ReferenceQueue();
    private final IdentityHashMap<Reference<? extends JavaBDDRegion>, BDD> referenceMap = new IdentityHashMap();
    @Option(secure=true, description="Initial size of the BDD node table in percentage of available Java heap memory (only used if initTableSize is 0).")
    private double initTableRatio = 0.001;
    @Option(secure=true, description="Initial size of the BDD node table, use 0 for size based on initTableRatio.")
    @IntegerOption(min=0L)
    private int initTableSize = 0;
    @Option(secure=true, description="Initial size of the BDD cache, use 0 for cacheRatio*initTableSize.")
    @IntegerOption(min=0L)
    private int cacheSize = 0;
    @Option(secure=true, description="Size of the BDD cache in relation to the node table size (set to 0 to use fixed BDD cache size).")
    private double cacheRatio = 0.1;
    private int nextvar = 0;
    private int varcount = 100;

    @SuppressForbidden(value="reflection on own methods")
    JavaBDDRegionManager(String bddPackage, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        if (this.initTableRatio <= 0.0 || this.initTableRatio >= 1.0) {
            throw new InvalidConfigurationException("Invalid value " + this.initTableRatio + " for option bdd.javabdd.initTableRatio, needs to be between 0 and 1.");
        }
        if (this.initTableSize == 0) {
            double size = (double)Runtime.getRuntime().maxMemory() * this.initTableRatio / 5.0 / 4.0;
            this.initTableSize = size > 2.147483647E9 ? Integer.MAX_VALUE : (int)size;
            this.logger.log(Level.CONFIG, new Object[]{"Setting value of bdd.javabdd.initTableSize to", this.initTableSize});
        }
        if (this.cacheRatio < 0.0) {
            throw new InvalidConfigurationException("Invalid value " + this.cacheRatio + " for option bdd.javabdd.cacheRatio, cannot be negative.");
        }
        if (this.cacheSize == 0) {
            this.cacheSize = (int)((double)this.initTableSize * this.cacheRatio);
        }
        this.factory = BDDFactory.init((String)bddPackage.toLowerCase(), (int)this.initTableSize, (int)this.cacheSize);
        try {
            Method gcCallback = JavaBDDRegionManager.class.getDeclaredMethod("gcCallback", Integer.class, BDDFactory.GCStats.class);
            gcCallback.setAccessible(true);
            this.factory.registerGCCallback((Object)this, gcCallback);
            Method resizeCallback = JavaBDDRegionManager.class.getDeclaredMethod("resizeCallback", Integer.class, Integer.class);
            resizeCallback.setAccessible(true);
            this.factory.registerResizeCallback((Object)this, resizeCallback);
            Method reorderCallback = JavaBDDRegionManager.class.getDeclaredMethod("reorderCallback", Integer.class, BDDFactory.ReorderStats.class);
            reorderCallback.setAccessible(true);
            this.factory.registerReorderCallback((Object)this, reorderCallback);
            if (!this.logger.wouldBeLogged(LOG_LEVEL)) {
                this.factory.unregisterGCCallback((Object)this, gcCallback);
                this.factory.unregisterResizeCallback((Object)this, resizeCallback);
                this.factory.unregisterReorderCallback((Object)this, reorderCallback);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        this.factory.setVarNum(this.varcount);
        this.factory.setCacheRatio(this.cacheRatio);
        this.trueFormula = new JavaBDDRegion(this.factory.one());
        this.falseFormula = new JavaBDDRegion(this.factory.zero());
    }

    private void gcCallback(Integer pre, BDDFactory.GCStats stats) {
        if (this.logger.wouldBeLogged(LOG_LEVEL)) {
            switch (pre) {
                case 1: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Starting BDD Garbage Collection"});
                    break;
                }
                case 0: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Finished BDD", stats});
                    break;
                }
                default: {
                    this.logger.log(LOG_LEVEL, new Object[]{stats});
                }
            }
        }
    }

    private void resizeCallback(Integer oldSize, Integer newSize) {
        this.logger.log(LOG_LEVEL, new Object[]{"BDD node table resized from", oldSize, "to", newSize});
    }

    private void reorderCallback(Integer pre, BDDFactory.ReorderStats stats) {
        if (this.logger.wouldBeLogged(LOG_LEVEL)) {
            switch (pre) {
                case 1: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Starting BDD Reordering"});
                    break;
                }
                case 0: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Finished BDD Reordering:", stats});
                    break;
                }
                default: {
                    this.logger.log(LOG_LEVEL, new Object[]{stats});
                }
            }
        }
    }

    @Override
    public void printStatistics(PrintStream out) {
        try {
            BDDFactory.GCStats stats = this.factory.getGCStats();
            int currentCacheSize = this.readCacheSize();
            StatisticsWriter.writingStatisticsTo(out).put("Number of BDD nodes", this.factory.getNodeNum()).put("Size of BDD node table", this.factory.getNodeTableSize()).putIf(currentCacheSize >= 0, "Size of BDD cache", currentCacheSize).put(this.cleanupQueueSize).put(this.cleanupTimer).put("Time for BDD garbage collection", TimeSpan.ofMillis((long)stats.sumtime).formatAs(TimeUnit.SECONDS) + " (in " + stats.num + " runs)");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @SuppressForbidden(value="reflection only for statistics")
    private int readCacheSize() {
        if (this.factory instanceof JFactory) {
            try {
                Field cacheField = JFactory.class.getDeclaredField("applycache");
                cacheField.setAccessible(true);
                Object cache = cacheField.get(this.factory);
                if (cache != null) {
                    Field tableField = cache.getClass().getDeclaredField("table");
                    tableField.setAccessible(true);
                    Object table = tableField.get(cache);
                    if (table instanceof Object[]) {
                        return ((Object[])table).length;
                    }
                }
            }
            catch (ReflectiveOperationException | SecurityException e) {
                this.logger.logDebugException((Throwable)e, "Could not access cache field of JFactory for statistics");
            }
            return -1;
        }
        return this.factory.getCacheSize();
    }

    private BDD createNewVar() {
        if (this.nextvar >= this.varcount) {
            this.varcount = (int)((double)this.varcount * 1.5);
            this.factory.setVarNum(this.varcount);
        }
        BDD ret = this.factory.ithVar(this.nextvar++);
        return ret;
    }

    @Override
    public JavaBDDRegion createPredicate() {
        this.cleanupReferences();
        return this.wrap(this.createNewVar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        this.cleanupTimer.start();
        try {
            Reference<JavaBDDRegion> ref;
            int count = 0;
            while ((ref = this.referenceQueue.poll()) != null) {
                ++count;
                BDD bdd = this.referenceMap.remove(ref);
                assert (bdd != null);
                bdd.free();
            }
            this.cleanupQueueSize.setNextValue(count);
        }
        finally {
            this.cleanupTimer.stop();
        }
    }

    private JavaBDDRegion wrap(BDD bdd) {
        JavaBDDRegion region = new JavaBDDRegion(bdd);
        PhantomReference<JavaBDDRegion> ref = new PhantomReference<JavaBDDRegion>(region, this.referenceQueue);
        this.referenceMap.put(ref, bdd);
        return region;
    }

    private static BDD unwrap(Region region) {
        return ((JavaBDDRegion)region).getBDD();
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDD imp = JavaBDDRegionManager.unwrap(pF1).imp(JavaBDDRegionManager.unwrap(pF2));
        boolean result = imp.isOne();
        imp.free();
        return result;
    }

    @Override
    public Region makeTrue() {
        this.cleanupReferences();
        return this.trueFormula;
    }

    @Override
    public Region makeFalse() {
        this.cleanupReferences();
        return this.falseFormula;
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF1).and(JavaBDDRegionManager.unwrap(pF2)));
    }

    @Override
    public Region makeNot(Region pF) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF).not());
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF1).or(JavaBDDRegionManager.unwrap(pF2)));
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF1).biimp(JavaBDDRegionManager.unwrap(pF2)));
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF1).xor(JavaBDDRegionManager.unwrap(pF2)));
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        this.cleanupReferences();
        return this.wrap(JavaBDDRegionManager.unwrap(pF1).ite(JavaBDDRegionManager.unwrap(pF2), JavaBDDRegionManager.unwrap(pF3)));
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        this.cleanupReferences();
        BDD f = JavaBDDRegionManager.unwrap(pF);
        JavaBDDRegion predicate = this.wrap(this.factory.ithVar(f.var()));
        JavaBDDRegion fThen = this.wrap(f.high());
        JavaBDDRegion fElse = this.wrap(f.low());
        return Triple.of(predicate, fThen, fElse);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        this.cleanupReferences();
        if (pF2.length == 0 || pF1.isTrue() || pF1.isFalse()) {
            return pF1;
        }
        BDD f = JavaBDDRegionManager.unwrap(pF2[0]).id();
        for (int i = 1; i < pF2.length; ++i) {
            f.andWith(JavaBDDRegionManager.unwrap(pF2[i]).id());
        }
        JavaBDDRegion result = this.wrap(JavaBDDRegionManager.unwrap(pF1).exist(f));
        f.free();
        return result;
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return new BDDRegionBuilder(pShutdownNotifier);
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView fmgr, Function<BooleanFormula, Region> atomToRegion) {
        this.cleanupReferences();
        BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
        if (bfmgr.isFalse(pF)) {
            return this.makeFalse();
        }
        if (bfmgr.isTrue(pF)) {
            return this.makeTrue();
        }
        try (FormulaToRegionConverter converter = new FormulaToRegionConverter(fmgr, atomToRegion);){
            JavaBDDRegion javaBDDRegion = this.wrap(bfmgr.visit(pF, converter));
            return javaBDDRegion;
        }
    }

    @Override
    public String getVersion() {
        return this.factory.getVersion();
    }

    @Override
    public void setVarOrder(ImmutableIntArray pVarOrder) {
        int[] order = new int[this.varcount];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i < pVarOrder.length() ? pVarOrder.get(i) : i;
        }
        this.factory.setVarOrder(order);
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy strategy) {
        switch (strategy) {
            case RANDOM: {
                this.factory.reorder(BDDFactory.REORDER_RANDOM);
                break;
            }
            case SIFT: {
                this.factory.reorder(BDDFactory.REORDER_SIFT);
                break;
            }
            case SIFTITE: {
                this.factory.reorder(BDDFactory.REORDER_SIFTITE);
                break;
            }
            case WIN2: {
                this.factory.reorder(BDDFactory.REORDER_WIN2);
                break;
            }
            case WIN2ITE: {
                this.factory.reorder(BDDFactory.REORDER_WIN2ITE);
                break;
            }
            case WIN3: {
                this.factory.reorder(BDDFactory.REORDER_WIN3);
                break;
            }
            case WIN3ITE: {
                this.factory.reorder(BDDFactory.REORDER_WIN3ITE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Reorder strategy " + strategy + " not supported");
            }
        }
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        Preconditions.checkArgument((pOldPredicates.size() == pNewPredicates.size() ? 1 : 0) != 0);
        BDDPairing pairing = this.factory.makePair();
        Streams.forEachPair(pOldPredicates.stream().map(JavaBDDRegionManager::unwrap), pNewPredicates.stream().map(JavaBDDRegionManager::unwrap), (r1, r2) -> pairing.set(r1.var(), r2.var()));
        return this.wrap(JavaBDDRegionManager.unwrap(pRegion).replace(pairing));
    }

    private class FormulaToRegionConverter
    implements AutoCloseable,
    BooleanFormulaVisitor<BDD> {
        private final Function<BooleanFormula, Region> atomToRegion;
        private final Map<BooleanFormula, BDD> cache = new HashMap<BooleanFormula, BDD>();
        private final BooleanFormulaManager bfmgr;

        FormulaToRegionConverter(FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
            this.atomToRegion = pAtomToRegion;
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        public BDD visitConstant(boolean value) {
            return value ? JavaBDDRegionManager.this.factory.one() : JavaBDDRegionManager.this.factory.zero();
        }

        public BDD visitBoundVar(BooleanFormula var, int deBruijnIdx) {
            throw new UnsupportedOperationException();
        }

        public BDD visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            return ((JavaBDDRegion)this.atomToRegion.apply(pAtom)).getBDD().id();
        }

        private BDD convert(BooleanFormula pOperand) {
            BDD operand = this.cache.get(pOperand);
            if (operand == null) {
                operand = (BDD)this.bfmgr.visit(pOperand, (BooleanFormulaVisitor)this);
                this.cache.put(pOperand, operand);
            }
            return operand.id();
        }

        @Override
        public void close() {
            for (BDD bdd : this.cache.values()) {
                bdd.free();
            }
            this.cache.clear();
        }

        public BDD visitNot(BooleanFormula pOperand) {
            BDD operand = this.convert(pOperand);
            BDD result = operand.not();
            operand.free();
            return result;
        }

        private BDD visitBinary(BooleanFormula pOperand1, BooleanFormula pOperand2, BDDFactory.BDDOp operator) {
            BDD operand1 = this.convert(pOperand1);
            BDD operand2 = this.convert(pOperand2);
            return operand1.applyWith(operand2, operator);
        }

        private BDD visitMulti(BDDFactory.BDDOp operator, List<BooleanFormula> pOperands) {
            Preconditions.checkArgument((pOperands.size() >= 2 ? 1 : 0) != 0);
            BDD result = this.convert(pOperands.get(0));
            for (int i = 1; i < pOperands.size(); ++i) {
                result = result.applyWith(this.convert(pOperands.get(i)), operator);
            }
            return result;
        }

        public BDD visitAnd(List<BooleanFormula> pOperands) {
            return this.visitMulti(BDDFactory.and, pOperands);
        }

        public BDD visitOr(List<BooleanFormula> pOperands) {
            return this.visitMulti(BDDFactory.or, pOperands);
        }

        public BDD visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            return this.visitBinary(operand1, operand2, BDDFactory.xor);
        }

        public BDD visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return this.visitBinary(pOperand1, pOperand2, BDDFactory.biimp);
        }

        public BDD visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return this.visitBinary(pOperand1, pOperand2, BDDFactory.imp);
        }

        public BDD visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            BDD condition = this.convert(pCondition);
            BDD thenBDD = this.convert(pThenFormula);
            BDD elseBDD = this.convert(pElseFormula);
            BDD result = condition.ite(thenBDD, elseBDD);
            condition.free();
            thenBDD.free();
            elseBDD.free();
            return result;
        }

        public BDD visitQuantifier(QuantifiedFormulaManager.Quantifier q, BooleanFormula quantifiedAST, List<Formula> args, BooleanFormula pBody) {
            throw new UnsupportedOperationException();
        }
    }

    private class BDDRegionBuilder
    implements RegionCreator.RegionBuilder {
        private final ShutdownNotifier shutdownNotifier;
        private final List<BDD> cubes = new ArrayList<BDD>();
        private BDD currentCube = null;

        private BDDRegionBuilder(ShutdownNotifier pShutdownNotifier) {
            this.shutdownNotifier = pShutdownNotifier;
        }

        @Override
        public void startNewConjunction() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            this.currentCube = JavaBDDRegionManager.this.factory.one();
        }

        @Override
        public void addPositiveRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube.andWith(((JavaBDDRegion)r).getBDD().id());
        }

        @Override
        public void addNegativeRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube.andWith(((JavaBDDRegion)r).getBDD().not());
        }

        @Override
        public void finishConjunction() {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            for (int i = 0; i < this.cubes.size(); ++i) {
                BDD cubeAtI = this.cubes.get(i);
                if (cubeAtI == null) {
                    this.cubes.set(i, this.currentCube);
                    this.currentCube = null;
                    return;
                }
                this.currentCube.orWith(cubeAtI);
                this.cubes.set(i, null);
            }
            if (this.currentCube != null) {
                this.cubes.add(this.currentCube);
                this.currentCube = null;
            }
        }

        @Override
        public Region getResult() throws InterruptedException {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            if (this.cubes.isEmpty()) {
                return JavaBDDRegionManager.this.falseFormula;
            }
            this.buildBalancedOr();
            return JavaBDDRegionManager.this.wrap(((BDD)Iterables.getOnlyElement(this.cubes)).id());
        }

        private void buildBalancedOr() throws InterruptedException {
            BDD result = JavaBDDRegionManager.this.factory.zero();
            for (BDD cube : this.cubes) {
                if (cube == null) continue;
                this.shutdownNotifier.shutdownIfNecessary();
                result.orWith(cube);
            }
            this.cubes.clear();
            this.cubes.add(result);
            assert (this.cubes.size() == 1);
        }

        @Override
        public void close() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            for (BDD bdd : this.cubes) {
                bdd.free();
            }
            this.cubes.clear();
        }
    }
}

