/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.bdd.PJBDDRegion;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.CreatorBuilder;
import org.sosy_lab.pjbdd.api.DD;

public class PJBDDRegionManager
implements RegionManager {
    private final Region trueFormula;
    private final Region falseFormula;
    private final Creator bddCreator;

    public PJBDDRegionManager(Configuration pConfig) throws InvalidConfigurationException {
        BuildFromConfig buildFromConfig = new BuildFromConfig(pConfig);
        this.bddCreator = buildFromConfig.makeCreator();
        this.trueFormula = PJBDDRegion.wrap(this.bddCreator.makeTrue());
        this.falseFormula = PJBDDRegion.wrap(this.bddCreator.makeFalse());
    }

    @Override
    public boolean entails(Region f1, Region f2) {
        return this.bddCreator.makeImply(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2)).isTrue();
    }

    @Override
    public Region createPredicate() {
        return PJBDDRegion.wrap(this.bddCreator.makeVariable());
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView fmgr, Function<BooleanFormula, Region> atomToRegion) {
        BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
        if (bfmgr.isFalse(pF)) {
            return this.makeFalse();
        }
        if (bfmgr.isTrue(pF)) {
            return this.makeTrue();
        }
        try (FormulaToRegionConverter converter = new FormulaToRegionConverter(fmgr, atomToRegion);){
            Region region = PJBDDRegion.wrap(bfmgr.visit(pF, converter));
            return region;
        }
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region f) {
        DD bdd = PJBDDRegion.unwrap(f);
        return Triple.of(PJBDDRegion.wrap(this.bddCreator.makeIthVar(bdd.getVariable())), PJBDDRegion.wrap(bdd.getHigh()), PJBDDRegion.wrap(bdd.getLow()));
    }

    @Override
    public void printStatistics(PrintStream out) {
        out.print(this.bddCreator.getCreatorStats().prettyPrint());
    }

    @Override
    public String getVersion() {
        return this.bddCreator.getVersion();
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
        this.bddCreator.setVarOrder(pOrder.asList());
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy strategy) {
        throw new UnsupportedOperationException("dynamic reordering not yet implemented");
    }

    @Override
    public RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return new RegionBuilder();
    }

    @Override
    public Region makeTrue() {
        return this.trueFormula;
    }

    @Override
    public Region makeFalse() {
        return this.falseFormula;
    }

    @Override
    public Region makeNot(Region f) {
        return PJBDDRegion.wrap(this.bddCreator.makeNot(PJBDDRegion.unwrap(f)));
    }

    @Override
    public Region makeAnd(Region f1, Region f2) {
        return PJBDDRegion.wrap(this.bddCreator.makeAnd(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2)));
    }

    @Override
    public Region makeOr(Region f1, Region f2) {
        return PJBDDRegion.wrap(this.bddCreator.makeOr(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2)));
    }

    @Override
    public Region makeEqual(Region f1, Region f2) {
        return PJBDDRegion.wrap(this.bddCreator.makeEqual(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2)));
    }

    @Override
    public Region makeUnequal(Region f1, Region f2) {
        return PJBDDRegion.wrap(this.bddCreator.makeUnequal(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2)));
    }

    @Override
    public Region makeIte(Region f1, Region f2, Region f3) {
        return PJBDDRegion.wrap(this.bddCreator.makeIte(PJBDDRegion.unwrap(f1), PJBDDRegion.unwrap(f2), PJBDDRegion.unwrap(f3)));
    }

    @Override
    public Region makeExists(Region f1, Region ... f2) {
        DD[] bddLevels = new DD[f2.length];
        IntStream.range(0, f2.length).forEach(i -> {
            bddLevels[i] = PJBDDRegion.unwrap(f2[i]);
        });
        return PJBDDRegion.wrap(this.bddCreator.makeExists(PJBDDRegion.unwrap(f1), bddLevels));
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        Preconditions.checkArgument((pOldPredicates.size() == pNewPredicates.size() ? 1 : 0) != 0);
        DD bdd = PJBDDRegion.unwrap(pRegion);
        for (int i = 0; i < pOldPredicates.size(); ++i) {
            DD oldVar = this.bddCreator.makeIthVar(PJBDDRegion.unwrap(pOldPredicates.get(i)).getVariable());
            DD newVar = this.bddCreator.makeIthVar(PJBDDRegion.unwrap(pNewPredicates.get(i)).getVariable());
            bdd = this.bddCreator.makeReplace(bdd, oldVar, newVar);
        }
        return PJBDDRegion.wrap(bdd);
    }

    private class RegionBuilder
    implements RegionCreator.RegionBuilder {
        private final List<DD> cubes = new ArrayList<DD>();
        private DD currentCube;

        private RegionBuilder() {
        }

        @Override
        public void startNewConjunction() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            this.currentCube = PJBDDRegionManager.this.bddCreator.makeTrue();
        }

        @Override
        public void addPositiveRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube = PJBDDRegionManager.this.bddCreator.makeAnd(this.currentCube, PJBDDRegion.unwrap(r));
        }

        @Override
        public void addNegativeRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube = PJBDDRegionManager.this.bddCreator.makeAnd(this.currentCube, PJBDDRegionManager.this.bddCreator.makeNot(PJBDDRegion.unwrap(r)));
        }

        @Override
        public void finishConjunction() {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            for (int i = 0; i < this.cubes.size(); ++i) {
                DD cubeAtI = this.cubes.get(i);
                if (cubeAtI == null) {
                    this.cubes.set(i, this.currentCube);
                    this.currentCube = null;
                    return;
                }
                this.currentCube = PJBDDRegionManager.this.bddCreator.makeOr(this.currentCube, cubeAtI);
                this.cubes.set(i, null);
            }
            if (this.currentCube != null) {
                this.cubes.add(this.currentCube);
                this.currentCube = null;
            }
        }

        @Override
        public Region getResult() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            if (this.cubes.isEmpty()) {
                return PJBDDRegionManager.this.falseFormula;
            }
            DD[] clauses = (DD[])this.cubes.stream().filter(bdd -> bdd != null).toArray(DD[]::new);
            DD result = PJBDDRegionManager.this.bddCreator.makeFalse();
            for (DD bdd2 : clauses) {
                result = PJBDDRegionManager.this.bddCreator.makeOr(result, bdd2);
            }
            this.cubes.clear();
            this.cubes.add(result);
            return PJBDDRegion.wrap(result);
        }

        @Override
        public void close() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            this.cubes.clear();
        }
    }

    private class FormulaToRegionConverter
    implements BooleanFormulaVisitor<DD>,
    AutoCloseable {
        private final Function<BooleanFormula, Region> atomToRegion;
        private final BooleanFormulaManager bfmgr;
        private final Map<BooleanFormula, DD> cache = new HashMap<BooleanFormula, DD>();

        FormulaToRegionConverter(FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
            this.atomToRegion = pAtomToRegion;
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        @Override
        public void close() {
            this.cache.clear();
            PJBDDRegionManager.this.bddCreator.shutDown();
        }

        public DD visitConstant(boolean pB) {
            return pB ? PJBDDRegionManager.this.bddCreator.makeTrue() : PJBDDRegionManager.this.bddCreator.makeFalse();
        }

        public DD visitBoundVar(BooleanFormula pBooleanFormula, int pI) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public DD visitNot(BooleanFormula pBooleanFormula) {
            return PJBDDRegionManager.this.bddCreator.makeNot(this.convert(pBooleanFormula));
        }

        public DD visitAnd(List<BooleanFormula> pList) {
            if (pList.isEmpty()) {
                return PJBDDRegionManager.this.bddCreator.makeFalse();
            }
            DD result = PJBDDRegionManager.this.bddCreator.makeTrue();
            for (BooleanFormula bFormula : pList) {
                result = PJBDDRegionManager.this.bddCreator.makeAnd(result, this.convert(bFormula));
            }
            return result;
        }

        public DD visitOr(List<BooleanFormula> pList) {
            if (pList.isEmpty()) {
                return PJBDDRegionManager.this.bddCreator.makeFalse();
            }
            DD result = PJBDDRegionManager.this.bddCreator.makeFalse();
            for (BooleanFormula bFormula : pList) {
                result = PJBDDRegionManager.this.bddCreator.makeOr(result, this.convert(bFormula));
            }
            return result;
        }

        public DD visitXor(BooleanFormula pBooleanFormula, BooleanFormula pBooleanFormula1) {
            return PJBDDRegionManager.this.bddCreator.makeXor(this.convert(pBooleanFormula), this.convert(pBooleanFormula1));
        }

        public DD visitEquivalence(BooleanFormula pBooleanFormula, BooleanFormula pBooleanFormula1) {
            return PJBDDRegionManager.this.bddCreator.makeEqual(this.convert(pBooleanFormula), this.convert(pBooleanFormula1));
        }

        public DD visitImplication(BooleanFormula pBooleanFormula, BooleanFormula pBooleanFormula1) {
            return PJBDDRegionManager.this.bddCreator.makeImply(this.convert(pBooleanFormula), this.convert(pBooleanFormula1));
        }

        public DD visitIfThenElse(BooleanFormula pBooleanFormula1, BooleanFormula pBooleanFormula2, BooleanFormula pBooleanFormula3) {
            return PJBDDRegionManager.this.bddCreator.makeIte(this.convert(pBooleanFormula1), this.convert(pBooleanFormula2), this.convert(pBooleanFormula3));
        }

        public DD visitQuantifier(QuantifiedFormulaManager.Quantifier pQuantifier, BooleanFormula pBooleanFormula, List<Formula> pList, BooleanFormula pBooleanFormula1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public DD visitAtom(BooleanFormula pBooleanFormula, FunctionDeclaration<BooleanFormula> pFunctionDeclaration) {
            return PJBDDRegion.unwrap(this.atomToRegion.apply(pBooleanFormula));
        }

        private DD convert(BooleanFormula pOperand) {
            DD operand = this.cache.get(pOperand);
            if (operand == null) {
                operand = (DD)this.bfmgr.visit(pOperand, (BooleanFormulaVisitor)this);
                this.cache.put(pOperand, operand);
            }
            return operand;
        }
    }

    @Options(prefix="bdd.pjbdd")
    private static class BuildFromConfig {
        @Option(secure=true, description="unique table's concurrency factor")
        @IntegerOption(min=1L)
        private int tableParallelism = 10000;
        @Option(secure=true, description="initial variable count")
        @IntegerOption(min=1L)
        private int varCount = 100;
        @Option(secure=true, description="increase factor for resizing tables")
        @IntegerOption(min=1L)
        private int increaseFactor = 1;
        @Option(secure=true, description="size of the BDD cache.")
        @IntegerOption(min=1L)
        private int cacheSize = 0;
        @Option(secure=true, description="Number of worker threads, Runtime.getRuntime().availableProcessors() default")
        @IntegerOption(min=1L)
        private int threads = Runtime.getRuntime().availableProcessors();
        @Option(secure=true, description="Initial size of the BDD node table in percentage of available Java heap memory (only used if initTableSize is 0).")
        private double initTableRatio = 0.001;
        @Option(secure=true, description="Initial size of the BDD node table, use 0 for size based on initTableRatio.")
        @IntegerOption(min=0L)
        private int initTableSize = 0;
        @Option(secure=true, description="Size of the BDD cache in relation to the node table size (set to 0 to use fixed BDD cache size).")
        private double cacheRatio = 0.1;
        @Option(secure=true, description="Use internal a int based bdd representation.")
        private boolean useInts = false;
        @Option(secure=true, description="Use bdd chaining.")
        private boolean useChainedBDD = false;
        @Option(secure=true, description="Disable thread safe bdd operations.")
        private boolean disableThreadSafety = false;

        private BuildFromConfig(Configuration pConfig) throws InvalidConfigurationException {
            pConfig.inject((Object)this);
        }

        private Creator makeCreator() {
            if (this.useInts) {
                CreatorBuilder intBuilder = Builders.intBuilder();
                this.resolveProperties(intBuilder);
                return intBuilder.build();
            }
            CreatorBuilder builder = this.useChainedBDD ? Builders.cbddBuilder() : Builders.bddBuilder();
            this.resolveProperties(builder);
            return builder.build();
        }

        private void resolveProperties(CreatorBuilder pBuilder) {
            if ((this.initTableRatio <= 0.0 || this.initTableRatio >= 1.0) && this.initTableSize == 0) {
                this.initTableSize = 100000;
            }
            if (this.initTableSize == 0) {
                double size = (double)Runtime.getRuntime().maxMemory() * this.initTableRatio / 5.0 / 8.0;
                int n = this.initTableSize = size > 2.147483647E9 ? Integer.MAX_VALUE : (int)size;
            }
            if (this.cacheSize == 0) {
                this.cacheSize = (int)((double)this.initTableSize * this.cacheRatio);
                this.cacheSize = Math.max(this.cacheSize, 100000);
            }
            if (this.disableThreadSafety) {
                pBuilder.disableThreadSafety();
            }
            pBuilder.setParallelism(this.tableParallelism).setVarCount(this.varCount).setCacheSize(this.cacheSize).setThreads(this.threads).setTableSize(this.initTableSize).setIncreaseFactor(this.increaseFactor);
            if (this.threads == 1) {
                pBuilder.setParallelizationType(Builders.ParallelizationType.NONE);
            }
        }
    }
}

