/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.PrintStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import jsylvan.JSylvan;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.bdd.SylvanBDDRegion;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionCreator;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;

@Options(prefix="bdd.sylvan")
class SylvanBDDRegionManager
implements RegionManager {
    private static final int SYLVAN_MAX_THREADS = 64;
    @GuardedBy(value="itself")
    private final StatTimer cleanupTimer = new StatTimer("Time for BDD cleanup after GC");
    private final Region trueFormula;
    private final Region falseFormula;
    private final ReferenceQueue<SylvanBDDRegion> referenceQueue = new ReferenceQueue();
    private final Map<Reference<SylvanBDDRegion>, Long> referenceMap = new ConcurrentHashMap<Reference<SylvanBDDRegion>, Long>();
    @Option(secure=true, description="Log2 size of the BDD node table.")
    @IntegerOption(min=1L)
    private int tableSize = 26;
    @Option(secure=true, description="Log2 size of the BDD cache.")
    @IntegerOption(min=1L)
    private int cacheSize = 24;
    @Option(secure=true, description="Granularity of the Sylvan BDD operations cache (recommended values 4-8).")
    @IntegerOption(min=1L)
    private int cacheGranularity = 4;
    @Option(secure=true, description="Number of worker threads, 0 for automatic.")
    @IntegerOption(min=0L)
    private int threads = 0;
    private int nextvar = 0;

    public SylvanBDDRegionManager(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.threads == 0) {
            this.threads = Runtime.getRuntime().availableProcessors();
        }
        if (this.threads > 64) {
            pLogger.logf(Level.WARNING, "Sylvan does not support %d threads, using %d threads.", new Object[]{this.threads, 64});
            this.threads = 64;
        }
        JSylvan.initialize((long)this.threads, (long)100000L, (int)(1 << this.tableSize), (int)(1 << this.cacheSize), (int)this.cacheGranularity);
        this.trueFormula = new SylvanBDDRegion(JSylvan.getTrue());
        this.falseFormula = new SylvanBDDRegion(JSylvan.getFalse());
        Concurrency.newDaemonThread((String)"BDD cleanup thread", (Runnable)new Runnable(){

            @Override
            public void run() {
                SylvanBDDRegionManager.cleanupReferences(SylvanBDDRegionManager.this.referenceQueue, SylvanBDDRegionManager.this.referenceMap, SylvanBDDRegionManager.this.cleanupTimer);
            }
        }).start();
    }

    public static SylvanBDDRegionManager getInstance(Configuration config, LogManager logger) throws InvalidConfigurationException {
        return new SylvanBDDRegionManager(config, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cleanupReferences(ReferenceQueue<SylvanBDDRegion> referenceQueue, Map<Reference<SylvanBDDRegion>, Long> referenceMap, StatTimer cleanupTimer) {
        try {
            while (true) {
                Reference<SylvanBDDRegion> ref = referenceQueue.remove();
                StatTimer statTimer = cleanupTimer;
                synchronized (statTimer) {
                    cleanupTimer.start();
                    long bdd = referenceMap.remove(ref);
                    JSylvan.deref((long)bdd);
                    cleanupTimer.stop();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatistics(PrintStream out) {
        StatTimer statTimer = this.cleanupTimer;
        synchronized (statTimer) {
            StatisticsWriter.writingStatisticsTo(out).putIf(this.cleanupTimer.getUpdateCount() > 0, "Number of BDD freed by GC", this.cleanupTimer.getUpdateCount()).putIfUpdatedAtLeastOnce(this.cleanupTimer);
        }
    }

    @Override
    public SylvanBDDRegion createPredicate() {
        return this.wrap(JSylvan.makeVar((int)this.nextvar++));
    }

    private SylvanBDDRegion wrap(long bdd) {
        JSylvan.ref((long)bdd);
        SylvanBDDRegion region = new SylvanBDDRegion(bdd);
        PhantomReference<SylvanBDDRegion> ref = new PhantomReference<SylvanBDDRegion>(region, this.referenceQueue);
        this.referenceMap.put(ref, bdd);
        return region;
    }

    private long unwrap(Region region) {
        return ((SylvanBDDRegion)region).getBDD();
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        long imp = JSylvan.makeImplies((long)this.unwrap(pF1), (long)this.unwrap(pF2));
        return imp == JSylvan.getTrue();
    }

    @Override
    public Region makeTrue() {
        return this.trueFormula;
    }

    @Override
    public Region makeFalse() {
        return this.falseFormula;
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        return this.wrap(JSylvan.makeAnd((long)this.unwrap(pF1), (long)this.unwrap(pF2)));
    }

    @Override
    public Region makeNot(Region pF) {
        return this.wrap(JSylvan.makeNot((long)this.unwrap(pF)));
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        return this.wrap(JSylvan.makeOr((long)this.unwrap(pF1), (long)this.unwrap(pF2)));
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        return this.wrap(JSylvan.makeEquals((long)this.unwrap(pF1), (long)this.unwrap(pF2)));
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        return this.wrap(JSylvan.makeNotEquals((long)this.unwrap(pF1), (long)this.unwrap(pF2)));
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        return this.wrap(JSylvan.makeIte((long)this.unwrap(pF1), (long)this.unwrap(pF2), (long)this.unwrap(pF3)));
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        long f = this.unwrap(pF);
        SylvanBDDRegion predicate = this.wrap(JSylvan.getIf((long)f));
        SylvanBDDRegion fThen = this.wrap(JSylvan.getThen((long)f));
        SylvanBDDRegion fElse = this.wrap(JSylvan.getElse((long)f));
        return Triple.of(predicate, fThen, fElse);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        if (pF2.length == 0) {
            return pF1;
        }
        long tmp = this.unwrap(pF2[0]);
        for (int i = 1; i < pF2.length; ++i) {
            tmp = JSylvan.makeAnd((long)tmp, (long)this.unwrap(pF2[i]));
        }
        SylvanBDDRegion result = this.wrap(JSylvan.makeExists((long)this.unwrap(pF1), (long)tmp));
        return result;
    }

    @Override
    public RegionCreator.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return new SylvanBDDRegionBuilder();
    }

    @Override
    public void setVarOrder(ImmutableIntArray pOrder) {
        throw new UnsupportedOperationException("reordering not yet implemented");
    }

    @Override
    public void reorder(RegionManager.VariableOrderingStrategy strategy) {
        throw new UnsupportedOperationException("reordering not yet implemented");
    }

    @Override
    public Region replace(Region pRegion, List<Region> pOldPredicates, List<Region> pNewPredicates) {
        Preconditions.checkArgument((pOldPredicates.size() == pNewPredicates.size() ? 1 : 0) != 0);
        long bdd = this.unwrap(pRegion);
        for (int i = 0; i < pOldPredicates.size(); ++i) {
            long oldVar = JSylvan.getVar((long)this.unwrap(pOldPredicates.get(i)));
            long newVar = JSylvan.getVar((long)this.unwrap(pNewPredicates.get(i)));
            bdd = JSylvan.makeExists((long)JSylvan.makeAnd((long)bdd, (long)JSylvan.makeEquals((long)oldVar, (long)newVar)), (long)oldVar);
        }
        return this.wrap(bdd);
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView fmgr, Function<BooleanFormula, Region> atomToRegion) {
        BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
        if (bfmgr.isFalse(pF)) {
            return this.makeFalse();
        }
        if (bfmgr.isTrue(pF)) {
            return this.makeTrue();
        }
        try (FormulaToRegionConverter converter = new FormulaToRegionConverter(fmgr, atomToRegion);){
            SylvanBDDRegion sylvanBDDRegion = this.wrap(bfmgr.visit(pF, converter));
            return sylvanBDDRegion;
        }
    }

    @Override
    public String getVersion() {
        return String.format("Sylvan (%d threads)", this.threads);
    }

    static {
        NativeLibraries.loadLibrary((String)"sylvan");
    }

    private class FormulaToRegionConverter
    implements BooleanFormulaVisitor<Long>,
    AutoCloseable {
        private final Function<BooleanFormula, Region> atomToRegion;
        private final BooleanFormulaManager bfmgr;
        private final Map<BooleanFormula, Long> cache = new HashMap<BooleanFormula, Long>();

        FormulaToRegionConverter(FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
            this.atomToRegion = pAtomToRegion;
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        public Long visitConstant(boolean value) {
            return value ? JSylvan.getTrue() : JSylvan.getFalse();
        }

        public Long visitBoundVar(BooleanFormula var, int deBruijnIdx) {
            throw new UnsupportedOperationException();
        }

        public Long visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            return SylvanBDDRegionManager.this.unwrap(this.atomToRegion.apply(pAtom));
        }

        private long convert(BooleanFormula pOperand) {
            Long operand = this.cache.get(pOperand);
            if (operand == null) {
                operand = JSylvan.ref((long)((Long)this.bfmgr.visit(pOperand, (BooleanFormulaVisitor)this)));
                this.cache.put(pOperand, operand);
            }
            return operand;
        }

        @Override
        public void close() {
            for (long bdd : this.cache.values()) {
                JSylvan.deref((long)bdd);
            }
            this.cache.clear();
        }

        public Long visitNot(BooleanFormula pOperand) {
            return JSylvan.makeNot((long)this.convert(pOperand));
        }

        public Long visitAnd(List<BooleanFormula> pOperands) {
            long result = JSylvan.getTrue();
            for (BooleanFormula f : pOperands) {
                long old = JSylvan.ref((long)result);
                result = JSylvan.makeAnd((long)result, (long)this.convert(f));
                JSylvan.deref((long)old);
            }
            return result;
        }

        public Long visitOr(List<BooleanFormula> pOperands) {
            long result = JSylvan.getFalse();
            for (BooleanFormula f : pOperands) {
                long old = JSylvan.ref((long)result);
                result = JSylvan.makeOr((long)result, (long)this.convert(f));
                JSylvan.deref((long)old);
            }
            return result;
        }

        public Long visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            return JSylvan.makeNotEquals((long)this.convert(operand1), (long)this.convert(operand2));
        }

        public Long visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return JSylvan.makeEquals((long)this.convert(pOperand1), (long)this.convert(pOperand2));
        }

        public Long visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return JSylvan.makeImplies((long)this.convert(pOperand1), (long)this.convert(pOperand2));
        }

        public Long visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            return JSylvan.makeIte((long)this.convert(pCondition), (long)this.convert(pThenFormula), (long)this.convert(pElseFormula));
        }

        public Long visitQuantifier(QuantifiedFormulaManager.Quantifier q, BooleanFormula quantifiedAST, List<Formula> boundVars, BooleanFormula pBody) {
            throw new UnsupportedOperationException();
        }
    }

    private class SylvanBDDRegionBuilder
    implements RegionCreator.RegionBuilder {
        private final List<Long> cubes = new ArrayList<Long>();
        private long currentCube = -1L;

        private SylvanBDDRegionBuilder() {
        }

        @Override
        public void startNewConjunction() {
            Preconditions.checkState((this.currentCube == -1L ? 1 : 0) != 0);
            this.currentCube = JSylvan.ref((long)JSylvan.getTrue());
        }

        @Override
        public void addPositiveRegion(Region r) {
            Preconditions.checkState((this.currentCube != -1L ? 1 : 0) != 0);
            long result = JSylvan.ref((long)JSylvan.makeAnd((long)this.currentCube, (long)SylvanBDDRegionManager.this.unwrap(r)));
            JSylvan.deref((long)this.currentCube);
            this.currentCube = result;
        }

        @Override
        public void addNegativeRegion(Region r) {
            Preconditions.checkState((this.currentCube != -1L ? 1 : 0) != 0);
            long negative = JSylvan.ref((long)JSylvan.makeNot((long)SylvanBDDRegionManager.this.unwrap(r)));
            long result = JSylvan.ref((long)JSylvan.makeAnd((long)this.currentCube, (long)negative));
            JSylvan.deref((long)negative);
            JSylvan.deref((long)this.currentCube);
            this.currentCube = result;
        }

        @Override
        public void finishConjunction() {
            Preconditions.checkState((this.currentCube != -1L ? 1 : 0) != 0);
            for (int i = 0; i < this.cubes.size(); ++i) {
                Long cubeAtI = this.cubes.get(i);
                if (cubeAtI == null) {
                    this.cubes.set(i, this.currentCube);
                    this.currentCube = -1L;
                    return;
                }
                long result = JSylvan.ref((long)JSylvan.makeOr((long)this.currentCube, (long)cubeAtI));
                JSylvan.deref((long)this.currentCube);
                JSylvan.deref((long)cubeAtI);
                this.currentCube = result;
                this.cubes.set(i, null);
            }
            if (this.currentCube != -1L) {
                this.cubes.add(this.currentCube);
                this.currentCube = -1L;
            }
        }

        @Override
        public Region getResult() throws InterruptedException {
            Preconditions.checkState((this.currentCube == -1L ? 1 : 0) != 0);
            if (this.cubes.isEmpty()) {
                return SylvanBDDRegionManager.this.falseFormula;
            }
            long[] clauses = Longs.toArray((Collection)FluentIterable.from(this.cubes).filter(Predicates.notNull()).toList());
            long result = JSylvan.ref((long)JSylvan.makeUnionPar((long[])clauses));
            for (long bdd : clauses) {
                JSylvan.deref((long)bdd);
            }
            this.cubes.clear();
            this.cubes.add(result);
            return SylvanBDDRegionManager.this.wrap(result);
        }

        @Override
        public void close() {
            Preconditions.checkState((this.currentCube == -1L ? 1 : 0) != 0);
            for (long bdd : this.cubes) {
                JSylvan.deref((long)bdd);
            }
            this.cubes.clear();
        }
    }
}

