/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

enum CexTraceAnalysisDirection {
    FORWARDS{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            return ImmutableIntArray.copyOf((IntStream)IntStream.range(0, traceFormulas.size()));
        }
    }
    ,
    BACKWARDS{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            ImmutableIntArray.Builder order = ImmutableIntArray.builder((int)traceFormulas.size());
            for (int i = traceFormulas.size() - 1; i >= 0; --i) {
                order.add(i);
            }
            return order.build();
        }
    }
    ,
    ZIGZAG{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            ImmutableIntArray.Builder order = ImmutableIntArray.builder((int)traceFormulas.size());
            int e = traceFormulas.size() - 1;
            int s = 0;
            boolean fromStart = false;
            while (s <= e) {
                int i = fromStart ? s++ : e--;
                fromStart = !fromStart;
                order.add(i);
            }
            return order.build();
        }
    }
    ,
    LOOP_FREE_FIRST{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            ListMultimap loopLevelsToIndexMap = MultimapBuilder.treeKeys().arrayListValues().build();
            CexTraceAnalysisDirection.createLoopDrivenStateOrdering(abstractionStates, (Multimap<Integer, Integer>)loopLevelsToIndexMap, new ArrayDeque<CFANode>(), pLoopStructure);
            return ImmutableIntArray.copyOf((Collection)loopLevelsToIndexMap.values());
        }
    }
    ,
    RANDOM{
        private final Random rnd = new Random(0L);

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            int[] array = IntStream.range(0, traceFormulas.size()).toArray();
            for (int i = array.length - 1; i > 0; --i) {
                int swapWith = this.rnd.nextInt(i + 1);
                int temp = array[i];
                array[i] = array[swapWith];
                array[swapWith] = temp;
            }
            return ImmutableIntArray.copyOf((int[])array);
        }
    }
    ,
    LOWEST_AVG_SCORE{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            return ImmutableIntArray.copyOf((IntStream)CexTraceAnalysisDirection.getIndexScoreTuples(traceFormulas, pVariableClassification, pLoopStructure, pFmgr).sorted(Comparator.comparing(Pair::getSecond)).mapToInt(Pair::getFirst));
        }
    }
    ,
    HIGHEST_AVG_SCORE{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            Comparator<Pair> scoreComparator = Comparator.comparing(Pair::getSecond);
            return ImmutableIntArray.copyOf((IntStream)CexTraceAnalysisDirection.getIndexScoreTuples(traceFormulas, pVariableClassification, pLoopStructure, pFmgr).sorted(scoreComparator.reversed()).mapToInt(Pair::getFirst));
        }
    }
    ,
    LOOP_FREE_FIRST_BACKWARDS{

        @Override
        public ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> abstractionStates, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
            ListMultimap loopLevelsToIndexMap = MultimapBuilder.treeKeys().arrayListValues().build();
            CexTraceAnalysisDirection.createLoopDrivenStateOrdering(abstractionStates, (Multimap<Integer, Integer>)loopLevelsToIndexMap, new ArrayDeque<CFANode>(), pLoopStructure);
            ImmutableIntArray.Builder order = ImmutableIntArray.builder((int)traceFormulas.size());
            for (List indices : Multimaps.asMap((ListMultimap)loopLevelsToIndexMap).values()) {
                order.addAll((Collection)Lists.reverse((List)indices));
            }
            return order.build();
        }
    };


    public abstract ImmutableIntArray orderFormulas(List<BooleanFormula> var1, List<AbstractState> var2, VariableClassification var3, LoopStructure var4, FormulaManagerView var5);

    private static Stream<Pair<Integer, Double>> getIndexScoreTuples(List<BooleanFormula> traceFormulas, VariableClassification pVariableClassification, LoopStructure pLoopStructure, FormulaManagerView pFmgr) {
        return Streams.mapWithIndex(traceFormulas.stream(), (formula, index) -> Pair.of((int)index, CexTraceAnalysisDirection.getAVGScoreForVariables(formula, pVariableClassification, pFmgr, pLoopStructure)));
    }

    private static double getAVGScoreForVariables(BooleanFormula formula, VariableClassification variableClassification, FormulaManagerView fmgr, LoopStructure loopStructure) {
        ImmutableSet varNames = FluentIterable.from(fmgr.extractVariableNames((Formula)formula)).transform(variable -> {
            Pair<String, OptionalInt> name = FormulaManagerView.parseName(variable);
            return name.getSecond().isPresent() ? name.getFirst() : null;
        }).filter(Predicates.notNull()).toSet();
        double currentScore = 0.0;
        for (String variableName : varNames) {
            currentScore = variableClassification.getIntBoolVars().contains(variableName) ? (currentScore += 2.0) : (variableClassification.getIntEqualVars().contains(variableName) ? (currentScore += 4.0) : (currentScore += 16.0));
            if (loopStructure.getLoopIncDecVariables().contains(variableName)) {
                currentScore += 100.0;
            }
            if (!(currentScore < 0.0)) continue;
            return Double.MAX_VALUE / (double)varNames.size();
        }
        if (varNames.isEmpty()) {
            return 0.0;
        }
        return currentScore / (double)varNames.size();
    }

    private static void createLoopDrivenStateOrdering(List<AbstractState> pAbstractionStates, Multimap<Integer, Integer> loopLevelsToIndexMap, Deque<CFANode> actLevelStack, LoopStructure loopStructure) {
        int actARGState;
        ImmutableSet<CFANode> loopHeads = loopStructure.getAllLoopHeads();
        CFANode actCFANode = null;
        boolean isCFANodeALoopHead = false;
        for (actARGState = loopLevelsToIndexMap.size(); !isCFANodeALoopHead && actLevelStack.isEmpty() && actARGState < pAbstractionStates.size(); ++actARGState) {
            actCFANode = AbstractStates.extractLocation(pAbstractionStates.get(actARGState));
            loopLevelsToIndexMap.put((Object)0, (Object)actARGState);
            isCFANodeALoopHead = loopHeads.contains((Object)actCFANode);
        }
        if (actARGState != pAbstractionStates.size()) {
            actLevelStack.push(actCFANode);
            CexTraceAnalysisDirection.createLoopDrivenStateOrdering0(pAbstractionStates, loopLevelsToIndexMap, actLevelStack, loopStructure);
        }
    }

    private static void createLoopDrivenStateOrdering0(List<AbstractState> pAbstractionStates, Multimap<Integer, Integer> loopLevelsToIndexMap, Deque<CFANode> actLevelStack, LoopStructure loopStructure) {
        if (loopLevelsToIndexMap.size() == pAbstractionStates.size()) {
            return;
        }
        int actARGState = loopLevelsToIndexMap.size();
        AbstractState lastState = pAbstractionStates.get(actARGState - 1);
        AbstractState actState = pAbstractionStates.get(actARGState);
        @Nullable CFANode actCFANode = AbstractStates.extractLocation(actState);
        Iterator<CFANode> it = actLevelStack.descendingIterator();
        while (it.hasNext()) {
            Preconditions.checkNotNull((Object)actCFANode, (Object)"node may be null and code needs to be fixed");
            CFANode lastLoopNode = it.next();
            if (actCFANode.getFunctionName().equals(lastLoopNode.getFunctionName())) {
                actCFANode = CexTraceAnalysisDirection.getPrevFunctionNode((ARGState)actState, (ARGState)lastState, lastLoopNode.getFunctionName());
            }
            if (actCFANode == null || !CexTraceAnalysisDirection.isNodePartOfLoop(lastLoopNode, actCFANode, loopStructure)) {
                it.remove();
                continue;
            }
            loopLevelsToIndexMap.put((Object)actLevelStack.size(), (Object)actARGState);
            if (loopStructure.getAllLoopHeads().contains((Object)actCFANode)) {
                actLevelStack.push(actCFANode);
            }
            CexTraceAnalysisDirection.createLoopDrivenStateOrdering0(pAbstractionStates, loopLevelsToIndexMap, actLevelStack, loopStructure);
            return;
        }
        CexTraceAnalysisDirection.createLoopDrivenStateOrdering(pAbstractionStates, loopLevelsToIndexMap, actLevelStack, loopStructure);
    }

    private static boolean isNodePartOfLoop(CFANode loopHead, CFANode potentialLoopNode, LoopStructure loopStructure) {
        for (LoopStructure.Loop loop : loopStructure.getLoopsForLoopHead(loopHead)) {
            if (!loop.getLoopNodes().contains((Object)potentialLoopNode)) continue;
            return true;
        }
        return false;
    }

    private static CFANode getPrevFunctionNode(ARGState argState, ARGState lastState, String wantedFunction) {
        CFANode returnNode = AbstractStates.extractLocation(argState);
        while (!returnNode.getFunctionName().equals(wantedFunction)) {
            if (Objects.equals(argState = argState.getParents().iterator().next(), lastState.getParents().iterator().next())) {
                return null;
            }
            returnNode = AbstractStates.extractLocation(argState);
        }
        return returnNode;
    }
}

