/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class CounterexampleTraceInfo {
    private final boolean spurious;
    private final ImmutableList<BooleanFormula> interpolants;
    private final ImmutableList<BooleanFormula> mCounterexampleFormula;
    private final ARGPath precisePath;

    private CounterexampleTraceInfo(boolean pSpurious, ImmutableList<BooleanFormula> pInterpolants, ImmutableList<BooleanFormula> pCounterexampleFormula, ARGPath pPrecisePath) {
        this.spurious = pSpurious;
        this.interpolants = pInterpolants;
        this.mCounterexampleFormula = pCounterexampleFormula;
        this.precisePath = pPrecisePath;
    }

    public static CounterexampleTraceInfo infeasible(List<BooleanFormula> pInterpolants) {
        return new CounterexampleTraceInfo(true, (ImmutableList<BooleanFormula>)ImmutableList.copyOf(pInterpolants), null, null);
    }

    public static CounterexampleTraceInfo infeasibleNoItp() {
        return new CounterexampleTraceInfo(true, null, null, null);
    }

    public static CounterexampleTraceInfo feasible(List<BooleanFormula> pCounterexampleFormula, ARGPath pPrecisePath) {
        return new CounterexampleTraceInfo(false, (ImmutableList<BooleanFormula>)ImmutableList.of(), (ImmutableList<BooleanFormula>)ImmutableList.copyOf(pCounterexampleFormula), pPrecisePath);
    }

    public static CounterexampleTraceInfo feasibleImprecise(List<BooleanFormula> pCounterexampleFormula) {
        return CounterexampleTraceInfo.feasible(pCounterexampleFormula, null);
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public ImmutableList<BooleanFormula> getInterpolants() {
        Preconditions.checkState((boolean)this.spurious);
        return this.interpolants;
    }

    public String toString() {
        return "Spurious: " + this.isSpurious() + (String)(this.isSpurious() ? ", interpolants: " + this.interpolants : "");
    }

    public ImmutableList<BooleanFormula> getCounterExampleFormulas() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.mCounterexampleFormula;
    }

    public @Nullable ARGPath getPrecisePath() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.precisePath;
    }
}

