/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CexTraceAnalysisDirection;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.ITPStrategy;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.NestedInterpolation;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.SequentialInterpolation;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.SequentialInterpolationWithSolver;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.TreeInterpolation;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.TreeInterpolationWithSolver;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.WellScopedInterpolation;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.predicate.refinement")
public final class InterpolationManager {
    private final Timer cexAnalysisTimer = new Timer();
    private final Timer satCheckTimer = new Timer();
    private final Timer getInterpolantTimer = new Timer();
    private final Timer cexAnalysisGetUsefulBlocksTimer = new Timer();
    private final Timer interpolantVerificationTimer = new Timer();
    private final Timer errorPathCreationTimer = new Timer();
    private int reusedFormulasOnSolverStack = 0;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PathFormulaManager pmgr;
    private final Solver solver;
    private final Interpolator<?> interpolator;
    @Option(secure=true, description="apply deletion-filter to the abstract counterexample, to get a minimal set of blocks, before applying interpolation-based refinement")
    private boolean getUsefulBlocks = false;
    @Option(secure=true, name="incrementalCexTraceCheck", description="Use incremental search in counterexample analysis to find a minimal infeasible part of the trace. This will typically lead to interpolants that refer to this part only. The option cexTraceCheckDirection defines in which order the blocks of the trace are looked at.")
    private boolean incrementalCheck = true;
    @Option(secure=true, name="cexTraceCheckDirection", description="Direction for doing counterexample analysis: from start of trace, from end of trace, or in more complex patterns. In combination with incrementalCexTraceCheck=true the generated interpolants will refer to the minimal infeasible part of the trace according to this strategy (e.g., with FORWARDS a minimal infeasible prefix is found).")
    private CexTraceAnalysisDirection direction = CexTraceAnalysisDirection.ZIGZAG;
    @Option(secure=true, description="Strategy how to interact with the intepolating prover. The analysis must support the strategy, otherwise the result will be useless!\n- SEQ_CPACHECKER: Generate an inductive sequence of interpolants by asking the solver individually for each of them. This allows us to fine-tune the queries with the option sequentialStrategy and is supported by all solvers.\n- SEQ: Generate an inductive sequence of interpolants by asking the solver for the whole sequence at once.\n- TREE: Use the tree-interpolation feature of the solver to get interpolants.\n- TREE_WELLSCOPED: Return each interpolant for i={0..n-1} for the partitions A=[lastFunctionEntryIndex..i] and B=[0..lastFunctionEntryIndex-1]+[i+1..n]. Based on a tree-like scheme.\n- TREE_NESTED: Use callstack and previous interpolants for next interpolants (cf. 'Nested Interpolants').\n- TREE_CPACHECKER: similar to TREE_NESTED, but the algorithm is taken from 'Tree Interpolation in Vampire'")
    private InterpolationStrategy strategy = InterpolationStrategy.SEQ_CPACHECKER;
    @Option(secure=true, description="dump all interpolation problems")
    private boolean dumpInterpolationProblems = false;
    @Option(secure=true, description="verify if the interpolants fulfill the interpolant properties")
    private boolean verifyInterpolants = false;
    @Option(secure=true, name="timelimit", description="time limit for refinement (use milliseconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.MILLISECONDS, defaultUserUnit=TimeUnit.MILLISECONDS, min=0L)
    private TimeSpan itpTimeLimit = TimeSpan.ofMillis((long)0L);
    @Option(secure=true, description="skip refinement if input formula is larger than this amount of bytes (ignored if 0)")
    private int maxRefinementSize = 0;
    @Option(secure=true, description="Use a single SMT solver environment for all interpolation queries and keep formulas pushed on solver stack between interpolation queries.")
    private boolean reuseInterpolationEnvironment = false;
    @Option(secure=true, description="After a failed interpolation query, try to solve the formulas again with different options instead of giving up immediately.")
    private boolean tryAgainOnInterpolationError = true;
    @Option(secure=true, description="When interpolation query fails, attempt to check feasibility of the current counterexample without interpolation")
    private boolean tryWithoutInterpolation = true;
    private final ITPStrategy itpStrategy;
    private final ExecutorService executor;
    private final LoopStructure loopStructure;
    private final VariableClassification variableClassification;

    public void printStatistics(StatisticsWriter w0) {
        if (this.cexAnalysisTimer.getNumberOfIntervals() == 0) {
            return;
        }
        w0.put("Counterexample analysis", this.cexAnalysisTimer + " (Max: " + this.cexAnalysisTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ", Calls: " + this.cexAnalysisTimer.getNumberOfIntervals() + ")");
        StatisticsWriter w1 = w0.beginLevel();
        if (this.cexAnalysisGetUsefulBlocksTimer.getNumberOfIntervals() > 0) {
            w1.put("Cex.focusing", this.cexAnalysisGetUsefulBlocksTimer + " (Max: " + this.cexAnalysisGetUsefulBlocksTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
        }
        w1.put("Refinement sat check", this.satCheckTimer);
        if (this.reuseInterpolationEnvironment && this.satCheckTimer.getNumberOfIntervals() > 0) {
            w1.put("Reused formulas on solver stack", this.reusedFormulasOnSolverStack + " (Avg: " + StatisticsUtils.div(this.reusedFormulasOnSolverStack, this.satCheckTimer.getNumberOfIntervals()) + ")");
        }
        w1.put("Interpolant computation", this.getInterpolantTimer);
        if (this.interpolantVerificationTimer.getNumberOfIntervals() > 0) {
            w1.put("Interpolant verification", this.interpolantVerificationTimer);
        }
        if (this.errorPathCreationTimer.getNumberOfIntervals() > 0) {
            w1.put("Error-path creation", this.errorPathCreationTimer);
        }
    }

    public InterpolationManager(PathFormulaManager pPmgr, Solver pSolver, Optional<LoopStructure> pLoopStructure, Optional<VariableClassification> pVarClassification, Configuration config, ShutdownNotifier pShutdownNotifier, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, InterpolationManager.class);
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.fmgr = pSolver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pmgr = pPmgr;
        this.solver = pSolver;
        this.loopStructure = pLoopStructure.orElse(null);
        this.variableClassification = pVarClassification.orElse(null);
        this.executor = this.itpTimeLimit.isEmpty() ? null : Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        this.interpolator = this.reuseInterpolationEnvironment ? new Interpolator() : null;
        switch (this.strategy) {
            case SEQ_CPACHECKER: {
                this.itpStrategy = new SequentialInterpolation(pLogger, pShutdownNotifier, this.fmgr, config);
                break;
            }
            case SEQ: {
                this.itpStrategy = new SequentialInterpolationWithSolver(pLogger, pShutdownNotifier, this.fmgr);
                break;
            }
            case TREE_WELLSCOPED: {
                this.itpStrategy = new WellScopedInterpolation(pLogger, pShutdownNotifier, this.fmgr);
                break;
            }
            case TREE_NESTED: {
                this.itpStrategy = new NestedInterpolation(pLogger, pShutdownNotifier, this.fmgr);
                break;
            }
            case TREE_CPACHECKER: {
                this.itpStrategy = new TreeInterpolation(pLogger, pShutdownNotifier, this.fmgr);
                break;
            }
            case TREE: {
                this.itpStrategy = new TreeInterpolationWithSolver(pLogger, pShutdownNotifier, this.fmgr);
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown interpolation strategy");
            }
        }
    }

    public CounterexampleTraceInfo buildCounterexampleTrace(BlockFormulaStrategy.BlockFormulas pFormulas, List<AbstractState> pAbstractionStates, Optional<ARGPath> pImprecisePath) throws CPAException, InterruptedException {
        assert (pAbstractionStates.isEmpty() || pFormulas.getSize() == pAbstractionStates.size());
        return this.callWithTimelimit(() -> this.buildCounterexampleTrace0(pFormulas, pAbstractionStates, pImprecisePath));
    }

    private CounterexampleTraceInfo callWithTimelimit(Callable<CounterexampleTraceInfo> callable) throws CPAException, InterruptedException {
        if (this.itpTimeLimit.isEmpty()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, CPAException.class, InterruptedException.class);
                throw new Classes.UnexpectedCheckedException("refinement", (Throwable)e);
            }
        }
        assert (this.executor != null);
        Future<CounterexampleTraceInfo> future = this.executor.submit(callable);
        try {
            return future.get(this.itpTimeLimit.asNanos(), TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            this.logger.log(Level.SEVERE, new Object[]{"SMT-solver timed out during interpolation process"});
            throw new RefinementFailedException(RefinementFailedException.Reason.TIMEOUT, null);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible((Throwable)t, CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("interpolation", t);
        }
    }

    public Optional<ImmutableList<BooleanFormula>> interpolate(List<BooleanFormula> pFormulas) throws CPAException, InterruptedException {
        return this.interpolate(pFormulas, (List<AbstractState>)ImmutableList.of());
    }

    public Optional<ImmutableList<BooleanFormula>> interpolate(List<BooleanFormula> pFormulas, List<AbstractState> pAbstractionStates) throws CPAException, InterruptedException {
        CounterexampleTraceInfo cexInfo = this.buildCounterexampleTrace(new BlockFormulaStrategy.BlockFormulas(pFormulas), pAbstractionStates, Optional.empty());
        if (cexInfo.isSpurious()) {
            return Optional.of(cexInfo.getInterpolants());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CounterexampleTraceInfo buildCounterexampleTrace0(BlockFormulaStrategy.BlockFormulas pFormulas, List<AbstractState> pAbstractionStates, Optional<ARGPath> imprecisePath) throws RefinementFailedException, InterruptedException {
        this.cexAnalysisTimer.start();
        try {
            BlockFormulaStrategy.BlockFormulas f = this.prepareCounterexampleFormulas(pFormulas);
            Interpolator currentInterpolator = this.reuseInterpolationEnvironment ? (Interpolator)Preconditions.checkNotNull(this.interpolator) : new Interpolator();
            try {
                CounterexampleTraceInfo counterexampleTraceInfo = currentInterpolator.buildCounterexampleTrace(f, pAbstractionStates, imprecisePath);
                if (!this.reuseInterpolationEnvironment) {
                    currentInterpolator.close();
                }
                return counterexampleTraceInfo;
            }
            catch (Throwable throwable) {
                try {
                    if (!this.reuseInterpolationEnvironment) {
                        currentInterpolator.close();
                    }
                    throw throwable;
                }
                catch (SolverException itpException) {
                    if (this.tryWithoutInterpolation) {
                        this.logger.logUserException(Level.FINEST, (Throwable)itpException, "Interpolation failed, attempting to solve without interpolation");
                        CounterexampleTraceInfo counterexampleTraceInfo = this.fallbackWithoutInterpolation(f, imprecisePath, itpException);
                        this.cexAnalysisTimer.stop();
                        return counterexampleTraceInfo;
                    }
                    throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null, itpException);
                }
            }
        }
        finally {
            this.cexAnalysisTimer.stop();
        }
    }

    public CounterexampleTraceInfo buildCounterexampleTraceWithoutInterpolation(BlockFormulaStrategy.BlockFormulas pFormulas, Optional<ARGPath> imprecisePath) throws CPAException, InterruptedException {
        return this.callWithTimelimit(() -> this.buildCounterexampleTraceWithoutInterpolation0(pFormulas, imprecisePath));
    }

    private CounterexampleTraceInfo buildCounterexampleTraceWithoutInterpolation0(BlockFormulaStrategy.BlockFormulas pFormulas, Optional<ARGPath> imprecisePath) throws CPAException, InterruptedException {
        this.cexAnalysisTimer.start();
        try {
            BlockFormulaStrategy.BlockFormulas f = this.prepareCounterexampleFormulas(pFormulas);
            try {
                CounterexampleTraceInfo counterexampleTraceInfo = this.solveCounterexample(f, imprecisePath);
                return counterexampleTraceInfo;
            }
            catch (SolverException e) {
                throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null, e);
            }
        }
        finally {
            this.cexAnalysisTimer.stop();
        }
    }

    private BlockFormulaStrategy.BlockFormulas prepareCounterexampleFormulas(BlockFormulaStrategy.BlockFormulas pFormulas) throws RefinementFailedException {
        int size;
        this.logger.log(Level.FINEST, new Object[]{"Building counterexample trace"});
        ImmutableList<BooleanFormula> f = pFormulas.getFormulas();
        if (this.fmgr.useBitwiseAxioms()) {
            f = this.addBitwiseAxioms(f);
        }
        this.logger.log(Level.ALL, new Object[]{"Counterexample trace formulas:", f});
        if (this.maxRefinementSize > 0 && (size = this.fmgr.dumpFormula(this.bfmgr.and((Collection<BooleanFormula>)f)).toString().length()) > this.maxRefinementSize) {
            this.logger.log(Level.FINEST, new Object[]{"Skipping refinement because input formula is", size, "bytes large."});
            throw new RefinementFailedException(RefinementFailedException.Reason.TooMuchUnrolling, null);
        }
        return new BlockFormulaStrategy.BlockFormulas((List<BooleanFormula>)f, (Map<Pair<ARGState, CFAEdge>, PathFormula>)pFormulas.getBranchingFormulas());
    }

    private CounterexampleTraceInfo fallbackWithoutInterpolation(BlockFormulaStrategy.BlockFormulas f, Optional<ARGPath> imprecisePath, SolverException itpException) throws InterruptedException, RefinementFailedException {
        try {
            CounterexampleTraceInfo counterexample = this.solveCounterexample(f, imprecisePath);
            if (!counterexample.isSpurious()) {
                return counterexample;
            }
        }
        catch (SolverException solvingException) {
            itpException.addSuppressed((Throwable)solvingException);
        }
        throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, null, itpException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CounterexampleTraceInfo solveCounterexample(BlockFormulaStrategy.BlockFormulas f, Optional<ARGPath> imprecisePath) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.solver.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            Object object;
            boolean isSat;
            this.satCheckTimer.start();
            try {
                for (BooleanFormula block : f.getFormulas()) {
                    prover.push(block);
                }
                isSat = !prover.isUnsat();
            }
            finally {
                this.satCheckTimer.stop();
            }
            if (isSat) {
                try {
                    object = this.getErrorPath(f, (BasicProverEnvironment<?>)prover, imprecisePath);
                    return object;
                }
                catch (SolverException modelException) {
                    CounterexampleTraceInfo counterexampleTraceInfo;
                    block16: {
                        this.logger.logUserException(Level.WARNING, (Throwable)modelException, "Could not create model for error path!");
                        counterexampleTraceInfo = CounterexampleTraceInfo.feasibleImprecise(f.getFormulas());
                        if (prover == null) break block16;
                        prover.close();
                    }
                    return counterexampleTraceInfo;
                }
            }
            object = CounterexampleTraceInfo.infeasibleNoItp();
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private ImmutableList<BooleanFormula> addBitwiseAxioms(ImmutableList<BooleanFormula> f) {
        BooleanFormula bitwiseAxioms = this.bfmgr.makeTrue();
        for (BooleanFormula fm : f) {
            BooleanFormula a = this.fmgr.getBitwiseAxioms(fm);
            if (this.bfmgr.isTrue(a)) continue;
            bitwiseAxioms = this.fmgr.getBooleanFormulaManager().and(bitwiseAxioms, a);
        }
        if (!this.bfmgr.isTrue(bitwiseAxioms)) {
            this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDING BITWISE AXIOMS TO THE", "LAST GROUP: ", bitwiseAxioms});
            return ImmutableList.builderWithExpectedSize((int)f.size()).addAll((Iterable)f.subList(0, f.size() - 1)).add((Object)this.bfmgr.and((BooleanFormula)f.get(f.size() - 1), bitwiseAxioms)).build();
        }
        return f;
    }

    private List<BooleanFormula> getUsefulBlocks(List<BooleanFormula> f) throws SolverException, InterruptedException {
        this.cexAnalysisGetUsefulBlocksTimer.start();
        try (ProverEnvironment thmProver = this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            boolean consistent;
            this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Calling getUsefulBlocks on path", "of length:", f.size()});
            BooleanFormula[] needed = new BooleanFormula[f.size()];
            for (int i = 0; i < needed.length; ++i) {
                needed[i] = this.bfmgr.makeTrue();
            }
            boolean backwards = this.direction == CexTraceAnalysisDirection.BACKWARDS;
            int start = backwards ? f.size() - 1 : 0;
            int increment = backwards ? -1 : 1;
            int toPop = 0;
            block6: do {
                consistent = true;
                for (BooleanFormula aNeeded : needed) {
                    if (this.bfmgr.isTrue(aNeeded)) continue;
                    thmProver.push(aNeeded);
                    ++toPop;
                }
                if (thmProver.isUnsat()) {
                    f = Arrays.asList(needed);
                    break;
                }
                if (this.direction == CexTraceAnalysisDirection.ZIGZAG) {
                    int s = 0;
                    int e = f.size() - 1;
                    boolean fromStart = false;
                    do {
                        int i = fromStart ? s++ : e--;
                        fromStart = !fromStart;
                        BooleanFormula t = f.get(i);
                        thmProver.push(t);
                        ++toPop;
                        if (!thmProver.isUnsat()) continue;
                        needed[i] = t;
                        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i, ", term: ", t});
                        while (toPop > 0) {
                            --toPop;
                            thmProver.pop();
                        }
                        consistent = false;
                        continue block6;
                    } while (e >= s);
                    continue;
                }
                int i = start;
                while (backwards ? i >= 0 : i < f.size()) {
                    BooleanFormula t = f.get(i);
                    thmProver.push(t);
                    ++toPop;
                    if (thmProver.isUnsat()) {
                        needed[i] = t;
                        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Found needed block: ", i, ", term: ", t});
                        while (toPop > 0) {
                            --toPop;
                            thmProver.pop();
                        }
                        consistent = false;
                        continue block6;
                    }
                    i += increment;
                }
            } while (!consistent);
            while (toPop > 0) {
                --toPop;
                thmProver.pop();
            }
        }
        this.logger.log(Level.ALL, new Object[]{"DEBUG_1", "Done getUsefulBlocks"});
        this.cexAnalysisGetUsefulBlocksTimer.stop();
        return f;
    }

    private ImmutableIntArray orderFormulas(List<BooleanFormula> traceFormulas, List<AbstractState> pAbstractionStates) {
        ImmutableIntArray result = this.direction.orderFormulas(traceFormulas, pAbstractionStates, this.variableClassification, this.loopStructure, this.fmgr);
        assert (Iterators.elementsEqual(result.stream().sorted().boxed().iterator(), IntStream.range(0, traceFormulas.size()).boxed().iterator())) : "Not a valid permutation: " + result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<BooleanFormula> getInterpolants(Interpolator<T> pInterpolator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) throws SolverException, InterruptedException {
        List<BooleanFormula> interpolants;
        try {
            this.getInterpolantTimer.start();
            interpolants = this.itpStrategy.getInterpolants(pInterpolator, formulasWithStatesAndGroupdIds);
        }
        finally {
            this.getInterpolantTimer.stop();
        }
        assert (formulasWithStatesAndGroupdIds.size() - 1 == interpolants.size()) : "we should return N-1 interpolants for N formulas.";
        if (this.verifyInterpolants) {
            try {
                this.interpolantVerificationTimer.start();
                this.itpStrategy.checkInterpolants(this.solver, formulasWithStatesAndGroupdIds, interpolants);
            }
            finally {
                this.interpolantVerificationTimer.stop();
            }
        }
        return interpolants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CounterexampleTraceInfo getErrorPath(BlockFormulaStrategy.BlockFormulas formulas, BasicProverEnvironment<?> pProver, Optional<ARGPath> pImprecisePath) throws SolverException, InterruptedException {
        if (pImprecisePath.isEmpty()) {
            return CounterexampleTraceInfo.feasibleImprecise(formulas.getFormulas());
        }
        this.errorPathCreationTimer.start();
        try {
            CounterexampleTraceInfo counterexampleTraceInfo;
            block17: {
                ARGPath precisePath;
                Model model;
                block15: {
                    CounterexampleTraceInfo counterexampleTraceInfo2;
                    block16: {
                        ARGPath imprecisePath = pImprecisePath.orElseThrow();
                        ImmutableSet<ARGState> pathElements = ARGUtils.getAllStatesOnPathsTo(imprecisePath.getLastState());
                        model = pProver.getModel();
                        precisePath = this.pmgr.getARGPathFromModel(model, imprecisePath.getFirstState(), (Predicate<? super ARGState>)((Predicate)arg_0 -> pathElements.contains(arg_0)), (Map<Pair<ARGState, CFAEdge>, PathFormula>)formulas.getBranchingFormulas());
                        if (precisePath.getLastState().equals(imprecisePath.getLastState())) break block15;
                        this.logger.log(Level.WARNING, new Object[]{"Could not create error path: ARG target path reached the wrong state!"});
                        counterexampleTraceInfo2 = CounterexampleTraceInfo.feasibleImprecise(formulas.getFormulas());
                        if (model == null) break block16;
                        model.close();
                    }
                    return counterexampleTraceInfo2;
                }
                counterexampleTraceInfo = CounterexampleTraceInfo.feasible(formulas.getFormulas(), precisePath);
                if (model == null) break block17;
                {
                    catch (Throwable throwable) {
                        try {
                            if (model != null) {
                                try {
                                    model.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IllegalArgumentException | CPATransferException e) {
                            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not create error path");
                            CounterexampleTraceInfo counterexampleTraceInfo3 = CounterexampleTraceInfo.feasibleImprecise(formulas.getFormulas());
                            return counterexampleTraceInfo3;
                        }
                    }
                }
                model.close();
            }
            return counterexampleTraceInfo;
        }
        finally {
            this.errorPathCreationTimer.stop();
        }
    }

    private void dumpInterpolationProblem(List<BooleanFormula> f) {
        int k = 0;
        for (BooleanFormula formula : f) {
            this.dumpFormulaToFile("formula", formula, k++);
        }
    }

    private void dumpFormulaToFile(String name, BooleanFormula f, int i) {
        @Nullable Path dumpFile = this.formatFormulaOutputFile(name, i);
        this.fmgr.dumpFormulaToFile(f, dumpFile);
    }

    private @Nullable Path formatFormulaOutputFile(String formula, int index) {
        return this.fmgr.formatFormulaOutputFile("interpolation", this.cexAnalysisTimer.getNumberOfIntervals(), formula, index);
    }

    public class Interpolator<T> {
        public InterpolatingProverEnvironment<T> itpProver;
        private final List<Pair<BooleanFormula, T>> currentlyAssertedFormulas = new ArrayList<Pair<BooleanFormula, T>>();

        Interpolator() {
            this.itpProver = this.newEnvironment();
        }

        public InterpolatingProverEnvironment<T> newEnvironment() {
            return InterpolationManager.this.solver.newProverEnvironmentWithInterpolation(SolverContext.ProverOptions.GENERATE_MODELS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CounterexampleTraceInfo buildCounterexampleTrace(BlockFormulaStrategy.BlockFormulas formulas, List<AbstractState> pAbstractionStates, Optional<ARGPath> imprecisePath) throws SolverException, InterruptedException {
            CounterexampleTraceInfo info;
            boolean spurious;
            ImmutableIntArray formulaPermutation;
            InterpolationManager.this.shutdownNotifier.shutdownIfNecessary();
            InterpolationManager.this.logger.log(Level.FINEST, new Object[]{"Checking feasibility of counterexample trace"});
            InterpolationManager.this.satCheckTimer.start();
            if (pAbstractionStates.isEmpty()) {
                pAbstractionStates = new ArrayList<Object>(Collections.nCopies(formulas.getSize(), null));
            }
            assert (pAbstractionStates.size() == formulas.getSize()) : "each pathFormula must end with an abstract State";
            ArrayList<Object> formulasWithStatesAndGroupdIds = new ArrayList<Object>(Collections.nCopies(formulas.getSize(), null));
            try {
                if (InterpolationManager.this.getUsefulBlocks) {
                    formulas = new BlockFormulaStrategy.BlockFormulas(InterpolationManager.this.getUsefulBlocks((List<BooleanFormula>)formulas.getFormulas()), (Map<Pair<ARGState, CFAEdge>, PathFormula>)formulas.getBranchingFormulas());
                }
                if (InterpolationManager.this.dumpInterpolationProblems) {
                    InterpolationManager.this.dumpInterpolationProblem((List<BooleanFormula>)formulas.getFormulas());
                }
                formulaPermutation = InterpolationManager.this.orderFormulas((List<BooleanFormula>)formulas.getFormulas(), pAbstractionStates);
                InterpolationManager.this.logger.log(Level.ALL, new Object[]{"Permutation of blocks for interpolation query:", formulaPermutation});
                spurious = this.checkInfeasabilityOfTrace((List<BooleanFormula>)formulas.getFormulas(), pAbstractionStates, formulaPermutation, (List<Triple<BooleanFormula, AbstractState, T>>)formulasWithStatesAndGroupdIds);
                assert (Lists.transform(formulasWithStatesAndGroupdIds, Triple::getFirst).equals(formulas.getFormulas()));
            }
            finally {
                InterpolationManager.this.satCheckTimer.stop();
            }
            InterpolationManager.this.logger.log(Level.FINEST, new Object[]{"Counterexample trace is", spurious ? "infeasible" : "feasible"});
            if (spurious) {
                List<BooleanFormula> interpolants;
                try {
                    interpolants = InterpolationManager.this.getInterpolants(this, formulasWithStatesAndGroupdIds);
                }
                catch (SolverException e) {
                    if (!InterpolationManager.this.tryAgainOnInterpolationError) {
                        throw e;
                    }
                    InterpolationManager.this.logger.logfDebugException((Throwable)e, "Interpolation failed, trying again in reverse order and with%s incremental check.", new Object[]{InterpolationManager.this.incrementalCheck ? "out" : ""});
                    Collections.fill(formulasWithStatesAndGroupdIds, null);
                    int[] permutation = formulaPermutation.toArray();
                    Ints.reverse((int[])permutation);
                    formulaPermutation = ImmutableIntArray.copyOf((int[])permutation);
                    boolean originalIncrementalCheck = InterpolationManager.this.incrementalCheck;
                    try {
                        InterpolationManager.this.incrementalCheck = !InterpolationManager.this.incrementalCheck;
                        InterpolationManager.this.satCheckTimer.start();
                        spurious = this.checkInfeasabilityOfTrace((List<BooleanFormula>)formulas.getFormulas(), pAbstractionStates, formulaPermutation, (List<Triple<BooleanFormula, AbstractState, T>>)formulasWithStatesAndGroupdIds);
                        assert (Lists.transform(formulasWithStatesAndGroupdIds, Triple::getFirst).equals(formulas.getFormulas()));
                        Verify.verify((boolean)spurious, (String)"Counterexample formulas became satisfiable on second try", (Object[])new Object[0]);
                    }
                    finally {
                        InterpolationManager.this.incrementalCheck = originalIncrementalCheck;
                        InterpolationManager.this.satCheckTimer.stop();
                    }
                    interpolants = InterpolationManager.this.getInterpolants(this, formulasWithStatesAndGroupdIds);
                }
                if (InterpolationManager.this.logger.wouldBeLogged(Level.ALL)) {
                    int i = 1;
                    for (BooleanFormula itp : interpolants) {
                        InterpolationManager.this.logger.log(Level.ALL, new Object[]{"For step", i++, "got:", "interpolant", itp});
                    }
                }
                info = CounterexampleTraceInfo.infeasible(interpolants);
            } else {
                info = InterpolationManager.this.getErrorPath(formulas, (BasicProverEnvironment<?>)this.itpProver, imprecisePath);
            }
            InterpolationManager.this.logger.log(Level.ALL, new Object[]{"Counterexample information:", info});
            return info;
        }

        private boolean checkInfeasabilityOfTrace(List<BooleanFormula> traceFormulas, List<AbstractState> traceStates, ImmutableIntArray formulaPermutation, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) throws InterruptedException, SolverException {
            ListIterator<Integer> todoIterator = formulaPermutation.asList().listIterator();
            int firstBadIndex = this.getIndexOfFirstNonReusableFormula(traceFormulas, traceStates, todoIterator, formulasWithStatesAndGroupdIds);
            this.cleanupSolverStack(firstBadIndex);
            this.addNewFormulasToStack(traceFormulas, traceStates, todoIterator, formulasWithStatesAndGroupdIds);
            assert (ImmutableMultiset.copyOf(traceFormulas).equals((Object)FluentIterable.from(this.currentlyAssertedFormulas).transform(Pair::getFirst).toMultiset()));
            return this.itpProver.isUnsat();
        }

        private int getIndexOfFirstNonReusableFormula(List<BooleanFormula> traceFormulas, List<AbstractState> traceStates, ListIterator<Integer> todoIterator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) {
            ListIterator<Pair<BooleanFormula, T>> assertedIterator = this.currentlyAssertedFormulas.listIterator();
            int firstBadIndex = -1;
            while (assertedIterator.hasNext()) {
                Pair<BooleanFormula, T> assertedFormula = assertedIterator.next();
                if (!todoIterator.hasNext()) {
                    firstBadIndex = assertedIterator.previousIndex();
                    break;
                }
                int index = todoIterator.next();
                BooleanFormula todoFormula = traceFormulas.get(index);
                if (todoFormula.equals(assertedFormula.getFirst())) {
                    Triple<BooleanFormula, AbstractState, T> assertedFormulaWithState = Triple.of(assertedFormula.getFirst(), traceStates.get(index), assertedFormula.getSecond());
                    formulasWithStatesAndGroupdIds.set(index, assertedFormulaWithState);
                    continue;
                }
                firstBadIndex = assertedIterator.previousIndex();
                todoIterator.previous();
                break;
            }
            return firstBadIndex;
        }

        private void cleanupSolverStack(int firstBadIndex) {
            if (firstBadIndex != -1) {
                if (firstBadIndex == 0) {
                    this.itpProver.close();
                    this.itpProver = this.newEnvironment();
                    this.currentlyAssertedFormulas.clear();
                } else {
                    assert (firstBadIndex > 0);
                    List<Pair<BooleanFormula, T>> toDeleteFormulas = this.currentlyAssertedFormulas.subList(firstBadIndex, this.currentlyAssertedFormulas.size());
                    for (int i = 0; i < toDeleteFormulas.size(); ++i) {
                        this.itpProver.pop();
                    }
                    toDeleteFormulas.clear();
                    InterpolationManager.this.reusedFormulasOnSolverStack += this.currentlyAssertedFormulas.size();
                }
            }
        }

        private void addNewFormulasToStack(List<BooleanFormula> traceFormulas, List<AbstractState> traceStates, ListIterator<Integer> todoIterator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) throws SolverException, InterruptedException {
            boolean isStillFeasible = true;
            if (InterpolationManager.this.incrementalCheck && !this.currentlyAssertedFormulas.isEmpty()) {
                boolean bl = isStillFeasible = !this.itpProver.isUnsat();
            }
            while (todoIterator.hasNext()) {
                int index = todoIterator.next();
                BooleanFormula f = traceFormulas.get(index);
                AbstractState state = traceStates.get(index);
                assert (formulasWithStatesAndGroupdIds.get(index) == null);
                InterpolationManager.this.logger.logf(Level.ALL, "Pushing formula for block %s:\n  %s", new Object[]{index, f});
                Object itpGroupId = this.itpProver.push(f);
                formulasWithStatesAndGroupdIds.set(index, Triple.of(f, state, itpGroupId));
                this.currentlyAssertedFormulas.add(Pair.of(f, itpGroupId));
                if (!InterpolationManager.this.incrementalCheck || !isStillFeasible || InterpolationManager.this.bfmgr.isTrue(f)) continue;
                isStillFeasible = !this.itpProver.isUnsat();
            }
        }

        private void close() {
            this.itpProver.close();
            this.itpProver = null;
            this.currentlyAssertedFormulas.clear();
        }
    }

    private static enum InterpolationStrategy {
        SEQ,
        SEQ_CPACHECKER,
        TREE,
        TREE_WELLSCOPED,
        TREE_NESTED,
        TREE_CPACHECKER;

    }
}

