/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

public class SeparateInterpolatingProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final FormulaManager mainFmgr;
    private final FormulaManager itpFmgr;
    private final InterpolatingProverEnvironment<T> itpEnv;

    public SeparateInterpolatingProverEnvironment(FormulaManager pMainFmgr, FormulaManager pItpFmgr, InterpolatingProverEnvironment<T> pItpEnv) {
        this.mainFmgr = (FormulaManager)Preconditions.checkNotNull((Object)pMainFmgr);
        this.itpFmgr = (FormulaManager)Preconditions.checkNotNull((Object)pItpFmgr);
        this.itpEnv = (InterpolatingProverEnvironment)Preconditions.checkNotNull(pItpEnv);
    }

    public T push(BooleanFormula mainF) throws InterruptedException {
        BooleanFormula itpF = this.itpFmgr.parse(this.mainFmgr.dumpFormula(mainF).toString());
        return (T)this.itpEnv.push(itpF);
    }

    public void pop() {
        this.itpEnv.pop();
    }

    public T addConstraint(BooleanFormula constraint) throws InterruptedException {
        return (T)this.itpEnv.addConstraint(this.convertToItp(constraint));
    }

    public void push() {
        this.itpEnv.push();
    }

    public int size() {
        return this.itpEnv.size();
    }

    public boolean isUnsat() throws InterruptedException, SolverException {
        return this.itpEnv.isUnsat();
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        return this.itpEnv.isUnsatWithAssumptions(Collections2.transform(assumptions, this::convertToItp));
    }

    public void close() {
        this.itpEnv.close();
    }

    public BooleanFormula getInterpolant(Collection<T> pFormulasOfA) throws SolverException, InterruptedException {
        BooleanFormula itpF = this.itpEnv.getInterpolant(pFormulasOfA);
        return this.convertToMain(itpF);
    }

    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<T>> partitionedFormulas) throws SolverException, InterruptedException {
        List itps = this.itpEnv.getSeqInterpolants(partitionedFormulas);
        return Lists.transform((List)itps, this::convertToMain);
    }

    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<T>> partitionedFormulas, int[] startOfSubTree) throws SolverException, InterruptedException {
        List itps = this.itpEnv.getTreeInterpolants(partitionedFormulas, startOfSubTree);
        return Lists.transform((List)itps, this::convertToMain);
    }

    private BooleanFormula convertToItp(BooleanFormula f) {
        return this.itpFmgr.parse(this.mainFmgr.dumpFormula(f).toString());
    }

    private BooleanFormula convertToMain(BooleanFormula f) {
        return this.mainFmgr.parse(this.itpFmgr.dumpFormula(f).toString());
    }

    public Model getModel() throws SolverException {
        return this.itpEnv.getModel();
    }

    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return this.itpEnv.getModelAssignments();
    }

    public List<BooleanFormula> getUnsatCore() {
        return Lists.transform((List)this.itpEnv.getUnsatCore(), this::convertToMain);
    }

    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Optional opt = this.itpEnv.unsatCoreOverAssumptions(Collections2.transform(pAssumptions, this::convertToItp));
        if (opt.isPresent()) {
            return Optional.of(Lists.transform((List)((List)opt.orElseThrow()), this::convertToMain));
        }
        return opt;
    }

    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        return (R)this.itpEnv.allSat(pCallback, Lists.transform(pImportant, this::convertToItp));
    }
}

