/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.ITPStrategy;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

public abstract class AbstractTreeInterpolation
extends ITPStrategy {
    AbstractTreeInterpolation(LogManager pLogger, ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr) {
        super(pLogger, pShutdownNotifier, pFmgr);
    }

    @Override
    public <T> void checkInterpolants(Solver solver, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, List<BooleanFormula> interpolants) throws SolverException, InterruptedException {
        int i;
        List formulas = Lists.transform(formulasWithStatesAndGroupdIds, Triple::getFirst);
        ImmutableIntArray subtrees = this.buildTreeStructure(formulasWithStatesAndGroupdIds).getSecond();
        assert (formulas.size() == subtrees.length()) : "each formula must be part of a subtree";
        assert (formulas.size() == interpolants.size() + 1) : "number of interpolants should match the tree-structure";
        if (!solver.implies((BooleanFormula)formulas.get(0), interpolants.get(0))) {
            throw new SolverException(String.format("interpolant %s is not implied by leaf formula.", interpolants.get(0)));
        }
        for (i = 1; i < subtrees.length() - 1; ++i) {
            if (subtrees.get(i) <= subtrees.get(i - 1) || solver.implies((BooleanFormula)formulas.get(i), interpolants.get(i))) continue;
            throw new SolverException(String.format("interpolant %s is not implied by leaf formula.", interpolants.get(i)));
        }
        for (i = 1; i < subtrees.length() - 1; ++i) {
            ArrayList<BooleanFormula> previousInterpolants = new ArrayList<BooleanFormula>();
            int currentSubtree = subtrees.get(i);
            int pos = i;
            while (subtrees.get(pos - 1) > currentSubtree) {
                previousInterpolants.add(interpolants.get(pos));
                pos = subtrees.get(pos - 1);
            }
            previousInterpolants.add(interpolants.get(pos - 1));
            previousInterpolants.add((BooleanFormula)formulas.get(i));
            if (solver.implies(this.bfmgr.and(previousInterpolants), interpolants.get(i))) continue;
            throw new SolverException(String.format("Interpolant %s is not implied by previous part of the path %s.", interpolants.get(i), this.bfmgr.and(previousInterpolants)));
        }
        ArrayList<BooleanFormula> previousInterpolants = new ArrayList<BooleanFormula>();
        int currentSubtree = subtrees.get(subtrees.length() - 1);
        assert (currentSubtree == 0) : "root should be in left-most subtree";
        int pos = subtrees.length() - 1;
        while (subtrees.get(pos - 1) > currentSubtree) {
            previousInterpolants.add(interpolants.get(pos));
            pos = subtrees.get(pos - 1);
        }
        previousInterpolants.add(interpolants.get(pos - 1));
        previousInterpolants.add((BooleanFormula)formulas.get(subtrees.length() - 1));
        if (!solver.implies(this.bfmgr.and(previousInterpolants), this.bfmgr.makeFalse())) {
            throw new SolverException("Interpolant " + interpolants.get(subtrees.length() - 1) + " is not implied by previous part of the path");
        }
        ArrayList<Set<String>> variablesInFormulas = new ArrayList<Set<String>>(formulas.size());
        for (BooleanFormula f : formulas) {
            variablesInFormulas.add(this.fmgr.extractVariableNames((Formula)f));
        }
        for (int i2 = 0; i2 < interpolants.size(); ++i2) {
            int j;
            int checksum = 0;
            HashSet variablesInA = new HashSet();
            for (int j2 = i2; j2 >= 0 && subtrees.get(j2) >= subtrees.get(i2); --j2) {
                variablesInA.addAll((Collection)variablesInFormulas.get(j2));
                ++checksum;
            }
            HashSet variablesInB = new HashSet();
            for (j = 0; j < subtrees.get(i2); ++j) {
                variablesInB.addAll((Collection)variablesInFormulas.get(j));
                ++checksum;
            }
            for (j = i2 + 1; j < subtrees.length(); ++j) {
                variablesInB.addAll((Collection)variablesInFormulas.get(j));
                ++checksum;
            }
            assert (checksum == formulas.size()) : "partitions for interpolant have wrong size";
            ImmutableSet allowedVariables = Sets.intersection(variablesInA, variablesInB).immutableCopy();
            Set<String> variablesInInterpolant = this.fmgr.extractVariableNames((Formula)interpolants.get(i2));
            Sets.SetView additionalVariables = Sets.difference(variablesInInterpolant, (Set)allowedVariables);
            if (additionalVariables.isEmpty()) continue;
            throw new SolverException(String.format("Interpolant %s contains forbidden variable(s) %s", interpolants.get(i2), additionalVariables));
        }
    }

    private static <T> TreePosition getTreePosition(List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, int position) {
        AbstractState abstractionState = (AbstractState)Preconditions.checkNotNull((Object)formulasWithStatesAndGroupdIds.get(position).getSecond());
        CFANode node = AbstractStates.extractLocation(abstractionState);
        if (node instanceof FunctionEntryNode && AbstractTreeInterpolation.callHasReturn(formulasWithStatesAndGroupdIds, position)) {
            return TreePosition.START;
        }
        if (node instanceof FunctionExitNode) {
            return TreePosition.END;
        }
        return TreePosition.MIDDLE;
    }

    protected static <T> boolean callHasReturn(List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, int callIndex) {
        ArrayDeque<CFANode> callstack = new ArrayDeque<CFANode>();
        AbstractState abstractionState = formulasWithStatesAndGroupdIds.get(callIndex).getSecond();
        CFANode node = AbstractStates.extractLocation(abstractionState);
        assert (node instanceof FunctionEntryNode) : "call needed as input param";
        callstack.addLast(node);
        for (Triple t : Iterables.skip(formulasWithStatesAndGroupdIds, (int)(callIndex + 1))) {
            assert (!callstack.isEmpty()) : "should have returned when callstack is empty";
            AbstractState abstractionState2 = (AbstractState)Preconditions.checkNotNull((Object)((AbstractState)t.getSecond()));
            CFANode node2 = AbstractStates.extractLocation(abstractionState2);
            if (node2 instanceof FunctionEntryNode) {
                callstack.addLast(node2);
            }
            CFANode lastEntryNode = (CFANode)callstack.getLast();
            if (!(node2 instanceof FunctionExitNode) || !((FunctionExitNode)node2).getEntryNode().equals(lastEntryNode)) continue;
            callstack.removeLast();
            if (!callstack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected <T> Pair<List<Triple<BooleanFormula, AbstractState, T>>, ImmutableIntArray> buildTreeStructure(List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) {
        ArrayList<Triple<BooleanFormula, AbstractState, T>> formulas = new ArrayList<Triple<BooleanFormula, AbstractState, T>>();
        ImmutableIntArray.Builder startOfSubTree = ImmutableIntArray.builder();
        ArrayDeque<Pair<Triple<BooleanFormula, AbstractState, T>, Integer>> stack = new ArrayDeque<Pair<Triple<BooleanFormula, AbstractState, T>, Integer>>();
        Pair<Triple<BooleanFormula, AbstractState, T>, Integer> leftMostSubtree = Pair.of(formulasWithStatesAndGroupdIds.get(0), 0);
        stack.add(leftMostSubtree);
        block5: for (int positionOfA = 0; positionOfA < formulasWithStatesAndGroupdIds.size(); ++positionOfA) {
            Triple<BooleanFormula, AbstractState, T> formula = formulasWithStatesAndGroupdIds.get(positionOfA);
            switch (AbstractTreeInterpolation.getTreePosition(formulasWithStatesAndGroupdIds, positionOfA)) {
                case START: {
                    stack.addLast(Pair.of(formula, formulas.size()));
                    continue block5;
                }
                case END: {
                    startOfSubTree.add(((Integer)((Pair)stack.getLast()).getSecond()).intValue());
                    formulas.add(formula);
                    Pair commonRoot = (Pair)stack.removeLast();
                    startOfSubTree.add(((Integer)((Pair)stack.getLast()).getSecond()).intValue());
                    formulas.add((Triple)commonRoot.getFirst());
                    assert ((Integer)commonRoot.getSecond() >= (Integer)((Pair)stack.getLast()).getSecond()) : "adding a complete subtree can only be done on the right side";
                    continue block5;
                }
                case MIDDLE: {
                    startOfSubTree.add(((Integer)((Pair)stack.getLast()).getSecond()).intValue());
                    formulas.add(formula);
                    continue block5;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        ImmutableIntArray resultingStartOfSubtree = startOfSubTree.build();
        Verify.verify((formulas.size() == resultingStartOfSubtree.length() ? 1 : 0) != 0, (String)"invalid number of tree elements: %s", (Object)resultingStartOfSubtree);
        Pair last = (Pair)stack.removeLast();
        assert (last == leftMostSubtree) : "root must start at left-most subtree";
        assert (stack.isEmpty()) : "after building the tree-structure there should not be formulas on the stack";
        this.logger.log(Level.ALL, new Object[]{"formulas of tree are:", formulas});
        this.logger.log(Level.ALL, new Object[]{"subtree-structure is:", resultingStartOfSubtree});
        assert (formulas.size() == formulasWithStatesAndGroupdIds.size()) : "invalid number of tree elements: " + formulas.size() + " vs " + formulasWithStatesAndGroupdIds.size();
        return Pair.of(formulas, resultingStartOfSubtree);
    }

    protected <T> List<BooleanFormula> flattenTreeItps(List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, List<BooleanFormula> itps) {
        assert (itps.size() == formulasWithStatesAndGroupdIds.size() - 1) : String.format("number of interpolants does not match formulas: %d vs %d", itps.size(), formulasWithStatesAndGroupdIds.size());
        ImmutableList.Builder interpolants = ImmutableList.builder();
        Iterator<BooleanFormula> iter = itps.iterator();
        for (int positionOfA = 0; positionOfA < formulasWithStatesAndGroupdIds.size() - 1; ++positionOfA) {
            BooleanFormula itp;
            switch (AbstractTreeInterpolation.getTreePosition(formulasWithStatesAndGroupdIds, positionOfA)) {
                case START: {
                    itp = this.bfmgr.makeTrue();
                    break;
                }
                case END: {
                    BooleanFormula functionSummary = iter.next();
                    BooleanFormula functionExecution = iter.next();
                    itp = this.rebuildInterpolant(functionSummary, functionExecution);
                    break;
                }
                case MIDDLE: {
                    itp = iter.next();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            interpolants.add((Object)itp);
        }
        assert (!iter.hasNext()) : "remaining interpolants: " + Lists.newArrayList(iter);
        return interpolants.build();
    }

    protected BooleanFormula rebuildInterpolant(BooleanFormula functionSummary, BooleanFormula functionExecution) {
        BooleanFormula rebuildItp = this.bfmgr.isTrue(functionSummary) || this.bfmgr.isFalse(functionSummary) ? functionExecution : (this.bfmgr.isTrue(functionExecution) || this.bfmgr.isFalse(functionExecution) ? functionSummary : this.bfmgr.or(functionSummary, functionExecution));
        return rebuildItp;
    }

    private static enum TreePosition {
        START,
        MIDDLE,
        END;

    }
}

