/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation.strategy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

public abstract class ITPStrategy {
    protected final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    protected final FormulaManagerView fmgr;
    protected final BooleanFormulaManager bfmgr;

    ITPStrategy(LogManager pLogger, ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr) {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.fmgr = pFmgr;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
    }

    public abstract <T> List<BooleanFormula> getInterpolants(InterpolationManager.Interpolator<T> var1, List<Triple<BooleanFormula, AbstractState, T>> var2) throws InterruptedException, SolverException;

    public <T> void checkInterpolants(Solver solver, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, List<BooleanFormula> interpolants) throws InterruptedException, SolverException {
        List formulas = Lists.transform(formulasWithStatesAndGroupdIds, Triple::getFirst);
        int n = interpolants.size();
        assert (n == formulas.size() - 1);
        if (!solver.implies((BooleanFormula)formulas.get(0), interpolants.get(0))) {
            throw new SolverException(String.format("First interpolant '%s' is not implied by first formula '%s'.", interpolants.get(0), formulas.get(0)));
        }
        for (int i = 1; i <= n - 1; ++i) {
            BooleanFormula conjunct = this.bfmgr.and(interpolants.get(i - 1), (BooleanFormula)formulas.get(i));
            if (solver.implies(conjunct, interpolants.get(i))) continue;
            throw new SolverException(String.format("Interpolant '%s' at index %d is not implied by previous part of the path", interpolants.get(i), i));
        }
        BooleanFormula conjunct = this.bfmgr.and(interpolants.get(n - 1), (BooleanFormula)formulas.get(n));
        if (!solver.implies(conjunct, this.bfmgr.makeFalse())) {
            throw new SolverException(String.format("Last interpolant '%s' fails to prove infeasibility of the remaining path '%s'.", interpolants.get(n - 1), formulas.get(n)));
        }
        ArrayList<Set<String>> variablesInFormulas = new ArrayList<Set<String>>(formulas.size());
        for (BooleanFormula f : formulas) {
            variablesInFormulas.add(this.fmgr.extractVariableNames((Formula)f));
        }
        for (int i = 0; i < interpolants.size(); ++i) {
            Set<String> variablesInInterpolant;
            HashSet variablesInA = new HashSet();
            for (int j = 0; j <= i; ++j) {
                variablesInA.addAll((Collection)variablesInFormulas.get(j));
            }
            HashSet variablesInB = new HashSet();
            for (int j = i + 1; j < formulas.size(); ++j) {
                variablesInB.addAll((Collection)variablesInFormulas.get(j));
            }
            ImmutableSet allowedVariables = Sets.intersection(variablesInA, variablesInB).immutableCopy();
            if (allowedVariables.containsAll(variablesInInterpolant = this.fmgr.extractVariableNames((Formula)interpolants.get(i)))) continue;
            throw new SolverException("Interpolant " + interpolants.get(i) + " contains forbidden variable(s) " + Sets.difference(variablesInInterpolant, (Set)allowedVariables));
        }
    }

    protected static <T1, T2, T3> List<T3> projectToThird(List<Triple<T1, T2, T3>> l) {
        return Lists.transform(l, Triple::getThird);
    }

    protected final <T> BooleanFormula getInterpolantFromSublist(InterpolatingProverEnvironment<T> pItpProver, List<T> itpGroupsIds, int start_of_A, int end_of_A) throws InterruptedException, SolverException {
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.ALL, new Object[]{"Looking for interpolant for formulas from", start_of_A, "to", end_of_A});
        BooleanFormula itp = pItpProver.getInterpolant(itpGroupsIds.subList(start_of_A, end_of_A + 1));
        this.logger.log(Level.ALL, new Object[]{"Received interpolant", itp});
        return itp;
    }
}

