/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.AbstractTreeInterpolation;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

public class NestedInterpolation
extends AbstractTreeInterpolation {
    public NestedInterpolation(LogManager pLogger, ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr) {
        super(pLogger, pShutdownNotifier, pFmgr);
    }

    @Override
    public <T> List<BooleanFormula> getInterpolants(InterpolationManager.Interpolator<T> interpolator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) throws InterruptedException, SolverException {
        ImmutableList.Builder interpolants = ImmutableList.builderWithExpectedSize((int)(formulasWithStatesAndGroupdIds.size() - 1));
        BooleanFormula lastItp = this.bfmgr.makeTrue();
        ArrayDeque<Pair<BooleanFormula, BooleanFormula>> callstack = new ArrayDeque<Pair<BooleanFormula, BooleanFormula>>();
        for (int positionOfA = 0; positionOfA < formulasWithStatesAndGroupdIds.size() - 1; ++positionOfA) {
            lastItp = this.getNestedInterpolant(formulasWithStatesAndGroupdIds, (ImmutableList.Builder<BooleanFormula>)interpolants, callstack, interpolator, positionOfA, lastItp);
        }
        ImmutableList result = interpolants.build();
        assert (formulasWithStatesAndGroupdIds.size() == result.size() + 1);
        if (!result.isEmpty()) assert (lastItp == Iterables.getLast((Iterable)result));
        return result;
    }

    private <T> BooleanFormula getNestedInterpolant(List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds, ImmutableList.Builder<BooleanFormula> interpolants, Deque<Pair<BooleanFormula, BooleanFormula>> callstack, InterpolationManager.Interpolator<T> interpolator, int positionOfA, BooleanFormula lastItp) throws InterruptedException, SolverException {
        BooleanFormula itp;
        AbstractState abstractionState = (AbstractState)Preconditions.checkNotNull((Object)formulasWithStatesAndGroupdIds.get(positionOfA).getSecond());
        CFANode node = AbstractStates.extractLocation(abstractionState);
        if (node instanceof FunctionEntryNode && NestedInterpolation.callHasReturn(formulasWithStatesAndGroupdIds, positionOfA)) {
            BooleanFormula call = formulasWithStatesAndGroupdIds.get(positionOfA).getFirst();
            callstack.addLast(Pair.of(lastItp, call));
            BooleanFormula itpTrue = this.bfmgr.makeTrue();
            interpolants.add((Object)itpTrue);
            return itpTrue;
        }
        try (InterpolatingProverEnvironment<T> itpProver = interpolator.newEnvironment();){
            ArrayList<Object> A = new ArrayList<Object>();
            ArrayList<Object> B = new ArrayList<Object>();
            A.add(itpProver.push(lastItp));
            A.add(itpProver.push(formulasWithStatesAndGroupdIds.get(positionOfA).getFirst()));
            for (Triple triple : Iterables.skip(formulasWithStatesAndGroupdIds, (int)(positionOfA + 1))) {
                B.add(itpProver.push((BooleanFormula)triple.getFirst()));
            }
            for (Pair pair : callstack) {
                B.add(itpProver.push((BooleanFormula)pair.getFirst()));
                B.add(itpProver.push((BooleanFormula)pair.getSecond()));
            }
            boolean unsat = itpProver.isUnsat();
            assert (unsat) : "formulas were unsat before, they have to be unsat now.";
            assert (!A.isEmpty() && !B.isEmpty());
            itp = itpProver.getInterpolant(A);
        }
        if (!callstack.isEmpty() && node instanceof FunctionExitNode) {
            Pair<BooleanFormula, BooleanFormula> scopingItp = callstack.removeLast();
            try (InterpolatingProverEnvironment<T> itpProver2 = interpolator.newEnvironment();){
                ArrayList<Object> A2 = new ArrayList<Object>();
                ArrayList<Object> B2 = new ArrayList<Object>();
                A2.add(itpProver2.push(itp));
                A2.add(itpProver2.push(scopingItp.getFirst()));
                A2.add(itpProver2.push(scopingItp.getSecond()));
                for (Triple triple : Iterables.skip(formulasWithStatesAndGroupdIds, (int)(positionOfA + 1))) {
                    B2.add(itpProver2.push((BooleanFormula)triple.getFirst()));
                }
                for (Pair<BooleanFormula, BooleanFormula> pair : callstack) {
                    B2.add(itpProver2.push(pair.getFirst()));
                    B2.add(itpProver2.push(pair.getSecond()));
                }
                boolean bl = itpProver2.isUnsat();
                assert (bl) : "formulas2 were unsat before, they have to be unsat now.";
                assert (!A2.isEmpty() && !B2.isEmpty());
                BooleanFormula booleanFormula = itpProver2.getInterpolant(A2);
                BooleanFormula rebuildItp = this.rebuildInterpolant(itp, booleanFormula);
                BooleanFormula scope = scopingItp.getFirst();
                if (!this.bfmgr.isFalse(scope)) {
                    rebuildItp = this.bfmgr.and(rebuildItp, scope);
                }
                interpolants.add((Object)rebuildItp);
                BooleanFormula booleanFormula2 = booleanFormula;
                return booleanFormula2;
            }
        }
        interpolants.add((Object)itp);
        return itp;
    }
}

