/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.ITPStrategy;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

@Options(prefix="cpa.predicate.refinement")
public class SequentialInterpolation
extends ITPStrategy {
    private static final String FALLBACK_BWD_MSG = "Falling back to backward interpolant, because forward interpolant caused exception:";
    private static final String FALLBACK_FWD_MSG = "Falling back to forward interpolant, because backward interpolant caused exception:";
    private static final String UNEXPECTED_DIRECTION_MSG = "unexpected direction for sequential interpolation";
    @Option(secure=true, description="In case we apply sequential interpolation, forward and backward directions return valid interpolants. We can either choose one of the directions, fallback to the other if one does not succeed, or even combine the interpolants.")
    private SeqInterpolationStrategy sequentialStrategy = SeqInterpolationStrategy.FWD;
    private final Random rnd = new Random(0L);

    public SequentialInterpolation(LogManager pLogger, ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr, Configuration pConfig) throws InvalidConfigurationException {
        super(pLogger, pShutdownNotifier, pFmgr);
        pConfig.inject((Object)this);
    }

    @Override
    public <T> List<BooleanFormula> getInterpolants(InterpolationManager.Interpolator<T> interpolator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStateAndGroupId) throws InterruptedException, SolverException {
        List formulas = SequentialInterpolation.projectToThird(formulasWithStateAndGroupId);
        switch (this.sequentialStrategy) {
            case FWD_FALLBACK: {
                try {
                    return this.getFwdInterpolants(interpolator, formulas);
                }
                catch (SolverException e) {
                    this.logger.logDebugException((Throwable)e, FALLBACK_BWD_MSG);
                }
            }
            case BWD: {
                return this.getBwdInterpolants(interpolator, formulas);
            }
            case BWD_FALLBACK: {
                try {
                    return this.getBwdInterpolants(interpolator, formulas);
                }
                catch (SolverException e) {
                    this.logger.logDebugException((Throwable)e, FALLBACK_FWD_MSG);
                }
            }
            case FWD: {
                return this.getFwdInterpolants(interpolator, formulas);
            }
            case CONJUNCTION: 
            case DISJUNCTION: 
            case WEIGHTED: 
            case RANDOM: {
                List<BooleanFormula> forward = null;
                try {
                    forward = this.getFwdInterpolants(interpolator, formulas);
                }
                catch (SolverException e) {
                    this.logger.logDebugException((Throwable)e, FALLBACK_BWD_MSG);
                    return this.getBwdInterpolants(interpolator, formulas);
                }
                try {
                    List<BooleanFormula> backward = this.getBwdInterpolants(interpolator, formulas);
                    return this.combine(forward, backward);
                }
                catch (SolverException e) {
                    if (forward == null) {
                        throw e;
                    }
                    this.logger.logDebugException((Throwable)e, FALLBACK_FWD_MSG);
                    return forward;
                }
            }
        }
        throw new AssertionError((Object)UNEXPECTED_DIRECTION_MSG);
    }

    private <T> List<BooleanFormula> getFwdInterpolants(InterpolationManager.Interpolator<T> interpolator, List<T> formulas) throws InterruptedException, SolverException {
        ImmutableList.Builder interpolants = ImmutableList.builderWithExpectedSize((int)(formulas.size() - 1));
        for (int end_of_A = 0; end_of_A < formulas.size() - 1; ++end_of_A) {
            boolean start_of_A = false;
            interpolants.add((Object)this.getInterpolantFromSublist(interpolator.itpProver, formulas, 0, end_of_A));
        }
        return interpolants.build();
    }

    private <T> List<BooleanFormula> getBwdInterpolants(InterpolationManager.Interpolator<T> interpolator, List<T> formulas) throws InterruptedException, SolverException {
        ImmutableList.Builder interpolants = ImmutableList.builderWithExpectedSize((int)(formulas.size() - 1));
        for (int start_of_A = 1; start_of_A < formulas.size(); ++start_of_A) {
            int end_of_A = formulas.size() - 1;
            interpolants.add((Object)this.bfmgr.not(this.getInterpolantFromSublist(interpolator.itpProver, formulas, start_of_A, end_of_A)));
        }
        return interpolants.build();
    }

    private List<BooleanFormula> combine(List<BooleanFormula> forward, List<BooleanFormula> backward) {
        Preconditions.checkNotNull(forward);
        Preconditions.checkNotNull(backward);
        switch (this.sequentialStrategy) {
            case CONJUNCTION: {
                ImmutableList.Builder interpolants = ImmutableList.builderWithExpectedSize((int)forward.size());
                for (int i = 0; i < forward.size(); ++i) {
                    interpolants.add((Object)this.bfmgr.and(forward.get(i), backward.get(i)));
                }
                return interpolants.build();
            }
            case DISJUNCTION: {
                ImmutableList.Builder interpolants = ImmutableList.builderWithExpectedSize((int)forward.size());
                for (int i = 0; i < forward.size(); ++i) {
                    interpolants.add((Object)this.bfmgr.or(forward.get(i), backward.get(i)));
                }
                return interpolants.build();
            }
            case WEIGHTED: {
                long weightFwd = this.getWeight(forward);
                long weightBwd = this.getWeight(backward);
                return weightFwd <= weightBwd ? forward : backward;
            }
            case RANDOM: {
                return this.rnd.nextBoolean() ? forward : backward;
            }
        }
        throw new AssertionError((Object)UNEXPECTED_DIRECTION_MSG);
    }

    private long getWeight(List<BooleanFormula> formulas) {
        long weight = 0L;
        for (BooleanFormula formula : formulas) {
            Visitor fv = new Visitor();
            this.fmgr.visitRecursively((Formula)formula, (FormulaVisitor<TraversalProcess>)fv);
            weight += fv.getWeight();
        }
        return weight;
    }

    private static final class Visitor
    extends DefaultFormulaVisitor<TraversalProcess> {
        private long weight = 0L;

        private Visitor() {
        }

        private long getWeight() {
            return this.weight;
        }

        protected TraversalProcess visitDefault(Formula pF) {
            return TraversalProcess.CONTINUE;
        }

        public TraversalProcess visitFreeVariable(Formula f, String name) {
            this.weight += 5L;
            return this.visitDefault(f);
        }

        public TraversalProcess visitConstant(Formula f, Object value) {
            ++this.weight;
            return this.visitDefault(f);
        }

        public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            this.weight = functionDeclaration.getType().isBooleanType() ? (this.weight += (long)(functionDeclaration.getKind() == FunctionDeclarationKind.EQ ? 30 : 20)) : (this.weight += 50L);
            return this.visitDefault(f);
        }
    }

    public static enum SeqInterpolationStrategy {
        FWD,
        FWD_FALLBACK,
        BWD,
        BWD_FALLBACK,
        CONJUNCTION,
        DISJUNCTION,
        WEIGHTED,
        RANDOM;

    }
}

