/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interpolation.strategy;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.strategy.AbstractTreeInterpolation;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

public class TreeInterpolation
extends AbstractTreeInterpolation {
    public TreeInterpolation(LogManager pLogger, ShutdownNotifier pShutdownNotifier, FormulaManagerView pFmgr) {
        super(pLogger, pShutdownNotifier, pFmgr);
    }

    @Override
    public <T> List<BooleanFormula> getInterpolants(InterpolationManager.Interpolator<T> interpolator, List<Triple<BooleanFormula, AbstractState, T>> formulasWithStatesAndGroupdIds) throws InterruptedException, SolverException {
        Pair<List<Triple<BooleanFormula, AbstractState, T>>, ImmutableIntArray> p = this.buildTreeStructure(formulasWithStatesAndGroupdIds);
        ImmutableList.Builder itps = ImmutableList.builderWithExpectedSize((int)p.getFirst().size());
        ArrayDeque<Pair<BooleanFormula, Integer>> itpStack = new ArrayDeque<Pair<BooleanFormula, Integer>>();
        for (int positionOfA = 0; positionOfA < p.getFirst().size() - 1; ++positionOfA) {
            itps.add((Object)this.getTreeInterpolant(interpolator, itpStack, p.getFirst(), p.getSecond(), positionOfA));
        }
        return this.flattenTreeItps(formulasWithStatesAndGroupdIds, (List<BooleanFormula>)itps.build());
    }

    private <T> BooleanFormula getTreeInterpolant(InterpolationManager.Interpolator<T> interpolator, Deque<Pair<BooleanFormula, Integer>> itpStack, List<Triple<BooleanFormula, AbstractState, T>> formulas, ImmutableIntArray startOfSubTree, int positionOfA) throws SolverException, InterruptedException {
        try (InterpolatingProverEnvironment<T> itpProver = interpolator.newEnvironment();){
            int currentSubtree = startOfSubTree.get(positionOfA);
            ArrayList<Object> A = new ArrayList<Object>();
            ArrayList<Object> B = new ArrayList<Object>();
            while (!itpStack.isEmpty() && currentSubtree <= itpStack.peekLast().getSecond()) {
                A.add(itpProver.push(itpStack.pollLast().getFirst()));
            }
            A.add(itpProver.push(formulas.get(positionOfA).getFirst()));
            assert (itpStack.isEmpty() == (currentSubtree == 0)) : "empty stack is only allowed, if we are in the left-most branch" + startOfSubTree + "@" + positionOfA + "=" + currentSubtree + " vs " + itpStack.size();
            for (Pair<BooleanFormula, Integer> externalChild : itpStack) {
                B.add(itpProver.push(externalChild.getFirst()));
            }
            for (int i = positionOfA + 1; i < formulas.size(); ++i) {
                B.add(itpProver.push(formulas.get(i).getFirst()));
            }
            boolean check = itpProver.isUnsat();
            assert (check) : "asserted formulas should be UNSAT";
            assert (!A.isEmpty() && !B.isEmpty());
            BooleanFormula interpolant = itpProver.getInterpolant(A);
            itpStack.addLast(Pair.of(interpolant, currentSubtree));
            BooleanFormula booleanFormula = interpolant;
            return booleanFormula;
        }
    }
}

