/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.invariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.LazyLocationMapping;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ReachedSetBasedExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class ExpressionTreeInvariantSupplier
implements ExpressionTreeSupplier {
    private final AggregatedReachedSets aggregatedReached;
    private final CFA cfa;
    private Set<UnmodifiableReachedSet> lastUsedReachedSets = ImmutableSet.of();
    private ExpressionTreeSupplier lastInvariantSupplier = ExpressionTreeSupplier.TrivialInvariantSupplier.INSTANCE;
    private final Map<UnmodifiableReachedSet, ExpressionTreeSupplier> singleInvariantSuppliers = new HashMap<UnmodifiableReachedSet, ExpressionTreeSupplier>();

    public ExpressionTreeInvariantSupplier(AggregatedReachedSets pAggregated, CFA pCFA) {
        this.aggregatedReached = pAggregated;
        this.cfa = pCFA;
        this.updateInvariants();
    }

    @Override
    public ExpressionTree<Object> getInvariantFor(CFANode pNode) throws InterruptedException {
        return this.lastInvariantSupplier.getInvariantFor(pNode);
    }

    public void updateInvariants() {
        Set<UnmodifiableReachedSet> newReached = this.aggregatedReached.snapShot();
        if (!newReached.equals(this.lastUsedReachedSets)) {
            Sets.SetView oldElements = Sets.difference(this.lastUsedReachedSets, newReached);
            Sets.SetView newElements = Sets.difference(newReached, this.lastUsedReachedSets);
            oldElements.forEach(r -> this.singleInvariantSuppliers.remove(r));
            newElements.forEach(r -> this.singleInvariantSuppliers.put((UnmodifiableReachedSet)r, new ReachedSetBasedExpressionTreeSupplier(new LazyLocationMapping((UnmodifiableReachedSet)r), this.cfa)));
            this.lastUsedReachedSets = newReached;
            this.lastInvariantSupplier = new AggregatedExpressionTreeSupplier((ImmutableCollection<ExpressionTreeSupplier>)ImmutableSet.copyOf(this.singleInvariantSuppliers.values()));
        }
    }

    private static class AggregatedExpressionTreeSupplier
    implements ExpressionTreeSupplier {
        private final Collection<ExpressionTreeSupplier> invariantSuppliers;

        private AggregatedExpressionTreeSupplier(ImmutableCollection<ExpressionTreeSupplier> pInvariantSuppliers) {
            this.invariantSuppliers = (Collection)Preconditions.checkNotNull(pInvariantSuppliers);
        }

        @Override
        public ExpressionTree<Object> getInvariantFor(CFANode pNode) throws InterruptedException {
            ExpressionTree<Object> result = ExpressionTrees.getTrue();
            for (ExpressionTreeSupplier supplier : this.invariantSuppliers) {
                result = And.of(result, supplier.getInvariantFor(pNode));
            }
            return result;
        }
    }
}

