/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.invariants;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.LazyLocationMapping;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

public class FormulaInvariantsSupplier
implements InvariantSupplier {
    private final AggregatedReachedSets aggregatedReached;
    private Set<UnmodifiableReachedSet> lastUsedReachedSets = ImmutableSet.of();
    private InvariantSupplier lastInvariantSupplier = InvariantSupplier.TrivialInvariantSupplier.INSTANCE;
    private final Map<UnmodifiableReachedSet, ReachedSetBasedFormulaSupplier> singleInvariantSuppliers = new HashMap<UnmodifiableReachedSet, ReachedSetBasedFormulaSupplier>();

    public FormulaInvariantsSupplier(AggregatedReachedSets pAggregated) {
        this.aggregatedReached = pAggregated;
        this.updateInvariants();
    }

    @Override
    public BooleanFormula getInvariantFor(CFANode pNode, Optional<CallstackStateEqualsWrapper> pCallstackInfo, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, @Nullable PathFormula pContext) throws InterruptedException {
        return this.lastInvariantSupplier.getInvariantFor(pNode, pCallstackInfo, pFmgr, pPfmgr, pContext);
    }

    public void updateInvariants() {
        Set<UnmodifiableReachedSet> tmp = this.aggregatedReached.snapShot();
        if (!tmp.equals(this.lastUsedReachedSets)) {
            Sets.SetView oldElements = Sets.difference(this.lastUsedReachedSets, tmp);
            Sets.SetView newElements = Sets.difference(tmp, this.lastUsedReachedSets);
            oldElements.forEach(r -> this.singleInvariantSuppliers.remove(r));
            newElements.forEach(r -> this.singleInvariantSuppliers.put((UnmodifiableReachedSet)r, new ReachedSetBasedFormulaSupplier(new LazyLocationMapping((UnmodifiableReachedSet)r))));
            this.lastUsedReachedSets = tmp;
            this.lastInvariantSupplier = new AggregatedInvariantSupplier((ImmutableCollection<ReachedSetBasedFormulaSupplier>)ImmutableSet.copyOf(this.singleInvariantSuppliers.values()));
        }
    }

    private static final class InvariantsCacheKey {
        private final CFANode node;
        private final Optional<CallstackStateEqualsWrapper> callstackInformation;
        private final FormulaManagerView fmgr;
        private final PathFormulaManager pfmgr;

        public InvariantsCacheKey(CFANode pNode, Optional<CallstackStateEqualsWrapper> pCallstackInformation, FormulaManagerView pFormulaManager, PathFormulaManager pPathFormulaManager) {
            this.node = pNode;
            this.callstackInformation = pCallstackInformation;
            this.fmgr = pFormulaManager;
            this.pfmgr = pPathFormulaManager;
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (pO == null || this.getClass() != pO.getClass()) {
                return false;
            }
            InvariantsCacheKey that = (InvariantsCacheKey)pO;
            return Objects.equals(this.node, that.node) && Objects.equals(this.callstackInformation, that.callstackInformation) && Objects.equals(this.fmgr, that.fmgr) && Objects.equals(this.pfmgr, that.pfmgr);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.callstackInformation, this.fmgr, this.pfmgr);
        }
    }

    private static class AggregatedInvariantSupplier
    implements InvariantSupplier {
        private final Collection<ReachedSetBasedFormulaSupplier> invariantSuppliers;
        private final Map<InvariantsCacheKey, List<BooleanFormula>> cache = new HashMap<InvariantsCacheKey, List<BooleanFormula>>();

        private AggregatedInvariantSupplier(ImmutableCollection<ReachedSetBasedFormulaSupplier> pInvariantSuppliers) {
            this.invariantSuppliers = (Collection)Preconditions.checkNotNull(pInvariantSuppliers);
        }

        @Override
        public BooleanFormula getInvariantFor(CFANode pNode, Optional<CallstackStateEqualsWrapper> callstackInformation, FormulaManagerView pFmgr, PathFormulaManager pPfmgr, PathFormula pContext) throws InterruptedException {
            Object invariants;
            InvariantsCacheKey key = new InvariantsCacheKey(pNode, callstackInformation, pFmgr, pPfmgr);
            if (this.cache.containsKey(key)) {
                invariants = this.cache.get(key);
            } else {
                invariants = Collections3.transformedImmutableListCopy(this.invariantSuppliers, s -> s.getInvariantFor(pNode, callstackInformation, pFmgr));
                this.cache.put(key, (List<BooleanFormula>)invariants);
            }
            BooleanFormulaManagerView bfmgr = pFmgr.getBooleanFormulaManager();
            if (pContext != null) {
                ArrayList<BooleanFormula> adjustedInvariants = new ArrayList<BooleanFormula>(invariants.size());
                NavigableSet<String> variables = pContext.getSsa().allVariables();
                for (BooleanFormula invariant : invariants) {
                    BooleanFormula inv = pFmgr.transformRecursively(invariant, new AddPointerInformationVisitor(pFmgr, pContext, pPfmgr));
                    if (!variables.containsAll(pFmgr.extractVariableNames((Formula)inv))) {
                        inv = pFmgr.filterLiterals(inv, (Predicate<BooleanFormula>)((Predicate)bf -> variables.containsAll(pFmgr.extractVariableNames((Formula)bf))));
                    }
                    adjustedInvariants.add(inv);
                }
                invariants = adjustedInvariants;
            }
            return (BooleanFormula)Verify.verifyNotNull((Object)bfmgr.and((Collection)invariants));
        }
    }

    private static class ReachedSetBasedFormulaSupplier {
        private final LazyLocationMapping lazyLocationMapping;

        public ReachedSetBasedFormulaSupplier(LazyLocationMapping pLazyLocationMapping) {
            this.lazyLocationMapping = Objects.requireNonNull(pLazyLocationMapping);
        }

        public BooleanFormula getInvariantFor(CFANode pLocation, Optional<CallstackStateEqualsWrapper> pCallstackInformation, FormulaManagerView fmgr) {
            BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
            BooleanFormula invariant = bfmgr.makeFalse();
            for (AbstractState locState : this.lazyLocationMapping.get(pLocation, pCallstackInformation)) {
                invariant = bfmgr.or(invariant, AbstractStates.extractReportedFormulas(fmgr, locState));
            }
            return invariant;
        }
    }

    private static class AddPointerInformationVisitor
    extends FormulaManagerView.FormulaTransformationVisitor {
        private final PathFormula context;
        private final PathFormulaManager pfgmr;

        protected AddPointerInformationVisitor(FormulaManagerView pFmgr, PathFormula pContext, PathFormulaManager pPfmgr) {
            super(pFmgr);
            this.pfgmr = pPfmgr;
            this.context = pContext;
        }

        public Formula visitFreeVariable(Formula atom, String varName) {
            if (this.context.getPointerTargetSet().isActualBase(varName)) {
                return this.pfgmr.makeFormulaForUninstantiatedVariable(varName, (CType)this.context.getPointerTargetSet().getBases().get((Object)varName), this.context.getPointerTargetSet(), false);
            }
            SSAMap ssa = this.context.getSsa();
            if (!ssa.containsVariable(varName)) {
                if (varName.startsWith("*(") && varName.endsWith(")")) {
                    String unwrappedVarName = varName.substring(2, varName.length() - 1);
                    if (!ssa.containsVariable(unwrappedVarName)) {
                        return atom;
                    }
                    CType type = ((CPointerType)ssa.getType(unwrappedVarName)).getType();
                    atom = this.pfgmr.makeFormulaForUninstantiatedVariable(unwrappedVarName, type, this.context.getPointerTargetSet(), true);
                    return atom;
                }
                return atom;
            }
            return atom;
        }
    }
}

