/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.errorprone.annotations.ForOverride;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;

public abstract class CachingPathFormulaBuilder
implements PathFormulaBuilder {
    private PathFormula cachedResult = null;
    private PathFormulaManager cachedInputPfmgr = null;
    private PathFormula cachedInputPathFormula = null;

    private @Nullable PathFormula cachedBuild(PathFormulaManager pPfmgr, PathFormula pPathFormula) {
        if (this.cachedResult == null || !pPfmgr.equals(this.cachedInputPfmgr) || !pPathFormula.equals(this.cachedInputPathFormula)) {
            return null;
        }
        return this.cachedResult;
    }

    private void updateCache(PathFormula pResult, PathFormulaManager pPfmgr, PathFormula pPathFormula) {
        this.cachedResult = pResult;
        this.cachedInputPfmgr = pPfmgr;
        this.cachedInputPathFormula = pPathFormula;
    }

    @ForOverride
    protected abstract PathFormula buildImplementation(PathFormulaManager var1, PathFormula var2) throws CPATransferException, InterruptedException;

    @Override
    public final PathFormula build(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
        PathFormula result = this.cachedBuild(pPfmgr, pathFormula);
        if (result == null) {
            result = this.buildImplementation(pPfmgr, pathFormula);
            this.updateCache(result, pPfmgr, pathFormula);
        }
        return result;
    }
}

