/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Equivalence;
import com.google.common.base.Predicate;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;

public class CachingPathFormulaManager
implements PathFormulaManager {
    public final ThreadSafeTimerContainer pathFormulaComputationTimer = new ThreadSafeTimerContainer(null);
    public LongAdder pathFormulaCacheHits = new LongAdder();
    public final PathFormulaManager delegate;
    private final Map<Pair<Equivalence.Wrapper<CFAEdge>, PathFormula>, Pair<PathFormula, ErrorConditions>> andFormulaWithConditionsCache = new HashMap<Pair<Equivalence.Wrapper<CFAEdge>, PathFormula>, Pair<PathFormula, ErrorConditions>>();
    private final Map<Pair<Equivalence.Wrapper<CFAEdge>, PathFormula>, PathFormula> andFormulaCache = new HashMap<Pair<Equivalence.Wrapper<CFAEdge>, PathFormula>, PathFormula>();
    private final Map<Pair<PathFormula, PathFormula>, PathFormula> orFormulaCache = new HashMap<Pair<PathFormula, PathFormula>, PathFormula>();
    private final Map<PathFormula, PathFormula> emptyFormulaCache = new HashMap<PathFormula, PathFormula>();
    private final PathFormula emptyFormula;

    public CachingPathFormulaManager(PathFormulaManager pDelegate) {
        this.delegate = pDelegate;
        this.emptyFormula = this.delegate.makeEmptyPathFormula();
    }

    private Pair<Equivalence.Wrapper<CFAEdge>, PathFormula> createFormulaCacheKey(PathFormula pOldFormula, CFAEdge pEdge) {
        return Pair.of(Equivalence.identity().wrap((Object)pEdge), pOldFormula);
    }

    @Override
    public Pair<PathFormula, ErrorConditions> makeAndWithErrorConditions(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        Pair<Equivalence.Wrapper<CFAEdge>, PathFormula> formulaCacheKey = this.createFormulaCacheKey(pOldFormula, pEdge);
        Pair<PathFormula, ErrorConditions> result = this.andFormulaWithConditionsCache.get(formulaCacheKey);
        if (result == null) {
            ThreadSafeTimerContainer.TimerWrapper t = this.pathFormulaComputationTimer.getNewTimer();
            t.start();
            result = this.delegate.makeAndWithErrorConditions(pOldFormula, pEdge);
            t.stop();
            this.andFormulaWithConditionsCache.put(formulaCacheKey, result);
        } else {
            this.pathFormulaCacheHits.increment();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        Pair<Equivalence.Wrapper<CFAEdge>, PathFormula> formulaCacheKey = this.createFormulaCacheKey(pOldFormula, pEdge);
        PathFormula result = this.andFormulaCache.get(formulaCacheKey);
        if (result == null) {
            ThreadSafeTimerContainer.TimerWrapper t = this.pathFormulaComputationTimer.getNewTimer();
            try {
                t.start();
                result = this.delegate.makeAnd(pOldFormula, pEdge);
                this.andFormulaCache.put(formulaCacheKey, result);
            }
            finally {
                t.stop();
            }
        } else {
            this.pathFormulaCacheHits.increment();
        }
        return result;
    }

    @Override
    public PathFormula makeOr(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        Pair<PathFormula, PathFormula> formulaCacheKey = Pair.of(pF1, pF2);
        PathFormula result = this.orFormulaCache.get(formulaCacheKey);
        if (result == null) {
            result = this.orFormulaCache.get(Pair.of(pF2, pF1));
        }
        if (result == null) {
            result = this.delegate.makeOr(pF1, pF2);
            this.orFormulaCache.put(formulaCacheKey, result);
        } else {
            this.pathFormulaCacheHits.increment();
        }
        return result;
    }

    @Override
    public PathFormula makeConjunction(List<PathFormula> pPathFormulas) {
        return this.delegate.makeConjunction(pPathFormulas);
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return this.emptyFormula;
    }

    @Override
    public PathFormula makeEmptyPathFormulaWithContextFrom(PathFormula pOldFormula) {
        PathFormula result = this.emptyFormulaCache.get(pOldFormula);
        if (result == null) {
            result = this.delegate.makeEmptyPathFormulaWithContextFrom(pOldFormula);
            this.emptyFormulaCache.put(pOldFormula, result);
        } else {
            this.pathFormulaCacheHits.increment();
        }
        return result;
    }

    @Override
    public PathFormula makeEmptyPathFormulaWithContext(SSAMap pSsaMap, PointerTargetSet pPts) {
        return this.delegate.makeEmptyPathFormulaWithContext(pSsaMap, pPts);
    }

    @Override
    public Formula makeFormulaForVariable(PathFormula pContext, String pVarName, CType pType) {
        return this.delegate.makeFormulaForVariable(pContext, pVarName, pType);
    }

    @Override
    public Formula makeFormulaForUninstantiatedVariable(String pVarName, CType pType, PointerTargetSet pContextPTS, boolean pForcePointerDereference) {
        return this.delegate.makeFormulaForUninstantiatedVariable(pVarName, pType, pContextPTS, pForcePointerDereference);
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, BooleanFormula pOtherFormula) {
        return this.delegate.makeAnd(pPathFormula, pOtherFormula);
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, CExpression pAssumption) throws CPATransferException, InterruptedException {
        return this.delegate.makeAnd(pPathFormula, pAssumption);
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        return this.delegate.makeFormulaForPath(pPath);
    }

    @Override
    public ARGPath getARGPathFromModel(Model pModel, ARGState pRoot, Predicate<? super ARGState> pStateFilter, Map<Pair<ARGState, CFAEdge>, PathFormula> pBranchingFormulasOverride) throws CPATransferException, InterruptedException {
        return this.delegate.getARGPathFromModel(pModel, pRoot, pStateFilter, pBranchingFormulasOverride);
    }

    @Override
    public void clearCaches() {
        this.andFormulaWithConditionsCache.clear();
        this.andFormulaCache.clear();
        this.orFormulaCache.clear();
        this.emptyFormulaCache.clear();
        this.delegate.clearCaches();
    }

    @Override
    public Formula expressionToFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCodeException {
        return this.delegate.expressionToFormula(pFormula, expr, edge);
    }

    @Override
    public BooleanFormula buildImplicationTestAsUnsat(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        return this.delegate.buildImplicationTestAsUnsat(pF1, pF2);
    }

    @Override
    public void printStatistics(PrintStream out) {
        int cacheHits = this.pathFormulaCacheHits.intValue();
        int totalPathFormulaComputations = this.pathFormulaComputationTimer.getNumberOfIntervals() + cacheHits;
        out.println("Number of path formula cache hits:   " + cacheHits + " (" + StatisticsUtils.toPercent(cacheHits, totalPathFormulaComputations) + ")");
        out.println();
        out.println("Inside post operator:                  ");
        out.println("  Inside path formula creation:        ");
        out.println("    Time for path formula computation: " + this.pathFormulaComputationTimer);
        out.println();
        this.delegate.printStatistics(out);
    }

    @Override
    public BooleanFormula addBitwiseAxiomsIfNeeded(BooleanFormula pMainFormula, BooleanFormula pExtractionFormula) {
        return this.delegate.addBitwiseAxiomsIfNeeded(pMainFormula, pExtractionFormula);
    }

    @Override
    public BooleanFormula buildWeakestPrecondition(CFAEdge pEdge, BooleanFormula pPostcondition) throws UnrecognizedCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        return this.delegate.buildWeakestPrecondition(pEdge, pPostcondition);
    }

    @Override
    public PointerTargetSet mergePts(PointerTargetSet pPts1, PointerTargetSet pPts2, SSAMap.SSAMapBuilder pSSA) throws InterruptedException {
        return this.delegate.mergePts(pPts1, pPts2, pSSA);
    }

    @Override
    public PathFormulaBuilder createNewPathFormulaBuilder() {
        return this.delegate.createNewPathFormulaBuilder();
    }
}

