/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilderFactory;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;

public class DefaultPathFormulaBuilder
extends CachingPathFormulaBuilder {
    @Override
    public PathFormulaBuilder makeOr(PathFormulaBuilder other) {
        return new PathFormulaOrBuilder(this, other);
    }

    @Override
    public PathFormulaBuilder makeAnd(CFAEdge pEdge) {
        return new EdgePathFormulaAndBuilder(this, pEdge);
    }

    @Override
    public PathFormulaBuilder makeAnd(CExpression pAssumption) {
        return new ExpressionPathFormulaAndBuilder(this, pAssumption);
    }

    @Override
    protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
        return pathFormula;
    }

    public static class Factory
    implements PathFormulaBuilderFactory {
        @Override
        public DefaultPathFormulaBuilder create() {
            return new DefaultPathFormulaBuilder();
        }
    }

    private static class PathFormulaOrBuilder
    extends DefaultPathFormulaBuilder {
        private PathFormulaBuilder first;
        private PathFormulaBuilder second;

        protected PathFormulaOrBuilder(PathFormulaBuilder first, PathFormulaBuilder second) {
            this.first = first;
            this.second = second;
        }

        @Override
        protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
            return pPfmgr.makeOr(this.first.build(pPfmgr, pathFormula), this.second.build(pPfmgr, pathFormula));
        }
    }

    private static class ExpressionPathFormulaAndBuilder
    extends PathFormulaAndBuilder {
        private CExpression assumption;

        protected ExpressionPathFormulaAndBuilder(DefaultPathFormulaBuilder pPathFormulaAndBuilder, CExpression pAssumption) {
            super(pPathFormulaAndBuilder);
            this.assumption = pAssumption;
        }

        @Override
        protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
            return pPfmgr.makeAnd(this.previousPathFormula.build(pPfmgr, pathFormula), this.assumption);
        }
    }

    private static class EdgePathFormulaAndBuilder
    extends PathFormulaAndBuilder {
        private CFAEdge edge;

        protected EdgePathFormulaAndBuilder(DefaultPathFormulaBuilder pPathFormulaAndBuilder, CFAEdge pEdge) {
            super(pPathFormulaAndBuilder);
            this.edge = pEdge;
        }

        @Override
        protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
            return pPfmgr.makeAnd(this.previousPathFormula.build(pPfmgr, pathFormula), this.edge);
        }
    }

    private static abstract class PathFormulaAndBuilder
    extends DefaultPathFormulaBuilder {
        protected final DefaultPathFormulaBuilder previousPathFormula;

        private PathFormulaAndBuilder(DefaultPathFormulaBuilder pPathFormulaAndBuilder) {
            this.previousPathFormula = pPathFormulaAndBuilder;
        }
    }
}

