/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class ErrorConditions {
    private final BooleanFormulaManagerView bfmgr;
    private BooleanFormula invalidDeref;
    private BooleanFormula invalidFree;

    public ErrorConditions(BooleanFormulaManagerView pBfmgr) {
        this.bfmgr = pBfmgr;
        this.invalidDeref = this.bfmgr.makeFalse();
        this.invalidFree = this.bfmgr.makeFalse();
    }

    public boolean isEnabled() {
        return true;
    }

    public void addInvalidDerefCondition(BooleanFormula pCo) {
        this.invalidDeref = this.bfmgr.or(this.invalidDeref, pCo);
    }

    public void addInvalidFreeCondition(BooleanFormula pCo) {
        this.invalidFree = this.bfmgr.or(this.invalidFree, pCo);
    }

    public BooleanFormula getInvalidDerefCondition() {
        return this.invalidDeref;
    }

    public BooleanFormula getInvalidFreeCondition() {
        return this.invalidFree;
    }

    public static ErrorConditions dummyInstance(BooleanFormulaManagerView pBfmgr) {
        return new DummyErrorConditions(pBfmgr);
    }

    private static class DummyErrorConditions
    extends ErrorConditions {
        public DummyErrorConditions(BooleanFormulaManagerView pBfmgr) {
            super(pBfmgr);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addInvalidDerefCondition(BooleanFormula pCo) {
        }

        @Override
        public void addInvalidFreeCondition(BooleanFormula pCo) {
        }
    }
}

