/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;

@Immutable
public final class FreshValueProvider
implements Serializable {
    private static final long serialVersionUID = 12359384095345L;
    @VisibleForTesting
    static final int DEFAULT_INCREMENT = 1;
    private final PersistentSortedMap<String, Integer> vars;

    public FreshValueProvider() {
        this.vars = PathCopyingPersistentTreeMap.of();
    }

    public FreshValueProvider(PersistentSortedMap<String, Integer> diffVars) {
        this.vars = diffVars;
    }

    int getFreshValue(String variable, int value) {
        Integer currentValue = (Integer)this.vars.get((Object)variable);
        if (currentValue != null && value < currentValue) {
            value = currentValue;
        }
        return value + 1;
    }

    public FreshValueProvider merge(FreshValueProvider other) {
        if (this.vars.isEmpty() && other.vars.isEmpty()) {
            return this;
        }
        return new FreshValueProvider((PersistentSortedMap<String, Integer>)PersistentSortedMaps.merge(this.vars, other.vars, (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getMaximumMergeConflictHandler()));
    }

    public boolean equals(Object other) {
        return other instanceof FreshValueProvider && (other == this || this.vars.equals(((FreshValueProvider)other).vars));
    }

    public int hashCode() {
        return this.vars.hashCode();
    }
}

