/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Immutable
public final class PathFormula
implements Serializable {
    private static final long serialVersionUID = -7716850731790578620L;
    private final BooleanFormula formula;
    private final SSAMap ssa;
    private final int length;
    private final PointerTargetSet pts;

    PathFormula(BooleanFormula pf, SSAMap ssa, PointerTargetSet pts, int pLength) {
        this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pf);
        this.ssa = (SSAMap)Preconditions.checkNotNull((Object)ssa);
        this.pts = (PointerTargetSet)Preconditions.checkNotNull((Object)pts);
        this.length = pLength;
    }

    @Deprecated
    public static PathFormula createManually(BooleanFormula pf, SSAMap ssa, PointerTargetSet pts, int pLength) {
        return new PathFormula(pf, ssa, pts, pLength);
    }

    public BooleanFormula getFormula() {
        return this.formula;
    }

    public SSAMap getSsa() {
        return this.ssa;
    }

    public PointerTargetSet getPointerTargetSet() {
        return this.pts;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.getFormula().toString();
    }

    public PathFormula withFormula(BooleanFormula newConstraint) {
        return new PathFormula(newConstraint, this.ssa, this.pts, this.length);
    }

    public PathFormula withContext(SSAMap newSsa, PointerTargetSet newPts) {
        return new PathFormula(this.formula, newSsa, newPts, this.length);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathFormula)) {
            return false;
        }
        PathFormula other = (PathFormula)obj;
        return this.length == other.length && this.formula.equals(other.formula) && this.ssa.equals(other.ssa) && this.pts.equals(other.pts);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.formula.hashCode();
        result = 31 * result + this.length;
        result = 31 * result + this.pts.hashCode();
        result = 31 * result + this.ssa.hashCode();
        return result;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 309890892L;
        private final String formulaDump;
        private final SSAMap ssa;
        private final int length;
        private final PointerTargetSet pts;

        public SerializationProxy(PathFormula pPathFormula) {
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            this.formulaDump = mgr.dumpFormula(pPathFormula.formula).toString();
            this.ssa = pPathFormula.ssa;
            this.length = pPathFormula.length;
            this.pts = pPathFormula.pts;
        }

        private Object readResolve() {
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            BooleanFormula formula = mgr.parse(this.formulaDump);
            return new PathFormula(formula, this.ssa, this.pts, this.length);
        }
    }
}

