/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;

public interface PathFormulaManager {
    public PathFormula makeEmptyPathFormula();

    public PathFormula makeEmptyPathFormulaWithContextFrom(PathFormula var1);

    public PathFormula makeEmptyPathFormulaWithContext(SSAMap var1, PointerTargetSet var2);

    public PathFormula makeOr(PathFormula var1, PathFormula var2) throws InterruptedException;

    public PathFormula makeAnd(PathFormula var1, BooleanFormula var2);

    public PathFormula makeAnd(PathFormula var1, CExpression var2) throws CPATransferException, InterruptedException;

    public PathFormula makeAnd(PathFormula var1, CFAEdge var2) throws CPATransferException, InterruptedException;

    public Pair<PathFormula, ErrorConditions> makeAndWithErrorConditions(PathFormula var1, CFAEdge var2) throws CPATransferException, InterruptedException;

    public PathFormula makeFormulaForPath(List<CFAEdge> var1) throws CPATransferException, InterruptedException;

    public PathFormula makeConjunction(List<PathFormula> var1);

    public Formula makeFormulaForVariable(PathFormula var1, String var2, CType var3);

    public Formula makeFormulaForUninstantiatedVariable(String var1, CType var2, PointerTargetSet var3, boolean var4);

    default public ARGPath getARGPathFromModel(Model model, ARGState root) throws CPATransferException, InterruptedException {
        return this.getARGPathFromModel(model, root, (Predicate<? super ARGState>)Predicates.alwaysTrue(), (Map<Pair<ARGState, CFAEdge>, PathFormula>)ImmutableMap.of());
    }

    public ARGPath getARGPathFromModel(Model var1, ARGState var2, Predicate<? super ARGState> var3, Map<Pair<ARGState, CFAEdge>, PathFormula> var4) throws CPATransferException, InterruptedException;

    public void clearCaches();

    public Formula expressionToFormula(PathFormula var1, CIdExpression var2, CFAEdge var3) throws UnrecognizedCodeException;

    public BooleanFormula buildImplicationTestAsUnsat(PathFormula var1, PathFormula var2) throws InterruptedException;

    public void printStatistics(PrintStream var1);

    public BooleanFormula addBitwiseAxiomsIfNeeded(BooleanFormula var1, BooleanFormula var2);

    public PathFormulaBuilder createNewPathFormulaBuilder();

    public BooleanFormula buildWeakestPrecondition(CFAEdge var1, BooleanFormula var2) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException, InterruptedException;

    public PointerTargetSet mergePts(PointerTargetSet var1, PointerTargetSet var2, SSAMap.SSAMapBuilder var3) throws InterruptedException;
}

