/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.DefaultPathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilderFactory;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMapMerger;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SymbolicLocationPathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoWpConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.Model;

@Options(prefix="cpa.predicate")
public class PathFormulaManagerImpl
implements PathFormulaManager {
    @Option(secure=true, description="Handle aliasing of pointers. This adds disjunctions to the formulas, so be careful when using cartesian abstraction.")
    private boolean handlePointerAliasing = true;
    @Option(secure=true, description="Call 'simplify' on generated formulas.")
    private boolean simplifyGeneratedPathFormulas = false;
    @Option(secure=true, description="Which path-formula builder to use.Depending on this setting additional terms are added to the path formulas,e.g. SYMBOLICLOCATIONS will add track the program counter symbolically with a special variable %pc")
    private PathFormulaBuilderVariants pathFormulaBuilderVariant = PathFormulaBuilderVariants.DEFAULT;
    private static final String NONDET_VARIABLE = "__nondet__";
    static final String NONDET_FLAG_VARIABLE = "__nondet__flag__";
    private static final CType NONDET_TYPE = CNumericTypes.SIGNED_INT;
    private final FormulaType<?> NONDET_FORMULA_TYPE;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final CtoFormulaConverter converter;
    private final @Nullable CtoWpConverter wpConverter;
    private final PathFormulaBuilderFactory pfbFactory;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    @Option(secure=true, description="add special information to formulas about non-deterministic functions")
    private boolean useNondetFlags = false;

    public PathFormulaManagerImpl(FormulaManagerView pFmgr, Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, AnalysisDirection pDirection) throws InvalidConfigurationException {
        this(pFmgr, config, pLogger, pShutdownNotifier, pCfa.getMachineModel(), pCfa.getVarClassification(), pDirection);
    }

    public PathFormulaManagerImpl(FormulaManagerView pFmgr, Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, AnalysisDirection pDirection) throws InvalidConfigurationException {
        config.inject((Object)this, PathFormulaManagerImpl.class);
        this.fmgr = pFmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        if (this.handlePointerAliasing) {
            FormulaEncodingWithPointerAliasingOptions options = new FormulaEncodingWithPointerAliasingOptions(config);
            if (options.useQuantifiersOnArrays()) {
                try {
                    this.fmgr.getQuantifiedFormulaManager();
                }
                catch (UnsupportedOperationException e) {
                    throw new InvalidConfigurationException("Cannot use quantifiers with current solver, either choose a different solver or disable quantifiers.");
                }
            }
            if (options.useArraysForHeap()) {
                try {
                    this.fmgr.getArrayFormulaManager();
                }
                catch (UnsupportedOperationException e) {
                    throw new InvalidConfigurationException("Cannot use arrays with current solver, either choose a different solver or disable arrays.");
                }
            }
            TypeHandlerWithPointerAliasing aliasingTypeHandler = new TypeHandlerWithPointerAliasing(pLogger, pMachineModel, options);
            this.converter = new CToFormulaConverterWithPointerAliasing(options, this.fmgr, pMachineModel, pVariableClassification, this.logger, this.shutdownNotifier, aliasingTypeHandler, pDirection);
            this.wpConverter = null;
        } else {
            FormulaEncodingOptions options = new FormulaEncodingOptions(config);
            CtoFormulaTypeHandler typeHandler = new CtoFormulaTypeHandler(pLogger, pMachineModel);
            this.converter = new CtoFormulaConverter(options, this.fmgr, pMachineModel, pVariableClassification, this.logger, this.shutdownNotifier, typeHandler, pDirection);
            this.wpConverter = new CtoWpConverter(options, this.fmgr, pMachineModel, pVariableClassification, this.logger, this.shutdownNotifier, typeHandler, pDirection);
            this.logger.log(Level.WARNING, new Object[]{"Handling of pointer aliasing is disabled, analysis is unsound if aliased pointers exist."});
        }
        switch (this.pathFormulaBuilderVariant) {
            case DEFAULT: {
                this.pfbFactory = new DefaultPathFormulaBuilder.Factory();
                break;
            }
            case SYMBOLICLOCATIONS: {
                this.pfbFactory = new SymbolicLocationPathFormulaBuilder.Factory(new CBinaryExpressionBuilder(pMachineModel, pLogger));
                break;
            }
            default: {
                throw new InvalidConfigurationException("Invalid type of path formula builder specified!");
            }
        }
        this.NONDET_FORMULA_TYPE = this.converter.getFormulaTypeFromCType(NONDET_TYPE);
    }

    @Override
    public Pair<PathFormula, ErrorConditions> makeAndWithErrorConditions(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        ErrorConditions errorConditions = new ErrorConditions(this.bfmgr);
        PathFormula pf = this.makeAnd(pOldFormula, pEdge, errorConditions);
        return Pair.of(pf, errorConditions);
    }

    private PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge, ErrorConditions errorConditions) throws UnrecognizedCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        int lFlagIndex;
        SSAMap.SSAMapBuilder ssa;
        int lNondetIndex;
        PathFormula pf = this.converter.makeAnd(pOldFormula, pEdge, errorConditions);
        if (this.useNondetFlags && (lNondetIndex = (ssa = pf.getSsa().builder()).getIndex(NONDET_VARIABLE)) != (lFlagIndex = ssa.getIndex(NONDET_FLAG_VARIABLE))) {
            if (lFlagIndex < 0) {
                lFlagIndex = 1;
            }
            BooleanFormula edgeFormula = pf.getFormula();
            for (int lIndex = lFlagIndex + 1; lIndex <= lNondetIndex; ++lIndex) {
                Object nondetVar = this.fmgr.makeVariable(this.NONDET_FORMULA_TYPE, NONDET_FLAG_VARIABLE, lIndex);
                BooleanFormula lAssignment = this.fmgr.assignment(nondetVar, this.fmgr.makeNumber(this.NONDET_FORMULA_TYPE, 1L));
                edgeFormula = this.bfmgr.and(edgeFormula, lAssignment);
            }
            ssa.setIndex(NONDET_FLAG_VARIABLE, NONDET_TYPE, lNondetIndex);
            pf = new PathFormula(edgeFormula, ssa.build(), pf.getPointerTargetSet(), pf.getLength());
        }
        if (this.simplifyGeneratedPathFormulas) {
            pf = pf.withFormula(this.fmgr.simplify(pf.getFormula()));
        }
        return pf;
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, CExpression pAssumption) throws CPATransferException, InterruptedException {
        CAssumeEdge fakeEdge = new CAssumeEdge(pAssumption.toASTString(), FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), pAssumption, true);
        return this.converter.makeAnd(pPathFormula, fakeEdge, ErrorConditions.dummyInstance(this.bfmgr));
    }

    @Override
    public PathFormula makeAnd(PathFormula pOldFormula, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        ErrorConditions errorConditions = ErrorConditions.dummyInstance(this.bfmgr);
        return this.makeAnd(pOldFormula, pEdge, errorConditions);
    }

    @Override
    public PathFormula makeConjunction(List<PathFormula> pPathFormulas) {
        if (pPathFormulas.isEmpty()) {
            return this.makeEmptyPathFormula();
        }
        BooleanFormula conjunction = this.bfmgr.and(Lists.transform(pPathFormulas, PathFormula::getFormula));
        int lengthSum = pPathFormulas.stream().mapToInt(PathFormula::getLength).sum();
        PathFormula last = (PathFormula)Iterables.getLast(pPathFormulas);
        return new PathFormula(conjunction, last.getSsa(), last.getPointerTargetSet(), lengthSum);
    }

    @Override
    public PathFormula makeEmptyPathFormula() {
        return new PathFormula(this.bfmgr.makeTrue(), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), 0);
    }

    @Override
    public PathFormula makeEmptyPathFormulaWithContextFrom(PathFormula oldFormula) {
        return new PathFormula(this.bfmgr.makeTrue(), oldFormula.getSsa(), oldFormula.getPointerTargetSet(), 0);
    }

    @Override
    public PathFormula makeEmptyPathFormulaWithContext(SSAMap pSsaMap, PointerTargetSet pPts) {
        return new PathFormula(this.bfmgr.makeTrue(), pSsaMap, pPts, 0);
    }

    @Override
    public PathFormula makeOr(PathFormula pathFormula1, PathFormula pathFormula2) throws InterruptedException {
        BooleanFormula formula1 = pathFormula1.getFormula();
        BooleanFormula formula2 = pathFormula2.getFormula();
        SSAMap ssa1 = pathFormula1.getSsa();
        SSAMap ssa2 = pathFormula2.getSsa();
        PointerTargetSet pts1 = pathFormula1.getPointerTargetSet();
        PointerTargetSet pts2 = pathFormula2.getPointerTargetSet();
        SSAMapMerger merger = new SSAMapMerger(this.useNondetFlags, this.fmgr, this.converter, this.shutdownNotifier, this.NONDET_FORMULA_TYPE);
        SSAMapMerger.MergeResult<SSAMap> mergeSSAResult = merger.mergeSSAMaps(ssa1, pts1, ssa2, pts2);
        SSAMap.SSAMapBuilder newSSA = mergeSSAResult.getResult().builder();
        SSAMapMerger.MergeResult<PointerTargetSet> mergePtsResult = this.converter.mergePointerTargetSets(pts1, pts2, newSSA);
        BooleanFormula newFormula1 = this.bfmgr.and(formula1, this.bfmgr.and(mergeSSAResult.getLeftConjunct(), mergePtsResult.getLeftConjunct()));
        BooleanFormula newFormula2 = this.bfmgr.and(formula2, this.bfmgr.and(mergeSSAResult.getRightConjunct(), mergePtsResult.getRightConjunct()));
        BooleanFormula newFormula = this.bfmgr.and(this.bfmgr.or(newFormula1, newFormula2), this.bfmgr.and(mergeSSAResult.getFinalConjunct(), mergePtsResult.getFinalConjunct()));
        PointerTargetSet newPTS = mergePtsResult.getResult();
        int newLength = Math.max(pathFormula1.getLength(), pathFormula2.getLength());
        PathFormula out = new PathFormula(newFormula, newSSA.build(), newPTS, newLength);
        if (this.simplifyGeneratedPathFormulas) {
            out = out.withFormula(this.fmgr.simplify(out.getFormula()));
        }
        return out;
    }

    @Override
    public PointerTargetSet mergePts(PointerTargetSet pPts1, PointerTargetSet pPts2, SSAMap.SSAMapBuilder pSSA) throws InterruptedException {
        return this.converter.mergePointerTargetSets(pPts1, pPts2, pSSA).getResult();
    }

    @Override
    public PathFormula makeAnd(PathFormula pPathFormula, BooleanFormula pOtherFormula) {
        SSAMap ssa = pPathFormula.getSsa();
        BooleanFormula otherFormula = this.fmgr.instantiate(pOtherFormula, ssa);
        BooleanFormula resultFormula = this.bfmgr.and(pPathFormula.getFormula(), otherFormula);
        PointerTargetSet pts = pPathFormula.getPointerTargetSet();
        return new PathFormula(resultFormula, ssa, pts, pPathFormula.getLength());
    }

    @Override
    public PathFormula makeFormulaForPath(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        PathFormula pathFormula = this.makeEmptyPathFormula();
        for (CFAEdge edge : pPath) {
            pathFormula = this.makeAnd(pathFormula, edge);
        }
        return pathFormula;
    }

    @Override
    public Formula makeFormulaForVariable(PathFormula pContext, String pVarName, CType pType) {
        return this.converter.makeFormulaForVariable(pContext.getSsa(), pContext.getPointerTargetSet(), pVarName, pType);
    }

    @Override
    public Formula makeFormulaForUninstantiatedVariable(String pVarName, CType pType, PointerTargetSet pContextPTS, boolean forcePointerDereference) {
        return this.converter.makeFormulaForUninstantiatedVariable(pVarName, pType, pContextPTS, forcePointerDereference);
    }

    @Override
    public ARGPath getARGPathFromModel(Model model, ARGState root, Predicate<? super ARGState> stateFilter, Map<Pair<ARGState, CFAEdge>, PathFormula> branchingFormulasOverride) throws CPATransferException, InterruptedException {
        final class WrappingException
        extends RuntimeException {
            private static final long serialVersionUID = 7106377117314217226L;

            WrappingException(Throwable cause) {
                super(cause);
            }
        }
        try {
            return ARGUtils.getPathFromBranchingInformation(root, stateFilter, (pathElement, positiveEdge) -> {
                Pair<ARGState, AssumeEdge> key = Pair.of(pathElement, positiveEdge);
                PathFormula pf = (PathFormula)branchingFormulasOverride.get(key);
                if (pf == null) {
                    PredicateAbstractState pe = AbstractStates.extractStateByType(pathElement, PredicateAbstractState.class);
                    Verify.verifyNotNull((Object)pe, (String)"Cannot find precise error path information without PredicateCPA.", (Object[])new Object[0]);
                    try {
                        pf = this.makeAnd(this.makeEmptyPathFormulaWithContextFrom(pe.getPathFormula()), (CFAEdge)positiveEdge);
                    }
                    catch (InterruptedException | CPATransferException e) {
                        throw new WrappingException((Throwable)e);
                    }
                }
                return model.evaluate(pf.getFormula());
            });
        }
        catch (WrappingException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), CPATransferException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), InterruptedException.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public Formula expressionToFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCodeException {
        return this.converter.buildTermFromPathFormula(pFormula, expr, edge);
    }

    @Override
    public BooleanFormula buildImplicationTestAsUnsat(PathFormula pF1, PathFormula pF2) throws InterruptedException {
        SSAMapMerger merger = new SSAMapMerger(this.useNondetFlags, this.fmgr, this.converter, this.shutdownNotifier, this.NONDET_FORMULA_TYPE);
        BooleanFormula bF = pF2.getFormula();
        return this.bfmgr.and(merger.addMergeAssumptions(pF1.getFormula(), pF1.getSsa(), pF1.getPointerTargetSet(), pF2.getSsa()), this.bfmgr.not(bF));
    }

    @Override
    public BooleanFormula addBitwiseAxiomsIfNeeded(BooleanFormula pMainFormula, BooleanFormula pExtractionFormula) {
        if (this.fmgr.useBitwiseAxioms()) {
            BooleanFormula bitwiseAxioms = this.fmgr.getBitwiseAxioms(pExtractionFormula);
            if (!this.fmgr.getBooleanFormulaManager().isTrue(bitwiseAxioms)) {
                this.logger.log(Level.ALL, new Object[]{"DEBUG_3", "ADDED BITWISE AXIOMS:", bitwiseAxioms});
                return this.fmgr.getBooleanFormulaManager().and(pMainFormula, bitwiseAxioms);
            }
        }
        return pMainFormula;
    }

    @Override
    public PathFormulaBuilder createNewPathFormulaBuilder() {
        return this.pfbFactory.create();
    }

    @Override
    public void printStatistics(PrintStream out) {
        this.converter.printStatistics(out);
    }

    @Override
    public BooleanFormula buildWeakestPrecondition(CFAEdge pEdge, BooleanFormula pPostcond) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException, InterruptedException {
        if (this.wpConverter != null) {
            return this.wpConverter.makePreconditionForEdge(pEdge, pPostcond);
        }
        throw new UnsupportedOperationException();
    }

    private static enum PathFormulaBuilderVariants {
        DEFAULT,
        SYMBOLICLOCATIONS;

    }
}

