/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SolverException;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public class PathFormulaManagerImplTest
extends SolverViewBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private PathFormulaManager pfmgrFwd;
    private PathFormulaManager pfmgrBwd;
    private CDeclarationEdge x_decl;
    private static final CType variableType = CNumericTypes.INT;
    private static final FormulaType<?> formulaType = FormulaType.getBitvectorTypeWithSize((int)32);

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void setup() throws Exception {
        Configuration configBackwards = Configuration.builder().copyFrom(this.config).setOption("cpa.predicate.handlePointerAliasing", "false").build();
        this.pfmgrFwd = new PathFormulaManagerImpl(this.mgrv, this.config, this.logger, ShutdownNotifier.createDummy(), MachineModel.LINUX32, Optional.empty(), AnalysisDirection.FORWARD);
        this.pfmgrBwd = new PathFormulaManagerImpl(this.mgrv, configBackwards, this.logger, ShutdownNotifier.createDummy(), MachineModel.LINUX32, Optional.empty(), AnalysisDirection.BACKWARD);
    }

    private Triple<CFAEdge, CFAEdge, MutableCFA> createCFA() throws UnrecognizedCodeException {
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(MachineModel.LINUX32, LogManager.createTestLogManager());
        String fName = "main";
        TreeMap<String, FunctionEntryNode> functions = new TreeMap<String, FunctionEntryNode>();
        CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.BOOL);
        CFunctionDeclaration fdef = new CFunctionDeclaration(FileLocation.DUMMY, functionType, fName, (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        CFunctionEntryNode entryNode = new CFunctionEntryNode(FileLocation.DUMMY, fdef, new FunctionExitNode(fdef), Optional.empty());
        CFANode a = new CFANode(fdef);
        CFANode b = new CFANode(fdef);
        BlankEdge init = new BlankEdge("", FileLocation.DUMMY, entryNode, a, "init");
        entryNode.addLeavingEdge(init);
        a.addEnteringEdge(init);
        CVariableDeclaration xDeclaration = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, CNumericTypes.INT, "x", "x", "x", new CInitializerExpression(FileLocation.DUMMY, CIntegerLiteralExpression.ZERO));
        this.x_decl = new CDeclarationEdge("int x = 0", FileLocation.DUMMY, a, b, xDeclaration);
        CBinaryExpression rhs = expressionBuilder.buildBinaryExpression(new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.PLUS);
        CStatementEdge a_to_b = new CStatementEdge("x := x + 1", new CExpressionAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), rhs), FileLocation.DUMMY, a, b);
        CBinaryExpression guard = expressionBuilder.buildBinaryExpression(new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "x", xDeclaration), this.intConstant(BigInteger.TEN), CBinaryExpression.BinaryOperator.LESS_THAN);
        CStatementEdge b_to_a = new CStatementEdge("x <= 10", new CExpressionStatement(FileLocation.DUMMY, guard), FileLocation.DUMMY, b, a);
        TreeMultimap nodes = TreeMultimap.create();
        nodes.put((Object)"main", (Object)a);
        nodes.put((Object)"main", (Object)b);
        functions.put("main", entryNode);
        MutableCFA cfa = new MutableCFA(MachineModel.LINUX32, functions, (TreeMultimap<String, CFANode>)nodes, entryNode, (List<Path>)ImmutableList.of(), Language.C);
        return Triple.of(a_to_b, b_to_a, cfa);
    }

    private CExpression intConstant(BigInteger constant) {
        return new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, constant);
    }

    @Test
    public void testCustomSSAIdx() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = data.getFirst();
        int customIdx = 1337;
        SSAMap ssaMap = SSAMap.emptySSAMap().withDefault(customIdx);
        PathFormula emptyWithCustomSSA = this.pfmgrFwd.makeEmptyPathFormulaWithContext(ssaMap, PointerTargetSet.emptyPointerTargetSet());
        PathFormula p = this.pfmgrFwd.makeAnd(emptyWithCustomSSA, a_to_b);
        Truth.assertThat((Integer)p.getSsa().getIndex("x")).isEqualTo((Object)(customIdx + 1));
    }

    @Test
    public void testAssignmentSSABackward() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = data.getFirst();
        PathFormula pf = this.makePathFormulaWithCustomIndex(this.pfmgrBwd, "x", CNumericTypes.INT, 10);
        pf = this.pfmgrBwd.makeAnd(pf, a_to_b);
        BooleanFormula expected = this.mgrv.makeEqual(this.mgrv.makeVariable(formulaType, "x", 10), this.mgrv.makePlus(this.mgrv.makeVariable(formulaType, "x", 11), this.mgrv.makeNumber(formulaType, 1L)));
        this.assertThatFormula(pf.getFormula()).isEquivalentTo(expected);
    }

    @Test
    public void testDeclarationSSABackward() throws Exception {
        this.createCFA();
        PathFormula pf = this.makePathFormulaWithCustomIndex(this.pfmgrBwd, "x", CNumericTypes.INT, 10);
        pf = this.pfmgrBwd.makeAnd(pf, this.x_decl);
        Truth.assertThat((Integer)pf.getSsa().getIndex("x")).isEqualTo((Object)11);
    }

    @Test
    public void testDeclarationSSAForward() throws Exception {
        this.createCFA();
        PathFormula pf = this.makePathFormulaWithCustomIndex(this.pfmgrFwd, "x", CNumericTypes.INT, 10);
        pf = this.pfmgrFwd.makeAnd(pf, this.x_decl);
        Truth.assertThat((Integer)pf.getSsa().getIndex("x")).isEqualTo((Object)11);
    }

    @Test
    public void testAssignmentSSAForward() throws Exception {
        Triple<CFAEdge, CFAEdge, MutableCFA> data = this.createCFA();
        CFAEdge a_to_b = data.getFirst();
        PathFormula pf = this.makePathFormulaWithCustomIndex(this.pfmgrFwd, "x", CNumericTypes.INT, 10);
        pf = this.pfmgrFwd.makeAnd(pf, a_to_b);
        BooleanFormula expected = this.mgrv.makeEqual(this.mgrv.makeVariable(formulaType, "x", 11), this.mgrv.makePlus(this.mgrv.makeVariable(formulaType, "x", 10), this.mgrv.makeNumber(formulaType, 1L)));
        this.assertThatFormula(pf.getFormula()).isEquivalentTo(expected);
    }

    private PathFormula makePathFormulaWithCustomIndex(PathFormulaManager pPfmgr, String pVar, CType pType, int pIndex) {
        SSAMap ssaMap = SSAMap.emptySSAMap().builder().setIndex(pVar, pType, pIndex).build();
        return pPfmgr.makeEmptyPathFormulaWithContext(ssaMap, PointerTargetSet.emptyPointerTargetSet());
    }

    @Test
    public void testEmpty() throws SolverException, InterruptedException {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula expected = new PathFormula(this.mgrv.getBooleanFormulaManager().makeTrue(), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), 0);
        this.assertEquals(expected, empty);
    }

    private PathFormula makePathFormulaWithVariable(String var, int index) {
        BooleanFormula f = this.mgrv.makeEqual(this.mgrv.makeVariable(formulaType, var, index), this.mgrv.makeNumber(formulaType, 0L));
        SSAMap s = SSAMap.emptySSAMap().builder().setIndex(var, variableType, index).build();
        return new PathFormula(f, s, PointerTargetSet.emptyPointerTargetSet(), 1);
    }

    private BooleanFormula makeVariableEquality(String var, int index1, int index2) {
        return this.mgrv.makeEqual(this.mgrv.makeVariable(formulaType, var, index2), this.mgrv.makeVariable(formulaType, var, index1));
    }

    @Test
    public void testMakeOrBothEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula result = this.pfmgrFwd.makeOr(empty, empty);
        this.assertEquals(empty, result);
    }

    @Test
    public void testMakeOrLeftEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula pf = this.makePathFormulaWithVariable("a", 2);
        PathFormula result = this.pfmgrFwd.makeOr(empty, pf);
        PathFormula expected = new PathFormula(this.mgrv.makeOr(this.makeVariableEquality("a", 1, 2), pf.getFormula()), pf.getSsa(), pf.getPointerTargetSet(), 1);
        this.assertEquals(expected, result);
    }

    @Test
    public void testMakeOrRightEmpty() throws Exception {
        PathFormula empty = this.pfmgrFwd.makeEmptyPathFormula();
        PathFormula pf = this.makePathFormulaWithVariable("a", 2);
        PathFormula result = this.pfmgrFwd.makeOr(pf, empty);
        PathFormula expected = new PathFormula(this.mgrv.makeOr(pf.getFormula(), this.makeVariableEquality("a", 1, 2)), pf.getSsa(), pf.getPointerTargetSet(), 1);
        this.assertEquals(expected, result);
    }

    @Test
    public void testMakeOr() throws Exception {
        PathFormula pf1 = this.makePathFormulaWithVariable("a", 2);
        PathFormula pf2 = this.makePathFormulaWithVariable("a", 3);
        PathFormula result = this.pfmgrFwd.makeOr(pf1, pf2);
        BooleanFormula left = this.mgrv.makeAnd(pf1.getFormula(), this.makeVariableEquality("a", 2, 3));
        BooleanFormula right = pf2.getFormula();
        PathFormula expected = new PathFormula(this.mgrv.makeOr(left, right), pf2.getSsa(), PointerTargetSet.emptyPointerTargetSet(), 1);
        this.assertEquals(expected, result);
    }

    @Test
    public void testMakeOrCommutative() throws Exception {
        PathFormula pf1 = this.makePathFormulaWithVariable("a", 2);
        PathFormula pf2 = this.makePathFormulaWithVariable("b", 3);
        PathFormula resultA = this.pfmgrFwd.makeOr(pf1, pf2);
        PathFormula resultB = this.pfmgrFwd.makeOr(pf2, pf1);
        this.assertThatFormula(resultA.getFormula()).isEquivalentTo(resultB.getFormula());
    }

    private void assertEquals(PathFormula expected, PathFormula result) throws SolverException, InterruptedException {
        this.assertThatFormula(result.getFormula()).isEquivalentTo(expected.getFormula());
        Truth.assertThat((Integer)result.getLength()).isEqualTo((Object)expected.getLength());
        Truth.assertThat((Object)result.getSsa()).isEqualTo((Object)result.getSsa());
        Truth.assertThat((Object)result.getPointerTargetSet()).isEqualTo((Object)expected.getPointerTargetSet());
    }
}

