/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Map;
import java.util.NavigableSet;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.collect.MapsDifference;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.util.predicates.pathformula.FreshValueProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

@Immutable
public final class SSAMap
implements Serializable {
    private static final long serialVersionUID = 7618801653203679876L;
    private static final int DEFAULT_DEFAULT_IDX = -1;
    private final int defaultValue;
    private static final PersistentSortedMaps.MergeConflictHandler<String, CType> TYPE_CONFLICT_CHECKER = new PersistentSortedMaps.MergeConflictHandler<String, CType>(){

        public CType resolveConflict(String name, CType type1, CType type2) {
            Preconditions.checkArgument((type1 instanceof CFunctionType && type2 instanceof CFunctionType || this.isEnumPointerType(type1) && this.isEnumPointerType(type2) || type1.equals(type2) ? 1 : 0) != 0, (String)"Cannot change type of variable %s in SSAMap from %s to %s", (Object)name, (Object)type1, (Object)type2);
            return type1;
        }

        private boolean isEnumPointerType(CType type) {
            if (type instanceof CPointerType) {
                return (type = ((CPointerType)type).getType()) instanceof CComplexType && ((CComplexType)type).getKind() == CComplexType.ComplexTypeKind.ENUM || type instanceof CElaboratedType && ((CElaboratedType)type).getKind() == CComplexType.ComplexTypeKind.ENUM;
            }
            return false;
        }
    };
    private static final SSAMap EMPTY_SSA_MAP = new SSAMap((PersistentSortedMap<String, Integer>)PathCopyingPersistentTreeMap.of(), new FreshValueProvider(), 0, (PersistentSortedMap<String, CType>)PathCopyingPersistentTreeMap.of());
    private final PersistentSortedMap<String, Integer> vars;
    private final FreshValueProvider freshValueProvider;
    private final PersistentSortedMap<String, CType> varTypes;
    private final int varsHashCode;
    private static final Joiner joiner = Joiner.on((String)" ");

    public static SSAMap emptySSAMap() {
        return EMPTY_SSA_MAP;
    }

    public SSAMap withDefault(int pDefaultValue) {
        return new SSAMap(this.vars, this.freshValueProvider, this.varsHashCode, this.varTypes, pDefaultValue);
    }

    public static SSAMap merge(SSAMap s1, SSAMap s2, MapsDifference.Visitor<String, Integer> collectDifferences) {
        Preconditions.checkArgument((s1.defaultValue == s2.defaultValue ? 1 : 0) != 0);
        if (s1.vars == s2.vars && s1.freshValueProvider == s2.freshValueProvider) {
            return s1;
        }
        PersistentSortedMap vars = PersistentSortedMaps.merge(s1.vars, s2.vars, (Equivalence)Equivalence.equals(), (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getMaximumMergeConflictHandler(), collectDifferences);
        FreshValueProvider freshValueProvider = s1.freshValueProvider.merge(s2.freshValueProvider);
        int defaultIndex = s1.defaultValue;
        PersistentSortedMap varTypes = PersistentSortedMaps.merge(s1.varTypes, s2.varTypes, CTypes.canonicalTypeEquivalence(), TYPE_CONFLICT_CHECKER, (MapsDifference.Visitor)MapsDifference.ignoreMapsDifference());
        return new SSAMap((PersistentSortedMap<String, Integer>)vars, freshValueProvider, 0, (PersistentSortedMap<String, CType>)varTypes, defaultIndex);
    }

    private SSAMap(PersistentSortedMap<String, Integer> vars, FreshValueProvider freshValueProvider, int varsHashCode, PersistentSortedMap<String, CType> varTypes, int defaultSSAIdx) {
        this.vars = vars;
        this.freshValueProvider = freshValueProvider;
        this.varTypes = varTypes;
        if (varsHashCode == 0) {
            this.varsHashCode = vars.hashCode();
        } else {
            this.varsHashCode = varsHashCode;
            assert (varsHashCode == vars.hashCode());
        }
        this.defaultValue = defaultSSAIdx;
    }

    private SSAMap(PersistentSortedMap<String, Integer> vars, FreshValueProvider freshValueProvider, int varsHashCode, PersistentSortedMap<String, CType> varTypes) {
        this(vars, freshValueProvider, varsHashCode, varTypes, -1);
    }

    public SSAMapBuilder builder() {
        return new SSAMapBuilder(this);
    }

    private static int getIndex(String variable, Map<String, Integer> vars, int defaultValue) {
        Integer value = vars.get(variable);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getIndex(String variable) {
        return SSAMap.getIndex(variable, this.vars, this.defaultValue);
    }

    public boolean containsVariable(String variable) {
        return this.vars.containsKey((Object)variable);
    }

    public CType getType(String name) {
        return (CType)this.varTypes.get((Object)name);
    }

    public NavigableSet<String> allVariables() {
        return this.vars.keySet();
    }

    public String toString() {
        return joiner.join((Iterable)this.vars.entrySet());
    }

    public int hashCode() {
        return this.varsHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSAMap)) {
            return false;
        }
        SSAMap other = (SSAMap)obj;
        return this.varsHashCode == other.varsHashCode && this.vars.equals(other.vars) && this.freshValueProvider.equals(other.freshValueProvider);
    }

    public static class SSAMapBuilder {
        private SSAMap ssa;
        private PersistentSortedMap<String, Integer> vars;
        private FreshValueProvider freshValueProvider;
        private PersistentSortedMap<String, CType> varTypes;
        private int varsHashCode;

        private SSAMapBuilder(SSAMap ssa) {
            this.ssa = ssa;
            this.vars = ssa.vars;
            this.freshValueProvider = ssa.freshValueProvider;
            this.varTypes = ssa.varTypes;
            this.varsHashCode = ssa.varsHashCode;
        }

        public int getIndex(String variable) {
            return SSAMap.getIndex(variable, this.vars, this.ssa.defaultValue);
        }

        public int getFreshIndex(String variable) {
            return this.freshValueProvider.getFreshValue(variable, SSAMap.getIndex(variable, this.vars, this.ssa.defaultValue));
        }

        public CType getType(String name) {
            return (CType)this.varTypes.get((Object)name);
        }

        @CanIgnoreReturnValue
        public SSAMapBuilder setIndex(String name, CType type, int idx) {
            CType oldType;
            Preconditions.checkArgument((idx > 0 ? 1 : 0) != 0, (String)"Non-positive index %s for variable %s with type %s", (Object)idx, (Object)name, (Object)type);
            int oldIdx = this.getIndex(name);
            Preconditions.checkArgument((idx >= oldIdx ? 1 : 0) != 0, (String)"Non-monotonic SSAMap update for variable %s with type %s from %s to %s", (Object)name, (Object)type, (Object)oldIdx, (Object)idx);
            type = type.getCanonicalType();
            assert (!(type instanceof CFunctionType)) : "Variable " + name + " has function type " + type;
            if (TypeHandlerWithPointerAliasing.isByteArrayAccessName(name)) {
                type = CNumericTypes.CHAR;
            }
            if ((oldType = (CType)this.varTypes.get((Object)name)) != null) {
                TYPE_CONFLICT_CHECKER.resolveConflict((Object)name, (Object)oldType, (Object)type);
            } else {
                this.varTypes = this.varTypes.putAndCopy((Object)name, (Object)type);
            }
            if (idx > oldIdx || idx == this.ssa.defaultValue) {
                this.vars = this.vars.putAndCopy((Object)name, (Object)idx);
                if (oldIdx != this.ssa.defaultValue) {
                    this.varsHashCode -= SSAMapBuilder.mapEntryHashCode(name, oldIdx);
                }
                this.varsHashCode += SSAMapBuilder.mapEntryHashCode(name, idx);
            }
            return this;
        }

        public void mergeFreshValueProviderWith(FreshValueProvider fvp) {
            this.freshValueProvider = this.freshValueProvider.merge(fvp);
        }

        @CanIgnoreReturnValue
        public SSAMapBuilder deleteVariable(String variable) {
            int index = this.getIndex(variable);
            if (index != this.ssa.defaultValue) {
                this.vars = this.vars.removeAndCopy((Object)variable);
                this.varsHashCode -= SSAMapBuilder.mapEntryHashCode(variable, index);
                this.varTypes = this.varTypes.removeAndCopy((Object)variable);
            }
            return this;
        }

        public NavigableSet<String> allVariables() {
            return this.varTypes.keySet();
        }

        public SSAMap build() {
            if (this.vars == this.ssa.vars && this.freshValueProvider == this.ssa.freshValueProvider) {
                return this.ssa;
            }
            this.ssa = new SSAMap(this.vars, this.freshValueProvider, this.varsHashCode, this.varTypes, this.ssa.defaultValue);
            return this.ssa;
        }

        private static int mapEntryHashCode(Object key, int value) {
            return key.hashCode() ^ value;
        }
    }
}

