/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.MapsDifference;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;

public class SSAMapMerger {
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManager bfmgr;
    private final ShutdownNotifier shutdownNotifier;
    private final CtoFormulaConverter converter;
    private final boolean useNondetFlags;
    private final FormulaType<?> nondetFormulaType;

    SSAMapMerger(boolean pUseNondetFlags, FormulaManagerView pFmgr, CtoFormulaConverter pConverter, ShutdownNotifier pShutdownNotifier, FormulaType<?> pNondetFormulaType) {
        this.useNondetFlags = pUseNondetFlags;
        this.fmgr = pFmgr;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.converter = pConverter;
        this.shutdownNotifier = pShutdownNotifier;
        this.nondetFormulaType = pNondetFormulaType;
    }

    MergeResult<SSAMap> mergeSSAMaps(SSAMap ssa1, PointerTargetSet pts1, SSAMap ssa2, PointerTargetSet pts2) throws InterruptedException {
        ArrayList symbolDifferences = new ArrayList();
        SSAMap resultSSA = SSAMap.merge(ssa1, ssa2, (MapsDifference.Visitor<String, Integer>)MapsDifference.collectMapsDifferenceTo(symbolDifferences));
        BooleanFormula mergeFormula1 = this.bfmgr.makeTrue();
        BooleanFormula mergeFormula2 = this.bfmgr.makeTrue();
        for (MapsDifference.Entry symbolDifference : symbolDifferences) {
            BooleanFormula mergeFormula;
            this.shutdownNotifier.shutdownIfNecessary();
            String symbolName = (String)symbolDifference.getKey();
            CType symbolType = resultSSA.getType(symbolName);
            int index1 = symbolDifference.getLeftValue().orElse(1);
            int index2 = symbolDifference.getRightValue().orElse(1);
            assert (symbolName != null);
            if (index1 > index2 && index1 > 1) {
                mergeFormula = this.makeSsaMerger(symbolName, symbolType, index2, index1, pts2);
                mergeFormula2 = this.bfmgr.and(mergeFormula2, mergeFormula);
                continue;
            }
            if (index2 <= 1) continue;
            assert (index1 < index2);
            mergeFormula = this.makeSsaMerger(symbolName, symbolType, index1, index2, pts1);
            mergeFormula1 = this.bfmgr.and(mergeFormula1, mergeFormula);
        }
        return new MergeResult<SSAMap>(resultSSA, mergeFormula1, mergeFormula2, this.bfmgr.makeTrue());
    }

    private BooleanFormula makeSsaMerger(String symbolName, CType symbolType, int oldIndex, int newIndex, PointerTargetSet oldPts) throws InterruptedException {
        assert (oldIndex > 0);
        assert (newIndex > oldIndex);
        if (this.useNondetFlags && symbolName.equals("__nondet__flag__")) {
            return this.makeSsaNondetFlagMerger(oldIndex, newIndex);
        }
        return this.converter.makeSsaUpdateTerm(symbolName, symbolType, oldIndex, newIndex, oldPts);
    }

    private BooleanFormula makeSsaNondetFlagMerger(int iSmaller, int iBigger) {
        Object pInitialValue = this.fmgr.makeNumber(this.nondetFormulaType, 0L);
        assert (iSmaller < iBigger);
        ArrayList<BooleanFormula> lResult = new ArrayList<BooleanFormula>();
        FormulaType<?> type = this.fmgr.getFormulaType(pInitialValue);
        for (int i = iSmaller + 1; i <= iBigger; ++i) {
            Object currentVar = this.fmgr.makeVariable(type, "__nondet__flag__", i);
            lResult.add(this.fmgr.assignment(currentVar, pInitialValue));
        }
        return this.bfmgr.and(lResult);
    }

    BooleanFormula addMergeAssumptions(BooleanFormula pFormula, SSAMap ssa1, PointerTargetSet pts1, SSAMap ssa2) throws InterruptedException {
        ArrayList symbolDifferences = new ArrayList();
        SSAMap resultSSA = SSAMap.merge(ssa1, ssa2, (MapsDifference.Visitor<String, Integer>)MapsDifference.collectMapsDifferenceTo(symbolDifferences));
        ArrayList<BooleanFormula> mergeFormula = new ArrayList<BooleanFormula>();
        mergeFormula.add(pFormula);
        for (MapsDifference.Entry symbolDifference : symbolDifferences) {
            this.shutdownNotifier.shutdownIfNecessary();
            String symbolName = (String)symbolDifference.getKey();
            CType symbolType = resultSSA.getType(symbolName);
            int index1 = symbolDifference.getLeftValue().orElse(1);
            int index2 = symbolDifference.getRightValue().orElse(1);
            assert (symbolName != null);
            if (index1 > index2 && index1 > 1) {
                return this.bfmgr.makeTrue();
            }
            if (index2 <= 1) continue;
            assert (index1 < index2);
            for (int i = index1; i < index2; ++i) {
                mergeFormula.add(this.makeSsaMerger(symbolName, symbolType, i, i + 1, pts1));
            }
        }
        return this.bfmgr.and(mergeFormula);
    }

    public static class MergeResult<T> {
        private final BooleanFormula leftConjunct;
        private final BooleanFormula rightConjunct;
        private final BooleanFormula finalConjunct;
        private final T result;

        public MergeResult(T pResult, BooleanFormula pLeftConjunct, BooleanFormula pRightConjunct, BooleanFormula pFinalConjunct) {
            this.result = Preconditions.checkNotNull(pResult);
            this.leftConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pLeftConjunct);
            this.rightConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pRightConjunct);
            this.finalConjunct = (BooleanFormula)Preconditions.checkNotNull((Object)pFinalConjunct);
        }

        public static <T> MergeResult<T> trivial(T result, BooleanFormulaManagerView bfmgr) {
            BooleanFormula trueFormula = bfmgr.makeTrue();
            return new MergeResult<T>(result, trueFormula, trueFormula, trueFormula);
        }

        BooleanFormula getLeftConjunct() {
            return this.leftConjunct;
        }

        BooleanFormula getRightConjunct() {
            return this.rightConjunct;
        }

        BooleanFormula getFinalConjunct() {
            return this.finalConjunct;
        }

        T getResult() {
            return this.result;
        }
    }
}

