/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import com.google.common.testing.ClassSanityTester;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.FreshValueProvider;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
public class SSAMapTest {
    private SSAMap.SSAMapBuilder builder;

    @SuppressForbidden(value="reflection only in test")
    private ClassSanityTester classSanityTester() throws Exception {
        Constructor<?> ptsConstructor = PointerTargetSet.class.getDeclaredConstructors()[0];
        ptsConstructor.setAccessible(true);
        PointerTargetSet dummyPTS = (PointerTargetSet)ptsConstructor.newInstance(PathCopyingPersistentTreeMap.of().putAndCopy((Object)"foo", (Object)CVoidType.VOID), PathCopyingPersistentTreeMap.of(), PersistentLinkedList.of(), PathCopyingPersistentTreeMap.of(), PersistentLinkedList.of(), 0);
        return new ClassSanityTester().setDistinctValues(SSAMap.class, (Object)SSAMap.emptySSAMap(), (Object)SSAMap.emptySSAMap().builder().setIndex("a", CVoidType.VOID, 1).build()).setDistinctValues(PointerTargetSet.class, (Object)PointerTargetSet.emptyPointerTargetSet(), (Object)dummyPTS);
    }

    @Before
    public void createBuilder() {
        this.builder = SSAMap.emptySSAMap().builder();
    }

    @Test
    public void testEquals() throws Exception {
        this.classSanityTester().testEquals(PathFormula.class);
    }

    @Test
    public void testNulls() throws Exception {
        this.classSanityTester().testNulls(PathFormula.class);
    }

    @Test
    public void testSSA() {
        this.builder.setIndex("a", CNumericTypes.INT, 1).setIndex("b", CNumericTypes.INT, 2).setIndex("c", CNumericTypes.INT, 3);
        Truth.assertThat((Integer)this.builder.getIndex("a")).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.builder.getIndex("b")).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.builder.getIndex("c")).isEqualTo((Object)3);
        Truth.assertThat((Integer)this.builder.getFreshIndex("a")).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).isEqualTo((Object)3);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).isEqualTo((Object)4);
        this.builder = this.builder.setIndex("b", CNumericTypes.INT, 5);
        Truth.assertThat((Integer)this.builder.getIndex("b")).isEqualTo((Object)5);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).isEqualTo((Object)6);
    }

    private static FreshValueProvider createFreshNewValueProviderWith(String name, int index) {
        PersistentSortedMap mapping = PathCopyingPersistentTreeMap.of().putAndCopy((Object)name, (Object)index);
        return new FreshValueProvider((PersistentSortedMap<String, Integer>)mapping);
    }

    @Test
    public void testSSAbam() {
        this.builder.setIndex("a", CNumericTypes.INT, 1).setIndex("b", CNumericTypes.INT, 2).setIndex("c", CNumericTypes.INT, 3);
        Truth.assertThat((Integer)this.builder.getIndex("a")).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.builder.getIndex("b")).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.builder.getIndex("c")).isEqualTo((Object)3);
        Truth.assertThat((Integer)this.builder.getFreshIndex("a")).isEqualTo((Object)2);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).isEqualTo((Object)3);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).isEqualTo((Object)4);
        this.builder = this.builder.setIndex("b", CNumericTypes.INT, 5);
        Truth.assertThat((Integer)this.builder.getIndex("b")).isEqualTo((Object)5);
        Truth.assertThat((Integer)this.builder.getFreshIndex("b")).isEqualTo((Object)6);
        FreshValueProvider bamfvp = SSAMapTest.createFreshNewValueProviderWith("c", 7);
        this.builder.mergeFreshValueProviderWith(bamfvp);
        Truth.assertThat((Integer)this.builder.getIndex("c")).isEqualTo((Object)3);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).isEqualTo((Object)8);
        FreshValueProvider bamfvp2 = SSAMapTest.createFreshNewValueProviderWith("c", 9);
        this.builder.mergeFreshValueProviderWith(bamfvp2);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).isEqualTo((Object)10);
        this.builder = this.builder.setIndex("c", CNumericTypes.INT, 15);
        Truth.assertThat((Integer)this.builder.getIndex("c")).isEqualTo((Object)15);
        Truth.assertThat((Integer)this.builder.getFreshIndex("c")).isEqualTo((Object)16);
    }

    @Test
    public void testSSAExceptionMonotone() {
        this.builder.setIndex("a", CNumericTypes.INT, 2);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.builder.setIndex("a", CNumericTypes.INT, 1));
    }

    @Test
    public void testSSAExceptionNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.builder.setIndex("a", CNumericTypes.INT, -5));
    }

    @Test
    public void testSSAExceptionMonotone2() {
        this.builder.setIndex("a", CNumericTypes.INT, 2);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.builder.setIndex("a", CNumericTypes.INT, 1));
    }
}

