/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula;

import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.DefaultPathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaBuilderFactory;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;

public class SymbolicLocationPathFormulaBuilder
extends DefaultPathFormulaBuilder {
    private final CBinaryExpressionBuilder cBinaryExpressionBuilder;

    @Override
    public PathFormulaBuilder makeAnd(CFAEdge pEdge) {
        return new SymbolicLocationPathFormulaAndBuilder(this, pEdge, this.cBinaryExpressionBuilder);
    }

    @Override
    public PathFormulaBuilder makeOr(PathFormulaBuilder other) {
        return new SymbolicLocationPathFormulaOrBuilder(this, other, this.cBinaryExpressionBuilder);
    }

    public SymbolicLocationPathFormulaBuilder(CBinaryExpressionBuilder pCBinaryExpressionBuilder) {
        this.cBinaryExpressionBuilder = pCBinaryExpressionBuilder;
    }

    private CLeftHandSide getPcAsLeftHandSide() {
        CVariableDeclaration pc = new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.EXTERN, CNumericTypes.UNSIGNED_INT, "%pc", "%pc", "%pc", null);
        return new CIdExpression(FileLocation.DUMMY, pc);
    }

    public CFAEdge makeProgramCounterAssumption(CFAEdge cfaEdge) throws UnrecognizedCodeException {
        CFANode predecessorNode = cfaEdge.getPredecessor();
        CFANode successorNode = cfaEdge.getSuccessor();
        CIntegerLiteralExpression rightHandSide = CIntegerLiteralExpression.createDummyLiteral(predecessorNode.getNodeNumber(), CNumericTypes.SIGNED_INT);
        CBinaryExpression assertion = this.cBinaryExpressionBuilder.buildBinaryExpression(this.getPcAsLeftHandSide(), rightHandSide, CBinaryExpression.BinaryOperator.EQUALS);
        CAssumeEdge oldPcValueAsumeEdge = new CAssumeEdge(assertion.toASTString(), FileLocation.DUMMY, predecessorNode, successorNode, assertion, true);
        return oldPcValueAsumeEdge;
    }

    public CFAEdge makeProgramCounterAssignment(CFAEdge cfaEdge) {
        CFANode predecessorNode = cfaEdge.getPredecessor();
        CFANode successorNode = cfaEdge.getSuccessor();
        CIntegerLiteralExpression rightHandSide = CIntegerLiteralExpression.createDummyLiteral(cfaEdge.getSuccessor().getNodeNumber(), CNumericTypes.SIGNED_INT);
        CExpressionAssignmentStatement pcTransfer = new CExpressionAssignmentStatement(FileLocation.DUMMY, this.getPcAsLeftHandSide(), rightHandSide);
        CStatementEdge assignNewPcValueStatementEdge = new CStatementEdge(pcTransfer.toASTString(), pcTransfer, FileLocation.DUMMY, predecessorNode, successorNode);
        return assignNewPcValueStatementEdge;
    }

    public static class Factory
    implements PathFormulaBuilderFactory {
        private final CBinaryExpressionBuilder cBinaryExpressionBuilder;

        public Factory(CBinaryExpressionBuilder pCBinaryExpressionBuilder) {
            this.cBinaryExpressionBuilder = pCBinaryExpressionBuilder;
        }

        @Override
        public DefaultPathFormulaBuilder create() {
            return new SymbolicLocationPathFormulaBuilder(this.cBinaryExpressionBuilder);
        }
    }

    private static class SymbolicLocationPathFormulaOrBuilder
    extends SymbolicLocationPathFormulaBuilder {
        private final PathFormulaBuilder first;
        private final PathFormulaBuilder second;

        protected SymbolicLocationPathFormulaOrBuilder(PathFormulaBuilder first, PathFormulaBuilder second, CBinaryExpressionBuilder cBinaryExpressionBuilder) {
            super(cBinaryExpressionBuilder);
            this.first = first;
            this.second = second;
        }

        @Override
        protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
            PathFormula result = pPfmgr.makeOr(this.first.build(pPfmgr, pathFormula), this.second.build(pPfmgr, pathFormula));
            return result;
        }
    }

    private static class SymbolicLocationPathFormulaAndBuilder
    extends SymbolicLocationPathFormulaBuilder {
        private final DefaultPathFormulaBuilder previousPathFormula;
        private final CFAEdge edge;

        protected SymbolicLocationPathFormulaAndBuilder(DefaultPathFormulaBuilder pPathFormulaAndBuilder, CFAEdge pEdge, CBinaryExpressionBuilder pCBinaryExpressionBuilder) {
            super(pCBinaryExpressionBuilder);
            this.previousPathFormula = pPathFormulaAndBuilder;
            this.edge = pEdge;
        }

        @Override
        protected PathFormula buildImplementation(PathFormulaManager pPfmgr, PathFormula pPathFormula) throws CPATransferException, InterruptedException {
            PathFormula pathFormula = this.previousPathFormula.build(pPfmgr, pPathFormula);
            return this.addNewPartsToPathFormula(pPfmgr, pathFormula);
        }

        private PathFormula addNewPartsToPathFormula(PathFormulaManager pPfmgr, PathFormula pathFormula) throws CPATransferException, InterruptedException {
            PathFormula newPathFormula = pPfmgr.makeAnd(pathFormula, this.makeProgramCounterAssumption(this.edge));
            newPathFormula = pPfmgr.makeAnd(newPathFormula, this.edge);
            newPathFormula = pPfmgr.makeAnd(newPathFormula, this.makeProgramCounterAssignment(this.edge));
            return newPathFormula;
        }
    }
}

