/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMapMerger;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.IsRelevantLhsVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.IsRelevantWithHavocAbstractionVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.LvalueVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;

public class CtoFormulaConverter {
    static final ImmutableSet<String> PURE_EXTERNAL_FUNCTIONS = ImmutableSet.of((Object)"abort", (Object)"exit", (Object)"__assert_fail", (Object)"__VERIFIER_error", (Object)"free", (Object)"kfree", (Object[])new String[]{"fprintf", "memcmp", "printf", "puts", "printk", "sprintf", "swprintf", "strcasecmp", "strchr", "strcmp", "strlen", "strncmp", "strrchr", "strstr"});
    private static final ImmutableMap<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"fesetround", (Object)"floating-point rounding modes", (Object)"memcpy", (Object)"memcpy", (Object)"memmove", (Object)"memmove", (Object)"memset", (Object)"memset");
    @Deprecated
    private static final String RETURN_VARIABLE_NAME = "__retval__";
    public static final String PARAM_VARIABLE_NAME = "__param__";
    private static final ImmutableSet<String> SAFE_VAR_ARG_FUNCTIONS = ImmutableSet.of((Object)"printf", (Object)"printk");
    private static final CharMatcher ILLEGAL_VARNAME_CHARACTERS = CharMatcher.anyOf((CharSequence)"|\\");
    private final Map<String, Formula> stringLitToFormula = new HashMap<String, Formula>();
    private int nextStringLitIndex = 0;
    final FormulaEncodingOptions options;
    protected final MachineModel machineModel;
    private final Optional<VariableClassification> variableClassification;
    final CtoFormulaTypeHandler typeHandler;
    protected final FormulaManagerView fmgr;
    protected final BooleanFormulaManagerView bfmgr;
    private final BitvectorFormulaManagerView efmgr;
    final FunctionFormulaManagerView ffmgr;
    protected final LogManagerWithoutDuplicates logger;
    protected final ShutdownNotifier shutdownNotifier;
    protected final AnalysisDirection direction;
    private static final int VARIABLE_UNINITIALIZED = 1;
    private static final int VARIABLE_FIRST_ASSIGNMENT = 2;
    private final FunctionDeclaration<?> stringUfDecl;
    protected final Set<CVariableDeclaration> globalDeclarations = new HashSet<CVariableDeclaration>();

    public CtoFormulaConverter(FormulaEncodingOptions pOptions, FormulaManagerView fmgr, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager logger, ShutdownNotifier pShutdownNotifier, CtoFormulaTypeHandler pTypeHandler, AnalysisDirection pDirection) {
        this.fmgr = fmgr;
        this.options = pOptions;
        this.machineModel = pMachineModel;
        this.variableClassification = pVariableClassification;
        this.typeHandler = pTypeHandler;
        this.bfmgr = fmgr.getBooleanFormulaManager();
        this.efmgr = fmgr.getBitvectorFormulaManager();
        this.ffmgr = fmgr.getFunctionFormulaManager();
        this.logger = new LogManagerWithoutDuplicates(logger);
        this.shutdownNotifier = pShutdownNotifier;
        this.direction = pDirection;
        this.stringUfDecl = this.ffmgr.declareUF("__string__", this.typeHandler.getPointerType(), FormulaType.IntegerType);
    }

    @FormatMethod
    void logfOnce(Level level, CFAEdge edge, String msg, Object ... args) {
        if (this.logger.wouldBeLogged(level)) {
            this.logger.logfOnce(level, "%s: %s: %s", new Object[]{edge.getFileLocation(), String.format(msg, args), edge.getDescription()});
        }
    }

    protected long getBitSizeof(CType pType) {
        return this.typeHandler.getBitSizeof(pType);
    }

    protected long getSizeof(CType pType) {
        return this.typeHandler.getSizeof(pType);
    }

    protected boolean isRelevantField(CCompositeType pCompositeType, String fieldName) {
        if (!(this.variableClassification.isPresent() && this.options.ignoreIrrelevantVariables() && this.options.ignoreIrrelevantFields())) {
            return true;
        }
        CCompositeType compositeType = CTypes.withoutVolatile(CTypes.withoutConst(pCompositeType));
        return this.variableClassification.orElseThrow().getRelevantFields().containsEntry((Object)compositeType, (Object)fieldName);
    }

    protected boolean isRelevantLeftHandSide(CLeftHandSide lhs) {
        if (!this.options.trackFunctionPointers() && CTypes.isFunctionPointer(lhs.getExpressionType())) {
            return false;
        }
        if (this.options.useHavocAbstraction() && !lhs.accept(new IsRelevantWithHavocAbstractionVisitor(this)).booleanValue()) {
            return false;
        }
        if (this.options.ignoreIrrelevantVariables() && this.variableClassification.isPresent()) {
            return lhs.accept(new IsRelevantLhsVisitor(this));
        }
        return true;
    }

    protected final boolean isRelevantVariable(CSimpleDeclaration var) {
        if (this.options.useHavocAbstraction() && var instanceof CVariableDeclaration) {
            CVariableDeclaration vDecl = (CVariableDeclaration)var;
            if (vDecl.isGlobal()) {
                return false;
            }
            if (vDecl.getType() instanceof CPointerType) {
                return false;
            }
        }
        if (this.options.ignoreIrrelevantVariables() && this.variableClassification.isPresent()) {
            boolean isRelevantVariable;
            boolean bl = isRelevantVariable = var.getName().equals(RETURN_VARIABLE_NAME) || this.variableClassification.orElseThrow().getRelevantVariables().contains(var.getQualifiedName());
            if (this.options.overflowVariablesAreRelevant()) {
                isRelevantVariable |= this.variableClassification.orElseThrow().getIntOverflowVars().contains(var.getQualifiedName());
            }
            return isRelevantVariable;
        }
        return true;
    }

    public final FormulaType<?> getFormulaTypeFromCType(CType type) {
        if ((type = type.getCanonicalType()) instanceof CSimpleType) {
            CSimpleType simpleType = (CSimpleType)type;
            switch (simpleType.getType()) {
                case FLOAT: {
                    return FormulaType.getSinglePrecisionFloatingPointType();
                }
                case DOUBLE: {
                    if (simpleType.isLong()) {
                        if (this.machineModel.getSizeofLongDouble() == this.machineModel.getSizeofDouble()) {
                            return FormulaType.getDoublePrecisionFloatingPointType();
                        }
                        if (this.machineModel == MachineModel.LINUX32 || this.machineModel == MachineModel.LINUX64) {
                            return FormulaType.getFloatingPointType((int)15, (int)63);
                        }
                        throw new AssertionError((Object)("Missing implementation of long double for machine model " + this.machineModel));
                    }
                    return FormulaType.getDoublePrecisionFloatingPointType();
                }
                case FLOAT128: {
                    return FormulaType.getFloatingPointType((int)15, (int)112);
                }
            }
        }
        int bitSize = Ints.checkedCast((long)this.typeHandler.getBitSizeof(type));
        return FormulaType.getBitvectorTypeWithSize((int)bitSize);
    }

    static String exprToVarNameUnscoped(AAstNode e) {
        return ILLEGAL_VARNAME_CHARACTERS.replaceFrom((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)e.toASTString()), '_');
    }

    static String exprToVarName(AAstNode e, String function) {
        return (function + "::" + CtoFormulaConverter.exprToVarNameUnscoped(e)).intern();
    }

    protected int makeFreshIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int idx = this.getFreshIndex(name, type, ssa);
        ssa.setIndex(name, type, idx);
        return idx;
    }

    protected int getFreshIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        int idx = ssa.getFreshIndex(name);
        if (idx <= 0) {
            idx = 2;
        }
        return idx;
    }

    protected int getIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        int idx = ssa.getIndex(name);
        if (idx <= 0) {
            this.logger.log(Level.ALL, new Object[]{"WARNING: Auto-instantiating variable:", name});
            idx = 1;
            ssa.setIndex(name, type, idx);
        }
        return idx;
    }

    protected void checkSsaSavedType(String name, CType type, CType t) {
        if (t != null && !CtoFormulaTypeUtils.areEqualWithMatchingPointerArray(t, type)) {
            if (!this.getFormulaTypeFromCType(t).equals(this.getFormulaTypeFromCType(type))) {
                throw new UnsupportedOperationException("Variable " + name + " used with types of different sizes! (Type1: " + t + ", Type2: " + type + ")");
            }
            this.logger.logf(Level.FINEST, "Variable %s was found with multiple types! (Type1: %s, Type2: %s)", new Object[]{name, t, type});
        }
    }

    public BooleanFormula makeSsaUpdateTerm(String variableName, CType variableType, int oldIndex, int newIndex, PointerTargetSet pts) throws InterruptedException {
        Preconditions.checkArgument((oldIndex > 0 && newIndex > oldIndex ? 1 : 0) != 0);
        FormulaType<?> variableFormulaType = this.getFormulaTypeFromCType(variableType);
        Object oldVariable = this.fmgr.makeVariable(variableFormulaType, variableName, oldIndex);
        Object newVariable = this.fmgr.makeVariable(variableFormulaType, variableName, newIndex);
        return this.fmgr.assignment(newVariable, oldVariable);
    }

    protected Formula makeConstant(String name, CType type) {
        return this.fmgr.makeVariableWithoutSSAIndex(this.getFormulaTypeFromCType(type), name);
    }

    protected Formula makeVariable(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int useIndex = this.getIndex(name, type, ssa);
        return this.fmgr.makeVariable(this.getFormulaTypeFromCType(type), name, useIndex);
    }

    public Formula makeFormulaForUninstantiatedVariable(String pVarName, CType pType, PointerTargetSet pContextPTS, boolean forcePointerDereference) {
        return this.fmgr.makeVariable(this.getFormulaTypeFromCType(pType), pVarName);
    }

    public Formula makeFormulaForVariable(SSAMap pContextSSA, PointerTargetSet pContextPTS, String pVarName, CType pType) {
        SSAMap.SSAMapBuilder ssa = pContextSSA.builder();
        Formula formula = this.makeVariable(pVarName, pType, ssa);
        Preconditions.checkArgument((boolean)ssa.build().equals(pContextSSA), (Object)"we cannot apply the SSAMap changes to the point where the information would be needed possible problems: uninitialized variables could be in more formulas which get conjuncted and then we get unsatisfiable formulas as a result");
        return formula;
    }

    protected Formula makeFreshVariable(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        int useIndex = this.direction == AnalysisDirection.BACKWARD ? this.getIndex(name, type, ssa) : this.makeFreshIndex(name, type, ssa);
        Object result = this.fmgr.makeVariable(this.getFormulaTypeFromCType(type), name, useIndex);
        if (this.direction == AnalysisDirection.BACKWARD) {
            this.makeFreshIndex(name, type, ssa);
        }
        return result;
    }

    protected Formula makeNondet(String name, CType type, SSAMap.SSAMapBuilder ssa, Constraints constraints) {
        int index = this.makeFreshIndex(name, type, ssa);
        Object newVariable = this.fmgr.makeVariableWithoutSSAIndex(this.getFormulaTypeFromCType(type), name + "!" + index);
        if (this.options.addRangeConstraintsForNondet()) {
            this.addRangeConstraint((Formula)newVariable, type, constraints);
        }
        return newVariable;
    }

    Formula makeStringLiteral(String literal) {
        Object result = this.stringLitToFormula.get(literal);
        if (result == null) {
            int n = this.nextStringLitIndex++;
            result = this.ffmgr.callUF(this.stringUfDecl, new Formula[]{this.fmgr.getIntegerFormulaManager().makeNumber(n)});
            this.stringLitToFormula.put(literal, (Formula)result);
        }
        return result;
    }

    protected @Nullable Formula makeValueReinterpretation(CType pFromType, CType pToType, Formula formula) {
        CType fromType = this.handlePointerAndEnumAsInt(pFromType);
        CType toType = this.handlePointerAndEnumAsInt(pToType);
        FormulaType<?> fromFormulaType = this.getFormulaTypeFromCType(fromType);
        FormulaType<?> toFormulaType = this.getFormulaTypeFromCType(toType);
        if (fromFormulaType.isBitvectorType() && toFormulaType.isFloatingPointType()) {
            int targetSize;
            int sourceSize = ((FormulaType.BitvectorType)fromFormulaType).getSize();
            if (sourceSize > (targetSize = ((FormulaType.FloatingPointType)toFormulaType).getTotalSize())) {
                formula = this.fmgr.getBitvectorFormulaManager().extract((BitvectorFormula)formula, targetSize - 1, 0);
            } else if (sourceSize < targetSize) {
                return null;
            }
            Verify.verify((boolean)this.fmgr.getFormulaType(formula).equals((Object)FormulaType.getBitvectorTypeWithSize((int)targetSize)), (String)"Unexpected result type for %s", (Object)formula);
            return this.fmgr.getFloatingPointFormulaManager().fromIeeeBitvector((BitvectorFormula)formula, (FormulaType.FloatingPointType)toFormulaType);
        }
        if (fromFormulaType.isFloatingPointType() && toFormulaType.isBitvectorType()) {
            int sourceSize = ((FormulaType.FloatingPointType)fromFormulaType).getTotalSize();
            int targetSize = ((FormulaType.BitvectorType)toFormulaType).getSize();
            formula = this.fmgr.getFloatingPointFormulaManager().toIeeeBitvector((FloatingPointFormula)formula);
            if (sourceSize > targetSize) {
                formula = this.fmgr.getBitvectorFormulaManager().extract((BitvectorFormula)formula, targetSize - 1, 0);
            } else if (sourceSize < targetSize) {
                return null;
            }
            Verify.verify((boolean)this.fmgr.getFormulaType(formula).equals(toFormulaType), (String)"Unexpected result type %s for %s", this.fmgr.getFormulaType(formula), (Object)formula);
            return formula;
        }
        return null;
    }

    protected Formula makeCast(CType pFromType, CType pToType, Formula formula, Constraints constraints, CFAEdge edge) throws UnrecognizedCodeException {
        Formula result = this.makeCast0(pFromType, pToType, formula, edge);
        if (this.options.encodeOverflowsWithUFs()) {
            result = this.encodeOverflowsWithUF(result, pToType, constraints);
        }
        return result;
    }

    private Formula encodeOverflowsWithUF(Formula value, CType type, Constraints constraints) {
        if ((type = type.getCanonicalType()) instanceof CSimpleType && ((CSimpleType)type).getType().isIntegerType()) {
            CSimpleType sType = (CSimpleType)type;
            FormulaType<Formula> numberType = this.fmgr.getFormulaType(value);
            boolean signed = this.machineModel.isSigned(sType);
            Formula lowerBound = this.fmgr.makeNumber(numberType, this.machineModel.getMinimalIntegerValue(sType));
            Formula upperBound = this.fmgr.makeNumber(numberType, this.machineModel.getMaximalIntegerValue(sType));
            BooleanFormula range = this.fmgr.makeRangeConstraint(value, lowerBound, upperBound, signed);
            try {
                range = this.fmgr.simplify(range);
            }
            catch (InterruptedException pE) {
                throw CtoFormulaConverter.propagateInterruptedException(pE);
            }
            if (this.bfmgr.isTrue(range)) {
                return value;
            }
            String ufName = String.format("_%s%s(%d)_", "overflow", signed ? "Signed" : "Unsigned", this.machineModel.getSizeofInBits(sType));
            Formula overflowUF = this.ffmgr.declareAndCallUF(ufName, numberType, value);
            this.addRangeConstraint(overflowUF, type, constraints);
            return this.bfmgr.ifThenElse(range, value, overflowUF);
        }
        return value;
    }

    private void addRangeConstraint(Formula variable, CType type, Constraints constraints) {
        if ((type = type.getCanonicalType()) instanceof CSimpleType && ((CSimpleType)type).getType().isIntegerType()) {
            CSimpleType sType = (CSimpleType)type;
            FormulaType<Formula> numberType = this.fmgr.getFormulaType(variable);
            boolean signed = this.machineModel.isSigned(sType);
            Formula lowerBound = this.fmgr.makeNumber(numberType, this.machineModel.getMinimalIntegerValue(sType));
            Formula upperBound = this.fmgr.makeNumber(numberType, this.machineModel.getMaximalIntegerValue(sType));
            constraints.addConstraint(this.fmgr.makeRangeConstraint(variable, lowerBound, upperBound, signed));
        }
    }

    private Formula makeCast0(CType pFromType, CType pToType, Formula formula, CFAEdge edge) throws UnrecognizedCodeException {
        CType toType;
        CType fromType = pFromType.getCanonicalType();
        if (fromType.equals(toType = pToType.getCanonicalType())) {
            return formula;
        }
        if (fromType instanceof CFunctionType) {
            fromType = new CPointerType(false, false, fromType);
        }
        fromType = this.handlePointerAndEnumAsInt(fromType);
        toType = this.handlePointerAndEnumAsInt(toType);
        if (this.isSimple(fromType) && this.isSimple(toType)) {
            return this.makeSimpleCast(fromType, toType, formula);
        }
        if ((fromType instanceof CPointerType || toType instanceof CPointerType) && this.getFormulaTypeFromCType(toType).equals(this.getFormulaTypeFromCType(fromType))) {
            return formula;
        }
        if (this.getBitSizeof(fromType) == this.getBitSizeof(toType)) {
            this.logger.logfOnce(Level.WARNING, "Ignoring cast from %s to %s.", new Object[]{fromType, toType});
            return formula;
        }
        throw new UnrecognizedCodeException("Cast from " + pFromType + " to " + pToType + " not supported!", edge);
    }

    private CType handlePointerAndEnumAsInt(CType pType) {
        if (pType instanceof CBitFieldType) {
            CType normalizedInnerType;
            CBitFieldType type = (CBitFieldType)pType;
            CType innerType = type.getType();
            if (innerType == (normalizedInnerType = this.handlePointerAndEnumAsInt(innerType))) {
                return pType;
            }
            return new CBitFieldType(normalizedInnerType, type.getBitFieldSize());
        }
        if (pType instanceof CPointerType) {
            return this.machineModel.getPointerEquivalentSimpleType();
        }
        if (pType instanceof CEnumType) {
            return ((CEnumType.CEnumerator)((CEnumType)pType).getEnumerators().get(0)).getType();
        }
        if (pType instanceof CElaboratedType && ((CElaboratedType)pType).getKind() == CComplexType.ComplexTypeKind.ENUM) {
            return CNumericTypes.INT;
        }
        return pType;
    }

    protected CExpression makeCastFromArrayToPointerIfNecessary(CExpression exp, CType targetType) {
        if (exp.getExpressionType().getCanonicalType() instanceof CArrayType && ((targetType = targetType.getCanonicalType()) instanceof CPointerType || targetType instanceof CSimpleType)) {
            return CtoFormulaConverter.makeCastFromArrayToPointer(exp);
        }
        return exp;
    }

    private static CExpression makeCastFromArrayToPointer(CExpression arrayExpression) {
        CArrayType arrayType = (CArrayType)arrayExpression.getExpressionType().getCanonicalType();
        CPointerType pointerType = arrayType.asPointerType();
        return new CUnaryExpression(arrayExpression.getFileLocation(), pointerType, arrayExpression, CUnaryExpression.UnaryOperator.AMPER);
    }

    private Formula makeSimpleCast(CType pFromCType, CType pToCType, Formula pFormula) {
        Object ret;
        this.checkSimpleCastArgument(pFromCType);
        this.checkSimpleCastArgument(pToCType);
        Predicate<CType> isSigned = t -> {
            CBitFieldType bitFieldType;
            if (t instanceof CSimpleType) {
                return this.machineModel.isSigned((CSimpleType)t);
            }
            if (t instanceof CBitFieldType && (bitFieldType = (CBitFieldType)t).getType() instanceof CSimpleType) {
                return this.machineModel.isSigned((CSimpleType)bitFieldType.getType());
            }
            throw new AssertionError((Object)("Not a simple type: " + t));
        };
        FormulaType<?> fromType = this.getFormulaTypeFromCType(pFromCType);
        FormulaType<?> toType = this.getFormulaTypeFromCType(pToCType);
        if (fromType.equals(toType)) {
            ret = pFormula;
        } else if (fromType.isBitvectorType() && toType.isBitvectorType()) {
            int toSize = ((FormulaType.BitvectorType)toType).getSize();
            int fromSize = ((FormulaType.BitvectorType)fromType).getSize();
            if (pToCType.getCanonicalType().equals(CNumericTypes.BOOL) || pToCType instanceof CBitFieldType && ((CBitFieldType)pToCType).getType().equals(CNumericTypes.BOOL)) {
                BitvectorFormula zeroFromSize = this.efmgr.makeBitvector(fromSize, 0L);
                BitvectorFormula zeroToSize = this.efmgr.makeBitvector(toSize, 0L);
                BitvectorFormula oneToSize = this.efmgr.makeBitvector(toSize, 1L);
                ret = this.bfmgr.ifThenElse(this.fmgr.makeEqual(zeroFromSize, pFormula), zeroToSize, oneToSize);
            } else {
                ret = fromSize > toSize ? this.fmgr.makeExtract(pFormula, toSize - 1, 0) : (fromSize < toSize ? this.fmgr.makeExtend(pFormula, toSize - fromSize, isSigned.test(pFromCType)) : pFormula);
            }
        } else if (fromType.isFloatingPointType()) {
            ret = toType.isFloatingPointType() ? this.fmgr.getFloatingPointFormulaManager().castTo((FloatingPointFormula)pFormula, isSigned.test(pToCType), toType) : this.fmgr.getFloatingPointFormulaManager().castTo((FloatingPointFormula)pFormula, isSigned.test(pToCType), toType, FloatingPointRoundingMode.TOWARD_ZERO);
        } else if (toType.isFloatingPointType()) {
            ret = this.fmgr.getFloatingPointFormulaManager().castFrom(pFormula, isSigned.test(pFromCType), (FormulaType.FloatingPointType)toType);
        } else {
            throw new IllegalArgumentException("Cast from " + pFromCType + " to " + pToCType + " needs theory conversion between " + fromType + " and " + toType);
        }
        assert (this.fmgr.getFormulaType(ret).equals(toType)) : "types do not match: " + this.fmgr.getFormulaType(ret) + " vs " + toType;
        return ret;
    }

    private void checkSimpleCastArgument(CType pType) {
        Preconditions.checkArgument((boolean)this.isSimple(pType), (String)"Cannot make a simple cast from or to %s", (Object)pType);
    }

    private boolean isSimple(CType pType) {
        CBitFieldType type;
        if (pType instanceof CSimpleType) {
            return true;
        }
        return pType instanceof CBitFieldType && (type = (CBitFieldType)pType).getType() instanceof CSimpleType;
    }

    protected CExpression convertLiteralToFloatIfNecessary(CExpression pExp, CType targetType) {
        if (!CtoFormulaConverter.isFloatingPointType(targetType)) {
            return pExp;
        }
        CExpression e = pExp;
        boolean negative = false;
        if (e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.MINUS) {
            e = ((CUnaryExpression)e).getOperand();
            negative = true;
        }
        if (e instanceof CIntegerLiteralExpression) {
            NumericValue intValue = new NumericValue(((CIntegerLiteralExpression)e).getValue());
            if (negative) {
                intValue = intValue.negate();
            }
            Value floatValue = AbstractExpressionValueVisitor.castCValue(intValue, targetType, this.machineModel, this.logger, e.getFileLocation());
            return new CFloatLiteralExpression(e.getFileLocation(), targetType, floatValue.asNumericValue().bigDecimalValue());
        }
        return pExp;
    }

    private static boolean isFloatingPointType(CType pType) {
        if (pType instanceof CSimpleType) {
            return ((CSimpleType)pType).getType().isFloatingPointType();
        }
        return false;
    }

    public PathFormula makeAnd(PathFormula oldFormula, CFAEdge edge, ErrorConditions errorConditions) throws UnrecognizedCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        String function = edge.getPredecessor() != null ? edge.getPredecessor().getFunctionName() : null;
        SSAMap.SSAMapBuilder ssa = oldFormula.getSsa().builder();
        Constraints constraints = new Constraints(this.bfmgr);
        PointerTargetSetBuilder pts = this.createPointerTargetSetBuilder(oldFormula.getPointerTargetSet());
        if (edge.getPredecessor() instanceof CFunctionEntryNode) {
            CFunctionEntryNode entryNode = (CFunctionEntryNode)edge.getPredecessor();
            this.addParameterConstraints(edge, function, ssa, pts, constraints, errorConditions, entryNode);
            this.addGlobalAssignmentConstraints(edge, function, ssa, pts, constraints, errorConditions, PARAM_VARIABLE_NAME, false);
            if (entryNode.getNumEnteringEdges() == 0) {
                this.handleEntryFunctionParameters(entryNode, ssa, constraints);
            }
        }
        BooleanFormula edgeFormula = this.createFormulaForEdge(edge, function, ssa, pts, constraints, errorConditions);
        if (edge.getSuccessor() instanceof FunctionExitNode) {
            this.addGlobalAssignmentConstraints(edge, function, ssa, pts, constraints, errorConditions, RETURN_VARIABLE_NAME, true);
        }
        edgeFormula = this.bfmgr.and(edgeFormula, constraints.get());
        SSAMap newSsa = ssa.build();
        PointerTargetSet newPts = pts.build();
        if (this.bfmgr.isTrue(edgeFormula) && newSsa == oldFormula.getSsa() && newPts.equals(oldFormula.getPointerTargetSet())) {
            return oldFormula;
        }
        BooleanFormula newFormula = this.bfmgr.and(oldFormula.getFormula(), edgeFormula);
        int newLength = oldFormula.getLength() + 1;
        PathFormula result = PathFormula.createManually(newFormula, newSsa, newPts, newLength);
        return result;
    }

    private void handleEntryFunctionParameters(CFunctionEntryNode entryNode, SSAMap.SSAMapBuilder ssa, Constraints constraints) {
        for (CParameterDeclaration param : entryNode.getFunctionDefinition().getParameters()) {
            if (ssa.getIndex(param.getQualifiedName()) > 0) continue;
            Formula var = this.makeFreshVariable(param.getQualifiedName(), CTypes.adjustFunctionOrArrayType(param.getType()), ssa);
            if (!this.options.addRangeConstraintsForNondet()) continue;
            this.addRangeConstraint(var, param.getType(), constraints);
        }
    }

    private void addParameterConstraints(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions, CFunctionEntryNode entryNode) throws UnrecognizedCodeException, InterruptedException {
        if (this.options.useParameterVariables()) {
            for (CParameterDeclaration formalParam : entryNode.getFunctionParameters()) {
                CParameterDeclaration tmpParameterExpression = new CParameterDeclaration(formalParam.getFileLocation(), formalParam.getType(), formalParam.getName() + PARAM_VARIABLE_NAME);
                tmpParameterExpression.setQualifiedName(formalParam.getQualifiedName() + PARAM_VARIABLE_NAME);
                CIdExpression lhs = new CIdExpression(formalParam.getFileLocation(), formalParam);
                CIdExpression rhs = new CIdExpression(formalParam.getFileLocation(), tmpParameterExpression);
                BooleanFormula eq = this.makeAssignment(lhs, rhs, edge, function, ssa, pts, constraints, errorConditions);
                constraints.addConstraint(eq);
            }
        }
    }

    private void addGlobalAssignmentConstraints(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions, String tmpNamePart, boolean tmpAsLHS) throws UnrecognizedCodeException, InterruptedException {
        if (this.options.useParameterVariablesForGlobals()) {
            for (CVariableDeclaration decl : this.globalDeclarations) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(decl.getFileLocation(), decl.getType(), decl.getName() + tmpNamePart + function);
                tmpParameter.setQualifiedName(decl.getQualifiedName() + tmpNamePart + function);
                CIdExpression tmp = new CIdExpression(decl.getFileLocation(), tmpParameter);
                CIdExpression glob = new CIdExpression(decl.getFileLocation(), decl);
                BooleanFormula eq = tmpAsLHS ? this.makeAssignment(tmp, glob, glob, edge, function, ssa, pts, constraints, errorConditions) : this.makeAssignment(glob, glob, tmp, edge, function, ssa, pts, constraints, errorConditions);
                constraints.addConstraint(eq);
            }
        }
    }

    private BooleanFormula createFormulaForEdge(CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, UnrecognizedCFAEdgeException, InterruptedException {
        switch (edge.getEdgeType()) {
            case StatementEdge: {
                return this.makeStatement((CStatementEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)edge;
                return this.makeReturn(returnEdge.asAssignment(), returnEdge, function, ssa, pts, constraints, errorConditions);
            }
            case DeclarationEdge: {
                return this.makeDeclaration((CDeclarationEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)edge;
                return this.makePredicate(assumeEdge.getExpression(), assumeEdge.getTruthAssumption(), assumeEdge, function, ssa, pts, constraints, errorConditions);
            }
            case BlankEdge: {
                return this.bfmgr.makeTrue();
            }
            case FunctionCallEdge: {
                return this.makeFunctionCall((CFunctionCallEdge)edge, function, ssa, pts, constraints, errorConditions);
            }
            case FunctionReturnEdge: {
                CFunctionSummaryEdge ce = ((CFunctionReturnEdge)edge).getSummaryEdge();
                return this.makeExitFunction(ce, function, ssa, pts, constraints, errorConditions);
            }
            case CallToReturnEdge: {
                CFunctionSummaryEdge ce = (CFunctionSummaryEdge)edge;
                return this.makeExitFunction(ce, function, ssa, pts, constraints, errorConditions);
            }
        }
        throw new UnrecognizedCFAEdgeException(edge);
    }

    private BooleanFormula makeStatement(CStatementEdge statement, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        CStatement stmt = statement.getStatement();
        if (stmt instanceof CAssignment) {
            CAssignment assignment = (CAssignment)stmt;
            return this.makeAssignment(assignment.getLeftHandSide(), assignment.getRightHandSide(), statement, function, ssa, pts, constraints, errorConditions);
        }
        if (stmt instanceof CFunctionCallStatement) {
            CRightHandSideVisitor<Formula, UnrecognizedCodeException> ev = this.createCRightHandSideVisitor(statement, function, ssa, pts, constraints, errorConditions);
            CFunctionCallStatement callStmt = (CFunctionCallStatement)stmt;
            callStmt.getFunctionCallExpression().accept(ev);
        } else if (!(stmt instanceof CExpressionStatement)) {
            throw new UnrecognizedCodeException("Unknown statement", statement, stmt);
        }
        return this.bfmgr.makeTrue();
    }

    protected BooleanFormula makeDeclaration(CDeclarationEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        long size;
        if (!(edge.getDeclaration() instanceof CVariableDeclaration)) {
            this.logfOnce(Level.FINEST, edge, "Ignoring declaration", new Object[0]);
            return this.bfmgr.makeTrue();
        }
        CVariableDeclaration decl = (CVariableDeclaration)edge.getDeclaration();
        String varName = decl.getQualifiedName();
        if (!this.isRelevantVariable(decl)) {
            this.logger.logfOnce(Level.FINEST, "%s: Ignoring declaration of unused variable: %s", new Object[]{decl.getFileLocation(), decl.toASTString()});
            return this.bfmgr.makeTrue();
        }
        this.checkForLargeArray(edge, decl.getType().getCanonicalType());
        if (this.options.useParameterVariablesForGlobals() && decl.isGlobal()) {
            this.globalDeclarations.add(decl);
        }
        if (this.direction == AnalysisDirection.FORWARD) {
            this.makeFreshIndex(varName, decl.getType(), ssa);
        }
        BooleanFormula result = this.bfmgr.makeTrue();
        if (decl.getInitializer() instanceof CInitializerList && (size = this.machineModel.getSizeof(decl.getType()).longValueExact()) > 0L) {
            Formula var = this.makeVariable(varName, decl.getType(), ssa);
            CType elementCType = decl.getType();
            FormulaType<?> elementFormulaType = this.getFormulaTypeFromCType(elementCType);
            Object zero = this.fmgr.makeNumber(elementFormulaType, 0L);
            result = this.bfmgr.and(result, this.fmgr.assignment(var, zero));
        }
        for (CAssignment cAssignment : CInitializers.convertToAssignments(decl, edge)) {
            result = this.bfmgr.and(result, this.makeAssignment(cAssignment.getLeftHandSide(), cAssignment.getRightHandSide(), edge, function, ssa, pts, constraints, errorConditions));
        }
        return result;
    }

    protected void checkForLargeArray(CDeclarationEdge declarationEdge, CType declarationType) throws UnsupportedCodeException {
        if (!this.options.shouldAbortOnLargeArrays() || !(declarationType instanceof CArrayType)) {
            return;
        }
        CArrayType arrayType = (CArrayType)declarationType;
        CType elementType = arrayType.getType();
        if (elementType instanceof CSimpleType && ((CSimpleType)elementType).getType().isFloatingPointType() && arrayType.getLengthAsInt().orElse(0) > 100) {
            throw new UnsupportedCodeException("large floating-point array", declarationEdge);
        }
        if (elementType instanceof CSimpleType && ((CSimpleType)elementType).getType() == CBasicType.INT && arrayType.getLengthAsInt().orElse(0) >= 10000) {
            throw new UnsupportedCodeException("large integer array", declarationEdge);
        }
    }

    protected BooleanFormula makeExitFunction(CFunctionSummaryEdge ce, String calledFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        this.addGlobalAssignmentConstraints(ce, calledFunction, ssa, pts, constraints, errorConditions, RETURN_VARIABLE_NAME, false);
        CFunctionCall retExp = ce.getExpression();
        if (retExp instanceof CFunctionCallStatement) {
            return this.bfmgr.makeTrue();
        }
        if (retExp instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement exp = (CFunctionCallAssignmentStatement)retExp;
            CFunctionCallExpression funcCallExp = exp.getRightHandSide();
            String callerFunction = ce.getSuccessor().getFunctionName();
            Optional<CVariableDeclaration> returnVariableDeclaration = ce.getFunctionEntry().getReturnVariable();
            if (!returnVariableDeclaration.isPresent()) {
                throw new UnrecognizedCodeException("Void function used in assignment", ce, retExp);
            }
            CIdExpression rhs = new CIdExpression(funcCallExp.getFileLocation(), returnVariableDeclaration.orElseThrow());
            return this.makeAssignment(exp.getLeftHandSide(), rhs, ce, callerFunction, ssa, pts, constraints, errorConditions);
        }
        throw new UnrecognizedCodeException("Unknown function exit expression", ce, retExp);
    }

    protected CType getReturnType(CFunctionCallExpression funcCallExp, CFAEdge edge) throws UnrecognizedCodeException {
        CType expType;
        CType retType;
        CFunctionDeclaration funcDecl = funcCallExp.getDeclaration();
        if (funcDecl == null) {
            CExpression functionNameExpression = funcCallExp.getFunctionNameExpression();
            CType expressionType = functionNameExpression.getExpressionType().getCanonicalType();
            if (expressionType instanceof CFunctionType) {
                CFunctionType funcPtrType = (CFunctionType)expressionType;
                retType = funcPtrType.getReturnType();
            } else if (CTypes.isFunctionPointer(expressionType)) {
                CFunctionType funcPtrType = (CFunctionType)((CPointerType)expressionType).getType().getCanonicalType();
                retType = funcPtrType.getReturnType();
            } else {
                throw new UnrecognizedCodeException("Cannot handle function pointer call with unknown type " + expressionType, edge, funcCallExp);
            }
            assert (retType != null);
        } else {
            retType = funcDecl.getType().getReturnType();
        }
        if (!(expType = funcCallExp.getExpressionType()).getCanonicalType().equals(retType.getCanonicalType())) {
            String functionName = funcDecl != null ? funcDecl.getName() : funcCallExp.getFunctionNameExpression().toASTString();
            this.logfOnce(Level.WARNING, edge, "Return type of function %s is %s, but result is used as type %s", functionName, retType, expType);
        }
        return expType;
    }

    protected BooleanFormula makeFunctionCall(CFunctionCallEdge edge, String callerFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        List<CExpression> actualParams = edge.getArguments();
        CFunctionEntryNode fn = edge.getSuccessor();
        List<CParameterDeclaration> formalParams = fn.getFunctionParameters();
        if (fn.getFunctionDefinition().getType().takesVarArgs()) {
            if (formalParams.size() > actualParams.size()) {
                throw new UnrecognizedCodeException("Number of parameters on function call does not match function definition", edge);
            }
            if (!SAFE_VAR_ARG_FUNCTIONS.contains((Object)fn.getFunctionName())) {
                this.logfOnce(Level.WARNING, edge, "Ignoring parameters passed as varargs to function %s", fn.getFunctionName());
            }
        } else if (formalParams.size() != actualParams.size()) {
            throw new UnrecognizedCodeException("Number of parameters on function call does not match function definition", edge);
        }
        int i = 0;
        BooleanFormula result = this.bfmgr.makeTrue();
        for (CParameterDeclaration formalParam : formalParams) {
            CIdExpression paramLHS;
            CExpression paramExpression = actualParams.get(i++);
            CIdExpression lhs = new CIdExpression(paramExpression.getFileLocation(), formalParam);
            if (this.options.useParameterVariables()) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(formalParam.getFileLocation(), formalParam.getType(), formalParam.getName() + PARAM_VARIABLE_NAME);
                tmpParameter.setQualifiedName(formalParam.getQualifiedName() + PARAM_VARIABLE_NAME);
                paramLHS = new CIdExpression(paramExpression.getFileLocation(), tmpParameter);
            } else {
                paramLHS = lhs;
            }
            BooleanFormula eq = this.makeAssignment(paramLHS, lhs, paramExpression, edge, callerFunction, ssa, pts, constraints, errorConditions);
            result = this.bfmgr.and(result, eq);
        }
        this.addGlobalAssignmentConstraints(edge, fn.getFunctionName(), ssa, pts, constraints, errorConditions, PARAM_VARIABLE_NAME, true);
        return result;
    }

    protected BooleanFormula makeReturn(Optional<CAssignment> assignment, CReturnStatementEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        if (!assignment.isPresent()) {
            return this.bfmgr.makeTrue();
        }
        return this.makeAssignment(assignment.orElseThrow().getLeftHandSide(), assignment.orElseThrow().getRightHandSide(), edge, function, ssa, pts, constraints, errorConditions);
    }

    private BooleanFormula makeAssignment(CLeftHandSide lhs, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        return this.makeAssignment(lhs, lhs, rhs, edge, function, ssa, pts, constraints, errorConditions);
    }

    protected BooleanFormula makeAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        if (!this.isRelevantLeftHandSide(lhsForChecking)) {
            return this.bfmgr.makeTrue();
        }
        CType lhsType = lhs.getExpressionType().getCanonicalType();
        if (lhsType instanceof CArrayType) {
            return this.bfmgr.makeTrue();
        }
        if (rhs instanceof CExpression) {
            rhs = this.makeCastFromArrayToPointerIfNecessary((CExpression)rhs, lhsType);
        }
        Formula l = null;
        Formula r = null;
        if (this.direction == AnalysisDirection.BACKWARD) {
            l = this.buildLvalueTerm(lhs, edge, function, ssa, pts, constraints, errorConditions);
            r = this.buildTerm(rhs, edge, function, ssa, pts, constraints, errorConditions);
        } else {
            r = this.buildTerm(rhs, edge, function, ssa, pts, constraints, errorConditions);
            l = this.buildLvalueTerm(lhs, edge, function, ssa, pts, constraints, errorConditions);
        }
        r = this.makeCast(rhs.getExpressionType(), lhsType, r, constraints, edge);
        return this.fmgr.assignment(l, r);
    }

    public final Formula buildTermFromPathFormula(PathFormula pFormula, CIdExpression expr, CFAEdge edge) throws UnrecognizedCodeException {
        String functionName = edge.getPredecessor().getFunctionName();
        Constraints constraints = new Constraints(this.bfmgr);
        return this.buildTerm(expr, edge, functionName, pFormula.getSsa().builder(), this.createPointerTargetSetBuilder(pFormula.getPointerTargetSet()), constraints, ErrorConditions.dummyInstance(this.bfmgr));
    }

    protected Formula buildTerm(CRightHandSide exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException {
        return exp.accept(this.createCRightHandSideVisitor(edge, function, ssa, pts, constraints, errorConditions));
    }

    protected Formula buildLvalueTerm(CLeftHandSide exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException {
        return exp.accept(new LvalueVisitor(this, edge, function, ssa, pts, constraints, errorConditions));
    }

    <T extends Formula> T ifTrueThenOneElseZero(FormulaType<T> type, BooleanFormula pCond) {
        T one = this.fmgr.makeNumber(type, 1L);
        T zero = this.fmgr.makeNumber(type, 0L);
        return this.bfmgr.ifThenElse(pCond, one, zero);
    }

    protected final <T extends Formula> BooleanFormula toBooleanFormula(T pF) {
        Optional<Triple<Object, Object, Object>> split;
        assert (!this.fmgr.getFormulaType(pF).isBooleanType());
        T zero = this.fmgr.makeNumber(this.fmgr.getFormulaType(pF), 0L);
        try {
            split = this.fmgr.splitIfThenElse(pF);
        }
        catch (UnsupportedOperationException e) {
            this.logger.logOnce(Level.INFO, new Object[]{"Solver does not support ITE splitting: " + e.getMessage()});
            split = Optional.empty();
        }
        if (split.isPresent()) {
            Triple<BooleanFormula, T, T> parts = split.orElseThrow();
            T one = this.fmgr.makeNumber(this.fmgr.getFormulaType(pF), 1L);
            if (parts.getSecond().equals(one) && parts.getThird().equals(zero)) {
                return parts.getFirst();
            }
            if (parts.getSecond().equals(zero) && parts.getThird().equals(one)) {
                return this.bfmgr.not(parts.getFirst());
            }
        }
        return this.bfmgr.not(this.fmgr.makeEqual(pF, zero));
    }

    protected BooleanFormula makePredicate(CExpression exp, boolean isTrue, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        Formula f = exp.accept(this.createCRightHandSideVisitor(edge, function, ssa, pts, constraints, errorConditions));
        BooleanFormula result = this.toBooleanFormula(f);
        if (!isTrue) {
            result = this.bfmgr.not(result);
        }
        return result;
    }

    public final BooleanFormula makePredicate(CExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, boolean truthAssumption) throws UnrecognizedCodeException, InterruptedException {
        PointerTargetSetBuilder pts = this.createPointerTargetSetBuilder(PointerTargetSet.emptyPointerTargetSet());
        Constraints constraints = new Constraints(this.bfmgr);
        ErrorConditions errorConditions = ErrorConditions.dummyInstance(this.bfmgr);
        BooleanFormula f = this.makePredicate(exp, truthAssumption, edge, function, ssa, pts, constraints, errorConditions);
        return this.bfmgr.and(f, constraints.get());
    }

    public final BooleanFormula makePredicate(CExpression exp, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa) throws UnrecognizedCodeException, InterruptedException {
        return this.makePredicate(exp, edge, function, ssa, true);
    }

    protected PointerTargetSetBuilder createPointerTargetSetBuilder(PointerTargetSet pts) {
        return PointerTargetSetBuilder.DummyPointerTargetSetBuilder.INSTANCE;
    }

    public SSAMapMerger.MergeResult<PointerTargetSet> mergePointerTargetSets(PointerTargetSet pts1, PointerTargetSet pts2, SSAMap.SSAMapBuilder ssa) throws InterruptedException {
        return SSAMapMerger.MergeResult.trivial(pts1, this.bfmgr);
    }

    protected CRightHandSideVisitor<Formula, UnrecognizedCodeException> createCRightHandSideVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) {
        return new ExpressionToFormulaVisitor(this, this.fmgr, pEdge, pFunction, ssa, constraints);
    }

    private BitvectorFormula accessField(Triple<Integer, Integer, Boolean> msb_Lsb_signed, BitvectorFormula f) {
        return this.fmgr.makeExtract(f, msb_Lsb_signed.getFirst(), msb_Lsb_signed.getSecond());
    }

    BitvectorFormula accessField(CFieldReference fExp, Formula f) throws UnrecognizedCodeException {
        assert (this.options.handleFieldAccess()) : "Fieldaccess if only allowed with handleFieldAccess";
        assert (f instanceof BitvectorFormula) : "Fields need to be represented with bitvectors";
        Triple<Integer, Integer, Boolean> msb_Lsb_signed = this.getFieldOffsetMsbLsb(fExp);
        return this.accessField(msb_Lsb_signed, (BitvectorFormula)f);
    }

    Formula replaceField(CFieldReference fExp, Formula pLVar, Optional<Formula> pRightVariable) throws UnrecognizedCodeException {
        assert (this.options.handleFieldAccess()) : "Fieldaccess if only allowed with handleFieldAccess";
        Triple<Integer, Integer, Boolean> msb_Lsb = this.getFieldOffsetMsbLsb(fExp);
        int size = this.efmgr.getLength((BitvectorFormula)pLVar);
        assert (size > msb_Lsb.getFirst()) : "pLVar is too small";
        assert (0 <= msb_Lsb.getSecond() && msb_Lsb.getFirst() >= msb_Lsb.getSecond()) : "msb_Lsb is invalid";
        ArrayList<Formula> parts = new ArrayList<Formula>(3);
        if (msb_Lsb.getFirst() + 1 < size) {
            parts.add(this.fmgr.makeExtract(pLVar, size - 1, msb_Lsb.getFirst() + 1));
        }
        if (pRightVariable.isPresent()) {
            assert (this.efmgr.getLength((BitvectorFormula)pRightVariable.orElseThrow()) == msb_Lsb.getFirst() + 1 - msb_Lsb.getSecond()) : "The new formula has not the right size";
            parts.add(pRightVariable.orElseThrow());
        }
        if (msb_Lsb.getSecond() > 0) {
            parts.add(this.fmgr.makeExtract(pLVar, msb_Lsb.getSecond() - 1, 0));
        }
        if (parts.isEmpty()) {
            return this.efmgr.makeBitvector(0, 0L);
        }
        return this.fmgr.makeConcat(parts);
    }

    private Triple<Integer, Integer, Boolean> getFieldOffsetMsbLsb(CFieldReference fExp) throws UnrecognizedCodeException {
        CExpression fieldRef = CtoFormulaTypeUtils.getRealFieldOwner(fExp);
        CCompositeType structType = (CCompositeType)fieldRef.getExpressionType().getCanonicalType();
        long offset = this.typeHandler.getBitOffset(structType, fExp.getFieldName());
        CType type = fExp.getExpressionType();
        long fieldSize = this.getBitSizeof(type);
        if (fieldSize == 0L && structType.getKind() == CComplexType.ComplexTypeKind.UNION) {
            fieldSize = this.getBitSizeof(fieldRef.getExpressionType());
        }
        boolean signed = !(type instanceof CSimpleType) || this.machineModel.isSigned((CSimpleType)type);
        long lsb = offset;
        long msb = offset + fieldSize - 1L;
        assert (lsb >= 0L);
        assert (msb >= lsb);
        return Triple.of(Ints.checkedCast((long)msb), Ints.checkedCast((long)lsb), signed);
    }

    Formula makeVariableUnsafe(CExpression exp, String function, SSAMap.SSAMapBuilder ssa, boolean makeFresh) {
        if (makeFresh) {
            this.logger.logOnce(Level.WARNING, new Object[]{"Program contains array, or pointer (multiple level of indirection), or field (enable handleFieldAccess and handleFieldAliasing) access; analysis is imprecise in case of aliasing."});
        }
        this.logger.logfOnce(Level.FINEST, "%s: Unhandled expression treated as free variable: %s", new Object[]{exp.getFileLocation(), exp.toASTString()});
        String var = CtoFormulaConverter.exprToVarName(exp, function);
        if (makeFresh) {
            return this.makeFreshVariable(var, exp.getExpressionType(), ssa);
        }
        return this.makeVariable(var, exp.getExpressionType(), ssa);
    }

    String isUnsupportedFunction(String functionName) {
        String result = null;
        if (UNSUPPORTED_FUNCTIONS.containsKey((Object)functionName)) {
            result = (String)UNSUPPORTED_FUNCTIONS.get((Object)functionName);
        } else if (functionName.startsWith("__atomic_")) {
            result = "atomic operations";
        }
        if (result != null && this.options.isAllowedUnsupportedFunction(functionName)) {
            this.logger.logfOnce(Level.WARNING, "Program contains calls to unsupported function %s, result may be wrong.", new Object[]{functionName});
            return null;
        }
        return result;
    }

    public static <T extends Throwable> RuntimeException propagateInterruptedException(InterruptedException e) throws T {
        throw e;
    }

    public void printStatistics(PrintStream out) {
    }
}

