/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.java_smt.api.FormulaType;

public class CtoFormulaTypeHandler {
    protected final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final FormulaType<?> pointerType;
    private final Map<CCompositeType, ImmutableMap<String, Long>> offsets = new HashMap<CCompositeType, ImmutableMap<String, Long>>();

    public CtoFormulaTypeHandler(LogManager pLogger, MachineModel pMachineModel) {
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.pointerType = FormulaType.getBitvectorTypeWithSize((int)this.machineModel.getSizeofPtrInBits());
    }

    public long getSizeof(CType pType) {
        long size = this.machineModel.getSizeof(pType).longValueExact();
        if (size == 0L) {
            CType type = pType.getCanonicalType();
            if (type instanceof CArrayType) {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "is a zero-length array, this is undefined."});
            } else if (type instanceof CCompositeType) {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "has no fields, this is undefined."});
            } else {
                this.logger.logOnce(Level.WARNING, new Object[]{"Type", pType, "has size 0 bytes."});
            }
        }
        return size;
    }

    public long getBitSizeof(CType pType) {
        if (pType instanceof CBitFieldType) {
            return ((CBitFieldType)pType).getBitFieldSize();
        }
        return this.getSizeof(pType) * (long)this.machineModel.getSizeofCharInBits();
    }

    public OptionalLong getOffset(CCompositeType compositeType, String memberName) {
        long bitOffset = this.getBitOffset(compositeType, memberName);
        if (bitOffset % (long)this.machineModel.getSizeofCharInBits() == 0L) {
            return OptionalLong.of(bitOffset / (long)this.machineModel.getSizeofCharInBits());
        }
        return OptionalLong.empty();
    }

    public OptionalLong getOffset(CCompositeType compositeType, CCompositeType.CCompositeTypeMemberDeclaration member) {
        return this.getOffset(compositeType, member.getName());
    }

    public long getBitOffset(CCompositeType compositeType, CCompositeType.CCompositeTypeMemberDeclaration member) {
        return this.getBitOffset(compositeType, member.getName());
    }

    long getBitOffset(CCompositeType compositeType, String memberName) {
        assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
        ImmutableMap multiset = this.offsets.get(compositeType);
        if (multiset == null) {
            Map<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> calculatedOffsets = this.machineModel.getAllFieldOffsetsInBits(compositeType);
            ImmutableMap.Builder memberOffsets = ImmutableMap.builderWithExpectedSize((int)calculatedOffsets.size());
            calculatedOffsets.forEach((key, value) -> memberOffsets.put((Object)key.getName(), (Object)value.longValueExact()));
            multiset = memberOffsets.buildOrThrow();
            this.offsets.put(compositeType, (ImmutableMap<String, Long>)multiset);
        }
        return (Long)multiset.get((Object)memberName);
    }

    public FormulaType<?> getPointerType() {
        return this.pointerType;
    }
}

