/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

public class CtoWpConverter
extends CtoFormulaConverter {
    private final Constraints constraints;
    private final PointerTargetSetBuilder pts;
    private final ErrorConditions errorConditions;

    public CtoWpConverter(FormulaEncodingOptions pOptions, FormulaManagerView pFmgr, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CtoFormulaTypeHandler pTypeHandler, AnalysisDirection pDirection) {
        super(pOptions, pFmgr, pMachineModel, pVariableClassification, pLogger, pShutdownNotifier, pTypeHandler, pDirection);
        this.constraints = new Constraints(this.bfmgr);
        this.pts = PointerTargetSetBuilder.DummyPointerTargetSetBuilder.INSTANCE;
        this.errorConditions = ErrorConditions.dummyInstance(this.bfmgr);
    }

    public BooleanFormula makePreconditionForEdge(CFAEdge pEdge, BooleanFormula pPostcond) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException, InterruptedException {
        String functionName = pEdge.getPredecessor().getFunctionName();
        switch (pEdge.getEdgeType()) {
            case StatementEdge: {
                return this.makePreconditionForStatement((CStatementEdge)pEdge, pPostcond, functionName);
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge edge = (CReturnStatementEdge)pEdge;
                return this.makePreconditionForReturn(edge.asAssignment(), edge, pPostcond, functionName);
            }
            case DeclarationEdge: {
                CDeclarationEdge edge = (CDeclarationEdge)pEdge;
                if (edge.getDeclaration() instanceof CVariableDeclaration) {
                    return this.makePreconditionForVarDeclaration(edge, (CVariableDeclaration)edge.getDeclaration(), pPostcond, functionName);
                }
                return pPostcond;
            }
            case AssumeEdge: {
                return this.makePreconditionForAssumption((CAssumeEdge)pEdge, pPostcond, functionName);
            }
            case FunctionCallEdge: {
                return this.makePreconditionForFunctionCall((CFunctionCallEdge)pEdge, pPostcond, functionName);
            }
            case FunctionReturnEdge: {
                return this.makePreconditionForFunctionExit(((CFunctionReturnEdge)pEdge).getSummaryEdge(), pPostcond);
            }
            case BlankEdge: {
                return pPostcond;
            }
        }
        throw new UnrecognizedCFAEdgeException(pEdge);
    }

    private static SSAMap.SSAMapBuilder emptySSAMap() {
        return SSAMap.emptySSAMap().builder();
    }

    private BooleanFormula makePreconditionForStatement(CStatementEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        CStatement stmt = pEdge.getStatement();
        if (stmt instanceof CAssignment) {
            return this.makePreconditionForAssignment((CAssignment)stmt, pEdge, pPostcond, pFunction);
        }
        if (stmt instanceof CFunctionCallStatement) {
            return this.makePreconditionForFunctionCallStatement(pEdge, (CFunctionCallStatement)stmt, pPostcond, pFunction);
        }
        if (!(stmt instanceof CExpressionStatement)) {
            throw new UnrecognizedCodeException("Unknown statement", pEdge, stmt);
        }
        return pPostcond;
    }

    private BooleanFormula makePreconditionForReturn(Optional<CAssignment> pAssgn, CReturnStatementEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        if (!pAssgn.isPresent()) {
            return pPostcond;
        }
        return this.makePreconditionForAssignement(pAssgn.orElseThrow().getLeftHandSide(), pAssgn.orElseThrow().getRightHandSide(), pEdge, pPostcond, pFunction);
    }

    private BooleanFormula makePreconditionForAssumption(CAssumeEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula f = this.makePredicate(pEdge.getExpression(), pEdge.getTruthAssumption(), pEdge, pFunction, CtoWpConverter.emptySSAMap(), this.pts, this.constraints, this.errorConditions);
        return this.bfmgr.and(this.fmgr.uninstantiate(f), pPostcond);
    }

    private BooleanFormula makePreconditionForAssignment(CAssignment pAssgn, CFAEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        CLeftHandSide lhs = pAssgn.getLeftHandSide();
        CRightHandSide rhs = pAssgn.getRightHandSide();
        CType lhsType = lhs.getExpressionType().getCanonicalType();
        if (lhsType instanceof CArrayType) {
            return pPostcond;
        }
        if (rhs instanceof CExpression) {
            rhs = this.makeCastFromArrayToPointerIfNecessary((CExpression)rhs, lhsType);
        }
        return this.makePreconditionForAssignement(lhs, rhs, pEdge, pPostcond, pFunction);
    }

    private BooleanFormula makePreconditionForAssignement(CLeftHandSide lhs, CRightHandSide rhs, CFAEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        Formula l = this.buildLvalueTerm(lhs, pEdge, pFunction, CtoWpConverter.emptySSAMap(), this.pts, this.constraints, this.errorConditions);
        Formula r = this.buildTerm(rhs, pEdge, pFunction, CtoWpConverter.emptySSAMap(), this.pts, this.constraints, this.errorConditions);
        HashMap<Formula, Formula> substitution = new HashMap<Formula, Formula>();
        substitution.put(this.fmgr.uninstantiate(l), this.fmgr.uninstantiate(r));
        return this.fmgr.substitute(pPostcond, substitution);
    }

    private BooleanFormula makePreconditionForVarDeclaration(CDeclarationEdge pEdge, CVariableDeclaration pDecl, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        this.checkForLargeArray(pEdge, pDecl.getType().getCanonicalType());
        BooleanFormula result = pPostcond;
        for (CAssignment cAssignment : CInitializers.convertToAssignments(pDecl, pEdge)) {
            result = this.makePreconditionForAssignment(cAssignment, pEdge, result, pFunction);
        }
        return result;
    }

    private BooleanFormula makePreconditionForFunctionCall(CFunctionCallEdge pEdge, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        CFunctionCallExpression callExpr = pEdge.getFunctionCallExpression();
        List<CParameterDeclaration> params = callExpr.getDeclaration().getParameters();
        List<CExpression> paramsExprs = callExpr.getParameterExpressions();
        if (params.size() != paramsExprs.size()) {
            throw new UnrecognizedCodeException("Number of parameters on function call does not match function definition", pEdge);
        }
        BooleanFormula result = pPostcond;
        Map<String, Formula> vars = this.fmgr.extractVariables((Formula)pPostcond);
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i).getQualifiedName();
            Formula paramVar = vars.get(param);
            if (paramVar == null) continue;
            CExpression expr = paramsExprs.get(i);
            Formula exprFormula = this.buildTerm(expr, pEdge, pFunction, CtoWpConverter.emptySSAMap(), this.pts, this.constraints, this.errorConditions);
            HashMap<Formula, Formula> substitution = new HashMap<Formula, Formula>();
            substitution.put(paramVar, this.fmgr.uninstantiate(exprFormula));
            result = this.fmgr.substitute(result, substitution);
        }
        return result;
    }

    private BooleanFormula makePreconditionForFunctionExit(CFunctionSummaryEdge pEdge, BooleanFormula pPostcond) throws UnrecognizedCodeException {
        CFunctionCall retExp = pEdge.getExpression();
        if (retExp instanceof CFunctionCallStatement) {
            return pPostcond;
        }
        if (retExp instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement callStmt = (CFunctionCallAssignmentStatement)retExp;
            CFunctionCallExpression callExpr = callStmt.getRightHandSide();
            String callerFunction = pEdge.getSuccessor().getFunctionName();
            Optional<CVariableDeclaration> retVarDecl = pEdge.getFunctionEntry().getReturnVariable();
            if (!retVarDecl.isPresent()) {
                throw new UnrecognizedCodeException("Void function used in assignment", pEdge, retExp);
            }
            CIdExpression rhs = new CIdExpression(callExpr.getFileLocation(), retVarDecl.orElseThrow());
            return this.makePreconditionForAssignement(callStmt.getLeftHandSide(), rhs, pEdge, pPostcond, callerFunction);
        }
        throw new UnrecognizedCodeException("Unknown function exit expression", pEdge, retExp);
    }

    private BooleanFormula makePreconditionForFunctionCallStatement(CStatementEdge pEdge, CFunctionCall pStmt, BooleanFormula pPostcond, String pFunction) throws UnrecognizedCodeException {
        if (pStmt instanceof CFunctionCallStatement) {
            return pPostcond;
        }
        if (pStmt instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement callStmt = (CFunctionCallAssignmentStatement)pStmt;
            return this.makePreconditionForAssignement(callStmt.getLeftHandSide(), callStmt.getRightHandSide(), pEdge, pPostcond, pFunction);
        }
        throw new UnrecognizedCodeException("Unknown call statement", pEdge, pStmt);
    }
}

