/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinFunctions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExternModelLoader;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

public class ExpressionToFormulaVisitor
extends DefaultCExpressionVisitor<Formula, UnrecognizedCodeException>
implements CRightHandSideVisitor<Formula, UnrecognizedCodeException> {
    private final CtoFormulaConverter conv;
    private final CFAEdge edge;
    private final String function;
    private final Constraints constraints;
    protected final FormulaManagerView mgr;
    protected final SSAMap.SSAMapBuilder ssa;

    public ExpressionToFormulaVisitor(CtoFormulaConverter pCtoFormulaConverter, FormulaManagerView pFmgr, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints) {
        this.conv = pCtoFormulaConverter;
        this.edge = pEdge;
        this.function = pFunction;
        this.ssa = pSsa;
        this.constraints = pConstraints;
        this.mgr = pFmgr;
    }

    @Override
    protected Formula visitDefault(CExpression exp) throws UnrecognizedCodeException {
        return this.conv.makeVariableUnsafe(exp, this.function, this.ssa, false);
    }

    protected Formula toFormula(CExpression e) throws UnrecognizedCodeException {
        return e.accept(this);
    }

    public Formula processOperand(CExpression e, CType calculationType, CType returnType) throws UnrecognizedCodeException {
        e = this.conv.convertLiteralToFloatIfNecessary(e, calculationType);
        e = this.conv.makeCastFromArrayToPointerIfNecessary(e, returnType);
        CType t = e.getExpressionType();
        Formula f = this.toFormula(e);
        return this.conv.makeCast(t, calculationType, f, this.constraints, this.edge);
    }

    private Formula getPointerTargetSizeLiteral(CPointerType pointerType, CType implicitType) {
        long pointerTargetSize = this.conv.getSizeof(pointerType.getType());
        return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(implicitType), pointerTargetSize);
    }

    private CType getPromotedTypeForArithmetic(CExpression exp) {
        CType t = exp.getExpressionType();
        t = t.getCanonicalType();
        if (CTypes.isIntegerType(t = CTypes.adjustFunctionOrArrayType(t))) {
            return this.conv.machineModel.applyIntegerPromotion(t);
        }
        return t;
    }

    @Override
    public Formula visit(CBinaryExpression exp) throws UnrecognizedCodeException {
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        Formula f1 = this.processOperand(exp.getOperand1(), calculationType, returnType);
        Formula f2 = this.processOperand(exp.getOperand2(), calculationType, returnType);
        return this.handleBinaryExpression(exp, f1, f2);
    }

    public final Formula handleBinaryExpression(CBinaryExpression exp, Formula f1, Formula f2) throws UnrecognizedCodeException {
        Formula ret;
        CBinaryExpression.BinaryOperator op = exp.getOperator();
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(returnType);
        boolean signed = calculationType instanceof CSimpleType ? this.conv.machineModel.isSigned((CSimpleType)calculationType) : (calculationType instanceof CPointerType ? this.conv.machineModel.getPointerEquivalentSimpleType().getCanonicalType().isSigned() : false);
        CType promT1 = this.getPromotedTypeForArithmetic(exp.getOperand1());
        CType promT2 = this.getPromotedTypeForArithmetic(exp.getOperand2());
        switch (op) {
            case PLUS: {
                if (!(promT1 instanceof CPointerType) && !(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f1, f2);
                    break;
                }
                if (!(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f1, this.mgr.makeMultiply(f2, this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType)));
                    break;
                }
                if (!(promT1 instanceof CPointerType)) {
                    ret = this.mgr.makePlus(f2, this.mgr.makeMultiply(f1, this.getPointerTargetSizeLiteral((CPointerType)promT2, calculationType)));
                    break;
                }
                throw new UnrecognizedCodeException("Can't add pointers", this.edge, exp);
            }
            case MINUS: {
                if (!(promT1 instanceof CPointerType) && !(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makeMinus(f1, f2);
                    break;
                }
                if (!(promT2 instanceof CPointerType)) {
                    ret = this.mgr.makeMinus(f1, this.mgr.makeMultiply(f2, this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType)));
                    break;
                }
                if (promT1 instanceof CPointerType) {
                    if (promT1.equals(promT2)) {
                        ret = this.mgr.makeDivide(this.mgr.makeMinus(f1, f2), this.getPointerTargetSizeLiteral((CPointerType)promT1, calculationType), true);
                        break;
                    }
                    throw new UnrecognizedCodeException("Can't subtract pointers of different types", this.edge, exp);
                }
                throw new UnrecognizedCodeException("Can't subtract a pointer from a non-pointer", this.edge, exp);
            }
            case MULTIPLY: {
                ret = this.mgr.makeMultiply(f1, f2);
                break;
            }
            case DIVIDE: {
                ret = this.mgr.makeDivide(f1, f2, signed);
                break;
            }
            case MODULO: {
                ret = this.mgr.makeModulo(f1, f2, signed);
                this.addModuloConstraints(exp, f1, f2, signed, ret);
                break;
            }
            case BINARY_AND: {
                ret = this.mgr.makeAnd(f1, f2);
                break;
            }
            case BINARY_OR: {
                ret = this.mgr.makeOr(f1, f2);
                break;
            }
            case BINARY_XOR: {
                ret = this.mgr.makeXor(f1, f2);
                break;
            }
            case SHIFT_LEFT: {
                ret = this.mgr.makeShiftLeft(f1, f2);
                break;
            }
            case SHIFT_RIGHT: {
                ret = this.mgr.makeShiftRight(f1, f2, signed);
                break;
            }
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case EQUALS: 
            case NOT_EQUALS: {
                BooleanFormula result;
                switch (op) {
                    case GREATER_THAN: {
                        result = this.mgr.makeGreaterThan(f1, f2, signed);
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = this.mgr.makeGreaterOrEqual(f1, f2, signed);
                        break;
                    }
                    case LESS_THAN: {
                        result = this.mgr.makeLessThan(f1, f2, signed);
                        break;
                    }
                    case LESS_EQUAL: {
                        result = this.mgr.makeLessOrEqual(f1, f2, signed);
                        break;
                    }
                    case EQUALS: {
                        result = this.handleEquals(exp, f1, f2);
                        break;
                    }
                    case NOT_EQUALS: {
                        result = this.conv.bfmgr.not(this.mgr.makeEqual(f1, f2));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return this.conv.ifTrueThenOneElseZero(returnFormulaType, result);
            }
            default: {
                throw new UnrecognizedCodeException("Unknown binary operator", this.edge, exp);
            }
        }
        Formula castedResult = this.conv.makeCast(calculationType, returnType, ret, this.constraints, this.edge);
        assert (returnFormulaType.equals(this.mgr.getFormulaType(castedResult))) : "Returntype and Formulatype do not match in visit(CBinaryExpression): " + exp;
        return castedResult;
    }

    private BooleanFormula handleEquals(CBinaryExpression exp, Formula f1, Formula f2) throws UnrecognizedCodeException {
        assert (exp.getOperator() == CBinaryExpression.BinaryOperator.EQUALS);
        CExpression e1 = exp.getOperand1();
        CExpression e2 = exp.getOperand2();
        if (e2.equals(CIntegerLiteralExpression.ZERO) && e1 instanceof CBinaryExpression && ((CBinaryExpression)e1).getOperator() == CBinaryExpression.BinaryOperator.BINARY_OR) {
            CBinaryExpression or = (CBinaryExpression)e1;
            Formula zero = f2;
            Formula a = this.processOperand(or.getOperand1(), exp.getCalculationType(), exp.getExpressionType());
            Formula b = this.processOperand(or.getOperand2(), exp.getCalculationType(), exp.getExpressionType());
            return this.conv.bfmgr.and(this.mgr.makeEqual(a, zero), this.mgr.makeEqual(b, zero));
        }
        return this.mgr.makeEqual(f1, f2);
    }

    private void addModuloConstraints(CBinaryExpression exp, Formula f1, Formula f2, boolean signed, Formula ret) {
        BooleanFormula modularCongruence;
        BigInteger modulo;
        BooleanFormulaManagerView bfmgr = this.mgr.getBooleanFormulaManager();
        if (exp.getOperand2() instanceof CIntegerLiteralExpression && !(modulo = ((CIntegerLiteralExpression)exp.getOperand2()).getValue()).equals(BigInteger.ZERO) && !bfmgr.isTrue(modularCongruence = this.mgr.makeModularCongruence(ret, f1, modulo = modulo.abs(), signed))) {
            this.constraints.addConstraint(modularCongruence);
        }
        FormulaType<Formula> numberType = this.mgr.getFormulaType(f1);
        Formula zero = this.mgr.makeNumber(numberType, 0L);
        BooleanFormula signAndNumBound = bfmgr.ifThenElse(this.mgr.makeGreaterOrEqual(f1, zero, signed), this.mgr.makeRangeConstraint(ret, zero, f1, signed), this.mgr.makeRangeConstraint(ret, f1, zero, signed));
        BooleanFormula denomBound = bfmgr.ifThenElse(this.mgr.makeGreaterOrEqual(f2, zero, signed), this.mgr.makeLessThan(ret, f2, signed), this.mgr.makeLessThan(f2, ret, signed));
        BooleanFormula newConstraints = bfmgr.ifThenElse(this.mgr.makeEqual(f2, zero), bfmgr.makeTrue(), bfmgr.and(signAndNumBound, denomBound));
        this.constraints.addConstraint(newConstraints);
    }

    @Override
    public Formula visit(CCastExpression cexp) throws UnrecognizedCodeException {
        CExpression op = cexp.getOperand();
        op = this.conv.makeCastFromArrayToPointerIfNecessary(op, cexp.getExpressionType());
        Formula operand = this.toFormula(op);
        CType after = cexp.getExpressionType();
        CType before = op.getExpressionType();
        return this.conv.makeCast(before, after, operand, this.constraints, this.edge);
    }

    @Override
    public Formula visit(CIdExpression idExp) throws UnrecognizedCodeException {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            CType t = idExp.getExpressionType();
            if (enumerator.hasValue()) {
                return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(t), enumerator.getValue());
            }
            return this.conv.makeConstant(enumerator.getName(), t);
        }
        return this.conv.makeVariable(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.ssa);
    }

    @Override
    public Formula visit(CFieldReference fExp) throws UnrecognizedCodeException {
        CSimpleDeclaration decl;
        if (this.conv.options.handleFieldAccess()) {
            CExpression fieldOwner = CtoFormulaTypeUtils.getRealFieldOwner(fExp);
            Formula f = this.toFormula(fieldOwner);
            return this.conv.accessField(fExp, f);
        }
        CExpression fieldRef = fExp.getFieldOwner();
        if (fieldRef instanceof CIdExpression && (decl = ((CIdExpression)fieldRef).getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal()) {
            return this.conv.makeVariable(CtoFormulaConverter.exprToVarNameUnscoped(fExp), fExp.getExpressionType(), this.ssa);
        }
        return (Formula)super.visit(fExp);
    }

    @Override
    public Formula visit(CCharLiteralExpression cExp) throws UnrecognizedCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(cExp.getExpressionType());
        return this.mgr.makeNumber(t, cExp.getCharacter());
    }

    @Override
    public Formula visit(CIntegerLiteralExpression iExp) throws UnrecognizedCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(iExp.getExpressionType());
        return this.mgr.makeNumber(t, iExp.getValue());
    }

    @Override
    public Formula visit(CImaginaryLiteralExpression exp) throws UnrecognizedCodeException {
        return this.toFormula(exp.getValue());
    }

    @Override
    public Formula visit(CFloatLiteralExpression fExp) throws UnrecognizedCodeException {
        FormulaType<?> t = this.conv.getFormulaTypeFromCType(fExp.getExpressionType());
        return this.mgr.getFloatingPointFormulaManager().makeNumber(fExp.getValue(), (FormulaType.FloatingPointType)t);
    }

    @Override
    public Formula visit(CStringLiteralExpression lexp) throws UnrecognizedCodeException {
        return this.conv.makeStringLiteral(lexp.getValue());
    }

    @Override
    public Formula visit(CUnaryExpression exp) throws UnrecognizedCodeException {
        CExpression operand = exp.getOperand();
        CUnaryExpression.UnaryOperator op = exp.getOperator();
        switch (op) {
            case MINUS: 
            case TILDE: {
                Formula ret;
                CType t = operand.getExpressionType();
                CType promoted = t.getCanonicalType();
                if (CTypes.isIntegerType(promoted)) {
                    promoted = this.conv.machineModel.applyIntegerPromotion(promoted);
                }
                Formula operandFormula = this.toFormula(operand);
                operandFormula = this.conv.makeCast(t, promoted, operandFormula, this.constraints, this.edge);
                if (op == CUnaryExpression.UnaryOperator.MINUS) {
                    ret = this.mgr.makeNegate(operandFormula);
                } else {
                    assert (op == CUnaryExpression.UnaryOperator.TILDE) : "This case should be impossible because of switch";
                    ret = this.mgr.makeNot(operandFormula);
                }
                CType returnType = exp.getExpressionType();
                FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(returnType);
                if (!returnFormulaType.equals(this.mgr.getFormulaType(ret))) {
                    ret = this.conv.makeCast(promoted, returnType, ret, this.constraints, this.edge);
                }
                assert (returnFormulaType.equals(this.mgr.getFormulaType(ret))) : "Returntype " + returnFormulaType + " and Formulatype " + this.mgr.getFormulaType(ret) + " do not match in visit(CUnaryExpression) for " + exp;
                return ret;
            }
            case AMPER: {
                return this.visitDefault(exp);
            }
            case SIZEOF: {
                CType lCType = exp.getOperand().getExpressionType();
                return this.handleSizeof(exp, lCType);
            }
            case ALIGNOF: {
                return this.handleAlignOf(exp, exp.getOperand().getExpressionType());
            }
        }
        throw new UnrecognizedCodeException("Unknown unary operator", this.edge, exp);
    }

    @Override
    public Formula visit(CTypeIdExpression tIdExp) throws UnrecognizedCodeException {
        CType lCType = tIdExp.getType();
        switch (tIdExp.getOperator()) {
            case SIZEOF: {
                return this.handleSizeof(tIdExp, lCType);
            }
            case ALIGNOF: {
                return this.handleAlignOf(tIdExp, lCType);
            }
        }
        return this.visitDefault(tIdExp);
    }

    private Formula handleSizeof(CExpression pExp, CType pCType) {
        return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(pExp.getExpressionType()), this.conv.getSizeof(pCType));
    }

    private Formula handleAlignOf(CExpression pExp, CType pCType) {
        return this.mgr.makeNumber(this.conv.getFormulaTypeFromCType(pExp.getExpressionType()), this.conv.machineModel.getAlignof(pCType));
    }

    @Override
    public Formula visit(CFunctionCallExpression e) throws UnrecognizedCodeException {
        String functionName;
        CExpression functionNameExpression = e.getFunctionNameExpression();
        CType returnType = e.getExpressionType();
        List<CExpression> parameters = e.getParameterExpressions();
        if (functionNameExpression instanceof CIdExpression) {
            Formula result;
            Formula result2;
            FloatingPointFormulaManagerView fpfmgr;
            CSimpleType paramType;
            CSimpleType resultType;
            FormulaType<?> formulaType;
            functionName = ((CIdExpression)functionNameExpression).getName();
            String isUnsupported = this.conv.isUnsupportedFunction(functionName);
            if (isUnsupported != null) {
                throw new UnsupportedCodeException(isUnsupported, this.edge, e);
            }
            if (this.conv.options.isNondetFunction(functionName) || this.conv.options.isMemoryAllocationFunction(functionName) || this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName)) {
                return this.conv.makeNondet(functionName, returnType, this.ssa, this.constraints);
            }
            if (this.conv.options.isExternModelFunction(functionName)) {
                ExternModelLoader loader = new ExternModelLoader(this.conv, this.conv.bfmgr, this.conv.fmgr);
                BooleanFormula result3 = loader.handleExternModelFunction(parameters, this.ssa);
                FormulaType<?> returnFormulaType = this.conv.getFormulaTypeFromCType(e.getExpressionType());
                return this.conv.ifTrueThenOneElseZero(returnFormulaType, result3);
            }
            if (BuiltinFunctions.isPopcountFunction(functionName)) {
                return this.handlePopCount(functionName, returnType, parameters, e);
            }
            if (BuiltinFloatFunctions.matchesInfinity(functionName)) {
                if (parameters.isEmpty() && (formulaType = this.conv.getFormulaTypeFromCType(resultType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makePlusInfinity((FormulaType.FloatingPointType)formulaType);
                }
            } else if (BuiltinFloatFunctions.matchesHugeVal(functionName)) {
                if (parameters.isEmpty() && (formulaType = this.conv.getFormulaTypeFromCType(resultType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makePlusInfinity((FormulaType.FloatingPointType)formulaType);
                }
            } else if (BuiltinFloatFunctions.matchesNaN(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(resultType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    return this.mgr.getFloatingPointFormulaManager().makeNaN((FormulaType.FloatingPointType)formulaType);
                }
            } else if (BuiltinFloatFunctions.matchesAbsolute(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr2 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula zero = fpfmgr2.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    FloatingPointFormula nan = fpfmgr2.makeNaN((FormulaType.FloatingPointType)formulaType);
                    BooleanFormula isNegative = this.mgr.makeOr(this.mgr.makeLessThan(param, zero, true), this.mgr.makeAnd(fpfmgr2.isZero(param), this.conv.bfmgr.not(fpfmgr2.assignment(zero, param))));
                    BooleanFormula isNan = fpfmgr2.isNaN(param);
                    return this.conv.bfmgr.ifThenElse(isNegative, this.mgr.makeNegate(param), this.conv.bfmgr.ifThenElse(isNan, nan, param));
                }
            } else if (BuiltinFloatFunctions.matchesFinite(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr3 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FormulaType<?> resultType2 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    return this.conv.bfmgr.ifThenElse(this.conv.bfmgr.or(fpfmgr3.isInfinity(param), fpfmgr3.isNaN(param)), this.mgr.makeNumber(resultType2, 0L), this.mgr.makeNumber(resultType2, 1L));
                }
            } else if (BuiltinFloatFunctions.matchesIsNaN(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr4 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FormulaType<?> resultType3 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    return this.conv.bfmgr.ifThenElse(fpfmgr4.isNaN(param), this.mgr.makeNumber(resultType3, 1L), this.mgr.makeNumber(resultType3, 0L));
                }
            } else if (BuiltinFloatFunctions.matchesIsInfinity(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr5 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula fp_zero = fpfmgr5.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    FormulaType<?> resultType4 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    Object zero = this.mgr.makeNumber(resultType4, 0L);
                    Object one = this.mgr.makeNumber(resultType4, 1L);
                    Object minus_one = this.mgr.makeNumber(resultType4, -1L);
                    return this.conv.bfmgr.ifThenElse(fpfmgr5.isInfinity(param), this.conv.bfmgr.ifThenElse(fpfmgr5.lessThan(param, fp_zero), minus_one, one), zero);
                }
            } else if (BuiltinFloatFunctions.matchesFloatClassify(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr6 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FormulaType<?> resultType5 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    Object zero = this.mgr.makeNumber(resultType5, 0L);
                    Object one = this.mgr.makeNumber(resultType5, 1L);
                    Object two = this.mgr.makeNumber(resultType5, 2L);
                    Object three = this.mgr.makeNumber(resultType5, 3L);
                    Object four = this.mgr.makeNumber(resultType5, 4L);
                    return this.conv.bfmgr.ifThenElse(fpfmgr6.isNaN(param), zero, this.conv.bfmgr.ifThenElse(fpfmgr6.isInfinity(param), one, this.conv.bfmgr.ifThenElse(fpfmgr6.isZero(param), two, this.conv.bfmgr.ifThenElse(fpfmgr6.isSubnormal(param), three, four))));
                }
            } else if (BuiltinFloatFunctions.matchesCopysign(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr7 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    FloatingPointFormula zero = fpfmgr7.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    FloatingPointFormula anything = (FloatingPointFormula)this.conv.makeNondet(functionName + "_NondetAnything", paramType, this.ssa, this.constraints);
                    BooleanFormula isFirstNegative = this.mgr.makeOr(this.mgr.makeLessThan(param0, zero, true), this.mgr.makeAnd(fpfmgr7.isZero(param0), this.mgr.makeOr(this.conv.bfmgr.not(fpfmgr7.assignment(param0, zero)), this.mgr.makeAnd(fpfmgr7.isNaN(param0), fpfmgr7.assignment(anything, zero)))));
                    BooleanFormula isSecondNegative = this.mgr.makeOr(this.mgr.makeLessThan(param1, zero, true), this.mgr.makeAnd(fpfmgr7.isZero(param1), this.mgr.makeOr(this.conv.bfmgr.not(fpfmgr7.assignment(param1, zero)), this.mgr.makeAnd(fpfmgr7.isNaN(param1), fpfmgr7.assignment(anything, zero)))));
                    BooleanFormula haveSameSign = this.conv.bfmgr.equivalence(isFirstNegative, isSecondNegative);
                    return this.conv.bfmgr.ifThenElse(haveSameSign, param0, fpfmgr7.negate(param0));
                }
            } else if (BuiltinFloatFunctions.matchesFmod(functionName) || BuiltinFloatFunctions.matchesFremainder(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormula n;
                    FloatingPointFormulaManagerView fpfmgr8 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    BooleanFormula isFirstInfinity = fpfmgr8.isInfinity(param0);
                    BooleanFormula isSecondInfinity = fpfmgr8.isInfinity(param1);
                    BooleanFormula isFirstNaN = fpfmgr8.isNaN(param0);
                    BooleanFormula isSecondNaN = fpfmgr8.isNaN(param1);
                    BooleanFormula isFirstZero = fpfmgr8.isZero(param0);
                    BooleanFormula isSecondZero = fpfmgr8.isZero(param1);
                    BooleanFormula domainErr = this.conv.bfmgr.or(isFirstInfinity, isFirstNaN, isSecondNaN, isSecondZero);
                    BooleanFormula noOpNeeded = this.conv.bfmgr.or(isSecondInfinity, isFirstZero);
                    if (BuiltinFloatFunctions.matchesFmod(functionName)) {
                        n = fpfmgr8.divide(param0, param1);
                        n = fpfmgr8.round(n, FloatingPointRoundingMode.TOWARD_ZERO);
                    } else {
                        n = fpfmgr8.divide(param0, param1);
                        n = fpfmgr8.round(n, FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN);
                    }
                    FloatingPointFormula mainCalculation = fpfmgr8.subtract(param0, fpfmgr8.multiply(n, param1));
                    return this.conv.bfmgr.ifThenElse(domainErr, fpfmgr8.makeNaN((FormulaType.FloatingPointType)formulaType), this.conv.bfmgr.ifThenElse(noOpNeeded, param0, mainCalculation));
                }
            } else if (BuiltinFloatFunctions.matchesFmin(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr9 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    BooleanFormula isFirstNaN = fpfmgr9.isNaN(param0);
                    BooleanFormula isSecondNaN = fpfmgr9.isNaN(param1);
                    BooleanFormula firstLessSecond = fpfmgr9.lessThan(param0, param1);
                    return this.conv.bfmgr.ifThenElse(isFirstNaN, param1, this.conv.bfmgr.ifThenElse(this.conv.bfmgr.or(isSecondNaN, firstLessSecond), param0, param1));
                }
            } else if (BuiltinFloatFunctions.matchesFmax(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr10 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    BooleanFormula isFirstNaN = fpfmgr10.isNaN(param0);
                    BooleanFormula isSecondNaN = fpfmgr10.isNaN(param1);
                    BooleanFormula firstGreaterSecond = fpfmgr10.greaterThan(param0, param1);
                    return this.conv.bfmgr.ifThenElse(isFirstNaN, param1, this.conv.bfmgr.ifThenElse(this.conv.bfmgr.or(isSecondNaN, firstGreaterSecond), param0, param1));
                }
            } else if (BuiltinFloatFunctions.matchesFdim(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr11 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    FloatingPointFormula zero = fpfmgr11.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    BooleanFormula isFirstNaN = fpfmgr11.isNaN(param0);
                    BooleanFormula isSecondNaN = fpfmgr11.isNaN(param1);
                    FloatingPointFormula diff = fpfmgr11.subtract(param0, param1);
                    return this.conv.bfmgr.ifThenElse(isFirstNaN, param0, this.conv.bfmgr.ifThenElse(isSecondNaN, param1, this.conv.bfmgr.ifThenElse(fpfmgr11.greaterThan(diff, zero), diff, zero)));
                }
            } else if (BuiltinFloatFunctions.matchesIsless(functionName)) {
                fpfmgr = this.mgr.getFloatingPointFormulaManager();
                result2 = this.inequalityBuiltin(functionName, parameters, fpfmgr::lessThan, fpfmgr);
                if (result2 != null) {
                    return result2;
                }
            } else if (BuiltinFloatFunctions.matchesIslessequal(functionName)) {
                fpfmgr = this.mgr.getFloatingPointFormulaManager();
                result2 = this.inequalityBuiltin(functionName, parameters, fpfmgr::lessOrEquals, fpfmgr);
                if (result2 != null) {
                    return result2;
                }
            } else if (BuiltinFloatFunctions.matchesIsgreater(functionName)) {
                fpfmgr = this.mgr.getFloatingPointFormulaManager();
                result2 = this.inequalityBuiltin(functionName, parameters, fpfmgr::greaterThan, fpfmgr);
                if (result2 != null) {
                    return result2;
                }
            } else if (BuiltinFloatFunctions.matchesIsgreaterequal(functionName)) {
                fpfmgr = this.mgr.getFloatingPointFormulaManager();
                result2 = this.inequalityBuiltin(functionName, parameters, fpfmgr::greaterOrEquals, fpfmgr);
                if (result2 != null) {
                    return result2;
                }
            } else if (BuiltinFloatFunctions.matchesIslessgreater(functionName)) {
                fpfmgr = this.mgr.getFloatingPointFormulaManager();
                result2 = this.inequalityBuiltin(functionName, parameters, (e1, e2) -> this.conv.bfmgr.not(fpfmgr.equalWithFPSemantics((FloatingPointFormula)e1, (FloatingPointFormula)e2)), fpfmgr);
                if (result2 != null) {
                    return result2;
                }
            } else if (BuiltinFloatFunctions.matchesIsunordered(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr12 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(parameters.get(1), paramType, paramType);
                    FormulaType<?> resultType6 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    Object zero = this.mgr.makeNumber(resultType6, 0L);
                    Object one = this.mgr.makeNumber(resultType6, 1L);
                    return this.conv.bfmgr.ifThenElse(fpfmgr12.isNaN(param0), one, this.conv.bfmgr.ifThenElse(fpfmgr12.isNaN(param1), one, zero));
                }
            } else if (BuiltinFloatFunctions.matchesSignbit(functionName)) {
                if (parameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr13 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula fp_zero = fpfmgr13.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    FormulaType<?> resultType7 = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
                    Object zero = this.mgr.makeNumber(resultType7, 0L);
                    Formula not_zero = this.conv.makeNondet(functionName + "_NonZero", CNumericTypes.INT, this.ssa, this.constraints);
                    Formula anything = this.conv.makeNondet(functionName + "_NondetAnything", CNumericTypes.INT, this.ssa, this.constraints);
                    this.constraints.addConstraint(this.mgr.makeNot(this.mgr.makeEqual(not_zero, zero)));
                    return this.conv.bfmgr.ifThenElse(fpfmgr13.isZero(param), this.conv.bfmgr.ifThenElse(fpfmgr13.assignment(param, fp_zero), zero, not_zero), this.conv.bfmgr.ifThenElse(fpfmgr13.isNaN(param), anything, this.conv.bfmgr.ifThenElse(fpfmgr13.lessThan(param, fp_zero), not_zero, zero)));
                }
            } else if (BuiltinFloatFunctions.matchesModf(functionName)) {
                if (parameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName))).isFloatingPointType()) {
                    FloatingPointFormulaManagerView fpfmgr14 = this.mgr.getFloatingPointFormulaManager();
                    FloatingPointFormula param = (FloatingPointFormula)this.processOperand(parameters.get(0), paramType, paramType);
                    FloatingPointFormula zero = fpfmgr14.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
                    FloatingPointFormula nan = fpfmgr14.makeNaN((FormulaType.FloatingPointType)formulaType);
                    FloatingPointFormula rounded = fpfmgr14.round(param, FloatingPointRoundingMode.TOWARD_ZERO);
                    return this.conv.bfmgr.ifThenElse(fpfmgr14.isNaN(param), nan, this.conv.bfmgr.ifThenElse(fpfmgr14.isInfinity(param), zero, fpfmgr14.subtract(param, rounded)));
                }
            } else if (BuiltinFloatFunctions.matchesCeil(functionName)) {
                result = this.roundingBuiltin(functionName, parameters, FloatingPointRoundingMode.TOWARD_POSITIVE);
                if (result != null) {
                    return result;
                }
            } else if (BuiltinFloatFunctions.matchesFloor(functionName)) {
                result = this.roundingBuiltin(functionName, parameters, FloatingPointRoundingMode.TOWARD_NEGATIVE);
                if (result != null) {
                    return result;
                }
            } else if (BuiltinFloatFunctions.matchesTrunc(functionName)) {
                result = this.roundingBuiltin(functionName, parameters, FloatingPointRoundingMode.TOWARD_ZERO);
                if (result != null) {
                    return result;
                }
            } else if (BuiltinFloatFunctions.matchesRound(functionName)) {
                result = this.roundNearestTiesAway(parameters, functionName, false, false);
                if (result != null) {
                    return result;
                }
            } else if (BuiltinFloatFunctions.matchesLround(functionName)) {
                result = this.roundNearestTiesAway(parameters, functionName, true, false);
                if (result != null) {
                    return result;
                }
            } else if (BuiltinFloatFunctions.matchesLlround(functionName)) {
                result = this.roundNearestTiesAway(parameters, functionName, true, true);
                if (result != null) {
                    return result;
                }
            } else if (!CtoFormulaConverter.PURE_EXTERNAL_FUNCTIONS.contains((Object)functionName)) {
                if (parameters.isEmpty()) {
                    this.conv.logger.logOnce(Level.INFO, new Object[]{"Assuming external function", functionName, "to be a constant function."});
                } else {
                    this.conv.logger.logOnce(Level.INFO, new Object[]{"Assuming external function", functionName, "to be a pure function."});
                }
            }
        } else {
            this.conv.logfOnce(Level.WARNING, this.edge, "Ignoring function call through function pointer %s", functionNameExpression);
            String escapedName = CtoFormulaConverter.exprToVarName(functionNameExpression, this.function);
            functionName = ("<func>{" + escapedName + "}").intern();
        }
        if (parameters.isEmpty()) {
            return this.conv.makeConstant(functionName, returnType);
        }
        CFunctionDeclaration functionDeclaration = e.getDeclaration();
        if (functionDeclaration == null) {
            if (functionNameExpression instanceof CIdExpression) {
                this.conv.logger.logfOnce(Level.WARNING, "Cannot get declaration of function %s, ignoring calls to it.", new Object[]{functionNameExpression});
            }
            return this.conv.makeNondet(functionName, returnType, this.ssa, this.constraints);
        }
        if (functionDeclaration.getType().takesVarArgs()) {
            return this.conv.makeNondet(functionName, returnType, this.ssa, this.constraints);
        }
        List<CType> formalParameterTypes = functionDeclaration.getType().getParameters();
        if (formalParameterTypes.size() != parameters.size()) {
            throw new UnrecognizedCodeException("Function " + functionDeclaration + " received " + parameters.size() + " parameters instead of the expected " + formalParameterTypes.size(), this.edge, e);
        }
        ArrayList<Formula> arguments = new ArrayList<Formula>(parameters.size());
        Iterator<CType> formalParameterTypesIt = formalParameterTypes.iterator();
        Iterator<CExpression> parametersIt = parameters.iterator();
        while (formalParameterTypesIt.hasNext() && parametersIt.hasNext()) {
            CType formalParameterType = formalParameterTypesIt.next();
            CExpression parameter = parametersIt.next();
            parameter = this.conv.makeCastFromArrayToPointerIfNecessary(parameter, formalParameterType);
            Formula argument = this.toFormula(parameter);
            arguments.add(this.conv.makeCast(parameter.getExpressionType(), formalParameterType, argument, this.constraints, this.edge));
        }
        assert (!formalParameterTypesIt.hasNext() && !parametersIt.hasNext());
        CType realReturnType = this.conv.getReturnType(e, this.edge);
        FormulaType<?> resultFormulaType = this.conv.getFormulaTypeFromCType(realReturnType);
        return this.conv.ffmgr.declareAndCallUF(functionName, resultFormulaType, arguments);
    }

    private @Nullable Formula roundNearestTiesAway(List<CExpression> pParameters, String pFunctionName, boolean pIsLRound, boolean pIsLongLong) throws UnrecognizedCodeException {
        CSimpleType paramType;
        FormulaType<?> formulaType;
        if (pParameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName))).isFloatingPointType()) {
            FloatingPointFormulaManagerView fpfmgr = this.mgr.getFloatingPointFormulaManager();
            FloatingPointFormula param = (FloatingPointFormula)this.processOperand(pParameters.get(0), paramType, paramType);
            FloatingPointFormula zero = fpfmgr.makeNumber(0.0, (FormulaType.FloatingPointType)formulaType);
            FloatingPointFormula fp_half = fpfmgr.makeNumber(0.5, (FormulaType.FloatingPointType)formulaType);
            FloatingPointFormula fp_neg_half = fpfmgr.makeNumber(-0.5, (FormulaType.FloatingPointType)formulaType);
            FloatingPointFormula integral = fpfmgr.round(param, FloatingPointRoundingMode.TOWARD_ZERO);
            FloatingPointFormula rounded_negative_Infinity = fpfmgr.round(param, FloatingPointRoundingMode.TOWARD_NEGATIVE);
            FloatingPointFormula rounded_positive_Infinity = fpfmgr.round(param, FloatingPointRoundingMode.TOWARD_POSITIVE);
            FloatingPointFormula castIntegral = null;
            FloatingPointFormula castNegative = null;
            Object castPositive = null;
            if (pIsLRound) {
                FormulaType<?> type = pIsLongLong ? this.conv.getFormulaTypeFromCType(CNumericTypes.LONG_LONG_INT) : this.conv.getFormulaTypeFromCType(CNumericTypes.LONG_INT);
                boolean signed = true;
                castIntegral = (FloatingPointFormula)fpfmgr.castTo(integral, true, type);
                castNegative = (FloatingPointFormula)fpfmgr.castTo(rounded_negative_Infinity, true, type);
                castPositive = fpfmgr.castTo(rounded_positive_Infinity, true, type);
            }
            return this.conv.bfmgr.ifThenElse(fpfmgr.greaterThan(param, zero), this.conv.bfmgr.ifThenElse(fpfmgr.greaterOrEquals(fpfmgr.subtract(param, integral), fp_half), pIsLRound ? castPositive : rounded_positive_Infinity, pIsLRound ? castIntegral : integral), this.conv.bfmgr.ifThenElse(fpfmgr.lessOrEquals(fpfmgr.subtract(param, integral), fp_neg_half), pIsLRound ? castNegative : rounded_negative_Infinity, pIsLRound ? castIntegral : integral));
        }
        return null;
    }

    private @Nullable Formula roundingBuiltin(String pFunctionName, List<CExpression> pParameters, FloatingPointRoundingMode pRoundingMode) throws UnrecognizedCodeException {
        CSimpleType paramType;
        FormulaType<?> formulaType;
        if (pParameters.size() == 1 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName))).isFloatingPointType()) {
            FloatingPointFormulaManagerView fpfmgr = this.mgr.getFloatingPointFormulaManager();
            FloatingPointFormula param = (FloatingPointFormula)this.processOperand(pParameters.get(0), paramType, paramType);
            FloatingPointFormula rounded = fpfmgr.round(param, pRoundingMode);
            return rounded;
        }
        return null;
    }

    private @Nullable Formula inequalityBuiltin(String pFunctionName, List<CExpression> pParameters, BiFunction<FloatingPointFormula, FloatingPointFormula, BooleanFormula> pFunction, FloatingPointFormulaManagerView pFpfmgr) throws UnrecognizedCodeException {
        CSimpleType paramType;
        FormulaType<?> formulaType;
        if (pParameters.size() == 2 && (formulaType = this.conv.getFormulaTypeFromCType(paramType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName))).isFloatingPointType()) {
            FloatingPointFormula param0 = (FloatingPointFormula)this.processOperand(pParameters.get(0), paramType, paramType);
            FloatingPointFormula param1 = (FloatingPointFormula)this.processOperand(pParameters.get(1), paramType, paramType);
            FormulaType<?> resultType = this.conv.getFormulaTypeFromCType(CNumericTypes.INT);
            Object zero = this.mgr.makeNumber(resultType, 0L);
            Object one = this.mgr.makeNumber(resultType, 1L);
            BooleanFormula isFirstNaN = pFpfmgr.isNaN(param0);
            BooleanFormula isSecondNaN = pFpfmgr.isNaN(param1);
            return this.conv.bfmgr.ifThenElse(isFirstNaN, zero, this.conv.bfmgr.ifThenElse(isSecondNaN, zero, this.conv.bfmgr.ifThenElse(pFunction.apply(param0, param1), one, zero)));
        }
        return null;
    }

    private Formula handlePopCount(String pFunctionName, CType pReturnType, List<CExpression> pParameters, CFunctionCallExpression e) throws UnrecognizedCodeException {
        if (pParameters.size() == 1) {
            CSimpleType paramType = BuiltinFunctions.getParameterTypeOfBuiltinPopcountFunction(pFunctionName);
            FormulaType<?> paramFormulaType = this.conv.getFormulaTypeFromCType(paramType);
            FormulaType<?> formulaReturnType = this.conv.getFormulaTypeFromCType(pReturnType);
            if (paramFormulaType.isBitvectorType()) {
                BitvectorFormulaManagerView bvMgrv = this.mgr.getBitvectorFormulaManager();
                BitvectorFormula bvParameter = (BitvectorFormula)this.toFormula(pParameters.get(0));
                FormulaType.BitvectorType bvParamType = (FormulaType.BitvectorType)paramFormulaType;
                FormulaType.BitvectorType bvReturnType = (FormulaType.BitvectorType)formulaReturnType;
                int offset = 0;
                BitvectorFormula result = bvMgrv.makeBitvector((FormulaType<BitvectorFormula>)bvReturnType, 0L);
                while (offset < bvParamType.getSize()) {
                    BitvectorFormula bitAtOffset = bvMgrv.extract(bvParameter, offset, offset++);
                    BitvectorFormula bitAtOffsetAsBV = bvMgrv.extend(bitAtOffset, bvReturnType.getSize() - 1, false);
                    result = bvMgrv.add(result, bitAtOffsetAsBV);
                }
                return result;
            }
            throw new IllegalArgumentException("Popcount implementation does not support non bitvector and non integer type " + paramFormulaType + " for Edge: " + this.edge);
        }
        throw new UnrecognizedCodeException("Function " + pFunctionName + " received " + pParameters.size() + " parameters instead of the expected 1", this.edge, e);
    }
}

