/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;

public class ExternModelLoader {
    private final CtoFormulaConverter conv;
    private final BooleanFormulaManagerView bfmgr;
    private final FormulaManagerView fmgr;

    public ExternModelLoader(CtoFormulaConverter pConv, BooleanFormulaManagerView pBfmgr, FormulaManagerView pFmgr) {
        this.conv = pConv;
        this.bfmgr = pBfmgr;
        this.fmgr = pFmgr;
    }

    public BooleanFormula handleExternModelFunction(List<CExpression> parameters, SSAMap.SSAMapBuilder ssa) {
        assert (!parameters.isEmpty()) : "No external model given!";
        String filename = parameters.get(0).toASTString().replace("\"", "");
        Path modelFile = Path.of(filename, new String[0]);
        return this.loadExternalFormula(modelFile, ssa);
    }

    private BooleanFormula loadExternalFormula(Path pModelFile, SSAMap.SSAMapBuilder ssa) {
        BooleanFormula booleanFormula;
        block17: {
            Path fileName = pModelFile.getFileName();
            if (fileName == null || !fileName.toString().endsWith(".dimacs")) {
                throw new UnsupportedOperationException("Sorry, we can only load dimacs models.");
            }
            BufferedReader br = Files.newBufferedReader(pModelFile, StandardCharsets.UTF_8);
            try {
                ArrayList<String> predicates = new ArrayList<String>(10000);
                predicates.add("RheinDummyVar");
                BooleanFormula externalModel = this.bfmgr.makeTrue();
                Object zero = this.fmgr.makeNumber(FormulaType.getBitvectorTypeWithSize((int)32), 0L);
                String line = "";
                while ((line = br.readLine()) != null) {
                    List parts;
                    if (line.startsWith("c ")) {
                        parts = Splitter.on((char)' ').splitToList((CharSequence)line);
                        int varID = Integer.parseInt(((String)parts.get(1)).replace("$", ""));
                        assert (predicates.size() == varID) : "messed up the dimacs parsing!";
                        predicates.add((String)parts.get(2));
                        continue;
                    }
                    if (line.startsWith("p ")) {
                        parts = Splitter.on((char)' ').splitToList((CharSequence)line);
                        assert (predicates.size() == Integer.parseInt((String)parts.get(2)) + 1) : "did not get all dimcas variables?";
                        continue;
                    }
                    if (line.trim().isEmpty()) continue;
                    BooleanFormula constraint = this.bfmgr.makeFalse();
                    for (String elementStr : Splitter.on((char)' ').split((CharSequence)line)) {
                        Object formulaVar;
                        if (elementStr.equals("0") || elementStr.isEmpty()) continue;
                        int elem = Integer.parseInt(elementStr);
                        String predName = "";
                        predName = elem > 0 ? (String)predicates.get(elem) : (String)predicates.get(-elem);
                        int ssaIndex = ssa.getIndex(predName);
                        Object constraintPart = null;
                        if (ssaIndex != -1) {
                            formulaVar = this.fmgr.makeVariable(this.conv.getFormulaTypeFromCType(ssa.getType(predName)), predName, ssaIndex);
                            constraintPart = elem > 0 ? this.fmgr.makeNot(this.fmgr.makeEqual(formulaVar, zero)) : this.fmgr.makeEqual(formulaVar, zero);
                        } else {
                            formulaVar = (BooleanFormula)this.fmgr.makeVariable(FormulaType.BooleanType, predName, 1);
                            constraintPart = elem > 0 ? formulaVar : this.bfmgr.not((BooleanFormula)formulaVar);
                        }
                        constraint = this.bfmgr.or(constraint, (BooleanFormula)constraintPart);
                    }
                    externalModel = this.bfmgr.and(externalModel, constraint);
                }
                booleanFormula = externalModel;
                if (br == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            br.close();
        }
        return booleanFormula;
    }
}

