/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula;

import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.Formula;

class LvalueVisitor
extends DefaultCExpressionVisitor<Formula, UnrecognizedCodeException> {
    private final CtoFormulaConverter conv;
    private final CFAEdge edge;
    private final String function;
    private final SSAMap.SSAMapBuilder ssa;
    private final PointerTargetSetBuilder pts;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;

    LvalueVisitor(CtoFormulaConverter pConv, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        this.conv = pConv;
        this.edge = pEdge;
        this.function = pFunction;
        this.ssa = pSsa;
        this.pts = pPts;
        this.constraints = pConstraints;
        this.errorConditions = pErrorConditions;
    }

    @Override
    protected BitvectorFormula visitDefault(CExpression exp) throws UnrecognizedCodeException {
        throw new UnrecognizedCodeException("Unknown lvalue", this.edge, exp);
    }

    @Override
    public Formula visit(CIdExpression idExp) {
        return this.conv.makeFreshVariable(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.ssa);
    }

    private Formula giveUpAndJustMakeVariable(CExpression exp) {
        return this.conv.makeVariableUnsafe(exp, this.function, this.ssa, true);
    }

    @Override
    public Formula visit(CUnaryExpression pE) throws UnrecognizedCodeException {
        return this.giveUpAndJustMakeVariable(pE);
    }

    @Override
    public Formula visit(CComplexCastExpression pE) throws UnrecognizedCodeException {
        if (pE.isImaginaryCast()) {
            throw new UnrecognizedCodeException("Unknown lvalue", this.edge, pE);
        }
        return this.giveUpAndJustMakeVariable(pE);
    }

    @Override
    public Formula visit(CPointerExpression pE) throws UnrecognizedCodeException {
        return this.giveUpAndJustMakeVariable(pE);
    }

    @Override
    public Formula visit(CFieldReference fexp) throws UnrecognizedCodeException {
        if (!this.conv.options.handleFieldAccess()) {
            CSimpleDeclaration decl;
            CExpression fieldRef = fexp.getFieldOwner();
            if (fieldRef instanceof CIdExpression && (decl = ((CIdExpression)fieldRef).getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal()) {
                String var = CtoFormulaConverter.exprToVarNameUnscoped(fexp);
                return this.conv.makeFreshVariable(var, fexp.getExpressionType(), this.ssa);
            }
            return this.giveUpAndJustMakeVariable(fexp);
        }
        CExpression owner = CtoFormulaTypeUtils.getRealFieldOwner(fexp);
        Formula oldStructure = this.conv.buildTerm(owner, this.edge, this.function, this.ssa, this.pts, this.constraints, this.errorConditions);
        Formula newStructure = owner.accept(this);
        Formula oldRestS = this.conv.replaceField(fexp, oldStructure, Optional.empty());
        Formula newRestS = this.conv.replaceField(fexp, newStructure, Optional.empty());
        this.constraints.addConstraint(this.conv.fmgr.makeEqual(oldRestS, newRestS));
        BitvectorFormula fieldFormula = this.conv.accessField(fexp, newStructure);
        return fieldFormula;
    }

    @Override
    public Formula visit(CArraySubscriptExpression pE) throws UnrecognizedCodeException {
        return this.giveUpAndJustMakeVariable(pE);
    }
}

