/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

abstract class AbstractMemoryRegionManager
implements MemoryRegionManager {
    private final Map<Pair<CFAEdge, String>, Integer> targetStats = new HashMap<Pair<CFAEdge, String>, Integer>();
    private final TypeHandlerWithPointerAliasing typeHandler;

    AbstractMemoryRegionManager(TypeHandlerWithPointerAliasing pTypeHandler) {
        this.typeHandler = pTypeHandler;
    }

    @Override
    public MemoryRegion makeMemoryRegion(CType pFieldOwnerType, CCompositeType.CCompositeTypeMemberDeclaration pMember) {
        return this.makeMemoryRegion(pFieldOwnerType, this.typeHandler.getSimplifiedType(pMember), pMember.getName());
    }

    @Override
    public final String getPointerAccessName(MemoryRegion pRegion) {
        Preconditions.checkNotNull((Object)pRegion);
        return pRegion.getName(this.typeHandler);
    }

    @Override
    public void addTargetToStats(CFAEdge pEdge, String pUfName, PointerTarget pTarget) {
        Pair<CFAEdge, String> key = Pair.of(pEdge, pUfName);
        Integer v = this.targetStats.get(key);
        if (v != null) {
            this.targetStats.put(key, v + 1);
        } else {
            this.targetStats.put(key, 1);
        }
    }

    @Override
    public void printStatistics(PrintStream out) {
        int totalTargets = 0;
        HashMap<String, Integer> perUf = new HashMap<String, Integer>();
        for (Map.Entry<Pair<CFAEdge, String>, Integer> entry : this.targetStats.entrySet()) {
            String key = entry.getKey().getSecond();
            Integer v = entry.getValue();
            if (v != null) {
                perUf.put(key, v + 1);
                totalTargets += v.intValue();
                continue;
            }
            perUf.put(key, 1);
        }
        out.println("Total number of created targets for pointer analysis: " + totalTargets);
        for (Map.Entry<Pair<CFAEdge, String>, Integer> entry : perUf.entrySet()) {
            out.println("   Number of created targets for uf: " + (String)((Object)entry.getKey()) + " is " + entry.getValue());
        }
        out.println();
    }
}

