/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.IsRelevantWithHavocAbstractionVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

class AssignmentHandler {
    private final FormulaEncodingWithPointerAliasingOptions options;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final CToFormulaConverterWithPointerAliasing conv;
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final CFAEdge edge;
    private final String function;
    private final SSAMap.SSAMapBuilder ssa;
    private final PointerTargetSetBuilder pts;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;
    private final MemoryRegionManager regionMgr;

    AssignmentHandler(CToFormulaConverterWithPointerAliasing pConv, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions, MemoryRegionManager pRegionMgr) {
        this.conv = pConv;
        this.typeHandler = pConv.typeHandler;
        this.options = this.conv.options;
        this.fmgr = this.conv.fmgr;
        this.bfmgr = this.conv.bfmgr;
        this.edge = pEdge;
        this.function = pFunction;
        this.ssa = pSsa;
        this.pts = pPts;
        this.constraints = pConstraints;
        this.errorConditions = pErrorConditions;
        this.regionMgr = pRegionMgr;
    }

    BooleanFormula handleAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, CType lhsType, @Nullable CRightHandSide rhs, boolean useOldSSAIndicesIfAliased) throws UnrecognizedCodeException, InterruptedException {
        if (!this.conv.isRelevantLeftHandSide(lhsForChecking)) {
            return this.conv.bfmgr.makeTrue();
        }
        CSimpleType rhsType = rhs != null ? this.typeHandler.getSimplifiedType(rhs) : CNumericTypes.SIGNED_CHAR;
        CExpressionVisitorWithPointerAliasing rhsVisitor = this.newExpressionVisitor();
        Expression rhsExpression = this.conv.options.useHavocAbstraction() && (rhs == null || rhs.accept(new IsRelevantWithHavocAbstractionVisitor(this.conv)) == false) ? Expression.Value.nondetValue() : this.createRHSExpression(rhs, lhsType, rhsVisitor);
        this.pts.addEssentialFields(rhsVisitor.getInitializedFields());
        this.pts.addEssentialFields(rhsVisitor.getUsedFields());
        List<CompositeField> rhsAddressedFields = rhsVisitor.getAddressedFields();
        Map<String, CType> rhsLearnedPointersTypes = rhsVisitor.getLearnedPointerTypes();
        CExpressionVisitorWithPointerAliasing lhsVisitor = this.newExpressionVisitor();
        Expression lhsExpression = lhs.accept(lhsVisitor);
        if (lhsExpression.isNondetValue()) {
            this.conv.logger.logfOnce(Level.WARNING, "%s: Ignoring assignment to %s because bit fields are currently not fully supported", new Object[]{this.edge.getFileLocation(), lhs});
            return this.conv.bfmgr.makeTrue();
        }
        Expression.Location lhsLocation = lhsExpression.asLocation();
        boolean useOldSSAIndices = useOldSSAIndicesIfAliased && lhsLocation.isAliased();
        Map<String, CType> lhsLearnedPointerTypes = lhsVisitor.getLearnedPointerTypes();
        this.pts.addEssentialFields(lhsVisitor.getInitializedFields());
        this.pts.addEssentialFields(lhsVisitor.getUsedFields());
        if (this.conv.options.revealAllocationTypeFromLHS() || this.conv.options.deferUntypedAllocations()) {
            DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this.conv, this.edge, this.ssa, this.pts, this.constraints, this.errorConditions, this.regionMgr);
            memoryHandler.handleDeferredAllocationsInAssignment(lhs, rhs, rhsExpression, lhsType, lhsLearnedPointerTypes, rhsLearnedPointersTypes);
        }
        HashSet<MemoryRegion> updatedRegions = useOldSSAIndices || this.options.useArraysForHeap() ? null : new HashSet<MemoryRegion>();
        BooleanFormula result = this.makeDestructiveAssignment(lhsType, rhsType, lhsLocation, rhsExpression, useOldSSAIndices, updatedRegions);
        if (lhsLocation.isUnaliasedLocation() && lhs instanceof CFieldReference) {
            CFieldReference fieldReference = (CFieldReference)lhs;
            CExpression fieldOwner = fieldReference.getFieldOwner();
            CType ownerType = this.typeHandler.getSimplifiedType(fieldOwner);
            if (!fieldReference.isPointerDereference() && ownerType instanceof CCompositeType) {
                CFieldReference owner;
                CType ownersOwnerType;
                if (((CCompositeType)ownerType).getKind() == CComplexType.ComplexTypeKind.UNION) {
                    this.addAssignmentsForOtherFieldsOfUnion(lhsType, (CCompositeType)ownerType, rhsType, rhsExpression, useOldSSAIndices, updatedRegions, fieldReference);
                }
                if (fieldOwner instanceof CFieldReference && (ownersOwnerType = this.typeHandler.getSimplifiedType((owner = (CFieldReference)fieldOwner).getFieldOwner())) instanceof CCompositeType && ((CCompositeType)ownersOwnerType).getKind() == CComplexType.ComplexTypeKind.UNION) {
                    this.addAssignmentsForOtherFieldsOfUnion(ownersOwnerType, (CCompositeType)ownersOwnerType, ownerType, this.createRHSExpression(owner, ownerType, rhsVisitor), useOldSSAIndices, updatedRegions, owner);
                }
            }
        }
        if (!useOldSSAIndices && !this.options.useArraysForHeap()) {
            if (lhsLocation.isAliased()) {
                PointerTargetPattern pattern = PointerTargetPattern.forLeftHandSide(lhs, this.typeHandler, this.edge, this.pts);
                this.finishAssignmentsForUF(lhsType, lhsLocation.asAliased(), pattern, updatedRegions);
            } else assert (updatedRegions != null && updatedRegions.isEmpty());
        }
        for (CompositeField field : rhsAddressedFields) {
            this.pts.addField(field);
        }
        return result;
    }

    private Expression createRHSExpression(CRightHandSide pRhs, CType pLhsType, CExpressionVisitorWithPointerAliasing pRhsVisitor) throws UnrecognizedCodeException {
        if (pRhs == null) {
            return Expression.Value.nondetValue();
        }
        CRightHandSide r = pRhs;
        if (r instanceof CExpression) {
            r = this.conv.convertLiteralToFloatIfNecessary((CExpression)r, pLhsType);
        }
        return r.accept(pRhsVisitor);
    }

    private CExpressionVisitorWithPointerAliasing newExpressionVisitor() {
        return new CExpressionVisitorWithPointerAliasing(this.conv, this.edge, this.function, this.ssa, this.constraints, this.errorConditions, this.pts, this.regionMgr);
    }

    BooleanFormula handleAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, @Nullable CRightHandSide rhs, boolean useOldSSAIndicesIfAliased) throws UnrecognizedCodeException, InterruptedException {
        return this.handleAssignment(lhs, lhsForChecking, this.typeHandler.getSimplifiedType(lhs), rhs, useOldSSAIndicesIfAliased);
    }

    BooleanFormula handleInitializationAssignments(CIdExpression variable, CType declarationType, List<CExpressionAssignmentStatement> assignments) throws UnrecognizedCodeException, InterruptedException {
        if (this.options.useQuantifiersOnArrays() && declarationType instanceof CArrayType && !assignments.isEmpty()) {
            return this.handleInitializationAssignmentsWithQuantifier(variable, assignments, false);
        }
        return this.handleInitializationAssignmentsWithoutQuantifier(assignments);
    }

    private BooleanFormula handleInitializationAssignmentsWithoutQuantifier(List<CExpressionAssignmentStatement> assignments) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula result = this.conv.bfmgr.makeTrue();
        for (CExpressionAssignmentStatement assignment : assignments) {
            CLeftHandSide lhs = assignment.getLeftHandSide();
            result = this.conv.bfmgr.and(result, this.handleAssignment(lhs, lhs, assignment.getRightHandSide(), true));
        }
        return result;
    }

    private BooleanFormula handleInitializationAssignmentsWithQuantifier(CIdExpression pLeftHandSide, List<CExpressionAssignmentStatement> pAssignments, boolean pUseOldSSAIndices) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula copyOldValue;
        assert (!pAssignments.isEmpty()) : "Cannot handle initialization assignments without an assignment right hand side.";
        CType lhsType = this.typeHandler.getSimplifiedType(pAssignments.get(0).getLeftHandSide());
        CType rhsType = this.typeHandler.getSimplifiedType(pAssignments.get(0).getRightHandSide());
        CExpressionVisitorWithPointerAliasing rhsVisitor = this.newExpressionVisitor();
        Expression rhsValue = pAssignments.get(0).getRightHandSide().accept(rhsVisitor);
        CExpressionVisitorWithPointerAliasing lhsVisitor = this.newExpressionVisitor();
        Expression.Location lhsLocation = pLeftHandSide.accept(lhsVisitor).asLocation();
        if (!(rhsValue.isValue() && this.checkEqualityOfInitializers(pAssignments, rhsVisitor) && lhsLocation.isAliased())) {
            return this.handleInitializationAssignmentsWithoutQuantifier(pAssignments);
        }
        MemoryRegion region = lhsLocation.asAliased().getMemoryRegion();
        if (region == null) {
            region = this.regionMgr.makeMemoryRegion(lhsType);
        }
        String targetName = this.regionMgr.getPointerAccessName(region);
        FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(lhsType);
        int oldIndex = this.conv.getIndex(targetName, lhsType, this.ssa);
        int newIndex = pUseOldSSAIndices ? this.conv.getIndex(targetName, lhsType, this.ssa) : this.conv.getFreshIndex(targetName, lhsType, this.ssa);
        Object counter = this.fmgr.makeVariableWithoutSSAIndex(this.conv.voidPointerFormulaType, targetName + "__" + oldIndex + "__counter");
        BooleanFormula rangeConstraint = this.fmgr.makeElementIndexConstraint(counter, lhsLocation.asAliased().getAddress(), pAssignments.size(), false);
        Object newDereference = this.conv.ptsMgr.makePointerDereference(targetName, targetType, newIndex, counter);
        Formula rhs = this.conv.makeCast(rhsType, lhsType, rhsValue.asValue().getValue(), this.constraints, this.edge);
        BooleanFormula assignNewValue = this.fmgr.assignment(newDereference, rhs);
        if (this.options.useArraysForHeap()) {
            ArrayFormulaManagerView afmgr = this.fmgr.getArrayFormulaManager();
            ArrayFormula newArray = afmgr.makeArray(targetName, newIndex, this.conv.voidPointerFormulaType, targetType);
            ArrayFormula oldArray = afmgr.makeArray(targetName, oldIndex, this.conv.voidPointerFormulaType, targetType);
            copyOldValue = this.fmgr.makeEqual(newArray, oldArray);
        } else {
            copyOldValue = this.fmgr.assignment(newDereference, this.conv.ptsMgr.makePointerDereference(targetName, targetType, oldIndex, counter));
        }
        return this.fmgr.getQuantifiedFormulaManager().forall((Formula)counter, this.bfmgr.and(this.bfmgr.implication(rangeConstraint, assignNewValue), this.bfmgr.implication(this.bfmgr.not(rangeConstraint), copyOldValue)));
    }

    private boolean checkEqualityOfInitializers(List<CExpressionAssignmentStatement> pAssignments, CExpressionVisitorWithPointerAliasing pRhsVisitor) throws UnrecognizedCodeException {
        Expression tmp = null;
        for (CExpressionAssignmentStatement assignment : pAssignments) {
            if (tmp == null) {
                tmp = assignment.getRightHandSide().accept(pRhsVisitor);
            }
            if (tmp.equals(assignment.getRightHandSide().accept(pRhsVisitor))) continue;
            return false;
        }
        return true;
    }

    private void finishAssignmentsForUF(CType lvalueType, Expression.Location.AliasedLocation lvalue, PointerTargetPattern pattern, Set<MemoryRegion> updatedRegions) throws InterruptedException {
        MemoryRegion region = lvalue.getMemoryRegion();
        if (region == null) {
            region = this.regionMgr.makeMemoryRegion(lvalueType);
        }
        if (CTypeUtils.isSimpleType(lvalueType)) assert (updatedRegions.contains(region));
        this.addRetentionForAssignment(region, lvalueType, lvalue.getAddress(), pattern, updatedRegions);
        this.updateSSA(updatedRegions, this.ssa);
    }

    BooleanFormula makeDestructiveAssignment(CType lvalueType, CType rvalueType, Expression.Location lvalue, Expression rvalue, boolean useOldSSAIndices, @Nullable Set<MemoryRegion> updatedRegions) throws UnrecognizedCodeException {
        CTypeUtils.checkIsSimplified(lvalueType);
        CTypeUtils.checkIsSimplified(rvalueType);
        Preconditions.checkArgument((!useOldSSAIndices || updatedRegions == null ? 1 : 0) != 0, (Object)"With old SSA indices returning updated regions does not make sense");
        if (lvalueType instanceof CArrayType) {
            return this.makeDestructiveArrayAssignment((CArrayType)lvalueType, rvalueType, lvalue, rvalue, useOldSSAIndices, updatedRegions);
        }
        if (lvalueType instanceof CCompositeType) {
            CCompositeType lvalueCompositeType = (CCompositeType)lvalueType;
            return this.makeDestructiveCompositeAssignment(lvalueCompositeType, rvalueType, lvalue, rvalue, useOldSSAIndices, updatedRegions);
        }
        return this.makeSimpleDestructiveAssignment(lvalueType, rvalueType, lvalue, rvalue, useOldSSAIndices, updatedRegions);
    }

    private BooleanFormula makeDestructiveArrayAssignment(CArrayType lvalueArrayType, CType rvalueType, Expression.Location lvalue, Expression rvalue, boolean useOldSSAIndices, Set<MemoryRegion> updatedRegions) throws UnrecognizedCodeException {
        CType newRvalueType;
        int length;
        Preconditions.checkArgument((boolean)lvalue.isAliased(), (Object)"Array elements are always aliased");
        CType lvalueElementType = lvalueArrayType.getType();
        OptionalInt lvalueLength = lvalueArrayType.getLengthAsInt();
        if (!lvalueLength.isPresent() && rvalue.isLocation()) {
            lvalueLength = ((CArrayType)rvalueType).getLengthAsInt();
        }
        int n = length = lvalueLength.isPresent() ? Integer.min(this.options.maxArrayLength(), lvalueLength.orElseThrow()) : this.options.defaultArrayLength();
        if (rvalue.isValue()) {
            Preconditions.checkArgument((boolean)CTypeUtils.isSimpleType(rvalueType), (String)"Impossible assignment of %s with type %s to array:", (Object)rvalue, (Object)rvalueType);
            newRvalueType = rvalue.isNondetValue() ? (CTypeUtils.isSimpleType(lvalueElementType) ? lvalueElementType : CNumericTypes.SIGNED_CHAR) : rvalueType;
        } else {
            Preconditions.checkArgument((boolean)rvalue.asLocation().isAliased(), (String)"Impossible assignment of %s with type %s to array:", (Object)rvalue, (Object)rvalueType);
            Preconditions.checkArgument((boolean)((CArrayType)rvalueType).getType().equals(lvalueElementType), (String)"Impossible array assignment due to incompatible types: assignment of %s with type %s to %s with type %s", (Object)rvalue, (Object)rvalueType, (Object)lvalue, (Object)lvalueArrayType);
            newRvalueType = CTypeUtils.checkIsSimplified(((CArrayType)rvalueType).getType());
        }
        BooleanFormula result = this.bfmgr.makeTrue();
        long offset = 0L;
        for (int i = 0; i < length; ++i) {
            Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset);
            Expression.Location.AliasedLocation newLvalue = Expression.Location.AliasedLocation.ofAddress(this.fmgr.makePlus(lvalue.asAliased().getAddress(), offsetFormula));
            Expression newRvalue = rvalue.isValue() ? rvalue : Expression.Location.AliasedLocation.ofAddress(this.fmgr.makePlus(rvalue.asAliasedLocation().getAddress(), offsetFormula));
            result = this.bfmgr.and(result, this.makeDestructiveAssignment(lvalueElementType, newRvalueType, newLvalue, newRvalue, useOldSSAIndices, updatedRegions));
            offset += this.conv.getSizeof(lvalueArrayType.getType());
        }
        return result;
    }

    private BooleanFormula makeDestructiveCompositeAssignment(CCompositeType lvalueCompositeType, CType rvalueType, Expression.Location lvalue, Expression rvalue, boolean useOldSSAIndices, Set<MemoryRegion> updatedRegions) throws UnrecognizedCodeException {
        Preconditions.checkArgument((rvalue.isValue() && CTypeUtils.isSimpleType(rvalueType) || rvalueType.equals(lvalueCompositeType) ? 1 : 0) != 0, (String)"Impossible assignment due to incompatible types: assignment of %s with type %s to %s with type %s", (Object)rvalue, (Object)rvalueType, (Object)lvalue, (Object)lvalueCompositeType);
        BooleanFormula result = this.bfmgr.makeTrue();
        for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : lvalueCompositeType.getMembers()) {
            Expression newRvalue;
            CType newRvalueType;
            Expression.Location newLvalue;
            OptionalLong offset;
            CType newLvalueType = this.typeHandler.getSimplifiedType(memberDeclaration);
            if (!this.conv.isRelevantField(lvalueCompositeType, memberDeclaration) || lvalue.isAliased() && CTypeUtils.isSimpleType(newLvalueType) && !rvalue.isValue() && !this.pts.tracksField(CompositeField.of(lvalueCompositeType, memberDeclaration)) && (rvalue.isAliasedLocation() || !this.conv.hasIndex(CToFormulaConverterWithPointerAliasing.getFieldAccessName(rvalue.asUnaliasedLocation().getVariableName(), memberDeclaration), newLvalueType, this.ssa)) || !(offset = this.typeHandler.getOffset(lvalueCompositeType, memberDeclaration)).isPresent()) continue;
            Object offsetFormula = this.fmgr.makeNumber(this.conv.voidPointerFormulaType, offset.orElseThrow());
            if (lvalue.isAliased()) {
                MemoryRegion region = this.regionMgr.makeMemoryRegion(lvalueCompositeType, memberDeclaration);
                newLvalue = Expression.Location.AliasedLocation.ofAddressWithRegion(this.fmgr.makePlus(lvalue.asAliased().getAddress(), offsetFormula), region);
            } else {
                newLvalue = Expression.Location.UnaliasedLocation.ofVariableName(CToFormulaConverterWithPointerAliasing.getFieldAccessName(lvalue.asUnaliased().getVariableName(), memberDeclaration));
            }
            if (rvalue.isLocation()) {
                newRvalueType = newLvalueType;
                if (rvalue.isAliasedLocation()) {
                    MemoryRegion region = this.regionMgr.makeMemoryRegion(rvalueType, memberDeclaration);
                    newRvalue = Expression.Location.AliasedLocation.ofAddressWithRegion(this.fmgr.makePlus(rvalue.asAliasedLocation().getAddress(), offsetFormula), region);
                } else {
                    newRvalue = Expression.Location.UnaliasedLocation.ofVariableName(CToFormulaConverterWithPointerAliasing.getFieldAccessName(rvalue.asUnaliasedLocation().getVariableName(), memberDeclaration));
                }
            } else {
                newRvalue = rvalue;
                newRvalueType = rvalue.isNondetValue() ? (CTypeUtils.isSimpleType(newLvalueType) ? newLvalueType : CNumericTypes.SIGNED_CHAR) : rvalueType;
            }
            result = this.bfmgr.and(result, this.makeDestructiveAssignment(newLvalueType, newRvalueType, newLvalue, newRvalue, useOldSSAIndices, updatedRegions));
        }
        return result;
    }

    private BooleanFormula makeSimpleDestructiveAssignment(CType lvalueType, CType pRvalueType, Expression.Location lvalue, Expression rvalue, boolean useOldSSAIndices, @Nullable Set<MemoryRegion> updatedRegions) throws UnrecognizedCodeException {
        BooleanFormula result;
        Formula rhs;
        CType rvalueType = CTypeUtils.implicitCastToPointer(pRvalueType);
        Preconditions.checkArgument((boolean)CTypeUtils.isSimpleType(lvalueType));
        Preconditions.checkArgument((boolean)CTypeUtils.isSimpleType(rvalueType));
        assert (!(lvalueType instanceof CFunctionType)) : "Can't assign to functions";
        FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(lvalueType);
        if (pRvalueType instanceof CArrayType && rvalue.isAliasedLocation()) {
            rhs = rvalue.asAliasedLocation().getAddress();
        } else {
            Optional<Formula> value = this.getValueFormula(rvalueType, rvalue);
            Formula formula = rhs = value.isPresent() ? this.conv.makeCast(rvalueType, lvalueType, value.orElseThrow(), this.constraints, this.edge) : null;
        }
        if (!lvalue.isAliased()) {
            assert (!useOldSSAIndices);
            String targetName = lvalue.asUnaliased().getVariableName();
            int newIndex = this.conv.makeFreshIndex(targetName, lvalueType, this.ssa);
            result = rhs != null ? this.fmgr.assignment(this.fmgr.makeVariable(targetType, targetName, newIndex), rhs) : this.bfmgr.makeTrue();
        } else {
            int newIndex;
            MemoryRegion region = lvalue.asAliased().getMemoryRegion();
            if (region == null) {
                region = this.regionMgr.makeMemoryRegion(lvalueType);
            }
            String targetName = this.regionMgr.getPointerAccessName(region);
            int oldIndex = this.conv.getIndex(targetName, lvalueType, this.ssa);
            if (useOldSSAIndices) {
                assert (updatedRegions == null) : "Returning updated regions is only for new indices";
                newIndex = oldIndex;
            } else if (this.options.useArraysForHeap()) {
                assert (updatedRegions == null) : "Return updated regions is only for UF encoding";
                if (rhs == null) {
                    String nondetName = "__nondet_value_" + CTypeUtils.typeToString(rvalueType).replace(' ', '_');
                    rhs = this.conv.makeNondet(nondetName, rvalueType, this.ssa, this.constraints);
                    rhs = this.conv.makeCast(rvalueType, lvalueType, rhs, this.constraints, this.edge);
                }
                newIndex = this.conv.makeFreshIndex(targetName, lvalueType, this.ssa);
            } else {
                assert (updatedRegions != null) : "UF encoding needs to update regions for new indices";
                updatedRegions.add(region);
                newIndex = this.conv.getFreshIndex(targetName, lvalueType, this.ssa);
            }
            if (rhs != null) {
                Formula address = lvalue.asAliased().getAddress();
                result = this.conv.ptsMgr.makePointerAssignment(targetName, targetType, oldIndex, newIndex, address, rhs);
            } else {
                result = this.bfmgr.makeTrue();
            }
        }
        return result;
    }

    private Optional<Formula> getValueFormula(CType pRValueType, Expression pRValue) throws AssertionError {
        switch (pRValue.getKind()) {
            case ALIASED_LOCATION: {
                MemoryRegion region = pRValue.asAliasedLocation().getMemoryRegion();
                if (region == null) {
                    region = this.regionMgr.makeMemoryRegion(pRValueType);
                }
                return Optional.of(this.conv.makeDereference(pRValueType, pRValue.asAliasedLocation().getAddress(), this.ssa, this.errorConditions, region));
            }
            case UNALIASED_LOCATION: {
                return Optional.of(this.conv.makeVariable(pRValue.asUnaliasedLocation().getVariableName(), pRValueType, this.ssa));
            }
            case DET_VALUE: {
                return Optional.of(pRValue.asValue().getValue());
            }
            case NONDET: {
                return Optional.empty();
            }
        }
        throw new AssertionError();
    }

    private void addAssignmentsForOtherFieldsOfUnion(CType lhsType, CCompositeType ownerType, CType rhsType, Expression rhsExpression, boolean useOldSSAIndices, Set<MemoryRegion> updatedRegions, CFieldReference fieldReference) throws UnrecognizedCodeException {
        CExpressionVisitorWithPointerAliasing lhsVisitor = this.newExpressionVisitor();
        for (CCompositeType.CCompositeTypeMemberDeclaration member : ownerType.getMembers()) {
            if (member.getName().equals(fieldReference.getFieldName())) continue;
            CType newLhsType = member.getType();
            CFieldReference newLhs = new CFieldReference(FileLocation.DUMMY, newLhsType, member.getName(), fieldReference.getFieldOwner(), false);
            Expression.Location newLhsLocation = newLhs.accept(lhsVisitor).asLocation();
            assert (newLhsLocation.isUnaliasedLocation());
            if (CTypeUtils.isSimpleType(newLhsType)) {
                this.addAssignmentsForOtherFieldsOfUnionForLhsSimpleType(lhsType, newLhsType, rhsType, rhsExpression, fieldReference, newLhsLocation, useOldSSAIndices, updatedRegions);
            }
            if (!(newLhsType instanceof CCompositeType) || !CTypeUtils.isSimpleType(rhsType) || rhsExpression.isNondetValue()) continue;
            this.addAssignmentsForOtherFieldsOfUnionForLhsCompositeType(newLhs, (CCompositeType)newLhsType, rhsType, rhsExpression, lhsVisitor, member, useOldSSAIndices, updatedRegions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addAssignmentsForOtherFieldsOfUnionForLhsSimpleType(CType lhsType, CType newLhsType, CType rhsType, Expression rhsExpression, CFieldReference fieldReference, Expression.Location newLhsLocation, boolean useOldSSAIndices, Set<MemoryRegion> updatedRegions) throws AssertionError, UnrecognizedCodeException, UnsupportedCodeException {
        Expression.Value newRhsExpression;
        if (CTypeUtils.isSimpleType(rhsType) && !rhsExpression.isNondetValue()) {
            Formula rhsFormula = this.getValueFormula(rhsType, rhsExpression).orElseThrow();
            rhsFormula = this.conv.makeCast(rhsType, lhsType, rhsFormula, this.constraints, this.edge);
            rhsFormula = this.conv.makeValueReinterpretation(lhsType, newLhsType, rhsFormula);
            newRhsExpression = Expression.Value.ofValueOrNondet(rhsFormula);
        } else if (rhsType instanceof CCompositeType) {
            if (((CCompositeType)rhsType).getKind() != CComplexType.ComplexTypeKind.STRUCT) throw new UnsupportedCodeException("Assignment of complex Unions via nested Struct-Members not supported", this.edge);
            CExpressionVisitorWithPointerAliasing expVisitor = this.newExpressionVisitor();
            long offset = 0L;
            int targetSize = Ints.checkedCast((long)this.typeHandler.getBitSizeof(newLhsType));
            Formula rhsFormula = null;
            for (CCompositeType.CCompositeTypeMemberDeclaration innerMember : ((CCompositeType)rhsType).getMembers()) {
                int innerMemberSize = Ints.checkedCast((long)this.typeHandler.getBitSizeof(innerMember.getType()));
                CFieldReference innerMemberFieldReference = new CFieldReference(FileLocation.DUMMY, innerMember.getType(), innerMember.getName(), fieldReference, false);
                Formula memberFormula = this.getValueFormula(innerMember.getType(), this.createRHSExpression(innerMemberFieldReference, innerMember.getType(), expVisitor)).orElseThrow();
                if (!(memberFormula instanceof BitvectorFormula)) {
                    CType interType = TypeUtils.createTypeWithLength(innerMemberSize);
                    memberFormula = this.conv.makeCast(innerMember.getType(), interType, memberFormula, this.constraints, this.edge);
                    memberFormula = this.conv.makeValueReinterpretation(innerMember.getType(), interType, memberFormula);
                }
                assert (memberFormula == null || memberFormula instanceof BitvectorFormula);
                if (memberFormula != null) {
                    if (rhsFormula == null) {
                        rhsFormula = this.fmgr.getBitvectorFormulaManager().makeBitvector(targetSize, 0L);
                    }
                    boolean lhsSigned = false;
                    if (!(newLhsType instanceof CPointerType)) {
                        lhsSigned = ((CSimpleType)newLhsType).isSigned();
                    }
                    memberFormula = this.fmgr.makeExtend(memberFormula, targetSize - innerMemberSize, lhsSigned);
                    memberFormula = this.fmgr.makeShiftLeft(memberFormula, this.fmgr.makeNumber(FormulaType.getBitvectorTypeWithSize((int)targetSize), offset));
                    rhsFormula = this.fmgr.makePlus(rhsFormula, memberFormula);
                }
                offset += this.typeHandler.getBitSizeof(innerMember.getType());
            }
            if (rhsFormula != null) {
                CType fromType = TypeUtils.createTypeWithLength(targetSize);
                rhsFormula = this.conv.makeCast(fromType, newLhsType, rhsFormula, this.constraints, this.edge);
                rhsFormula = this.conv.makeValueReinterpretation(fromType, newLhsType, rhsFormula);
            }
            newRhsExpression = Expression.Value.ofValueOrNondet(rhsFormula);
        } else {
            newRhsExpression = Expression.Value.nondetValue();
        }
        CType newRhsType = newLhsType;
        this.constraints.addConstraint(this.makeDestructiveAssignment(newLhsType, newRhsType, newLhsLocation, newRhsExpression, useOldSSAIndices, updatedRegions));
    }

    private void addAssignmentsForOtherFieldsOfUnionForLhsCompositeType(CExpression newLhs, CCompositeType newLhsType, CType rhsType, Expression rhsExpression, CExpressionVisitorWithPointerAliasing lhsVisitor, CCompositeType.CCompositeTypeMemberDeclaration member, boolean useOldSSAIndices, Set<MemoryRegion> updatedRegions) throws AssertionError, UnrecognizedCodeException {
        CCompositeType.CCompositeTypeMemberDeclaration innerMember;
        int fieldOffset;
        CCompositeType memberType = newLhsType;
        CExpression memberCFieldReference = newLhs;
        int rhsSize = Ints.checkedCast((long)this.typeHandler.getBitSizeof(rhsType));
        Iterator<CCompositeType.CCompositeTypeMemberDeclaration> iterator = memberType.getMembers().iterator();
        while (iterator.hasNext() && (fieldOffset = Ints.checkedCast((long)this.typeHandler.getBitOffset(memberType, innerMember = iterator.next()))) < rhsSize) {
            int fieldSize = Math.min(Ints.checkedCast((long)this.typeHandler.getBitSizeof(innerMember.getType())), rhsSize - fieldOffset);
            assert (fieldSize > 0);
            int startIndex = fieldOffset;
            int endIndex = fieldOffset + fieldSize - 1;
            Formula rhsFormula = this.getValueFormula(rhsType, rhsExpression).orElseThrow();
            if (rhsType instanceof CPointerType) {
                CType rhsCasted = TypeUtils.createTypeWithLength(rhsSize);
                rhsFormula = this.conv.makeCast(rhsType, rhsCasted, rhsFormula, this.constraints, this.edge);
                rhsFormula = this.conv.makeValueReinterpretation(rhsType, rhsCasted, rhsFormula);
            } else {
                rhsFormula = this.conv.makeCast(rhsType, memberType, rhsFormula, this.constraints, this.edge);
                rhsFormula = this.conv.makeValueReinterpretation(rhsType, memberType, rhsFormula);
            }
            assert (rhsFormula == null || rhsFormula instanceof BitvectorFormula);
            if (rhsFormula != null) {
                rhsFormula = this.fmgr.makeExtract(rhsFormula, endIndex, startIndex);
            }
            Expression.Value newRhsExpression = Expression.Value.ofValueOrNondet(rhsFormula);
            CFieldReference innerMemberCFieldReference = new CFieldReference(FileLocation.DUMMY, member.getType(), innerMember.getName(), memberCFieldReference, false);
            Expression.Location innerMemberLocation = innerMemberCFieldReference.accept(lhsVisitor).asLocation();
            this.constraints.addConstraint(this.makeDestructiveAssignment(innerMember.getType(), innerMember.getType(), innerMemberLocation, newRhsExpression, useOldSSAIndices, updatedRegions));
        }
    }

    private void addRetentionForAssignment(MemoryRegion region, CType lvalueType, Formula startAddress, PointerTargetPattern pattern, Set<MemoryRegion> regionsToRetain) throws InterruptedException {
        Preconditions.checkNotNull((Object)lvalueType);
        Preconditions.checkNotNull((Object)startAddress);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkNotNull(regionsToRetain);
        assert (!this.options.useArraysForHeap());
        CTypeUtils.checkIsSimplified(lvalueType);
        long size = this.conv.getSizeof(lvalueType);
        if (this.options.useQuantifiersOnArrays()) {
            this.addRetentionConstraintsWithQuantifiers(lvalueType, pattern, startAddress, size, regionsToRetain);
        } else {
            this.addRetentionConstraintsWithoutQuantifiers(region, lvalueType, pattern, startAddress, size, regionsToRetain);
        }
    }

    private void addRetentionConstraintsWithQuantifiers(CType lvalueType, PointerTargetPattern pattern, Formula startAddress, long size, Set<MemoryRegion> regions) {
        for (MemoryRegion region : regions) {
            BooleanFormula updateCondition;
            String ufName = this.regionMgr.getPointerAccessName(region);
            int oldIndex = this.conv.getIndex(ufName, region.getType(), this.ssa);
            int newIndex = this.conv.getFreshIndex(ufName, region.getType(), this.ssa);
            FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(region.getType());
            Object counter = this.fmgr.makeVariableWithoutSSAIndex(this.conv.voidPointerFormulaType, ufName + "__counter");
            if (CTypeUtils.isSimpleType(lvalueType)) {
                updateCondition = this.fmgr.makeEqual(counter, startAddress);
            } else if (pattern.isExact()) {
                Formula targetAddress = this.conv.makeFormulaForTarget(pattern.asPointerTarget());
                updateCondition = this.fmgr.makeElementIndexConstraint(counter, targetAddress, size, false);
            } else {
                updateCondition = this.fmgr.makeElementIndexConstraint(counter, startAddress, size, false);
            }
            BooleanFormula body = this.bfmgr.or(updateCondition, this.conv.makeRetentionConstraint(ufName, oldIndex, newIndex, targetType, (Formula)counter));
            this.constraints.addConstraint(this.fmgr.getQuantifiedFormulaManager().forall((Formula)counter, body));
        }
    }

    private void addRetentionConstraintsWithoutQuantifiers(MemoryRegion region, CType lvalueType, PointerTargetPattern pattern, Formula startAddress, long size, Set<MemoryRegion> regionsToRetain) throws InterruptedException {
        Preconditions.checkNotNull((Object)region);
        if (CTypeUtils.isSimpleType(lvalueType)) {
            this.addSimpleTypeRetentionConstraints(pattern, (Set<MemoryRegion>)ImmutableSet.of((Object)region), startAddress);
        } else if (pattern.isExact()) {
            this.addExactRetentionConstraints(pattern.withRange(size), regionsToRetain);
        } else if (pattern.isSemiExact()) {
            if (lvalueType instanceof CArrayType) {
                lvalueType = CTypeUtils.checkIsSimplified(((CArrayType)lvalueType).getType());
                region = this.regionMgr.makeMemoryRegion(lvalueType);
            } else {
                CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration = ((CCompositeType)lvalueType).getMembers().get(0);
                region = this.regionMgr.makeMemoryRegion(lvalueType, memberDeclaration);
            }
            this.addSemiexactRetentionConstraints(pattern, region, startAddress, size, regionsToRetain);
        } else {
            this.addInexactRetentionConstraints(startAddress, size, regionsToRetain);
        }
    }

    private void makeRetentionConstraints(Set<MemoryRegion> regions, Function<MemoryRegion, ? extends Iterable<PointerTarget>> targetLookup, BiConsumer<Formula, BooleanFormula> constraintConsumer) throws InterruptedException {
        for (MemoryRegion region : regions) {
            String ufName = this.regionMgr.getPointerAccessName(region);
            int oldIndex = this.conv.getIndex(ufName, region.getType(), this.ssa);
            int newIndex = this.conv.getFreshIndex(ufName, region.getType(), this.ssa);
            FormulaType<?> targetType = this.conv.getFormulaTypeFromCType(region.getType());
            for (PointerTarget target : targetLookup.apply(region)) {
                this.regionMgr.addTargetToStats(this.edge, ufName, target);
                this.conv.shutdownNotifier.shutdownIfNecessary();
                Formula targetAddress = this.conv.makeFormulaForTarget(target);
                constraintConsumer.accept(targetAddress, this.conv.makeRetentionConstraint(ufName, oldIndex, newIndex, targetType, targetAddress));
            }
        }
    }

    private void addSimpleTypeRetentionConstraints(PointerTargetPattern pattern, Set<MemoryRegion> regions, Formula startAddress) throws InterruptedException {
        if (!pattern.isExact()) {
            this.makeRetentionConstraints(regions, region -> this.pts.getMatchingTargets((MemoryRegion)region, pattern), (targetAddress, constraint) -> {
                BooleanFormula updateCondition = this.fmgr.makeEqual(targetAddress, startAddress);
                this.constraints.addConstraint(this.bfmgr.or(updateCondition, (BooleanFormula)constraint));
            });
        }
        this.addExactRetentionConstraints(pattern, regions);
    }

    private void addExactRetentionConstraints(Predicate<PointerTarget> pattern, Set<MemoryRegion> regions) throws InterruptedException {
        this.makeRetentionConstraints(regions, region -> this.pts.getNonMatchingTargets((MemoryRegion)region, pattern), (targetAddress, constraint) -> this.constraints.addConstraint((BooleanFormula)constraint));
    }

    private void addSemiexactRetentionConstraints(PointerTargetPattern pattern, MemoryRegion firstElementRegion, Formula startAddress, long size, Set<MemoryRegion> regions) throws InterruptedException {
        for (PointerTarget target : this.pts.getMatchingTargets(firstElementRegion, pattern)) {
            Formula candidateAddress = this.conv.makeFormulaForTarget(target);
            BooleanFormula negAntecedent = this.bfmgr.not(this.fmgr.makeEqual(candidateAddress, startAddress));
            Predicate<PointerTarget> exact = PointerTargetPattern.forRange(target.getBase(), target.getOffset(), size);
            ArrayList<BooleanFormula> consequent = new ArrayList<BooleanFormula>();
            this.makeRetentionConstraints(regions, region -> this.pts.getNonMatchingTargets((MemoryRegion)region, exact), (targetAddress, constraint) -> consequent.add((BooleanFormula)constraint));
            this.constraints.addConstraint(this.bfmgr.or(negAntecedent, this.bfmgr.and(consequent)));
        }
    }

    private void addInexactRetentionConstraints(Formula startAddress, long size, Set<MemoryRegion> regions) throws InterruptedException {
        this.makeRetentionConstraints(regions, region -> this.pts.getAllTargets((MemoryRegion)region), (targetAddress, constraint) -> {
            BooleanFormula updateCondition = this.fmgr.makeElementIndexConstraint(targetAddress, startAddress, size, false);
            this.constraints.addConstraint(this.bfmgr.or(updateCondition, (BooleanFormula)constraint));
        });
    }

    private void updateSSA(Set<MemoryRegion> regions, SSAMap.SSAMapBuilder pSsa) {
        for (MemoryRegion region : regions) {
            String ufName = this.regionMgr.getPointerAccessName(region);
            this.conv.makeFreshIndex(ufName, region.getType(), pSsa);
        }
    }
}

