/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;

class BaseVisitor
extends DefaultCExpressionVisitor<Variable, UnrecognizedCodeException> {
    private final PointerTargetSetBuilder pts;
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final CFAEdge cfaEdge;
    private @Nullable Variable lastBase = null;

    BaseVisitor(CFAEdge cfaEdge, PointerTargetSetBuilder pts, TypeHandlerWithPointerAliasing pTypeHandler) {
        this.cfaEdge = cfaEdge;
        this.pts = pts;
        this.typeHandler = pTypeHandler;
    }

    @Override
    protected Variable visitDefault(CExpression pExp) throws UnrecognizedCodeException {
        throw new UnrecognizedCodeException("unexpected expression in lvalue", this.cfaEdge, pExp);
    }

    @Override
    public Variable visit(CArraySubscriptExpression e) throws UnrecognizedCodeException {
        return null;
    }

    @Override
    public Variable visit(CBinaryExpression e) throws UnrecognizedCodeException {
        return null;
    }

    @Override
    public Variable visit(CCastExpression e) throws UnrecognizedCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public Variable visit(CComplexCastExpression e) throws UnrecognizedCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public Variable visit(CFieldReference e) throws UnrecognizedCodeException {
        Variable base = (e = e.withExplicitPointerDereference()).getFieldOwner().accept(this);
        if (base != null) {
            return Variable.create(CToFormulaConverterWithPointerAliasing.getFieldAccessName(base.getName(), e), this.typeHandler.getSimplifiedType(e));
        }
        return null;
    }

    @Override
    public Variable visit(CIdExpression e) throws UnrecognizedCodeException {
        CType type = this.typeHandler.getSimplifiedType(e);
        if (!this.pts.isActualBase(e.getDeclaration().getQualifiedName()) && !CTypeUtils.containsArray(type, e.getDeclaration())) {
            this.lastBase = Variable.create(e.getDeclaration().getQualifiedName(), type);
            return this.lastBase;
        }
        return null;
    }

    @Override
    public Variable visit(CIntegerLiteralExpression e) throws UnrecognizedCodeException {
        return null;
    }

    @Override
    public Variable visit(CPointerExpression e) throws UnrecognizedCodeException {
        return null;
    }

    @Nullable Variable getLastBase() {
        return this.lastBase;
    }
}

