/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AbstractMemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class BnBRegionManager
extends AbstractMemoryRegionManager
implements MemoryRegionManager {
    private static final String GLOBAL = "global";
    private static final String SEPARATOR = ":";
    private final Optional<VariableClassification> varClassification;
    private final Multimap<CType, String> fieldRegions;

    BnBRegionManager(Optional<VariableClassification> var, Multimap<CType, String> fieldRegions, TypeHandlerWithPointerAliasing pTypeHandler) {
        super(pTypeHandler);
        this.fieldRegions = fieldRegions;
        this.varClassification = var;
    }

    @Override
    public MemoryRegion makeMemoryRegion(CType pType) {
        Preconditions.checkNotNull((Object)pType);
        CTypeUtils.checkIsSimplified(pType);
        return new GlobalBnBRegion(pType);
    }

    @Override
    public MemoryRegion makeMemoryRegion(CType pFieldOwnerType, CType pFieldType, String pFieldName) {
        Preconditions.checkNotNull((Object)pFieldOwnerType);
        Preconditions.checkNotNull((Object)pFieldType);
        Preconditions.checkNotNull((Object)pFieldName);
        CTypeUtils.checkIsSimplified(pFieldOwnerType);
        CTypeUtils.checkIsSimplified(pFieldType);
        if (this.fieldRegions.containsEntry((Object)pFieldOwnerType, (Object)pFieldName)) {
            return new FieldBnBRegion(pFieldOwnerType, pFieldType, pFieldName);
        }
        return new GlobalBnBRegion(pFieldType);
    }

    @Override
    public void printStatistics(PrintStream out) {
        Object bnbSize;
        super.printStatistics(out);
        if (this.varClassification.isPresent()) {
            VariableClassification var = this.varClassification.orElseThrow();
            int relevantSize = var.getRelevantFields().size();
            int addressedSize = var.getAddressedFields().size();
            out.println("Number of relevant fields:    " + relevantSize);
            out.println("Number of addressed fields:   " + addressedSize);
            bnbSize = StatisticsUtils.valueWithPercentage(this.fieldRegions.size(), relevantSize);
        } else {
            bnbSize = this.fieldRegions.size() + " ()";
        }
        out.println("Number of BnB memory regions: " + (String)bnbSize);
        out.println();
    }

    private static final class FieldBnBRegion
    implements MemoryRegion {
        private final CType fieldOwnerType;
        private final CType fieldType;
        private final String fieldName;

        FieldBnBRegion(CType pFieldOwnerType, CType pFieldType, String pFieldName) {
            this.fieldOwnerType = pFieldOwnerType;
            this.fieldType = pFieldType;
            this.fieldName = pFieldName;
        }

        @Override
        public CType getType() {
            return this.fieldType;
        }

        @Override
        public String getName(TypeHandlerWithPointerAliasing typeHandler) {
            return typeHandler.getPointerAccessNameForType(this.fieldOwnerType) + BnBRegionManager.SEPARATOR + this.fieldName;
        }

        public String toString() {
            return "FieldBnBRegion [fieldOwnerType=" + this.fieldOwnerType + ", fieldType=" + this.fieldType + ", fieldName=" + this.fieldName + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.fieldType.hashCode();
            result = 31 * result + this.fieldOwnerType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldBnBRegion other = (FieldBnBRegion)obj;
            return this.fieldName.equals(other.fieldName) && this.fieldType.equals(other.fieldType) && this.fieldOwnerType.equals(other.fieldOwnerType);
        }
    }

    private static final class GlobalBnBRegion
    implements MemoryRegion {
        private final CType type;

        public String toString() {
            return "GlobalBnBRegion [type=" + this.type + "]";
        }

        GlobalBnBRegion(CType pType) {
            this.type = pType;
        }

        @Override
        public CType getType() {
            return this.type;
        }

        @Override
        public String getName(TypeHandlerWithPointerAliasing typeHandler) {
            return typeHandler.getPointerAccessNameForType(this.type) + ":global";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GlobalBnBRegion other = (GlobalBnBRegion)obj;
            return this.type.equals(other.type);
        }
    }
}

