/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.AdaptingCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinFunctions;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;
import org.sosy_lab.cpachecker.util.OverflowAssumptionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.BaseVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerApproximatingVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Variable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

class CExpressionVisitorWithPointerAliasing
extends DefaultCExpressionVisitor<Expression, UnrecognizedCodeException>
implements CRightHandSideVisitor<Expression, UnrecognizedCodeException> {
    private final CToFormulaConverterWithPointerAliasing conv;
    private final TypeHandlerWithPointerAliasing typeHandler;
    private final OverflowAssumptionManager ofmgr;
    private final CFAEdge edge;
    private final SSAMap.SSAMapBuilder ssa;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;
    private final PointerTargetSetBuilder pts;
    private final MemoryRegionManager regionMgr;
    private String function;
    private final ExpressionToFormulaVisitor delegate;
    private final List<CompositeField> usedFields = new ArrayList<CompositeField>(1);
    private final List<CompositeField> initializedFields = new ArrayList<CompositeField>();
    private final List<CompositeField> addressedFields = new ArrayList<CompositeField>();
    private final Map<String, CType> learnedPointerTypes = Maps.newHashMapWithExpectedSize((int)1);

    CExpressionVisitorWithPointerAliasing(CToFormulaConverterWithPointerAliasing cToFormulaConverter, CFAEdge cfaEdge, String function, SSAMap.SSAMapBuilder ssa, Constraints constraints, ErrorConditions errorConditions, PointerTargetSetBuilder pts, MemoryRegionManager regionMgr) {
        this.delegate = new ExpressionToFormulaVisitor(cToFormulaConverter, cToFormulaConverter.fmgr, cfaEdge, function, ssa, constraints){

            @Override
            protected Formula toFormula(CExpression e) throws UnrecognizedCodeException {
                return CExpressionVisitorWithPointerAliasing.this.asValueFormula(e.accept(CExpressionVisitorWithPointerAliasing.this), CExpressionVisitorWithPointerAliasing.this.typeHandler.getSimplifiedType(e));
            }
        };
        this.conv = cToFormulaConverter;
        this.typeHandler = cToFormulaConverter.typeHandler;
        this.ofmgr = new OverflowAssumptionManager(this.conv.machineModel, (LogManager)this.conv.logger);
        this.edge = cfaEdge;
        this.ssa = ssa;
        this.constraints = constraints;
        this.errorConditions = errorConditions;
        this.pts = pts;
        this.regionMgr = regionMgr;
        this.function = function;
    }

    CRightHandSideVisitor<Formula, UnrecognizedCodeException> asFormulaVisitor() {
        return new AdaptingExpressionToFormulaVisitor(this);
    }

    private void addEqualBaseAddressConstraint(Formula p1, Formula p2) {
        if (this.errorConditions.isEnabled()) {
            this.constraints.addConstraint(this.conv.fmgr.makeEqual(this.conv.makeBaseAddressOfTerm(p1), this.conv.makeBaseAddressOfTerm(p2)));
        }
    }

    private Formula asValueFormula(Expression e, CType type, boolean isSafe) {
        if (e.isNondetValue()) {
            String nondetName = "__nondet_value_" + CTypeUtils.typeToString(type).replace(' ', '_');
            return this.conv.makeNondet(nondetName, type, this.ssa, this.constraints);
        }
        if (e.isValue()) {
            return e.asValue().getValue();
        }
        if (e.isAliasedLocation()) {
            MemoryRegion region = e.asAliasedLocation().getMemoryRegion();
            if (region == null) {
                region = this.regionMgr.makeMemoryRegion(type);
            }
            return !isSafe ? this.conv.makeDereference(type, e.asAliasedLocation().getAddress(), this.ssa, this.errorConditions, region) : this.conv.makeSafeDereference(type, e.asAliasedLocation().getAddress(), this.ssa, region);
        }
        return this.conv.makeVariable(e.asUnaliasedLocation().getVariableName(), type, this.ssa);
    }

    Formula asValueFormula(Expression e, CType type) {
        return this.asValueFormula(e, type, false);
    }

    private Formula asSafeValueFormula(Expression e, CType type) {
        return this.asValueFormula(e, type, true);
    }

    private Expression.Location.AliasedLocation dereference(CExpression pE, Expression pResult) {
        CType type = this.typeHandler.getSimplifiedType(pE);
        if (pResult.isAliasedLocation() && (type instanceof CCompositeType || type instanceof CArrayType && (!(pE instanceof CIdExpression) || !(((CIdExpression)pE).getDeclaration() instanceof CParameterDeclaration)))) {
            return pResult.asAliasedLocation();
        }
        return Expression.Location.AliasedLocation.ofAddress(this.asValueFormula(pResult, CTypeUtils.implicitCastToPointer(type)));
    }

    @Override
    public Expression.Location.AliasedLocation visit(CArraySubscriptExpression e) throws UnrecognizedCodeException {
        CExpression arrayExpression = e.getArrayExpression();
        Expression.Location.AliasedLocation base = this.dereference(arrayExpression, arrayExpression.accept(this));
        assert (base.isAliasedLocation()) : "Not the location of the first array element";
        CType elementType = this.typeHandler.getSimplifiedType(e);
        CExpression subscript = e.getSubscriptExpression();
        CType subscriptType = this.typeHandler.getSimplifiedType(subscript);
        Formula index = this.conv.makeCast(subscriptType, CPointerType.POINTER_TO_VOID, this.asValueFormula(subscript.accept(this), subscriptType), this.constraints, this.edge);
        Object coeff = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, this.conv.getSizeof(elementType));
        Formula baseAddress = ((Expression)base).asAliasedLocation().getAddress();
        Formula address = this.conv.fmgr.makePlus(baseAddress, this.conv.fmgr.makeMultiply(coeff, index));
        this.addEqualBaseAddressConstraint(baseAddress, address);
        return Expression.Location.AliasedLocation.ofAddress(address);
    }

    @Override
    public Expression visit(CFieldReference e) throws UnrecognizedCodeException {
        BaseVisitor baseVisitor;
        Variable variable = (e = e.withExplicitPointerDereference()).accept(baseVisitor = new BaseVisitor(this.edge, this.pts, this.typeHandler));
        if (variable != null) {
            String variableName = variable.getName();
            return Expression.Location.UnaliasedLocation.ofVariableName(variableName);
        }
        CType fieldOwnerType = this.typeHandler.getSimplifiedType(e.getFieldOwner());
        if (fieldOwnerType instanceof CCompositeType) {
            Expression.Location.AliasedLocation base = e.getFieldOwner().accept(this).asAliasedLocation();
            String fieldName = e.getFieldName();
            this.usedFields.add(CompositeField.of((CCompositeType)fieldOwnerType, fieldName));
            OptionalLong fieldOffset = this.typeHandler.getOffset((CCompositeType)fieldOwnerType, fieldName);
            if (!fieldOffset.isPresent()) {
                return Expression.Value.nondetValue();
            }
            Object offset = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, fieldOffset.orElseThrow());
            Formula address = this.conv.fmgr.makePlus(base.getAddress(), offset);
            this.addEqualBaseAddressConstraint(base.getAddress(), address);
            CType fieldType = this.typeHandler.simplifyType(e.getExpressionType());
            MemoryRegion region = this.regionMgr.makeMemoryRegion(fieldOwnerType, fieldType, fieldName);
            return Expression.Location.AliasedLocation.ofAddressWithRegion(address, region);
        }
        throw new UnrecognizedCodeException("Field owner of a non-composite type", this.edge, e);
    }

    static boolean isRevealingType(CType type) {
        return (type instanceof CPointerType || type instanceof CArrayType) && !type.equals(CPointerType.POINTER_TO_VOID);
    }

    private PointerApproximatingVisitor getPointerApproximatingVisitor() {
        return new PointerApproximatingVisitor(this.typeHandler, this.edge);
    }

    @Override
    public Expression visit(CCastExpression e) throws UnrecognizedCodeException {
        CType resultType = this.typeHandler.getSimplifiedType(e);
        CExpression operand = this.conv.makeCastFromArrayToPointerIfNecessary(e.getOperand(), resultType);
        Expression result = operand.accept(this);
        if (CExpressionVisitorWithPointerAliasing.isRevealingType(resultType)) {
            operand.accept(this.getPointerApproximatingVisitor()).ifPresent(s -> this.learnedPointerTypes.put((String)s, resultType));
        }
        CType operandType = this.typeHandler.getSimplifiedType(operand);
        if (CTypeUtils.isSimpleType(resultType)) {
            return Expression.Value.ofValue(this.conv.makeCast(operandType, resultType, this.asValueFormula(result, operandType), this.constraints, this.edge));
        }
        if (CTypes.withoutConst(resultType).equals(CTypes.withoutConst(operandType))) {
            return result;
        }
        throw new UnrecognizedCodeException("Conversion to non-scalar type requested", this.edge, e);
    }

    @Override
    public Expression visit(CIdExpression e) throws UnrecognizedCodeException {
        CType resultType = this.typeHandler.getSimplifiedType(e);
        String variableName = e.getDeclaration().getQualifiedName();
        if (!this.pts.isActualBase(variableName) && !CTypeUtils.containsArray(resultType, e.getDeclaration())) {
            if (!(e.getDeclaration() instanceof CFunctionDeclaration)) {
                return Expression.Location.UnaliasedLocation.ofVariableName(variableName);
            }
            return Expression.Value.ofValue(this.conv.makeConstant(variableName, resultType));
        }
        Formula address = this.conv.makeBaseAddress(variableName, resultType);
        return Expression.Location.AliasedLocation.ofAddress(address);
    }

    @Override
    public Expression.Value visit(CUnaryExpression e) throws UnrecognizedCodeException {
        if (e.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            BaseVisitor baseVisitor;
            CExpression operand = e.getOperand();
            Variable baseVariable = operand.accept(baseVisitor = new BaseVisitor(this.edge, this.pts, this.typeHandler));
            if (baseVariable == null) {
                Expression.Location.AliasedLocation addressExpression = null;
                ImmutableList alreadyUsedFields = ImmutableList.copyOf(this.usedFields);
                this.usedFields.clear();
                if (this.errorConditions.isEnabled() && operand instanceof CFieldReference) {
                    CFieldReference field = (CFieldReference)operand;
                    CExpression fieldOwner = field.getFieldOwner();
                    boolean isDeref = field.isPointerDereference();
                    if (!isDeref && fieldOwner instanceof CPointerExpression) {
                        fieldOwner = ((CPointerExpression)fieldOwner).getOperand();
                        isDeref = true;
                    }
                    if (isDeref) {
                        CPointerType pointerType = (CPointerType)this.typeHandler.getSimplifiedType(fieldOwner);
                        Formula base = this.asSafeValueFormula(fieldOwner.accept(this), pointerType);
                        String fieldName = field.getFieldName();
                        CCompositeType compositeType = (CCompositeType)CTypeUtils.checkIsSimplified(pointerType.getType());
                        this.usedFields.add(CompositeField.of(compositeType, fieldName));
                        long fieldOffset = this.typeHandler.getOffset(compositeType, fieldName).orElseThrow(() -> new UnrecognizedCodeException("Taking address of bit fields is not allowed", e));
                        Object offset = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, fieldOffset);
                        addressExpression = Expression.Location.AliasedLocation.ofAddress(this.conv.fmgr.makePlus(base, offset));
                        this.addEqualBaseAddressConstraint(base, addressExpression.getAddress());
                    }
                }
                if (addressExpression == null) {
                    addressExpression = operand.accept(this).asAliasedLocation();
                }
                this.addressedFields.addAll(this.usedFields);
                this.usedFields.addAll((Collection<CompositeField>)alreadyUsedFields);
                return Expression.Value.ofValue(addressExpression.getAddress());
            }
            if (operand instanceof CIdExpression && this.typeHandler.simplifyType(operand.getExpressionType()) instanceof CArrayType && ((CIdExpression)operand).getDeclaration() instanceof CParameterDeclaration) {
                return Expression.Value.ofValue(this.dereference(operand, operand.accept(this)).getAddress());
            }
            Variable base = baseVisitor.getLastBase();
            Formula baseAddress = this.conv.makeBaseAddress(base.getName(), base.getType());
            this.conv.addValueImportConstraints(baseAddress, base.getName(), base.getType(), this.initializedFields, this.ssa, this.constraints, null);
            if (this.pts.isPreparedBase(base.getName())) {
                this.pts.shareBase(base.getName(), base.getType());
            } else {
                Object size = this.conv.fmgr.makeNumber(this.conv.voidPointerFormulaType, this.typeHandler.getSizeof(base.getType()));
                this.pts.addBase(base.getName(), base.getType(), (Formula)size, this.constraints);
            }
            return this.visit(e);
        }
        return this.visitDefault(e);
    }

    @Override
    public Expression.Location.AliasedLocation visit(CPointerExpression e) throws UnrecognizedCodeException {
        CExpression operand = e.getOperand();
        return this.dereference(operand, operand.accept(this));
    }

    @Override
    public Expression.Value visit(CBinaryExpression exp) throws UnrecognizedCodeException {
        CType returnType = exp.getExpressionType();
        CType calculationType = exp.getCalculationType();
        Formula f1 = this.delegate.processOperand(exp.getOperand1(), calculationType, returnType);
        Formula f2 = this.delegate.processOperand(exp.getOperand2(), calculationType, returnType);
        Formula result = this.delegate.handleBinaryExpression(exp, f1, f2);
        CType t1 = this.typeHandler.getSimplifiedType(exp.getOperand1());
        CType t2 = this.typeHandler.getSimplifiedType(exp.getOperand2());
        if (t1.equals(CPointerType.POINTER_TO_VOID) || t2.equals(CPointerType.POINTER_TO_VOID)) {
            if (CExpressionVisitorWithPointerAliasing.isRevealingType(t1)) {
                exp.getOperand2().accept(this.getPointerApproximatingVisitor()).ifPresent(s -> this.learnedPointerTypes.put((String)s, t1));
            } else if (CExpressionVisitorWithPointerAliasing.isRevealingType(t2)) {
                exp.getOperand1().accept(this.getPointerApproximatingVisitor()).ifPresent(s -> this.learnedPointerTypes.put((String)s, t2));
            }
        }
        CBinaryExpression.BinaryOperator op = exp.getOperator();
        switch (op) {
            case PLUS: {
                if (t1 instanceof CPointerType) {
                    this.addEqualBaseAddressConstraint(result, f1);
                }
                if (!(t2 instanceof CPointerType)) break;
                this.addEqualBaseAddressConstraint(result, f2);
                break;
            }
        }
        return Expression.Value.ofValue(result);
    }

    @Override
    protected Expression.Value visitDefault(CExpression e) throws UnrecognizedCodeException {
        return Expression.Value.ofValue(e.accept(this.delegate));
    }

    @Override
    public Expression.Value visit(CFunctionCallExpression e) throws UnrecognizedCodeException {
        CType resultType;
        CExpression functionNameExpression = e.getFunctionNameExpression();
        if (functionNameExpression instanceof CIdExpression) {
            List<CExpression> parameters;
            String functionName = ((CIdExpression)functionNameExpression).getName();
            if (this.conv.options.isDynamicMemoryFunction(functionName)) {
                DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this.conv, this.edge, this.ssa, this.pts, this.constraints, this.errorConditions, this.regionMgr);
                try {
                    return memoryHandler.handleDynamicMemoryFunction(e, functionName, this);
                }
                catch (InterruptedException exc) {
                    throw CtoFormulaConverter.propagateInterruptedException(exc);
                }
            }
            if (BuiltinFloatFunctions.matchesModf(functionName)) {
                CSimpleType returnType = BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(functionName);
                parameters = e.getParameterExpressions();
                String trunc = BuiltinFloatFunctions.getAppropriateTruncName(returnType);
                FileLocation dummy = FileLocation.DUMMY;
                CPointerExpression lhs = new CPointerExpression(dummy, returnType, parameters.get(1));
                CFunctionDeclaration functionDecl = new CFunctionDeclaration(dummy, CFunctionType.functionTypeWithReturnType(returnType), trunc, (List<CParameterDeclaration>)ImmutableList.of((Object)new CParameterDeclaration(dummy, returnType, "irrelevant_parameter_name")), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
                CFunctionCallExpression rhs = new CFunctionCallExpression(dummy, returnType, new CIdExpression(dummy, functionDecl), Collections.singletonList(parameters.get(0)), functionDecl);
                BooleanFormula form = null;
                try {
                    form = this.conv.makeAssignment(lhs, lhs, rhs, this.edge, this.function, this.ssa, this.pts, this.constraints, this.errorConditions);
                }
                catch (InterruptedException e1) {
                    CtoFormulaConverter.propagateInterruptedException(e1);
                }
                this.constraints.addConstraint((BooleanFormula)Preconditions.checkNotNull(form));
            }
            if (BuiltinFunctions.matchesStrlen(functionName)) {
                int maxIndex = this.conv.options.maxPreciseStrFunctionSize();
                parameters = e.getParameterExpressions();
                assert (parameters.size() == 1);
                CExpression parameter = parameters.get(0);
                CType returnType = e.getExpressionType();
                Formula f = this.conv.makeNondet(functionName, returnType, this.ssa, this.constraints);
                for (long i = (long)maxIndex; i >= 0L; --i) {
                    f = this.stringEndsAtIndexOrOtherwise(parameter, i, f, returnType);
                }
                return Expression.Value.ofValue(f);
            }
            if (functionName.equals("memcmp") || functionName.equals("strcmp") || functionName.equals("strncmp")) {
                return this.handleCmpFunction(functionName, e);
            }
            if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(functionName)) {
                List<CExpression> parameters2 = e.getParameterExpressions();
                assert (parameters2.size() == 3);
                CExpression var1 = parameters2.get(0);
                CExpression var2 = parameters2.get(1);
                CExpression var3 = parameters2.get(2);
                Expression overflows = BuiltinOverflowFunctions.handleOverflow(this.ofmgr, var1, var2, var3, functionName).accept(this);
                Formula f = this.asValueFormula(overflows, CNumericTypes.BOOL);
                if (!BuiltinOverflowFunctions.isFunctionWithoutSideEffect(functionName)) {
                    CPointerExpression lhs = new CPointerExpression(FileLocation.DUMMY, ((CPointerType)var3.getExpressionType()).getType(), var3);
                    CExpression rhs = BuiltinOverflowFunctions.handleOverflowSideeffects(this.ofmgr, var1, var2, var3, functionName);
                    BooleanFormula form = null;
                    try {
                        form = this.conv.makeAssignment(lhs, lhs, rhs, this.edge, this.function, this.ssa, this.pts, this.constraints, this.errorConditions);
                    }
                    catch (InterruptedException e1) {
                        CtoFormulaConverter.propagateInterruptedException(e1);
                    }
                    this.constraints.addConstraint((BooleanFormula)Preconditions.checkNotNull(form));
                }
                return Expression.Value.ofValue(f);
            }
        }
        if ((resultType = this.conv.getReturnType(e, this.edge)) instanceof CCompositeType || CTypeUtils.containsArrayOutsideFunctionParameter(resultType)) {
            this.conv.logger.logfOnce(Level.WARNING, "Extern function %s returning a composite is treated as nondet.", new Object[]{e});
            return Expression.Value.nondetValue();
        }
        return Expression.Value.ofValue(this.delegate.visit(e));
    }

    private Expression.Value handleCmpFunction(String functionName, CFunctionCallExpression e) throws UnrecognizedCodeException {
        Formula sizeFormula;
        CType sizeType;
        List<CExpression> parameters = e.getParameterExpressions();
        assert (parameters.size() == 2 || parameters.size() == 3);
        CExpression s1 = parameters.get(0);
        CExpression s2 = parameters.get(1);
        CSimpleType returnType = (CSimpleType)e.getExpressionType().getCanonicalType();
        boolean signed = false;
        CSimpleType uChar = CNumericTypes.UNSIGNED_CHAR;
        boolean checkStringEnd = functionName.startsWith("str");
        boolean hasBounds = parameters.size() == 3;
        long maxIndex = this.conv.options.maxPreciseStrFunctionSize();
        if (hasBounds) {
            CExpression size = parameters.get(2);
            if (size instanceof CIntegerLiteralExpression) {
                maxIndex = Math.min(maxIndex, ((CIntegerLiteralExpression)size).asLong());
            }
            sizeType = e.getDeclaration().getParameters().get(2).getType().getCanonicalType();
            sizeFormula = this.asValueFormula(size.accept(this), sizeType);
            sizeFormula = this.conv.makeCast(size.getExpressionType(), sizeType, sizeFormula, this.constraints, this.edge);
        } else {
            sizeType = this.conv.machineModel.getPointerEquivalentSimpleType();
            sizeFormula = null;
        }
        Formula stringTerminator = this.delegate.visit(CIntegerLiteralExpression.createDummyLiteral(0L, uChar));
        Formula result = this.conv.makeNondet(functionName, returnType, this.ssa, this.constraints);
        Formula zero = this.delegate.visit(CIntegerLiteralExpression.createDummyLiteral(0L, returnType));
        BooleanFormula resultIsPos = this.conv.fmgr.makeGreaterThan(result, zero, true);
        BooleanFormula resultIsNeg = this.conv.fmgr.makeLessThan(result, zero, true);
        BooleanFormula isGreater = resultIsPos;
        BooleanFormula isLess = resultIsNeg;
        for (long index = maxIndex; index >= 0L; --index) {
            CIntegerLiteralExpression indexLiteral = CIntegerLiteralExpression.createDummyLiteral(index, sizeType);
            CArraySubscriptExpression s1AtIndexExp = new CArraySubscriptExpression(FileLocation.DUMMY, uChar, s1, indexLiteral);
            CArraySubscriptExpression s2AtIndexExp = new CArraySubscriptExpression(FileLocation.DUMMY, uChar, s2, indexLiteral);
            Formula s1AtIndex = this.asValueFormula(this.visit(s1AtIndexExp), uChar);
            Formula s2AtIndex = this.asValueFormula(this.visit(s2AtIndexExp), uChar);
            BooleanFormula isEqualAtIndex = this.conv.fmgr.makeEqual(s1AtIndex, s2AtIndex);
            BooleanFormula isLessAtIndex = this.conv.fmgr.makeLessThan(s1AtIndex, s2AtIndex, false);
            BooleanFormula isGreaterAtIndex = this.conv.fmgr.makeGreaterThan(s1AtIndex, s2AtIndex, false);
            if (checkStringEnd) {
                BooleanFormula isStringEnd = this.conv.fmgr.makeEqual(s1AtIndex, stringTerminator);
                isEqualAtIndex = this.conv.bfmgr.and(isEqualAtIndex, this.conv.bfmgr.not(isStringEnd));
            }
            isLess = this.conv.bfmgr.or(isLessAtIndex, this.conv.bfmgr.and(isEqualAtIndex, isLess));
            isGreater = this.conv.bfmgr.or(isGreaterAtIndex, this.conv.bfmgr.and(isEqualAtIndex, isGreater));
            if (!hasBounds) continue;
            Formula indexFormula = this.asValueFormula((Expression)this.visit(indexLiteral), sizeType);
            BooleanFormula boundNotReached = this.conv.fmgr.makeLessThan(indexFormula, sizeFormula, false);
            isLess = this.conv.bfmgr.and(isLess, boundNotReached);
            isGreater = this.conv.bfmgr.and(isGreater, boundNotReached);
        }
        this.constraints.addConstraint(this.conv.bfmgr.equivalence(resultIsPos, isGreater));
        this.constraints.addConstraint(this.conv.bfmgr.equivalence(resultIsNeg, isLess));
        return Expression.Value.ofValue(result);
    }

    private Formula stringEndsAtIndexOrOtherwise(CExpression parameter, Long index, Formula otherwise, CType returnType) throws UnrecognizedCodeException {
        Expression.Location.AliasedLocation parameterAtIndex = this.visit(new CArraySubscriptExpression(FileLocation.DUMMY, CNumericTypes.CHAR, parameter, CIntegerLiteralExpression.createDummyLiteral(index, CNumericTypes.UNSIGNED_INT)));
        Formula nullTerminator = this.delegate.visit(CIntegerLiteralExpression.createDummyLiteral(0L, CNumericTypes.CHAR));
        BooleanFormula condition = this.conv.fmgr.makeEqual(this.asValueFormula(parameterAtIndex, CNumericTypes.CHAR), nullTerminator);
        return this.conv.bfmgr.ifThenElse(condition, this.conv.fmgr.makeNumber(this.conv.getFormulaTypeFromCType(returnType), index), otherwise);
    }

    List<CompositeField> getUsedFields() {
        return Collections.unmodifiableList(this.usedFields);
    }

    List<CompositeField> getInitializedFields() {
        return Collections.unmodifiableList(this.initializedFields);
    }

    List<CompositeField> getAddressedFields() {
        return Collections.unmodifiableList(this.addressedFields);
    }

    Map<String, CType> getLearnedPointerTypes() {
        return Collections.unmodifiableMap(this.learnedPointerTypes);
    }

    private static class AdaptingExpressionToFormulaVisitor
    extends AdaptingCExpressionVisitor<Formula, Expression, UnrecognizedCodeException>
    implements CRightHandSideVisitor<Formula, UnrecognizedCodeException> {
        private AdaptingExpressionToFormulaVisitor(CExpressionVisitorWithPointerAliasing pDelegate) {
            super(pDelegate);
        }

        @Override
        protected Formula convert(Expression value, CExpression rhs) throws UnrecognizedCodeException {
            return this.convert0(value, rhs);
        }

        private Formula convert0(Expression value, CRightHandSide rhs) {
            CExpressionVisitorWithPointerAliasing v = (CExpressionVisitorWithPointerAliasing)this.delegate;
            CType type = v.typeHandler.getSimplifiedType(rhs);
            return v.asValueFormula(value, type);
        }

        @Override
        public Formula visit(CFunctionCallExpression e) throws UnrecognizedCodeException {
            return this.convert0(((CExpressionVisitorWithPointerAliasing)this.delegate).visit(e), e);
        }
    }
}

