/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CDefaults;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMapMerger;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.IsRelevantWithHavocAbstractionVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AssignmentHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.BnBRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CompositeField;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DefaultRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.smt.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

public class CToFormulaConverterWithPointerAliasing
extends CtoFormulaConverter {
    final LogManagerWithoutDuplicates logger;
    final FormulaManagerView fmgr;
    final BooleanFormulaManagerView bfmgr;
    final MachineModel machineModel;
    final ShutdownNotifier shutdownNotifier;
    private final @Nullable ArrayFormulaManagerView afmgr;
    final TypeHandlerWithPointerAliasing typeHandler;
    final PointerTargetSetManager ptsMgr;
    final FormulaType<?> voidPointerFormulaType;
    final Formula nullPointer;
    private MemoryRegionManager regionMgr;
    final FormulaEncodingWithPointerAliasingOptions options;
    private final Optional<VariableClassification> variableClassification;
    private static final String FIELD_NAME_SEPARATOR = "$";

    public CToFormulaConverterWithPointerAliasing(FormulaEncodingWithPointerAliasingOptions pOptions, FormulaManagerView formulaManagerView, MachineModel pMachineModel, Optional<VariableClassification> pVariableClassification, LogManager logger, ShutdownNotifier pShutdownNotifier, TypeHandlerWithPointerAliasing pTypeHandler, AnalysisDirection pDirection) throws InvalidConfigurationException {
        super(pOptions, formulaManagerView, pMachineModel, pVariableClassification, logger, pShutdownNotifier, pTypeHandler, pDirection);
        this.logger = ((CtoFormulaConverter)this).logger;
        this.fmgr = ((CtoFormulaConverter)this).fmgr;
        this.bfmgr = ((CtoFormulaConverter)this).bfmgr;
        this.machineModel = ((CtoFormulaConverter)this).machineModel;
        this.shutdownNotifier = ((CtoFormulaConverter)this).shutdownNotifier;
        if (pDirection == AnalysisDirection.BACKWARD) {
            throw new InvalidConfigurationException("Backward formula construction is not yet implemented for pointer aliasing.");
        }
        this.variableClassification = pVariableClassification;
        this.options = pOptions;
        this.typeHandler = pTypeHandler;
        this.regionMgr = this.options.useMemoryRegions() ? this.buildBnBMemoryRegions() : new DefaultRegionManager(pTypeHandler);
        this.ptsMgr = new PointerTargetSetManager(this, this.options, this.fmgr, this.typeHandler, this.shutdownNotifier, this.regionMgr);
        this.afmgr = this.options.useArraysForHeap() ? this.fmgr.getArrayFormulaManager() : null;
        this.voidPointerFormulaType = this.typeHandler.getPointerType();
        this.nullPointer = this.fmgr.makeNumber(this.voidPointerFormulaType, 0L);
    }

    private MemoryRegionManager buildBnBMemoryRegions() {
        if (!this.variableClassification.isPresent()) {
            return new BnBRegionManager(this.variableClassification, (Multimap<CType, String>)ImmutableListMultimap.of(), this.typeHandler);
        }
        VariableClassification var = this.variableClassification.orElseThrow();
        Multimap<CCompositeType, String> relevant = var.getRelevantFields();
        Multimap<CCompositeType, String> addressed = var.getAddressedFields();
        HashMultimap bnb = HashMultimap.create();
        for (Map.Entry p : relevant.entries()) {
            if (addressed.containsEntry(p.getKey(), p.getValue())) continue;
            CType type = this.typeHandler.simplifyType((CType)p.getKey());
            bnb.put((Object)type, (Object)((String)p.getValue()));
        }
        return new BnBRegionManager(this.variableClassification, (Multimap<CType, String>)ImmutableListMultimap.copyOf((Multimap)bnb), this.typeHandler);
    }

    static String getFieldAccessName(String base, CCompositeType.CCompositeTypeMemberDeclaration member) {
        return base + FIELD_NAME_SEPARATOR + member.getName();
    }

    static String getFieldAccessName(String base, CFieldReference fieldAccess) {
        return base + FIELD_NAME_SEPARATOR + fieldAccess.getFieldName();
    }

    Formula makeBaseAddressOfTerm(Formula address) {
        if (this.options.useHavocAbstraction()) {
            return this.bfmgr.makeBoolean(true);
        }
        return this.ptsMgr.makePointerDereference("__BASE_ADDRESS_OF__", this.voidPointerFormulaType, address);
    }

    Formula makeBaseAddress(String baseName, CType baseType) {
        return this.makeConstant(PointerTargetSet.getBaseName(baseName), CTypeUtils.getBaseType(baseType));
    }

    @Override
    protected void checkSsaSavedType(String name, CType type, @Nullable CType ssaSavedType) {
        if (ssaSavedType != null && !ssaSavedType.equals(type)) {
            CTypeUtils.checkIsSimplified(ssaSavedType);
            CTypeUtils.checkIsSimplified(type);
            this.logger.logf(Level.FINEST, "Variable %s was found with multiple types! (Type1: %s, Type2: %s)", new Object[]{name, ssaSavedType, type});
        }
    }

    @Override
    public BooleanFormula makeSsaUpdateTerm(String symbolName, CType symbolType, int oldIndex, int newIndex, PointerTargetSet pts) throws InterruptedException {
        Preconditions.checkArgument((oldIndex > 0 && newIndex > oldIndex ? 1 : 0) != 0);
        if (TypeHandlerWithPointerAliasing.isPointerAccessSymbol(symbolName)) {
            if (!this.options.useMemoryRegions()) assert (symbolName.equals(this.typeHandler.getPointerAccessNameForType(symbolType)));
            if (this.options.useArraysForHeap()) {
                return this.makeSsaArrayMerger(symbolName, symbolType, oldIndex, newIndex);
            }
            return this.makeSsaUFMerger(symbolName, symbolType, oldIndex, newIndex, pts);
        }
        return super.makeSsaUpdateTerm(symbolName, symbolType, oldIndex, newIndex, pts);
    }

    private BooleanFormula makeSsaArrayMerger(String pFunctionName, CType pReturnType, int pOldIndex, int pNewIndex) {
        FormulaType<?> returnFormulaType = this.getFormulaTypeFromCType(pReturnType);
        ArrayFormula newArray = this.afmgr.makeArray(pFunctionName, pNewIndex, this.voidPointerFormulaType, returnFormulaType);
        ArrayFormula oldArray = this.afmgr.makeArray(pFunctionName, pOldIndex, this.voidPointerFormulaType, returnFormulaType);
        return this.fmgr.makeEqual(newArray, oldArray);
    }

    private BooleanFormula makeSsaUFMerger(String functionName, CType returnType, int oldIndex, int newIndex, PointerTargetSet pts) throws InterruptedException {
        FormulaType<?> returnFormulaType = this.getFormulaTypeFromCType(returnType);
        if (this.options.useQuantifiersOnArrays()) {
            Object counter = this.fmgr.makeVariableWithoutSSAIndex(this.voidPointerFormulaType, functionName + "__counter");
            return this.fmgr.getQuantifiedFormulaManager().forall((Formula)counter, this.makeRetentionConstraint(functionName, oldIndex, newIndex, returnFormulaType, (Formula)counter));
        }
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (PointerTarget target : pts.getAllTargets(functionName)) {
            this.shutdownNotifier.shutdownIfNecessary();
            Formula targetAddress = this.makeFormulaForTarget(target);
            result.add(this.makeRetentionConstraint(functionName, oldIndex, newIndex, returnFormulaType, targetAddress));
        }
        return this.bfmgr.and(result);
    }

    boolean hasIndex(String name, CType type, SSAMap.SSAMapBuilder ssa) {
        this.checkSsaSavedType(name, type, ssa.getType(name));
        return ssa.getIndex(name) > 0;
    }

    Formula makeDereference(CType type, Formula address, SSAMap.SSAMapBuilder ssa, ErrorConditions errorConditions, MemoryRegion region) {
        if (errorConditions.isEnabled()) {
            errorConditions.addInvalidDerefCondition(this.fmgr.makeEqual(address, this.nullPointer));
            errorConditions.addInvalidDerefCondition(this.fmgr.makeLessThan(address, this.makeBaseAddressOfTerm(address), false));
        }
        return this.makeSafeDereference(type, address, ssa, region);
    }

    Formula makeSafeDereference(CType type, Formula address, SSAMap.SSAMapBuilder ssa, MemoryRegion region) {
        CTypeUtils.checkIsSimplified(type);
        String ufName = this.regionMgr.getPointerAccessName(region);
        int index = this.getIndex(ufName, type, ssa);
        FormulaType<?> returnType = this.getFormulaTypeFromCType(type);
        return this.ptsMgr.makePointerDereference(ufName, returnType, index, address);
    }

    Formula makeFormulaForTarget(PointerTarget target) {
        return this.fmgr.makePlus(this.fmgr.makeVariableWithoutSSAIndex(this.voidPointerFormulaType, target.getBaseName()), this.fmgr.makeNumber(this.voidPointerFormulaType, target.getOffset()));
    }

    BooleanFormula makeRetentionConstraint(String targetName, int oldIndex, int newIndex, FormulaType<?> type, Formula targetAddress) {
        return this.fmgr.assignment(this.ptsMgr.makePointerDereference(targetName, type, newIndex, targetAddress), this.ptsMgr.makePointerDereference(targetName, type, oldIndex, targetAddress));
    }

    private boolean isAddressedVariable(CDeclaration var) {
        return !this.variableClassification.isPresent() || this.variableClassification.orElseThrow().getAddressedVariables().contains(var.getQualifiedName());
    }

    private void declareSharedBase(CDeclaration declaration, CSimpleDeclaration originalDeclaration, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException {
        assert (declaration.getType().equals(originalDeclaration.getType()));
        CType type = this.typeHandler.getSimplifiedType(declaration);
        CType decayedType = this.typeHandler.getSimplifiedType(originalDeclaration);
        if (originalDeclaration instanceof CParameterDeclaration && decayedType instanceof CArrayType) {
            decayedType = new CPointerType(false, false, ((CArrayType)decayedType).getType());
        }
        Formula size = decayedType.isIncomplete() ? null : this.getSizeExpression(decayedType, edge, function, ssa, pts, constraints, errorConditions);
        if (CTypeUtils.containsArray(type, originalDeclaration)) {
            pts.addBase(declaration.getQualifiedName(), type, size, constraints);
        } else if (this.isAddressedVariable(declaration) || !CTypeUtils.isSimpleType(decayedType)) {
            if (this.options.useConstraintOptimization()) {
                pts.prepareBase(declaration.getQualifiedName(), type, size, constraints);
            } else {
                pts.addBase(declaration.getQualifiedName(), type, size, constraints);
            }
        }
    }

    private Formula getSizeExpression(CType type, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException {
        if (type instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)type;
            Formula elementSize = this.getSizeExpression(arrayType.getType(), edge, function, ssa, pts, constraints, errorConditions);
            Formula elementCount = this.buildTerm(arrayType.getLength(), edge, function, ssa, pts, constraints, errorConditions);
            elementCount = this.makeCast(arrayType.getLength().getExpressionType(), CPointerType.POINTER_TO_VOID, elementCount, constraints, edge);
            return this.fmgr.makeMultiply(elementSize, elementCount);
        }
        return this.fmgr.makeNumber(this.voidPointerFormulaType, this.typeHandler.getSizeof(type));
    }

    void addValueImportConstraints(Formula address, String baseName, CType baseType, List<CompositeField> fields, SSAMap.SSAMapBuilder ssa, Constraints constraints, @Nullable MemoryRegion region) {
        assert (!CTypeUtils.containsArrayOutsideFunctionParameter(baseType)) : "Array access can't be encoded as a variable";
        if (baseType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)baseType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                OptionalLong offset = this.typeHandler.getOffset(compositeType, memberDeclaration);
                if (!offset.isPresent()) continue;
                CType memberType = this.typeHandler.getSimplifiedType(memberDeclaration);
                String newBaseName = CToFormulaConverterWithPointerAliasing.getFieldAccessName(baseName, memberDeclaration);
                if (!this.isRelevantField(compositeType, memberDeclaration)) continue;
                fields.add(CompositeField.of(compositeType, memberDeclaration));
                MemoryRegion newRegion = this.regionMgr.makeMemoryRegion(compositeType, memberDeclaration);
                this.addValueImportConstraints(this.fmgr.makePlus(address, this.fmgr.makeNumber(this.voidPointerFormulaType, offset.orElseThrow())), newBaseName, memberType, fields, ssa, constraints, newRegion);
            }
        } else if (!(baseType instanceof CFunctionType) && !baseType.isIncomplete() && this.hasIndex(baseName, baseType, ssa)) {
            MemoryRegion newRegion = region;
            if (newRegion == null) {
                newRegion = this.regionMgr.makeMemoryRegion(baseType);
            }
            constraints.addConstraint(this.fmgr.makeEqual(this.makeSafeDereference(baseType, address, ssa, newRegion), this.makeVariable(baseName, baseType, ssa)));
        }
        ssa.deleteVariable(baseName);
    }

    private static List<CExpressionAssignmentStatement> expandStringLiterals(List<CExpressionAssignmentStatement> assignments) throws UnrecognizedCodeException {
        ArrayList<CExpressionAssignmentStatement> result = new ArrayList<CExpressionAssignmentStatement>();
        for (CExpressionAssignmentStatement assignment : assignments) {
            CExpression rhs = assignment.getRightHandSide();
            if (rhs instanceof CStringLiteralExpression) {
                CArrayType lhsArrayType;
                CLeftHandSide lhs = assignment.getLeftHandSide();
                CType lhsType = lhs.getExpressionType();
                if (lhsType instanceof CArrayType) {
                    lhsArrayType = (CArrayType)lhsType;
                } else if (lhsType instanceof CPointerType) {
                    lhsArrayType = new CArrayType(false, false, ((CPointerType)lhsType).getType(), null);
                } else {
                    throw new UnrecognizedCodeException("Assigning string literal to " + lhsType, assignment);
                }
                List<CCharLiteralExpression> chars = ((CStringLiteralExpression)rhs).expandStringLiteral(lhsArrayType);
                int offset = 0;
                for (CCharLiteralExpression e : chars) {
                    result.add(new CExpressionAssignmentStatement(assignment.getFileLocation(), new CArraySubscriptExpression(lhs.getFileLocation(), lhsArrayType.getType(), lhs, new CIntegerLiteralExpression(lhs.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(offset))), e));
                    ++offset;
                }
                continue;
            }
            result.add(assignment);
        }
        return result;
    }

    private List<CExpressionAssignmentStatement> expandAssignmentList(CVariableDeclaration declaration, List<CExpressionAssignmentStatement> explicitAssignments) {
        CType variableType = this.typeHandler.getSimplifiedType(declaration);
        CIdExpression lhs = new CIdExpression(declaration.getFileLocation(), variableType, declaration.getName(), declaration);
        HashSet<String> alreadyAssigned = new HashSet<String>();
        for (CExpressionAssignmentStatement statement : explicitAssignments) {
            alreadyAssigned.add(statement.getLeftHandSide().toString());
        }
        ArrayList<CExpressionAssignmentStatement> defaultAssignments = new ArrayList<CExpressionAssignmentStatement>();
        this.expandAssignmentList(variableType, lhs, alreadyAssigned, defaultAssignments);
        defaultAssignments.addAll(explicitAssignments);
        return defaultAssignments;
    }

    private void expandAssignmentList(CType type, CLeftHandSide lhs, Set<String> alreadyAssigned, List<CExpressionAssignmentStatement> defaultAssignments) {
        if (alreadyAssigned.contains(lhs.toString())) {
            return;
        }
        CTypeUtils.checkIsSimplified(type);
        if (type instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)type;
            CType elementType = CTypeUtils.checkIsSimplified(arrayType.getType());
            OptionalInt length = arrayType.getLengthAsInt();
            if (length.isPresent()) {
                int l = Math.min(length.orElseThrow(), this.options.maxArrayLength());
                for (int i = 0; i < l; ++i) {
                    CArraySubscriptExpression newLhs = new CArraySubscriptExpression(lhs.getFileLocation(), elementType, lhs, new CIntegerLiteralExpression(lhs.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(i)));
                    this.expandAssignmentList(elementType, newLhs, alreadyAssigned, defaultAssignments);
                }
            }
        } else if (type instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)type;
            if (compositeType.getKind() == CComplexType.ComplexTypeKind.UNION) {
                return;
            }
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                CType memberType = memberDeclaration.getType();
                CFieldReference newLhs = new CFieldReference(lhs.getFileLocation(), memberType, memberDeclaration.getName(), lhs, false);
                this.expandAssignmentList(memberType, newLhs, alreadyAssigned, defaultAssignments);
            }
        } else {
            assert (CTypeUtils.isSimpleType(type));
            if (type.equals(CPointerType.POINTER_TO_CHAR) && alreadyAssigned.contains(lhs.toString() + "[0]")) {
                return;
            }
            CExpression initExp = ((CInitializerExpression)CDefaults.forType(type, lhs.getFileLocation())).getExpression();
            defaultAssignments.add(new CExpressionAssignmentStatement(lhs.getFileLocation(), lhs, initExp));
        }
    }

    @Override
    protected PointerTargetSetBuilder createPointerTargetSetBuilder(PointerTargetSet pts) {
        return new PointerTargetSetBuilder.RealPointerTargetSetBuilder(pts, this.typeHandler, this.ptsMgr, this.options, this.regionMgr);
    }

    @Override
    public SSAMapMerger.MergeResult<PointerTargetSet> mergePointerTargetSets(PointerTargetSet pPts1, PointerTargetSet pPts2, SSAMap.SSAMapBuilder pSsa) throws InterruptedException {
        return this.ptsMgr.mergePointerTargetSets(pPts1, pPts2, pSsa);
    }

    @Override
    protected CRightHandSideVisitor<Formula, UnrecognizedCodeException> createCRightHandSideVisitor(CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        CExpressionVisitorWithPointerAliasing rhsVisitor = new CExpressionVisitorWithPointerAliasing(this, pEdge, pFunction, pSsa, pConstraints, pErrorConditions, pPts, this.regionMgr);
        return rhsVisitor.asFormulaVisitor();
    }

    @Override
    protected BooleanFormula makeReturn(Optional<CAssignment> assignment, CReturnStatementEdge returnEdge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula result = super.makeReturn(assignment, returnEdge, function, ssa, pts, constraints, errorConditions);
        if (assignment.isPresent()) {
            CVariableDeclaration returnVariableDeclaraton = ((CFunctionEntryNode)returnEdge.getSuccessor().getEntryNode()).getReturnVariable().orElseThrow();
            this.declareSharedBase(returnVariableDeclaraton, returnVariableDeclaraton, returnEdge, function, ssa, pts, constraints, errorConditions);
        }
        return result;
    }

    @Override
    protected BooleanFormula makeAssignment(CLeftHandSide lhs, CLeftHandSide lhsForChecking, CRightHandSide rhs, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        CType lhsType = this.typeHandler.getSimplifiedType(lhs);
        if (this.isArrayAssignment(lhs, lhsType)) {
            lhsType = new CPointerType(lhsType.isConst(), lhsType.isVolatile(), ((CArrayType)lhsType).getType());
        }
        if (rhs instanceof CExpression) {
            rhs = this.makeCastFromArrayToPointerIfNecessary((CExpression)rhs, lhsType);
        }
        AssignmentHandler assignmentHandler = new AssignmentHandler(this, edge, function, ssa, pts, constraints, errorConditions, this.regionMgr);
        return assignmentHandler.handleAssignment(lhs, lhsForChecking, lhsType, rhs, false);
    }

    private boolean isArrayAssignment(CLeftHandSide lhs, CType lhsType) {
        if (lhs instanceof CIdExpression && lhsType instanceof CArrayType) {
            CSimpleDeclaration declaration = ((CIdExpression)lhs).getDeclaration();
            if (declaration instanceof CParameterDeclaration) {
                return true;
            }
            if (this.options.useParameterVariablesForGlobals() && declaration instanceof CVariableDeclaration && ((CVariableDeclaration)declaration).isGlobal()) {
                return true;
            }
        }
        return false;
    }

    private static String getLogMessage(String msg, CFAEdge edge) {
        return edge.getFileLocation() + ": " + msg + ": " + edge.getDescription();
    }

    private void logDebug(String msg, CFAEdge edge) {
        this.logger.log(Level.ALL, () -> CToFormulaConverterWithPointerAliasing.getLogMessage(msg, edge));
    }

    @Override
    protected BooleanFormula makeDeclaration(CDeclarationEdge declarationEdge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula result;
        Integer actualLength;
        if (!(declarationEdge.getDeclaration() instanceof CVariableDeclaration)) {
            this.logDebug("Ignoring declaration", declarationEdge);
            return this.bfmgr.makeTrue();
        }
        CVariableDeclaration declaration = (CVariableDeclaration)declarationEdge.getDeclaration();
        CType declarationType = this.typeHandler.getSimplifiedType(declaration);
        if (!this.isRelevantVariable(declaration) && !this.isAddressedVariable(declaration)) {
            this.logDebug("Ignoring declaration of unused variable", declarationEdge);
            return this.bfmgr.makeTrue();
        }
        this.checkForLargeArray(declarationEdge, declarationType);
        if (errorConditions.isEnabled()) {
            Formula address = this.makeBaseAddress(declaration.getQualifiedName(), declarationType);
            constraints.addConstraint(this.fmgr.makeEqual(this.makeBaseAddressOfTerm(address), address));
        }
        CInitializer initializer = declaration.getInitializer();
        if (declarationType instanceof CArrayType && ((CArrayType)declarationType).getLength() == null && (actualLength = initializer instanceof CInitializerList ? Integer.valueOf(((CInitializerList)initializer).getInitializers().size()) : (initializer instanceof CInitializerExpression && ((CInitializerExpression)initializer).getExpression() instanceof CStringLiteralExpression ? Integer.valueOf(((CStringLiteralExpression)((CInitializerExpression)initializer).getExpression()).getContentString().length() + 1) : null)) != null) {
            declarationType = new CArrayType(declarationType.isConst(), declarationType.isVolatile(), ((CArrayType)declarationType).getType(), new CIntegerLiteralExpression(declaration.getFileLocation(), this.machineModel.getPointerDiffType(), BigInteger.valueOf(actualLength.intValue())));
            declaration = new CVariableDeclaration(declaration.getFileLocation(), declaration.isGlobal(), declaration.getCStorageClass(), declarationType, declaration.getName(), declaration.getOrigName(), declaration.getQualifiedName(), initializer);
        }
        this.declareSharedBase(declaration, declaration, declarationEdge, function, ssa, pts, constraints, errorConditions);
        if (this.options.useParameterVariablesForGlobals() && declaration.isGlobal()) {
            this.globalDeclarations.add(declaration);
        }
        CIdExpression lhs = new CIdExpression(declaration.getFileLocation(), declaration);
        AssignmentHandler assignmentHandler = new AssignmentHandler(this, declarationEdge, function, ssa, pts, constraints, errorConditions, this.regionMgr);
        if (initializer instanceof CInitializerExpression || initializer == null) {
            if (initializer != null) {
                if (this.options.handleStringLiteralInitializers()) {
                    List<CExpressionAssignmentStatement> assignments = CInitializers.convertToAssignments(declaration, declarationEdge);
                    assignments = CToFormulaConverterWithPointerAliasing.expandStringLiterals(assignments);
                    return assignmentHandler.handleInitializationAssignments(lhs, declarationType, assignments);
                }
                result = assignmentHandler.handleAssignment(lhs, lhs, ((CInitializerExpression)initializer).getExpression(), true);
            } else {
                result = this.isRelevantVariable(declaration) && !declarationType.isIncomplete() ? assignmentHandler.handleAssignment(lhs, lhs, null, true) : this.bfmgr.makeTrue();
            }
        } else if (initializer instanceof CInitializerList) {
            List<CExpressionAssignmentStatement> assignments = CInitializers.convertToAssignments(declaration, declarationEdge);
            if (this.options.handleStringLiteralInitializers()) {
                assignments = CToFormulaConverterWithPointerAliasing.expandStringLiterals(assignments);
            }
            if (this.options.handleImplicitInitialization()) {
                assignments = this.expandAssignmentList(declaration, assignments);
            }
            result = assignmentHandler.handleInitializationAssignments(lhs, declarationType, assignments);
        } else {
            throw new UnrecognizedCodeException("Unrecognized initializer", declarationEdge, initializer);
        }
        return result;
    }

    @Override
    protected BooleanFormula makePredicate(CExpression e, boolean truthAssumption, CFAEdge edge, String function, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        CType expressionType = this.typeHandler.getSimplifiedType(e);
        CExpressionVisitorWithPointerAliasing ev = new CExpressionVisitorWithPointerAliasing(this, edge, function, ssa, constraints, errorConditions, pts, this.regionMgr);
        BooleanFormula result = this.toBooleanFormula(ev.asValueFormula(e.accept(ev), expressionType));
        if (this.options.deferUntypedAllocations()) {
            DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this, edge, ssa, pts, constraints, errorConditions, this.regionMgr);
            memoryHandler.handleDeferredAllocationsInAssume(e, ev.getLearnedPointerTypes());
        }
        if (!truthAssumption) {
            result = this.bfmgr.not(result);
        }
        if (this.options.useHavocAbstraction() && !e.accept(new IsRelevantWithHavocAbstractionVisitor(this)).booleanValue()) {
            result = this.bfmgr.makeBoolean(true);
        }
        pts.addEssentialFields(ev.getInitializedFields());
        pts.addEssentialFields(ev.getUsedFields());
        return result;
    }

    @Override
    protected BooleanFormula makeFunctionCall(CFunctionCallEdge edge, String callerFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        CFunctionEntryNode entryNode = edge.getSuccessor();
        for (CParameterDeclaration formalParameter : entryNode.getFunctionParameters()) {
            CVariableDeclaration declaration;
            CVariableDeclaration formalDeclaration = formalParameter.asVariableDeclaration();
            if (this.options.useParameterVariables()) {
                CParameterDeclaration tmpParameter = new CParameterDeclaration(formalParameter.getFileLocation(), formalParameter.getType(), formalParameter.getName() + "__param__");
                tmpParameter.setQualifiedName(formalParameter.getQualifiedName() + "__param__");
                declaration = tmpParameter.asVariableDeclaration();
            } else {
                declaration = formalDeclaration;
            }
            this.declareSharedBase(declaration, formalParameter, edge, entryNode.getFunctionName(), ssa, pts, constraints, errorConditions);
        }
        BooleanFormula result = super.makeFunctionCall(edge, callerFunction, ssa, pts, constraints, errorConditions);
        return result;
    }

    @Override
    protected BooleanFormula makeExitFunction(CFunctionSummaryEdge summaryEdge, String calledFunction, SSAMap.SSAMapBuilder ssa, PointerTargetSetBuilder pts, Constraints constraints, ErrorConditions errorConditions) throws UnrecognizedCodeException, InterruptedException {
        BooleanFormula result = super.makeExitFunction(summaryEdge, calledFunction, ssa, pts, constraints, errorConditions);
        DynamicMemoryHandler memoryHandler = new DynamicMemoryHandler(this, summaryEdge, ssa, pts, constraints, errorConditions, this.regionMgr);
        memoryHandler.handleDeferredAllocationInFunctionExit(calledFunction);
        return result;
    }

    @Override
    protected CType getReturnType(CFunctionCallExpression pFuncCallExp, CFAEdge pEdge) throws UnrecognizedCodeException {
        return this.typeHandler.simplifyType(super.getReturnType(pFuncCallExp, pEdge));
    }

    @Override
    protected CExpression makeCastFromArrayToPointerIfNecessary(CExpression pExp, CType pTargetType) {
        return super.makeCastFromArrayToPointerIfNecessary(pExp, pTargetType);
    }

    @Override
    protected Formula makeCast(CType pFromType, CType pToType, Formula pFormula, Constraints constraints, CFAEdge pEdge) throws UnrecognizedCodeException {
        return super.makeCast(pFromType, pToType, pFormula, constraints, pEdge);
    }

    @Override
    protected @Nullable Formula makeValueReinterpretation(CType pFromType, CType pToType, Formula pFormula) {
        return super.makeValueReinterpretation(pFromType, pToType, pFormula);
    }

    @Override
    protected Formula makeConstant(String pName, CType pType) {
        return super.makeConstant(pName, pType);
    }

    @Override
    protected Formula makeVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeVariable(pName, pType, pSsa);
    }

    @Override
    public Formula makeFormulaForUninstantiatedVariable(String pVarName, CType pType, PointerTargetSet pContextPTS, boolean forcePointerDereference) {
        Object address;
        Preconditions.checkArgument((!(pType instanceof CFunctionType) ? 1 : 0) != 0);
        if (forcePointerDereference) {
            address = this.fmgr.makeVariable(this.getFormulaTypeFromCType(CTypeUtils.getBaseType(pType)), pVarName);
        } else if (pContextPTS.isActualBase(pVarName) || CTypeUtils.containsArrayOutsideFunctionParameter(pType)) {
            address = this.makeBaseAddress(pVarName, pType);
        } else {
            return super.makeFormulaForUninstantiatedVariable(pVarName, pType, pContextPTS, forcePointerDereference);
        }
        CTypeUtils.checkIsSimplified(pType);
        MemoryRegion region = this.regionMgr.makeMemoryRegion(pType);
        String ufName = this.regionMgr.getPointerAccessName(region);
        FormulaType<?> returnType = this.getFormulaTypeFromCType(pType);
        return this.ptsMgr.makePointerDereference(ufName, returnType, address);
    }

    @Override
    public Formula makeFormulaForVariable(SSAMap pContextSSA, PointerTargetSet pContextPTS, String pVarName, CType pType) {
        Formula formula;
        Preconditions.checkArgument((!(pType instanceof CFunctionType) ? 1 : 0) != 0);
        SSAMap.SSAMapBuilder ssa = pContextSSA.builder();
        if (pContextPTS.isActualBase(pVarName) || CTypeUtils.containsArrayOutsideFunctionParameter(pType)) {
            Formula address = this.makeBaseAddress(pVarName, pType);
            MemoryRegion region = this.regionMgr.makeMemoryRegion(pType);
            formula = this.makeSafeDereference(pType, address, ssa, region);
        } else {
            formula = this.makeVariable(pVarName, pType, ssa);
        }
        if (!ssa.build().equals(pContextSSA)) {
            throw new IllegalArgumentException("we cannot apply the SSAMap changes to the point where the information would be needed. Possible problems: uninitialized variables could be in more formulas which get conjuncted and then we get unsatisfiable formulas as a result.\n difference in SSA variables: " + Sets.difference(ssa.allVariables(), pContextSSA.allVariables()));
        }
        return formula;
    }

    @Override
    protected Formula buildTerm(CRightHandSide pExp, CFAEdge pEdge, String pFunction, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) throws UnrecognizedCodeException {
        return super.buildTerm(pExp, pEdge, pFunction, pSsa, pPts, pConstraints, pErrorConditions);
    }

    @Override
    protected Formula makeFreshVariable(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        return super.makeFreshVariable(pName, this.typeHandler.simplifyType(pType), pSsa);
    }

    @Override
    protected int getIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        if (TypeHandlerWithPointerAliasing.isPointerAccessSymbol(pName)) {
            pType = this.typeHandler.simplifyTypeForPointerAccess(pType).getCanonicalType();
        }
        return super.getIndex(pName, pType, pSsa);
    }

    @Override
    protected int getFreshIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        if (TypeHandlerWithPointerAliasing.isPointerAccessSymbol(pName)) {
            pType = this.typeHandler.simplifyTypeForPointerAccess(pType).getCanonicalType();
        }
        return super.getFreshIndex(pName, pType, pSsa);
    }

    @Override
    protected int makeFreshIndex(String pName, CType pType, SSAMap.SSAMapBuilder pSsa) {
        if (TypeHandlerWithPointerAliasing.isPointerAccessSymbol(pName)) {
            pType = this.typeHandler.simplifyTypeForPointerAccess(pType).getCanonicalType();
        }
        return super.makeFreshIndex(pName, pType, pSsa);
    }

    @Override
    protected long getSizeof(CType pType) {
        return super.getSizeof(pType);
    }

    @Override
    protected long getBitSizeof(CType pType) {
        return super.getBitSizeof(pType);
    }

    @Override
    protected boolean isRelevantLeftHandSide(CLeftHandSide pLhs) {
        return super.isRelevantLeftHandSide(pLhs);
    }

    protected boolean isRelevantField(CCompositeType pCompositeType, CCompositeType.CCompositeTypeMemberDeclaration pField) {
        return super.isRelevantField(pCompositeType, pField.getName());
    }

    @Override
    protected Formula makeNondet(String pVarName, CType pType, SSAMap.SSAMapBuilder pSsa, Constraints pConstraints) {
        return super.makeNondet(pVarName, this.typeHandler.simplifyType(pType), pSsa, pConstraints);
    }

    @Override
    protected CExpression convertLiteralToFloatIfNecessary(CExpression pExp, CType pTargetType) {
        return super.convertLiteralToFloatIfNecessary(pExp, pTargetType);
    }

    @Override
    public void printStatistics(PrintStream out) {
        this.regionMgr.printStatistics(out);
    }
}

