/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import java.util.OptionalInt;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CachingCanonizingCTypeVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;

class CTypeUtils {
    private static final CachingCanonizingCTypeVisitor typeVisitor = new CachingCanonizingCTypeVisitor(true, true, false);

    private CTypeUtils() {
    }

    static int getArrayLength(CArrayType t, FormulaEncodingWithPointerAliasingOptions options) {
        OptionalInt length = t.getLengthAsInt();
        return length.isPresent() ? Integer.min(options.maxArrayLength(), length.orElseThrow()) : options.defaultArrayLength();
    }

    private static boolean containsArrayInComposite(CType pType) {
        CTypeUtils.checkIsSimplified(pType);
        if (pType instanceof CArrayType) {
            return true;
        }
        if (pType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)pType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite!";
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                if (!CTypeUtils.containsArrayInComposite(memberDeclaration.getType())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean containsArrayOutsideFunctionParameter(CType pType) {
        CTypeUtils.checkIsSimplified(pType);
        if (pType instanceof CArrayType) {
            return true;
        }
        if (pType instanceof CCompositeType) {
            return CTypeUtils.containsArrayInComposite(pType);
        }
        return false;
    }

    static boolean containsArrayInFunctionParameter(CType pType) {
        CTypeUtils.checkIsSimplified(pType);
        if (pType instanceof CCompositeType) {
            return CTypeUtils.containsArrayInComposite(pType);
        }
        return false;
    }

    static boolean containsArray(CType pType, CSimpleDeclaration pDeclaration) {
        CTypeUtils.checkIsSimplified(pType);
        if (pDeclaration instanceof CParameterDeclaration) {
            return CTypeUtils.containsArrayInFunctionParameter(pType);
        }
        return CTypeUtils.containsArrayOutsideFunctionParameter(pType);
    }

    static CType getBaseType(CType type) {
        CTypeUtils.checkIsSimplified(type);
        if (!(type instanceof CArrayType)) {
            return new CPointerType(false, false, type);
        }
        return new CPointerType(false, false, ((CArrayType)type).getType());
    }

    static CType implicitCastToPointer(CType type) {
        CTypeUtils.checkIsSimplified(type);
        if (type instanceof CArrayType) {
            return new CPointerType(false, false, CTypeUtils.checkIsSimplified(((CArrayType)type).getType()));
        }
        if (type instanceof CFunctionType) {
            return new CPointerType(false, false, type);
        }
        return type;
    }

    static boolean isSimpleType(CType type) {
        return !(type instanceof CArrayType) && !(type instanceof CCompositeType);
    }

    private static synchronized CType simplifyType(CType type) {
        return type.accept(typeVisitor);
    }

    static <T extends CType> T checkIsSimplified(T type) {
        Preconditions.checkArgument((!type.isConst() ? 1 : 0) != 0, (String)"Type %s is const but should have been simplified.", type);
        Preconditions.checkArgument((!type.isVolatile() ? 1 : 0) != 0, (String)"Type %s is volatile but should have been simplified.", type);
        assert (type.equals(type.getCanonicalType())) : "Type " + type + " is not equal to its canonical type but should have been simplified.";
        assert (type.equals(CTypeUtils.simplifyType(type))) : "Type " + type + " is not equal to its simplified type but should have been simplified.";
        return type;
    }

    static String typeToString(CType type) {
        CTypeUtils.checkIsSimplified(type);
        return type.toString();
    }
}

