/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;

class CachingCanonizingCTypeVisitor
extends DefaultCTypeVisitor<CType, NoException> {
    private final Map<CType, CType> typeCache = new HashMap<CType, CType>();
    private final CTypeTransformerVisitor typeVisitor;

    CachingCanonizingCTypeVisitor(boolean ignoreConst, boolean ignoreVolatile, boolean ignoreSignedness) {
        this.typeVisitor = new CTypeTransformerVisitor(ignoreConst, ignoreVolatile, ignoreSignedness);
    }

    @Override
    public CCompositeType visit(CCompositeType t) {
        CCompositeType result = (CCompositeType)this.typeCache.get(t);
        if (result != null) {
            return result;
        }
        CCompositeType canonicalType = t.getCanonicalType();
        List<CCompositeType.CCompositeTypeMemberDeclaration> oldMembers = canonicalType.getMembers();
        canonicalType = new CCompositeType(!this.typeVisitor.ignoreConst && canonicalType.isConst(), !this.typeVisitor.ignoreVolatile && canonicalType.isVolatile(), canonicalType.getKind(), canonicalType.getName(), canonicalType.getOrigName());
        this.typeCache.put(t, canonicalType);
        ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> memberDeclarations = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(oldMembers.size());
        for (CCompositeType.CCompositeTypeMemberDeclaration oldMemberDeclaration : oldMembers) {
            CType oldMemberType = oldMemberDeclaration.getType();
            CType memberType = oldMemberType.accept(this);
            if (memberType != oldMemberType) {
                memberDeclarations.add(new CCompositeType.CCompositeTypeMemberDeclaration(memberType, oldMemberDeclaration.getName()));
                continue;
            }
            memberDeclarations.add(oldMemberDeclaration);
        }
        canonicalType.setMembers(memberDeclarations);
        return canonicalType;
    }

    @Override
    public CType visitDefault(CType t) {
        CType result = this.typeCache.get(t);
        if (result != null) {
            return result;
        }
        result = t.getCanonicalType();
        result = !(result instanceof CCompositeType) ? result.accept(this.typeVisitor) : this.visit((CCompositeType)result);
        this.typeCache.put(t, result);
        return result;
    }

    private class CTypeTransformerVisitor
    implements CTypeVisitor<CType, NoException> {
        private final boolean ignoreConst;
        private final boolean ignoreVolatile;
        private final boolean ignoreSignedness;

        private CTypeTransformerVisitor(boolean ignoreConst, boolean ignoreVolatile, boolean ignoreSignedness) {
            this.ignoreConst = ignoreConst;
            this.ignoreVolatile = ignoreVolatile;
            this.ignoreSignedness = ignoreSignedness;
        }

        @Override
        public CType visit(CArrayType t) {
            CType oldType = t.getType();
            CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
            return !(type != oldType || t.isConst() && this.ignoreConst || t.isVolatile() && this.ignoreVolatile) ? t : new CArrayType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), type, t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            throw new AssertionError((Object)"should never be called");
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            CComplexType realType;
            CComplexType oldRealType = t.getRealType();
            CComplexType cComplexType = realType = oldRealType != null ? (CComplexType)oldRealType.accept(CachingCanonizingCTypeVisitor.this) : null;
            return !(realType != oldRealType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CElaboratedType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), t.getKind(), t.getName(), t.getOrigName(), realType);
        }

        @Override
        public CPointerType visit(CPointerType t) {
            CType oldType = t.getType();
            CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
            return !(type != oldType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CPointerType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), type);
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            CType oldRealType = t.getRealType();
            CType realType = oldRealType.accept(CachingCanonizingCTypeVisitor.this);
            return !(realType != oldRealType || this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile()) ? t : new CTypedefType(!this.ignoreConst && t.isConst(), !this.ignoreConst && t.isVolatile(), t.getName(), realType);
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            CFunctionType result;
            CType oldReturnType = t.getReturnType();
            CType returnType = oldReturnType.accept(CachingCanonizingCTypeVisitor.this);
            List<CType> parameterTypes = null;
            int i = 0;
            for (CType oldType : t.getParameters()) {
                CType type = oldType.accept(CachingCanonizingCTypeVisitor.this);
                if (type != oldType && parameterTypes == null) {
                    parameterTypes = new ArrayList<CType>(t.getParameters().subList(0, i));
                }
                if (parameterTypes != null) {
                    parameterTypes.add(type);
                }
                ++i;
            }
            if (returnType == oldReturnType && parameterTypes == null) {
                result = t;
            } else {
                result = new CFunctionType(returnType, parameterTypes != null ? parameterTypes : t.getParameters(), t.takesVarArgs());
                if (t.getName() != null) {
                    result.setName(t.getName());
                }
            }
            return result;
        }

        @Override
        public CType visit(CEnumType t) {
            return ((CEnumType.CEnumerator)t.getEnumerators().get(0)).getType().accept(CachingCanonizingCTypeVisitor.this);
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return !(this.ignoreConst && t.isConst() || this.ignoreVolatile && t.isVolatile() || this.ignoreSignedness && t.isSigned() || this.ignoreSignedness && t.isUnsigned()) ? t : new CSimpleType(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile(), t.getType(), t.isLong(), t.isShort(), !this.ignoreSignedness && t.isSigned(), !this.ignoreSignedness && t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CType visit(CBitFieldType pCBitFieldType) {
            CType type = pCBitFieldType.getType().accept(this);
            if (type != pCBitFieldType.getType()) {
                return new CBitFieldType(type, pCBitFieldType.getBitFieldSize());
            }
            return pCBitFieldType;
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(!this.ignoreConst && t.isConst(), !this.ignoreVolatile && t.isVolatile());
        }
    }
}

