/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;

@Immutable
final class CompositeField
implements Comparable<CompositeField>,
Serializable {
    private static final long serialVersionUID = -5194535211223682619L;
    private final CCompositeType compositeType;
    private final String compositeTypeStr;
    private final CCompositeType.CCompositeTypeMemberDeclaration field;

    private CompositeField(CCompositeType pCompositeType, CCompositeType.CCompositeTypeMemberDeclaration pField) {
        this.compositeType = pCompositeType;
        this.compositeTypeStr = CTypeUtils.typeToString(pCompositeType);
        this.field = pField;
    }

    static CompositeField of(CCompositeType pCompositeType, String pFieldName) {
        for (CCompositeType.CCompositeTypeMemberDeclaration declaration : pCompositeType.getMembers()) {
            if (!declaration.getName().equals(pFieldName)) continue;
            return new CompositeField(pCompositeType, declaration);
        }
        throw new AssertionError((Object)("Tried to start tracking for a non-existent field " + pFieldName + " in composite type " + pCompositeType));
    }

    static CompositeField of(CCompositeType pCompositeType, CCompositeType.CCompositeTypeMemberDeclaration pField) {
        return new CompositeField(pCompositeType, pField);
    }

    CCompositeType getOwnerType() {
        return this.compositeType;
    }

    CCompositeType.CCompositeTypeMemberDeclaration getFieldDeclaration() {
        return this.field;
    }

    String getFieldName() {
        return this.field.getName();
    }

    public String toString() {
        return this.compositeTypeStr + "." + this.getFieldName();
    }

    @Override
    public int compareTo(CompositeField other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.compositeTypeStr), (Comparable)((Object)other.compositeTypeStr)).compare((Comparable)((Object)this.getFieldName()), (Comparable)((Object)other.getFieldName())).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompositeField)) {
            return false;
        }
        CompositeField other = (CompositeField)obj;
        return this.compositeTypeStr.equals(other.compositeTypeStr) && this.getFieldName().equals(other.getFieldName());
    }

    public int hashCode() {
        return this.compositeTypeStr.hashCode() * 17 + this.getFieldName().hashCode();
    }
}

