/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AbstractMemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegion;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.MemoryRegionManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

class DefaultRegionManager
extends AbstractMemoryRegionManager
implements MemoryRegionManager {
    DefaultRegionManager(TypeHandlerWithPointerAliasing pTypeHandler) {
        super(pTypeHandler);
    }

    @Override
    public MemoryRegion makeMemoryRegion(CType pType) {
        Preconditions.checkNotNull((Object)pType);
        CTypeUtils.checkIsSimplified(pType);
        return new DefaultMemoryRegion(pType);
    }

    @Override
    public MemoryRegion makeMemoryRegion(CType pType, CType pExpressionType, String pFieldName) {
        Preconditions.checkNotNull((Object)pType);
        Preconditions.checkNotNull((Object)pExpressionType);
        Preconditions.checkNotNull((Object)pFieldName);
        CTypeUtils.checkIsSimplified(pExpressionType);
        return new DefaultMemoryRegion(pExpressionType);
    }

    private static final class DefaultMemoryRegion
    implements MemoryRegion {
        private final CType type;

        DefaultMemoryRegion(CType pType) {
            this.type = pType;
        }

        @Override
        public CType getType() {
            return this.type;
        }

        @Override
        public String getName(TypeHandlerWithPointerAliasing typeHandler) {
            return typeHandler.getPointerAccessNameForType(this.type);
        }

        public String toString() {
            return "DefaultMemoryRegion [type=" + this.type + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultMemoryRegion other = (DefaultMemoryRegion)obj;
            return this.type.equals(other.type);
        }
    }
}

