/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.Formula;

@Immutable
class DeferredAllocation
implements Serializable {
    private static final long serialVersionUID = -6882598785306470437L;
    private final boolean isZeroed;
    private final Optional<CIntegerLiteralExpression> size;
    private final Formula sizeExp;
    private final String base;

    DeferredAllocation(String base, Optional<CIntegerLiteralExpression> size, Formula pSizeExp, boolean isZeroed) {
        this.isZeroed = isZeroed;
        this.size = size;
        this.sizeExp = pSizeExp;
        this.base = base;
    }

    String getBase() {
        return this.base;
    }

    boolean isZeroed() {
        return this.isZeroed;
    }

    boolean hasKnownSize() {
        return this.size.isPresent();
    }

    Optional<CIntegerLiteralExpression> getSize() {
        return this.size;
    }

    Formula getSizeExpression() {
        return this.sizeExp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeferredAllocation)) {
            return false;
        }
        DeferredAllocation otherPool = (DeferredAllocation)other;
        return this.base.equals(otherPool.base) && this.isZeroed == otherPool.isZeroed && this.sizeExp.equals((Object)otherPool.sizeExp) && this.size.equals(otherPool.size);
    }

    public int hashCode() {
        int result = 0;
        result += this.base.hashCode() * 997;
        result += this.size.hashCode() * 617;
        result += this.sizeExp.hashCode() * 617;
        return result += this.isZeroed ? 307 : 0;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 4850967154964188729L;
        private final boolean isZeroed;
        private final String base;
        private final long size;
        private final @Nullable CType sizeType;
        private final String sizeExp;

        private SerializationProxy(DeferredAllocation pDeferredAllocationPool) {
            this.isZeroed = pDeferredAllocationPool.isZeroed;
            this.base = pDeferredAllocationPool.base;
            FormulaManagerView mgr = GlobalInfo.getInstance().getPredicateFormulaManagerView();
            this.sizeExp = mgr.dumpArbitraryFormula(pDeferredAllocationPool.sizeExp);
            if (pDeferredAllocationPool.size.isPresent()) {
                this.size = pDeferredAllocationPool.size.orElseThrow().asLong();
                this.sizeType = pDeferredAllocationPool.size.orElseThrow().getExpressionType();
            } else {
                this.size = -1L;
                this.sizeType = null;
            }
        }

        private Object readResolve() {
            return new DeferredAllocation(this.base, this.sizeType != null ? Optional.of(CIntegerLiteralExpression.createDummyLiteral(this.size, this.sizeType)) : Optional.empty(), GlobalInfo.getInstance().getPredicateFormulaManagerView().parseArbitraryFormula(this.sizeExp), this.isZeroed);
        }
    }
}

